/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.context.skill.metadata.language;

import com.github.copilot.chat.conversation.agent.context.skill.metadata.AggregateMetadata;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.Project;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectFile;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectServiceKt;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.buildtool.ProjectBuildTool;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.buildtool.ProjectBuildToolKt;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.Language;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.LanguageService;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.ProjectLanguage;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.sdk.Sdk;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.sdk.SdkService;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.sdk.SdkServiceKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"LanguageService", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/LanguageService;", "sdkService", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/SdkService;", "core"})
public final class LanguageServiceKt {
    @NotNull
    public static final LanguageService LanguageService(@NotNull SdkService sdkService) {
        Intrinsics.checkNotNullParameter((Object)sdkService, (String)"sdkService");
        return new LanguageService(sdkService){
            final /* synthetic */ SdkService $sdkService;
            {
                this.$sdkService = $sdkService;
            }

            public ProjectLanguage getProjectLanguage(Project project, ProjectFile currentFile, AggregateMetadata aggregateMetadata) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)aggregateMetadata, (String)"aggregateMetadata");
                Language language = this.determinePrimaryLanguage(aggregateMetadata, project, currentFile);
                if (language == null) {
                    return null;
                }
                Language primaryLanguage = language;
                String primaryLanguageVersion = this.determinePrimaryLanguageVersion(aggregateMetadata, project, currentFile, primaryLanguage);
                return new ProjectLanguage(primaryLanguage, primaryLanguageVersion, 0, 4, null);
            }

            private final Language determinePrimaryLanguage(AggregateMetadata $this$determinePrimaryLanguage, Project project, ProjectFile currentFile) {
                List<ProjectLanguage> primaryLanguages = $this$determinePrimaryLanguage.getLanguages().getByHighestFileCount();
                if (primaryLanguages.size() == 1) {
                    return ((ProjectLanguage)CollectionsKt.first(primaryLanguages)).getLanguage();
                }
                Object object = currentFile;
                if (object != null && (object = ProjectServiceKt.getLanguage(object)) != null) {
                    Object currentLanguage = object;
                    boolean bl = false;
                    if (primaryLanguages.isEmpty()) {
                        return currentLanguage;
                    }
                    Iterable $this$forEach$iv = primaryLanguages;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ProjectLanguage primaryLanguage = (ProjectLanguage)element$iv;
                        boolean bl2 = false;
                        if (primaryLanguage.getLanguage() != currentLanguage) continue;
                        return primaryLanguage.getLanguage();
                    }
                }
                List<Language> buildToolImpliedLanguages = ProjectBuildToolKt.getImpliedLanguages($this$determinePrimaryLanguage.getBuildTools());
                if (primaryLanguages.isEmpty() && !((Collection)buildToolImpliedLanguages).isEmpty()) {
                    return (Language)((Object)CollectionsKt.first(buildToolImpliedLanguages));
                }
                if (!((Collection)primaryLanguages).isEmpty()) {
                    if (!((Collection)buildToolImpliedLanguages).isEmpty()) {
                        Iterable $this$forEach$iv = primaryLanguages;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ProjectLanguage primaryLanguage = (ProjectLanguage)element$iv;
                            boolean bl = false;
                            if (!buildToolImpliedLanguages.contains((Object)((Object)primaryLanguage.getLanguage()))) continue;
                            return primaryLanguage.getLanguage();
                        }
                    }
                    return ((ProjectLanguage)CollectionsKt.first(primaryLanguages)).getLanguage();
                }
                Sdk sdk = this.$sdkService.getProjectSdk(project);
                return sdk != null ? sdk.getLanguage() : null;
            }

            private final String determinePrimaryLanguageVersion(AggregateMetadata $this$determinePrimaryLanguageVersion, Project project, ProjectFile currentFile, Language primaryLanguage) {
                Object object;
                ProjectFile projectFile = currentFile;
                if (projectFile != null) {
                    object = projectFile;
                    SdkService sdkService = this.$sdkService;
                    ProjectFile file = object;
                    boolean bl = false;
                    Sdk sdk = sdkService.getFileSdk(file, primaryLanguage);
                    if (sdk != null) {
                        Sdk it = sdk;
                        boolean bl2 = false;
                        return it.getVersion();
                    }
                }
                if ($this$determinePrimaryLanguageVersion.getType().isProject() && !((Collection)$this$determinePrimaryLanguageVersion.getBuildTools()).isEmpty() && (object = this.$sdkService.getFileSdk(((ProjectBuildTool)CollectionsKt.first((Iterable)$this$determinePrimaryLanguageVersion.getBuildTools())).getBuildFile(), primaryLanguage)) != null) {
                    Object it = object;
                    boolean bl = false;
                    return ((Sdk)it).getVersion();
                }
                Sdk sdk = this.$sdkService.getProjectSdk(project, primaryLanguage);
                return sdk != null ? sdk.getVersion() : null;
            }
        };
    }

    public static /* synthetic */ LanguageService LanguageService$default(SdkService sdkService, int n, Object object) {
        if ((n & 1) != 0) {
            sdkService = SdkServiceKt.SdkService$default(null, null, 3, null);
        }
        return LanguageServiceKt.LanguageService(sdkService);
    }
}

