/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.context.skill.metadata.language;

import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.Language;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.ProjectLanguage;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.ProjectLanguageKt;
import io.ktor.util.collections.ConcurrentMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0007H\u0086\u0002J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0002J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\tJ\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u001b\u001a\u00020\tJ\u0018\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\tJ\u0018\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u001d\u001a\u00020\tJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001fJ\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0096\u0002J\b\u0010#\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/ProjectLanguages;", "", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/ProjectLanguage;", "<init>", "()V", "projectLanguages", "", "", "size", "", "getSize", "()I", "isEmpty", "", "()Z", "isNotEmpty", "contains", "languageId", "language", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/Language;", "get", "add", "projectLanguage", "addAll", "languages", "remove", "incrementFileCount", "increment", "decrementFileCount", "decrement", "getByHighestFileCount", "", "toList", "iterator", "", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nProjectLanguage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectLanguage.kt\ncom/github/copilot/chat/conversation/agent/context/skill/metadata/language/ProjectLanguages\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n1855#3,2:181\n1855#3,2:183\n1855#3,2:185\n*S KotlinDebug\n*F\n+ 1 ProjectLanguage.kt\ncom/github/copilot/chat/conversation/agent/context/skill/metadata/language/ProjectLanguages\n*L\n107#1:181,2\n148#1:183,2\n171#1:185,2\n*E\n"})
public final class ProjectLanguages
implements Iterable<ProjectLanguage>,
KMappedMarker {
    @NotNull
    private final Map<String, ProjectLanguage> projectLanguages = (Map)new ConcurrentMap(0, 1, null);

    public final int getSize() {
        return this.projectLanguages.size();
    }

    public final boolean isEmpty() {
        return this.projectLanguages.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.projectLanguages.isEmpty();
    }

    public final boolean contains(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return this.projectLanguages.containsKey(ProjectLanguageKt.access$normalize(languageId));
    }

    public final boolean contains(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return this.contains(language.getId());
    }

    @Nullable
    public final ProjectLanguage get(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return this.projectLanguages.get(ProjectLanguageKt.access$normalize(languageId));
    }

    @Nullable
    public final ProjectLanguage get(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return this.get(language.getId());
    }

    @NotNull
    public final ProjectLanguages add(@NotNull ProjectLanguage projectLanguage) {
        ProjectLanguages projectLanguages;
        Intrinsics.checkNotNullParameter((Object)projectLanguage, (String)"projectLanguage");
        ProjectLanguages $this$add_u24lambda_u240 = projectLanguages = this;
        boolean bl = false;
        $this$add_u24lambda_u240.projectLanguages.put(ProjectLanguageKt.access$normalize(projectLanguage.getLanguage().getId()), projectLanguage);
        return projectLanguages;
    }

    @NotNull
    public final ProjectLanguages addAll(@NotNull ProjectLanguages languages) {
        ProjectLanguages projectLanguages;
        Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
        ProjectLanguages $this$addAll_u24lambda_u242 = projectLanguages = this;
        boolean bl = false;
        Iterable $this$forEach$iv = languages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectLanguage projectLanguage = (ProjectLanguage)element$iv;
            boolean bl2 = false;
            Language language = projectLanguage.component1();
            int fileCount = projectLanguage.component3();
            $this$addAll_u24lambda_u242.incrementFileCount(language, Math.max(1, fileCount));
        }
        return projectLanguages;
    }

    @NotNull
    public final ProjectLanguages remove(@NotNull String languageId) {
        ProjectLanguages projectLanguages;
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        ProjectLanguages $this$remove_u24lambda_u243 = projectLanguages = this;
        boolean bl = false;
        $this$remove_u24lambda_u243.projectLanguages.remove(ProjectLanguageKt.access$normalize(languageId));
        return projectLanguages;
    }

    @NotNull
    public final ProjectLanguages remove(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return this.remove(language.getId());
    }

    @NotNull
    public final ProjectLanguages incrementFileCount(@NotNull String languageId, int increment) {
        ProjectLanguages projectLanguages;
        block1: {
            ProjectLanguages $this$incrementFileCount_u24lambda_u246;
            block0: {
                Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
                $this$incrementFileCount_u24lambda_u246 = projectLanguages = this;
                boolean bl = false;
                ProjectLanguage projectLanguage = $this$incrementFileCount_u24lambda_u246.get(languageId);
                if (projectLanguage == null) break block0;
                ProjectLanguage it = projectLanguage;
                boolean bl2 = false;
                it.setFileCount(it.getFileCount() + increment);
                break block1;
            }
            Language language = Language.Companion.forId(languageId);
            if (language == null) break block1;
            Language it = language;
            boolean bl = false;
            $this$incrementFileCount_u24lambda_u246.add(new ProjectLanguage(it, null, increment, 2, null));
        }
        return projectLanguages;
    }

    public static /* synthetic */ ProjectLanguages incrementFileCount$default(ProjectLanguages projectLanguages, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return projectLanguages.incrementFileCount(string, n);
    }

    @NotNull
    public final ProjectLanguages incrementFileCount(@NotNull Language language, int increment) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return this.incrementFileCount(language.getId(), increment);
    }

    public static /* synthetic */ ProjectLanguages incrementFileCount$default(ProjectLanguages projectLanguages, Language language, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return projectLanguages.incrementFileCount(language, n);
    }

    @NotNull
    public final ProjectLanguages decrementFileCount(@NotNull String languageId, int decrement) {
        ProjectLanguages projectLanguages;
        block1: {
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            ProjectLanguages $this$decrementFileCount_u24lambda_u248 = projectLanguages = this;
            boolean bl = false;
            ProjectLanguage projectLanguage = $this$decrementFileCount_u24lambda_u248.get(languageId);
            if (projectLanguage == null) break block1;
            ProjectLanguage language = projectLanguage;
            boolean bl2 = false;
            language.setFileCount(language.getFileCount() - decrement);
            if (language.getFileCount() <= 0) {
                $this$decrementFileCount_u24lambda_u248.remove(languageId);
            }
        }
        return projectLanguages;
    }

    public static /* synthetic */ ProjectLanguages decrementFileCount$default(ProjectLanguages projectLanguages, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return projectLanguages.decrementFileCount(string, n);
    }

    @NotNull
    public final ProjectLanguages decrementFileCount(@NotNull Language language, int decrement) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return this.decrementFileCount(language.getId(), decrement);
    }

    public static /* synthetic */ ProjectLanguages decrementFileCount$default(ProjectLanguages projectLanguages, Language language, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return projectLanguages.decrementFileCount(language, n);
    }

    @NotNull
    public final List<ProjectLanguage> getByHighestFileCount() {
        int highestFileCount = 0;
        List highestFileCountLanguages = new ArrayList();
        Iterable $this$forEach$iv = this.projectLanguages.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectLanguage projectLanguage = (ProjectLanguage)element$iv;
            boolean bl = false;
            if (projectLanguage.getFileCount() > highestFileCount) {
                highestFileCount = projectLanguage.getFileCount();
                highestFileCountLanguages.clear();
                highestFileCountLanguages.add(projectLanguage);
                continue;
            }
            if (projectLanguage.getFileCount() != highestFileCount) continue;
            highestFileCountLanguages.add(projectLanguage);
        }
        return highestFileCountLanguages;
    }

    @NotNull
    public final List<ProjectLanguage> toList() {
        return CollectionsKt.toList((Iterable)this.projectLanguages.values());
    }

    @Override
    @NotNull
    public Iterator<ProjectLanguage> iterator() {
        return this.projectLanguages.values().iterator();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u2411.append("[");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        Iterable $this$forEach$iv = this.projectLanguages.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectLanguage it = (ProjectLanguage)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder3 = $this$toString_u24lambda_u2411.append("  " + it.getLanguage() + ": " + it.getFileCount());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder4 = $this$toString_u24lambda_u2411.append("]");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

