/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.context.skill.metadata.language.sdk;

import com.github.copilot.chat.conversation.agent.context.skill.metadata.Project;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectFile;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectServiceKt;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.Language;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.sdk.Sdk;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.sdk.SdkService;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.sdk.SdkVersionParser;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.sdk.kotlin.KotlinSdkService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.jetbrains.python.sdk.PythonSdkType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\t*\u00020\u000bH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\t*\u00020\u000bH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\t*\u00020\u0013H\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\u0013H\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\t*\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t*\u00060\u0015j\u0002`\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t*\u00060\u0015j\u0002`\u0016H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00060\u0015j\u0002`\u0016H\u0002J\t\u0010\u001a\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0019H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/PlatformSdkService;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/SdkService;", "kotlinSdkService", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/kotlin/KotlinSdkService;", "versionParser", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/SdkVersionParser;", "<init>", "(Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/kotlin/KotlinSdkService;Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/SdkVersionParser;)V", "getProjectSdk", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/Sdk;", "project", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/Project;", "projectLanguage", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/Language;", "getJavaSdk", "getKotlinSdk", "getPythonSdk", "getFileSdk", "file", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectFile;", "toJavaSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/PlatformSdk;", "toPythonSdk", "getVersion", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nSdkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkService.kt\ncom/github/copilot/chat/conversation/agent/context/skill/metadata/language/sdk/PlatformSdkService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
final class PlatformSdkService
implements SdkService {
    @NotNull
    private final KotlinSdkService kotlinSdkService;
    @NotNull
    private final SdkVersionParser versionParser;

    public PlatformSdkService(@NotNull KotlinSdkService kotlinSdkService, @NotNull SdkVersionParser versionParser) {
        Intrinsics.checkNotNullParameter((Object)kotlinSdkService, (String)"kotlinSdkService");
        Intrinsics.checkNotNullParameter((Object)versionParser, (String)"versionParser");
        this.kotlinSdkService = kotlinSdkService;
        this.versionParser = versionParser;
    }

    @Override
    @Nullable
    public Sdk getProjectSdk(@NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            com.intellij.openapi.projectRoots.Sdk sdk = ProjectServiceKt.getSdk(project);
            Object object2 = object = sdk != null ? sdk.getSdkType() : null;
            object = object instanceof JavaSdkType ? this.getJavaSdk(project) : (object instanceof PythonSdkType ? this.getPythonSdk(project) : null);
        }
        catch (Throwable throwable) {
            object = null;
        }
        return object;
    }

    @Override
    @Nullable
    public Sdk getProjectSdk(@NotNull Project project, @NotNull Language projectLanguage) {
        Sdk sdk;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)projectLanguage), (String)"projectLanguage");
        try {
            sdk = switch (WhenMappings.$EnumSwitchMapping$0[projectLanguage.ordinal()]) {
                case 1 -> this.getJavaSdk(project);
                case 2 -> this.getKotlinSdk(project);
                case 3 -> this.getPythonSdk(project);
                default -> null;
            };
        }
        catch (Throwable throwable) {
            sdk = null;
        }
        return sdk;
    }

    private final Sdk getJavaSdk(Project $this$getJavaSdk) {
        com.intellij.openapi.projectRoots.Sdk sdk = ProjectServiceKt.getSdk($this$getJavaSdk);
        return sdk != null ? this.toJavaSdk(sdk) : null;
    }

    private final Sdk getKotlinSdk(Project $this$getKotlinSdk) {
        Sdk sdk;
        com.intellij.openapi.project.Project project = ProjectServiceKt.getPlatformProject($this$getKotlinSdk);
        if (project != null) {
            com.intellij.openapi.project.Project it = project;
            boolean bl = false;
            sdk = this.kotlinSdkService.getKotlinSdk(it);
        } else {
            sdk = null;
        }
        return sdk;
    }

    private final Sdk getPythonSdk(Project $this$getPythonSdk) {
        com.intellij.openapi.projectRoots.Sdk sdk = ProjectServiceKt.getSdk($this$getPythonSdk);
        return sdk != null ? this.toPythonSdk(sdk) : null;
    }

    @Override
    @Nullable
    public Sdk getFileSdk(@NotNull ProjectFile file, @NotNull Language projectLanguage) {
        Sdk sdk;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)projectLanguage), (String)"projectLanguage");
        try {
            sdk = switch (WhenMappings.$EnumSwitchMapping$0[projectLanguage.ordinal()]) {
                case 1 -> this.getJavaSdk(file);
                case 2 -> this.getKotlinSdk(file);
                case 3 -> this.getPythonSdk(file);
                default -> null;
            };
        }
        catch (Throwable throwable) {
            sdk = null;
        }
        return sdk;
    }

    private final Sdk getJavaSdk(ProjectFile $this$getJavaSdk) {
        com.intellij.openapi.projectRoots.Sdk sdk = ProjectServiceKt.getSdk($this$getJavaSdk);
        return sdk != null ? this.toJavaSdk(sdk) : null;
    }

    private final Sdk getKotlinSdk(ProjectFile $this$getKotlinSdk) {
        Sdk sdk;
        Module module = ProjectServiceKt.getModule($this$getKotlinSdk);
        if (module != null) {
            Module it = module;
            boolean bl = false;
            sdk = this.kotlinSdkService.getKotlinSdk(it);
        } else {
            sdk = null;
        }
        return sdk;
    }

    private final Sdk getPythonSdk(ProjectFile $this$getPythonSdk) {
        com.intellij.openapi.projectRoots.Sdk sdk = ProjectServiceKt.getSdk($this$getPythonSdk);
        return sdk != null ? this.toPythonSdk(sdk) : null;
    }

    private final Sdk toJavaSdk(com.intellij.openapi.projectRoots.Sdk $this$toJavaSdk) {
        Sdk sdk;
        if (!($this$toJavaSdk.getSdkType() instanceof JavaSdkType)) {
            return null;
        }
        String string = this.getVersion($this$toJavaSdk);
        if (string != null) {
            String version = string;
            boolean bl = false;
            sdk = new Sdk(Language.JAVA, version);
        } else {
            sdk = null;
        }
        return sdk;
    }

    private final Sdk toPythonSdk(com.intellij.openapi.projectRoots.Sdk $this$toPythonSdk) {
        Sdk sdk;
        if (!($this$toPythonSdk.getSdkType() instanceof PythonSdkType)) {
            return null;
        }
        String string = this.getVersion($this$toPythonSdk);
        if (string != null) {
            String version = string;
            boolean bl = false;
            sdk = new Sdk(Language.PYTHON, version);
        } else {
            sdk = null;
        }
        return sdk;
    }

    private final String getVersion(com.intellij.openapi.projectRoots.Sdk $this$getVersion) {
        String string = $this$getVersion.getVersionString();
        if (string != null) {
            String versionStr = string;
            boolean bl = false;
            String string2 = this.versionParser.parseVersion(versionStr);
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                return it;
            }
        }
        String string3 = $this$getVersion.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        return this.versionParser.parseVersion(string3);
    }

    private final KotlinSdkService component1() {
        return this.kotlinSdkService;
    }

    private final SdkVersionParser component2() {
        return this.versionParser;
    }

    @NotNull
    public final PlatformSdkService copy(@NotNull KotlinSdkService kotlinSdkService, @NotNull SdkVersionParser versionParser) {
        Intrinsics.checkNotNullParameter((Object)kotlinSdkService, (String)"kotlinSdkService");
        Intrinsics.checkNotNullParameter((Object)versionParser, (String)"versionParser");
        return new PlatformSdkService(kotlinSdkService, versionParser);
    }

    public static /* synthetic */ PlatformSdkService copy$default(PlatformSdkService platformSdkService, KotlinSdkService kotlinSdkService, SdkVersionParser sdkVersionParser, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinSdkService = platformSdkService.kotlinSdkService;
        }
        if ((n & 2) != 0) {
            sdkVersionParser = platformSdkService.versionParser;
        }
        return platformSdkService.copy(kotlinSdkService, sdkVersionParser);
    }

    @NotNull
    public String toString() {
        return "PlatformSdkService(kotlinSdkService=" + this.kotlinSdkService + ", versionParser=" + this.versionParser + ")";
    }

    public int hashCode() {
        int result = this.kotlinSdkService.hashCode();
        result = result * 31 + this.versionParser.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlatformSdkService)) {
            return false;
        }
        PlatformSdkService platformSdkService = (PlatformSdkService)other;
        if (!Intrinsics.areEqual((Object)this.kotlinSdkService, (Object)platformSdkService.kotlinSdkService)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.versionParser, (Object)platformSdkService.versionParser);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Language.values().length];
            try {
                nArray[Language.JAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.KOTLIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.PYTHON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

