/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.rpc.notification;

import com.github.copilot.chat.conversation.agent.rpc.Preconditions;
import com.github.copilot.chat.precondition.ChatPreconditionsPublisher;
import com.github.copilot.chat.precondition.ChatPreconditionsUtilKt;
import com.github.copilot.lang.agent.rpc.JsonRPC;
import com.github.copilot.lang.agent.rpc.JsonRpcNotificationListener;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.google.gson.JsonElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u000bH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/copilot/chat/conversation/agent/rpc/notification/ConversationPreconditionsNotificationListener;", "Lcom/github/copilot/lang/agent/rpc/JsonRpcNotificationListener;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "preconditionsPublisher", "Lcom/github/copilot/chat/precondition/ChatPreconditionsPublisher;", "<init>", "(Lcom/github/copilot/platform/utils/observability/Logger;Lcom/github/copilot/chat/precondition/ChatPreconditionsPublisher;)V", "handleMessage", "", "name", "", "message", "Lcom/google/gson/JsonElement;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nConversationPreconditionsNotificationListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationPreconditionsNotificationListener.kt\ncom/github/copilot/chat/conversation/agent/rpc/notification/ConversationPreconditionsNotificationListener\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,41:1\n39#2:42\n*S KotlinDebug\n*F\n+ 1 ConversationPreconditionsNotificationListener.kt\ncom/github/copilot/chat/conversation/agent/rpc/notification/ConversationPreconditionsNotificationListener\n*L\n12#1:42\n*E\n"})
public final class ConversationPreconditionsNotificationListener
implements JsonRpcNotificationListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private final ChatPreconditionsPublisher preconditionsPublisher;
    @NotNull
    private static final String PRECONDITIONS_NOTIFICATION_NAME = "conversation/preconditionsNotification";

    public ConversationPreconditionsNotificationListener(@NotNull Logger log, @NotNull ChatPreconditionsPublisher preconditionsPublisher) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)preconditionsPublisher, (String)"preconditionsPublisher");
        this.log = log;
        this.preconditionsPublisher = preconditionsPublisher;
    }

    public /* synthetic */ ConversationPreconditionsNotificationListener(Logger logger, ChatPreconditionsPublisher chatPreconditionsPublisher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(ConversationPreconditionsNotificationListener.class);
        }
        if ((n & 2) != 0) {
            chatPreconditionsPublisher = ChatPreconditionsPublisher.Companion;
        }
        this(logger, chatPreconditionsPublisher);
    }

    @Override
    public boolean handleMessage(@NotNull String name, @NotNull JsonElement message) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!Intrinsics.areEqual((Object)name, (Object)PRECONDITIONS_NOTIFICATION_NAME)) {
            return false;
        }
        try {
            Preconditions preconditions = JsonRPC.parseResponse(message, Preconditions.class);
            Intrinsics.checkNotNullExpressionValue((Object)preconditions, (String)"parseResponse(...)");
            Preconditions preconditions2 = preconditions;
            this.log.debug("preconditions: " + preconditions2);
            this.preconditionsPublisher.publish(ChatPreconditionsUtilKt.toChatPreconditions(preconditions2));
        }
        catch (Throwable ex) {
            this.log.warn("failed to publish preconditions", ex);
        }
        return true;
    }

    private final Logger component1() {
        return this.log;
    }

    private final ChatPreconditionsPublisher component2() {
        return this.preconditionsPublisher;
    }

    @NotNull
    public final ConversationPreconditionsNotificationListener copy(@NotNull Logger log, @NotNull ChatPreconditionsPublisher preconditionsPublisher) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)preconditionsPublisher, (String)"preconditionsPublisher");
        return new ConversationPreconditionsNotificationListener(log, preconditionsPublisher);
    }

    public static /* synthetic */ ConversationPreconditionsNotificationListener copy$default(ConversationPreconditionsNotificationListener conversationPreconditionsNotificationListener, Logger logger, ChatPreconditionsPublisher chatPreconditionsPublisher, int n, Object object) {
        if ((n & 1) != 0) {
            logger = conversationPreconditionsNotificationListener.log;
        }
        if ((n & 2) != 0) {
            chatPreconditionsPublisher = conversationPreconditionsNotificationListener.preconditionsPublisher;
        }
        return conversationPreconditionsNotificationListener.copy(logger, chatPreconditionsPublisher);
    }

    @NotNull
    public String toString() {
        return "ConversationPreconditionsNotificationListener(log=" + this.log + ", preconditionsPublisher=" + this.preconditionsPublisher + ")";
    }

    public int hashCode() {
        int result = this.log.hashCode();
        result = result * 31 + this.preconditionsPublisher.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConversationPreconditionsNotificationListener)) {
            return false;
        }
        ConversationPreconditionsNotificationListener conversationPreconditionsNotificationListener = (ConversationPreconditionsNotificationListener)other;
        if (!Intrinsics.areEqual((Object)this.log, (Object)conversationPreconditionsNotificationListener.log)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.preconditionsPublisher, (Object)conversationPreconditionsNotificationListener.preconditionsPublisher);
    }

    public ConversationPreconditionsNotificationListener() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/copilot/chat/conversation/agent/rpc/notification/ConversationPreconditionsNotificationListener$Companion;", "", "<init>", "()V", "PRECONDITIONS_NOTIFICATION_NAME", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

