/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.workspace.project;

import com.github.copilot.chat.conversation.agent.workspace.FileWatcher;
import com.github.copilot.chat.conversation.agent.workspace.Workspace;
import com.github.copilot.chat.conversation.agent.workspace.WorkspaceFile;
import com.github.copilot.chat.conversation.agent.workspace.project.ProjectWorkspace;
import com.github.copilot.chat.conversation.agent.workspace.project.ProjectWorkspaceFile;
import com.github.copilot.chat.conversation.agent.workspace.project.ProjectWorkspaceFileKt;
import com.github.copilot.platform.utils.FileEventListener;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.VirtualFileKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u0013*\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\f\u0010\u001b\u001a\u00020\u0010*\u00020\u001aH\u0002J\r\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004H\u00c2\u0003J\u0017\u0010\u001d\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\bH\u00d6\u0001R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/copilot/chat/conversation/agent/workspace/project/ProjectWorkspace;", "Lcom/github/copilot/chat/conversation/agent/workspace/Workspace;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/github/copilot/platform/utils/PlatformProject;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "uri", "", "Lorg/jetbrains/annotations/NotNull;", "getUri", "()Ljava/lang/String;", "isWatchingFiles", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getFiles", "", "Lcom/github/copilot/chat/conversation/agent/workspace/WorkspaceFile;", "Lcom/github/copilot/chat/conversation/agent/workspace/WorkspaceFiles;", "excludeGitignoredFiles", "", "excludeIdeIgnoredFiles", "watchFiles", "", "fileWatcher", "Lcom/github/copilot/chat/conversation/agent/workspace/FileWatcher;", "isNotExcluded", "Lcom/intellij/openapi/vfs/VirtualFile;", "toWorkspaceFile", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "core"})
public final class ProjectWorkspace
implements Workspace {
    @NotNull
    private final Project project;
    @NotNull
    private final String uri;
    @NotNull
    private final AtomicBoolean isWatchingFiles;

    public ProjectWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        VirtualFile virtualFile = ProjectKt.getDir(this.project);
        Intrinsics.checkNotNull((Object)virtualFile);
        this.uri = VirtualFileKt.getUri(virtualFile);
        this.isWatchingFiles = new AtomicBoolean(false);
    }

    @Override
    @NotNull
    public String getUri() {
        return this.uri;
    }

    @Override
    @NotNull
    public List<WorkspaceFile> getFiles(boolean excludeGitignoredFiles, boolean excludeIdeIgnoredFiles) {
        ProjectKt.waitUntilGitInitialized(this.project);
        List files = new ArrayList();
        ProjectKt.iterateFiles$default(this.project, null, arg_0 -> ProjectWorkspace.getFiles$lambda$0(this, excludeGitignoredFiles, excludeIdeIgnoredFiles, files, arg_0), 1, null);
        return files;
    }

    @Override
    public void watchFiles(boolean excludeGitignoredFiles, boolean excludeIdeIgnoredFiles, @NotNull FileWatcher fileWatcher) {
        Intrinsics.checkNotNullParameter((Object)fileWatcher, (String)"fileWatcher");
        if (this.isWatchingFiles.getAndSet(true)) {
            return;
        }
        ProjectKt.subscribeToFileEvents(this.project, new FileEventListener(fileWatcher, this, excludeGitignoredFiles, excludeIdeIgnoredFiles){
            final /* synthetic */ FileWatcher $fileWatcher;
            final /* synthetic */ ProjectWorkspace this$0;
            final /* synthetic */ boolean $excludeGitignoredFiles;
            final /* synthetic */ boolean $excludeIdeIgnoredFiles;
            {
                this.$fileWatcher = $fileWatcher;
                this.this$0 = $receiver;
                this.$excludeGitignoredFiles = $excludeGitignoredFiles;
                this.$excludeIdeIgnoredFiles = $excludeIdeIgnoredFiles;
            }

            public void onCreate(VFileCreateEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.ifNotExcluded(event.getFile(), (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> watchFiles.1.onCreate$lambda$0(this.$fileWatcher, this.this$0, arg_0)));
            }

            public void onEdit(VFileContentChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.ifNotExcluded(event.getFile(), (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> watchFiles.1.onEdit$lambda$1(this.$fileWatcher, this.this$0, arg_0)));
            }

            public void onDelete(VFileDeleteEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.ifNotExcluded(event.getFile(), (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> watchFiles.1.onDelete$lambda$2(this.$fileWatcher, this.this$0, arg_0)));
            }

            public void onCopy(VFileCopyEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile virtualFile = event.findCreatedFile();
                    if (virtualFile == null) break block0;
                    this.ifNotExcluded(virtualFile, (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> watchFiles.1.onCopy$lambda$3(this.$fileWatcher, this.this$0, arg_0)));
                }
            }

            public void onMove(VFileMoveEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getOldParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOldParent(...)");
                this.$fileWatcher.onFileDeleted(new ProjectWorkspaceFile(VirtualFileKt.getUri(virtualFile) + "/" + event.getFile().getName()));
                this.ifNotExcluded(event.getFile(), (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> watchFiles.1.onMove$lambda$4(this.$fileWatcher, this.this$0, arg_0)));
            }

            private final boolean isNotExcluded(VirtualFile $this$isNotExcluded) {
                VirtualFile virtualFile = $this$isNotExcluded;
                return (virtualFile != null ? !virtualFile.isDirectory() : false) && ProjectWorkspace.access$isNotExcluded(this.this$0, $this$isNotExcluded, this.$excludeGitignoredFiles, this.$excludeIdeIgnoredFiles);
            }

            private final void ifNotExcluded(VirtualFile $this$ifNotExcluded, Function1<? super VirtualFile, Unit> block) {
                if (this.isNotExcluded($this$ifNotExcluded)) {
                    VirtualFile virtualFile = $this$ifNotExcluded;
                    Intrinsics.checkNotNull((Object)virtualFile);
                    block.invoke((Object)virtualFile);
                }
            }

            private static final Unit onCreate$lambda$0(FileWatcher $fileWatcher, ProjectWorkspace this$0, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                $fileWatcher.onFileCreated(ProjectWorkspace.access$toWorkspaceFile(this$0, file));
                return Unit.INSTANCE;
            }

            private static final Unit onEdit$lambda$1(FileWatcher $fileWatcher, ProjectWorkspace this$0, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                $fileWatcher.onFileChanged(ProjectWorkspace.access$toWorkspaceFile(this$0, file));
                return Unit.INSTANCE;
            }

            private static final Unit onDelete$lambda$2(FileWatcher $fileWatcher, ProjectWorkspace this$0, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                $fileWatcher.onFileDeleted(ProjectWorkspace.access$toWorkspaceFile(this$0, file));
                return Unit.INSTANCE;
            }

            private static final Unit onCopy$lambda$3(FileWatcher $fileWatcher, ProjectWorkspace this$0, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                $fileWatcher.onFileCreated(ProjectWorkspace.access$toWorkspaceFile(this$0, file));
                return Unit.INSTANCE;
            }

            private static final Unit onMove$lambda$4(FileWatcher $fileWatcher, ProjectWorkspace this$0, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                $fileWatcher.onFileCreated(ProjectWorkspace.access$toWorkspaceFile(this$0, file));
                return Unit.INSTANCE;
            }
        });
    }

    private final boolean isNotExcluded(VirtualFile $this$isNotExcluded, boolean excludeGitignoredFiles, boolean excludeIdeIgnoredFiles) {
        if (VirtualFileKt.isIdeFile($this$isNotExcluded)) {
            return false;
        }
        if (excludeGitignoredFiles && VirtualFileKt.isGitIgnored($this$isNotExcluded, ProjectKt.getFileStatusManager(this.project))) {
            return false;
        }
        return !excludeIdeIgnoredFiles || !VirtualFileKt.isIdeIgnored($this$isNotExcluded, ProjectKt.getIndex(this.project));
    }

    private final WorkspaceFile toWorkspaceFile(VirtualFile $this$toWorkspaceFile) {
        return ProjectWorkspaceFileKt.ProjectWorkspaceFile($this$toWorkspaceFile);
    }

    private final Project component1() {
        return this.project;
    }

    @NotNull
    public final ProjectWorkspace copy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ProjectWorkspace(project);
    }

    public static /* synthetic */ ProjectWorkspace copy$default(ProjectWorkspace projectWorkspace, Project project, int n, Object object) {
        if ((n & 1) != 0) {
            project = projectWorkspace.project;
        }
        return projectWorkspace.copy(project);
    }

    @NotNull
    public String toString() {
        return "ProjectWorkspace(project=" + this.project + ")";
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProjectWorkspace)) {
            return false;
        }
        ProjectWorkspace projectWorkspace = (ProjectWorkspace)other;
        return Intrinsics.areEqual((Object)this.project, (Object)projectWorkspace.project);
    }

    private static final Unit getFiles$lambda$0(ProjectWorkspace this$0, boolean $excludeGitignoredFiles, boolean $excludeIdeIgnoredFiles, List $files, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this$0.isNotExcluded(file, $excludeGitignoredFiles, $excludeIdeIgnoredFiles)) {
            $files.add(this$0.toWorkspaceFile(file));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isNotExcluded(ProjectWorkspace $this, VirtualFile $receiver, boolean excludeGitignoredFiles, boolean excludeIdeIgnoredFiles) {
        return $this.isNotExcluded($receiver, excludeGitignoredFiles, excludeIdeIgnoredFiles);
    }

    public static final /* synthetic */ WorkspaceFile access$toWorkspaceFile(ProjectWorkspace $this, VirtualFile $receiver) {
        return $this.toWorkspaceFile($receiver);
    }
}

