/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.followup;

import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.message.ChatFollowUp;
import com.github.copilot.chat.renderer.ChatMarkdownTransformer;
import com.github.copilot.style.Style;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/copilot/chat/followup/FollowUpComponent;", "Ljavax/swing/JPanel;", "followUp", "Lcom/github/copilot/chat/message/ChatFollowUp;", "onClick", "Lkotlin/Function0;", "", "<init>", "(Lcom/github/copilot/chat/message/ChatFollowUp;Lkotlin/jvm/functions/Function0;)V", "processKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "leftConstraint", "Ljava/awt/GridBagConstraints;", "rightConstraint", "core"})
public final class FollowUpComponent
extends JPanel {
    @NotNull
    private final Function0<Unit> onClick;

    public FollowUpComponent(@NotNull ChatFollowUp followUp, @NotNull Function0<Unit> onClick) {
        Intrinsics.checkNotNullParameter((Object)followUp, (String)"followUp");
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        super(new GridBagLayout());
        this.onClick = onClick;
        Icon icon = CopilotIcons.Sparkle;
        JLabel iconLabel = new JLabel(icon);
        this.add((Component)iconLabel, this.leftConstraint());
        String formattedMessage = ChatMarkdownTransformer.INSTANCE.toHtml(followUp.getMessage());
        JLabel linkLabel2 = new JLabel("<HTML>" + formattedMessage + "</HTML>");
        linkLabel2.setForeground((Color)Style.Colors.INSTANCE.getFollowUp());
        linkLabel2.setCursor(new Cursor(12));
        final int dynamicBottomMargin = Math.max((int)Math.ceil((double)(icon.getIconHeight() - linkLabel2.getFont().getSize()) / (double)2), 0);
        linkLabel2.setBorder(BorderFactory.createEmptyBorder(0, 6, dynamicBottomMargin, 0));
        linkLabel2.setVerticalAlignment(0);
        linkLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                try {
                    onClick.invoke();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, JBUI.CurrentTheme.Focus.focusColor()), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
            }

            @Override
            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setBorder(BorderFactory.createEmptyBorder(0, 6, dynamicBottomMargin, 0));
            }
        });
        this.add((Component)linkLabel2, this.rightConstraint());
    }

    public /* synthetic */ FollowUpComponent(ChatFollowUp chatFollowUp, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = FollowUpComponent::_init_$lambda$0;
        }
        this(chatFollowUp, (Function0<Unit>)function0);
    }

    @Override
    protected void processKeyEvent(@Nullable KeyEvent e) {
        KeyEvent keyEvent = e;
        boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 10 : false;
        if (bl && e.getID() == 401) {
            this.onClick.invoke();
        } else {
            super.processKeyEvent(e);
        }
    }

    private final GridBagConstraints leftConstraint() {
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        return c;
    }

    private final GridBagConstraints rightConstraint() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.gridx = 1;
        return c;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }
}

