/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.formatting;

import com.github.copilot.chat.renderer.MarkdownASTEnvelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/github/copilot/chat/formatting/Markdown;", "", "<init>", "()V", "getMarkdownAst", "Lcom/github/copilot/chat/renderer/MarkdownASTEnvelope;", "rawMarkdown", "", "decomposeASTtoPartialOffsets", "", "Lcom/github/copilot/chat/formatting/Markdown$MarkdownPartial;", "getCodeBlockProperties", "Lcom/github/copilot/chat/formatting/Markdown$CodeBlockProperties;", "Lorg/intellij/markdown/ast/ASTNode;", "markdown", "getMarkdownType", "Lcom/github/copilot/chat/formatting/Markdown$MarkdownType;", "CodeBlockProperties", "MarkdownPartial", "MarkdownType", "core"})
@SourceDebugExtension(value={"SMAP\nMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Markdown.kt\ncom/github/copilot/chat/formatting/Markdown\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1747#2,3:121\n*S KotlinDebug\n*F\n+ 1 Markdown.kt\ncom/github/copilot/chat/formatting/Markdown\n*L\n40#1:121,3\n*E\n"})
public final class Markdown {
    @NotNull
    public static final Markdown INSTANCE = new Markdown();

    private Markdown() {
    }

    private final MarkdownASTEnvelope getMarkdownAst(String rawMarkdown) {
        String markdown = ((Object)StringsKt.trim((CharSequence)rawMarkdown)).toString();
        GFMFlavourDescriptor flavour = new GFMFlavourDescriptor(false, false, false, 7, null);
        return new MarkdownASTEnvelope(markdown, new MarkdownParser((MarkdownFlavourDescriptor)flavour).buildMarkdownTreeFromString(markdown));
    }

    @NotNull
    public final List<MarkdownPartial> decomposeASTtoPartialOffsets(@NotNull String rawMarkdown) {
        Intrinsics.checkNotNullParameter((Object)rawMarkdown, (String)"rawMarkdown");
        List partials = new ArrayList();
        MarkdownASTEnvelope astEnvelope = this.getMarkdownAst(rawMarkdown);
        Map codeBlockTypeCounts = new LinkedHashMap();
        if (astEnvelope.getAstRoot().getChildren().isEmpty()) {
            return partials;
        }
        for (ASTNode child : astEnvelope.getAstRoot().getChildren()) {
            if (this.getMarkdownType(child) == MarkdownType.CODE_BLOCK) {
                boolean bl;
                CodeBlockProperties codeBlockProperties;
                block8: {
                    codeBlockProperties = this.getCodeBlockProperties(child, astEnvelope.getMarkdown());
                    codeBlockTypeCounts.put(MarkdownType.CODE_BLOCK, ((Number)codeBlockTypeCounts.getOrDefault((Object)MarkdownType.CODE_BLOCK, 0)).intValue() + 1);
                    Iterable $this$any$iv = child.getChildren();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ASTNode it = (ASTNode)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                partials.add(new MarkdownPartial(codeBlockProperties.getStartOffset(), codeBlockProperties.getEndOffset(), null, MarkdownType.CODE_BLOCK, codeBlockProperties.getLanguage(), ((Number)codeBlockTypeCounts.getOrDefault((Object)MarkdownType.CODE_BLOCK, 0)).intValue(), 4, null));
                continue;
            }
            if (!((Collection)partials).isEmpty() && ((MarkdownPartial)CollectionsKt.last((List)partials)).getType() == MarkdownType.MARKDOWN) {
                ((MarkdownPartial)CollectionsKt.last((List)partials)).setEnd(child.getEndOffset());
                continue;
            }
            partials.add(new MarkdownPartial(child.getStartOffset(), child.getEndOffset(), null, MarkdownType.MARKDOWN, null, 0, 52, null));
        }
        for (MarkdownPartial partial : partials) {
            String string = astEnvelope.getMarkdown().substring(partial.getStart(), partial.getEnd());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            partial.setContent(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        return partials;
    }

    private final CodeBlockProperties getCodeBlockProperties(ASTNode $this$getCodeBlockProperties, String markdown) {
        CodeBlockProperties codeBlockProperties = new CodeBlockProperties(null, 0, 0, 7, null);
        Iterator iterator = ((Iterable)$this$getCodeBlockProperties.getChildren()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            ASTNode child = (ASTNode)iterator.next();
            IElementType iElementType = child.getType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.FENCE_LANG)) {
                String string = markdown.substring(child.getStartOffset(), child.getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                codeBlockProperties.setLanguage(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_START)) {
                if ($this$getCodeBlockProperties.getChildren().size() > index + 1 && Intrinsics.areEqual((Object)((ASTNode)$this$getCodeBlockProperties.getChildren().get(index + 1)).getType(), (Object)MarkdownTokenTypes.FENCE_LANG)) {
                    codeBlockProperties.setStartOffset(((ASTNode)$this$getCodeBlockProperties.getChildren().get(index + 1)).getEndOffset());
                    continue;
                }
                codeBlockProperties.setStartOffset(child.getEndOffset());
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_END)) continue;
            codeBlockProperties.setEndOffset(child.getStartOffset());
        }
        if (codeBlockProperties.getEndOffset() == 0) {
            codeBlockProperties.setEndOffset($this$getCodeBlockProperties.getEndOffset());
        }
        return codeBlockProperties;
    }

    private final MarkdownType getMarkdownType(ASTNode $this$getMarkdownType) {
        return Intrinsics.areEqual((Object)$this$getMarkdownType.getType(), (Object)MarkdownElementTypes.CODE_FENCE) ? MarkdownType.CODE_BLOCK : MarkdownType.MARKDOWN;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J)\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/github/copilot/chat/formatting/Markdown$CodeBlockProperties;", "", "language", "", "startOffset", "", "endOffset", "<init>", "(Ljava/lang/String;II)V", "getLanguage", "()Ljava/lang/String;", "setLanguage", "(Ljava/lang/String;)V", "getStartOffset", "()I", "setStartOffset", "(I)V", "getEndOffset", "setEndOffset", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    public static final class CodeBlockProperties {
        @Nullable
        private String language;
        private int startOffset;
        private int endOffset;

        public CodeBlockProperties(@Nullable String language, int startOffset, int endOffset) {
            this.language = language;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public /* synthetic */ CodeBlockProperties(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                string = null;
            }
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            this(string, n, n2);
        }

        @Nullable
        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(@Nullable String string) {
            this.language = string;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final void setStartOffset(int n) {
            this.startOffset = n;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        public final void setEndOffset(int n) {
            this.endOffset = n;
        }

        @Nullable
        public final String component1() {
            return this.language;
        }

        public final int component2() {
            return this.startOffset;
        }

        public final int component3() {
            return this.endOffset;
        }

        @NotNull
        public final CodeBlockProperties copy(@Nullable String language, int startOffset, int endOffset) {
            return new CodeBlockProperties(language, startOffset, endOffset);
        }

        public static /* synthetic */ CodeBlockProperties copy$default(CodeBlockProperties codeBlockProperties, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = codeBlockProperties.language;
            }
            if ((n3 & 2) != 0) {
                n = codeBlockProperties.startOffset;
            }
            if ((n3 & 4) != 0) {
                n2 = codeBlockProperties.endOffset;
            }
            return codeBlockProperties.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "CodeBlockProperties(language=" + this.language + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ")";
        }

        public int hashCode() {
            int result = this.language == null ? 0 : this.language.hashCode();
            result = result * 31 + Integer.hashCode(this.startOffset);
            result = result * 31 + Integer.hashCode(this.endOffset);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CodeBlockProperties)) {
                return false;
            }
            CodeBlockProperties codeBlockProperties = (CodeBlockProperties)other;
            if (!Intrinsics.areEqual((Object)this.language, (Object)codeBlockProperties.language)) {
                return false;
            }
            if (this.startOffset != codeBlockProperties.startOffset) {
                return false;
            }
            return this.endOffset == codeBlockProperties.endOffset;
        }

        public CodeBlockProperties() {
            this(null, 0, 0, 7, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003JG\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\t\u0010%\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000e\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/github/copilot/chat/formatting/Markdown$MarkdownPartial;", "", "start", "", "end", "content", "", "type", "Lcom/github/copilot/chat/formatting/Markdown$MarkdownType;", "language", "index", "<init>", "(IILjava/lang/String;Lcom/github/copilot/chat/formatting/Markdown$MarkdownType;Ljava/lang/String;I)V", "getStart", "()I", "getEnd", "setEnd", "(I)V", "getContent", "()Ljava/lang/String;", "setContent", "(Ljava/lang/String;)V", "getType", "()Lcom/github/copilot/chat/formatting/Markdown$MarkdownType;", "getLanguage", "getIndex", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    public static final class MarkdownPartial {
        private final int start;
        private int end;
        @NotNull
        private String content;
        @NotNull
        private final MarkdownType type;
        @Nullable
        private final String language;
        private final int index;

        public MarkdownPartial(int start2, int end, @NotNull String content, @NotNull MarkdownType type, @Nullable String language, int index) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.start = start2;
            this.end = end;
            this.content = content;
            this.type = type;
            this.language = language;
            this.index = index;
        }

        public /* synthetic */ MarkdownPartial(int n, int n2, String string, MarkdownType markdownType, String string2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                string = "";
            }
            if ((n4 & 8) != 0) {
                markdownType = MarkdownType.MARKDOWN;
            }
            if ((n4 & 0x10) != 0) {
                string2 = null;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 0;
            }
            this(n, n2, string, markdownType, string2, n3);
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final void setContent(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.content = string;
        }

        @NotNull
        public final MarkdownType getType() {
            return this.type;
        }

        @Nullable
        public final String getLanguage() {
            return this.language;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final String component3() {
            return this.content;
        }

        @NotNull
        public final MarkdownType component4() {
            return this.type;
        }

        @Nullable
        public final String component5() {
            return this.language;
        }

        public final int component6() {
            return this.index;
        }

        @NotNull
        public final MarkdownPartial copy(int start2, int end, @NotNull String content, @NotNull MarkdownType type, @Nullable String language, int index) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new MarkdownPartial(start2, end, content, type, language, index);
        }

        public static /* synthetic */ MarkdownPartial copy$default(MarkdownPartial markdownPartial, int n, int n2, String string, MarkdownType markdownType, String string2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = markdownPartial.start;
            }
            if ((n4 & 2) != 0) {
                n2 = markdownPartial.end;
            }
            if ((n4 & 4) != 0) {
                string = markdownPartial.content;
            }
            if ((n4 & 8) != 0) {
                markdownType = markdownPartial.type;
            }
            if ((n4 & 0x10) != 0) {
                string2 = markdownPartial.language;
            }
            if ((n4 & 0x20) != 0) {
                n3 = markdownPartial.index;
            }
            return markdownPartial.copy(n, n2, string, markdownType, string2, n3);
        }

        @NotNull
        public String toString() {
            return "MarkdownPartial(start=" + this.start + ", end=" + this.end + ", content=" + this.content + ", type=" + this.type + ", language=" + this.language + ", index=" + this.index + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + this.content.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
            result = result * 31 + Integer.hashCode(this.index);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MarkdownPartial)) {
                return false;
            }
            MarkdownPartial markdownPartial = (MarkdownPartial)other;
            if (this.start != markdownPartial.start) {
                return false;
            }
            if (this.end != markdownPartial.end) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)markdownPartial.content)) {
                return false;
            }
            if (this.type != markdownPartial.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.language, (Object)markdownPartial.language)) {
                return false;
            }
            return this.index == markdownPartial.index;
        }

        public MarkdownPartial() {
            this(0, 0, null, null, null, 0, 63, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/copilot/chat/formatting/Markdown$MarkdownType;", "", "<init>", "(Ljava/lang/String;I)V", "MARKDOWN", "CODE_BLOCK", "core"})
    public static final class MarkdownType
    extends Enum<MarkdownType> {
        public static final /* enum */ MarkdownType MARKDOWN = new MarkdownType();
        public static final /* enum */ MarkdownType CODE_BLOCK = new MarkdownType();
        private static final /* synthetic */ MarkdownType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MarkdownType[] values() {
            return (MarkdownType[])$VALUES.clone();
        }

        public static MarkdownType valueOf(String value) {
            return Enum.valueOf(MarkdownType.class, value);
        }

        @NotNull
        public static EnumEntries<MarkdownType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = markdownTypeArray = new MarkdownType[]{MarkdownType.MARKDOWN, MarkdownType.CODE_BLOCK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

