/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.inline;

import com.github.copilot.chat.inline.ConditionalActionConfiguration;
import com.github.copilot.chat.inline.DefaultActionScopePredicateFactory;
import com.github.copilot.chat.inline.InlineChatService;
import com.github.copilot.chat.inline.KeyStrokeExecutor;
import com.github.copilot.chat.inline.PredicateFactory;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import java.util.Collection;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J$\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/copilot/chat/inline/ConditionalEditorActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "conditionalActionConfiguration", "Lcom/github/copilot/chat/inline/ConditionalActionConfiguration;", "inlineChatService", "Lcom/github/copilot/chat/inline/InlineChatService;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/github/copilot/chat/inline/ConditionalActionConfiguration;Lcom/github/copilot/chat/inline/InlineChatService;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getInlineChatService", "()Lcom/github/copilot/chat/inline/InlineChatService;", "executing", "", "predicateFactory", "Lcom/github/copilot/chat/inline/PredicateFactory;", "executeActionInAlternativeHandler", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "alternativeHandlerIsEnabled", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "doExecute", "core"})
@SourceDebugExtension(value={"SMAP\nConditionalEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConditionalEditorActionHandler.kt\ncom/github/copilot/chat/inline/ConditionalEditorActionHandler\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n39#2:66\n1747#3,3:67\n*S KotlinDebug\n*F\n+ 1 ConditionalEditorActionHandler.kt\ncom/github/copilot/chat/inline/ConditionalEditorActionHandler\n*L\n25#1:66\n34#1:67,3\n*E\n"})
public final class ConditionalEditorActionHandler
extends EditorActionHandler {
    @NotNull
    private final EditorActionHandler originalHandler;
    @NotNull
    private final ConditionalActionConfiguration conditionalActionConfiguration;
    @NotNull
    private final InlineChatService inlineChatService;
    @NotNull
    private final Logger log;
    private boolean executing;
    @NotNull
    private final PredicateFactory predicateFactory;

    public ConditionalEditorActionHandler(@NotNull EditorActionHandler originalHandler, @NotNull ConditionalActionConfiguration conditionalActionConfiguration, @NotNull InlineChatService inlineChatService, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        Intrinsics.checkNotNullParameter((Object)conditionalActionConfiguration, (String)"conditionalActionConfiguration");
        Intrinsics.checkNotNullParameter((Object)inlineChatService, (String)"inlineChatService");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.originalHandler = originalHandler;
        this.conditionalActionConfiguration = conditionalActionConfiguration;
        this.inlineChatService = inlineChatService;
        this.log = log;
        this.predicateFactory = new DefaultActionScopePredicateFactory(this.inlineChatService);
    }

    public /* synthetic */ ConditionalEditorActionHandler(EditorActionHandler editorActionHandler, ConditionalActionConfiguration conditionalActionConfiguration, InlineChatService inlineChatService, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(ConditionalEditorActionHandler.class);
        }
        this(editorActionHandler, conditionalActionConfiguration, inlineChatService, logger);
    }

    @NotNull
    public final InlineChatService getInlineChatService() {
        return this.inlineChatService;
    }

    private final void executeActionInAlternativeHandler(Editor editor) {
        KeyStrokeExecutor executor = this.conditionalActionConfiguration.getKeyStrokeExecutorProvider().keyStrokeExecutor(editor);
        if (executor != null) {
            Iterable $this$any$iv = this.conditionalActionConfiguration.getBoundKeyStrokes();
            boolean $i$f$any = false;
            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
                for (Object element$iv : $this$any$iv) {
                    KeyStroke it = (KeyStroke)element$iv;
                    boolean bl = false;
                    if (!executor.executeKeyStroke(it)) continue;
                    break;
                }
            }
        }
    }

    private final boolean alternativeHandlerIsEnabled(Editor editor, Caret caret, DataContext dataContext) {
        return this.predicateFactory.predicate(this.conditionalActionConfiguration.getScope()).evaluate(editor, caret, dataContext);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.alternativeHandlerIsEnabled(editor, caret, dataContext) || this.originalHandler.isEnabled(editor, caret, dataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (this.executing) {
            return;
        }
        try {
            this.executing = true;
            if (this.alternativeHandlerIsEnabled(editor, caret, dataContext)) {
                this.executeActionInAlternativeHandler(editor);
            } else {
                this.originalHandler.execute(editor, caret, dataContext);
            }
        }
        finally {
            this.executing = false;
        }
    }
}

