/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.inline;

import com.github.copilot.chat.inline.InlineChatInputPanel;
import com.github.copilot.chat.inline.InlineChatTopPanel;
import com.github.copilot.chat.inline.KeyStrokeExecutor;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.platform.utils.EditorKt;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.style.Style;
import com.github.copilot.ui.component.JComponentKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.RoundedLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001?B)\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020%J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020(H\u0002J\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020+J\b\u0010/\u001a\u00020(H\u0002J\b\u00100\u001a\u00020(H\u0016J\u0014\u00101\u001a\u00020+2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0014\u00102\u001a\u00020+2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J,\u00103\u001a\u00020(2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/github/copilot/chat/inline/InlineChatComponent;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "Lcom/github/copilot/chat/inline/KeyStrokeExecutor;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "persistenceService", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "editor", "Lcom/intellij/openapi/editor/Editor;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;Lcom/intellij/openapi/editor/Editor;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getLog", "()Lcom/github/copilot/platform/utils/observability/Logger;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "setInlay", "(Lcom/intellij/openapi/editor/Inlay;)V", "inlineContainer", "Ljava/awt/Container;", "getInlineContainer", "()Ljava/awt/Container;", "setInlineContainer", "(Ljava/awt/Container;)V", "chatInputPanel", "Lcom/github/copilot/chat/inline/InlineChatInputPanel;", "getChatInputPanel", "()Lcom/github/copilot/chat/inline/InlineChatInputPanel;", "topPanel", "Lcom/github/copilot/chat/inline/InlineChatTopPanel;", "centerContent", "Ljavax/swing/JComponent;", "centerPanel", "setContent", "", "content", "getInlayOffset", "", "showContent", "createInlay", "offset", "redraw", "dispose", "calcWidthInPixels", "calcHeightInPixels", "paint", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "executeKeyStroke", "", "keyStroke", "Ljavax/swing/KeyStroke;", "handleKeyboardFocusChange", "FocusInputOnClickMouseListener", "core"})
@SourceDebugExtension(value={"SMAP\nInlineChatComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineChatComponent.kt\ncom/github/copilot/chat/inline/InlineChatComponent\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n39#2:246\n1282#3:247\n4098#3,11:248\n1283#3:262\n1747#4,3:259\n*S KotlinDebug\n*F\n+ 1 InlineChatComponent.kt\ncom/github/copilot/chat/inline/InlineChatComponent\n*L\n32#1:246\n182#1:247\n183#1:248,11\n182#1:262\n184#1:259,3\n*E\n"})
public final class InlineChatComponent
extends JPanel
implements EditorCustomElementRenderer,
KeyStrokeExecutor,
Disposable {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Logger log;
    @Nullable
    private Inlay<?> inlay;
    @Nullable
    private Container inlineContainer;
    @NotNull
    private final InlineChatInputPanel chatInputPanel;
    @NotNull
    private final InlineChatTopPanel topPanel;
    @Nullable
    private JComponent centerContent;
    @NotNull
    private final JPanel centerPanel;

    public InlineChatComponent(@NotNull Disposable parentDisposable, @NotNull ChatSessionPersistenceService persistenceService, @NotNull Editor editor, @NotNull Logger log) {
        JPanel $this$centerPanel_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)persistenceService, (String)"persistenceService");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(new GridBagLayout());
        this.editor = editor;
        this.log = log;
        this.chatInputPanel = new InlineChatInputPanel(this, persistenceService, this.editor, null, 8, null);
        this.topPanel = new InlineChatTopPanel(this.chatInputPanel, this.editor);
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        InlineChatComponent inlineChatComponent = this;
        boolean bl = false;
        $this$centerPanel_u24lambda_u240.setBackground((Color)Style.Colors.InlineChat.INSTANCE.getBackground());
        $this$centerPanel_u24lambda_u240.setVisible(false);
        $this$centerPanel_u24lambda_u240.addMouseListener(new FocusInputOnClickMouseListener(this));
        inlineChatComponent.centerPanel = jPanel;
        this.setOpaque(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        $this$centerPanel_u24lambda_u240 = jPanel = new RoundedLineBorder((Color)Style.Colors.InlineChat.INSTANCE.getBorder(), 8, 1);
        Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        inlineChatComponent = this;
        boolean bl2 = false;
        this.setBackground((Color)Style.Colors.InlineChat.INSTANCE.getBackground());
        Unit unit = Unit.INSTANCE;
        inlineChatComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(border, (Border)((Object)jPanel)), BorderFactory.createCompoundBorder((Border)new RoundedLineBorder((Color)Style.Colors.InlineChat.INSTANCE.getBackground(), 8, 1), BorderFactory.createMatteBorder(11, 11, 11, 11, (Color)Style.Colors.InlineChat.INSTANCE.getBackground()))));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.add((Component)this.topPanel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 1;
        this.add((Component)this.centerPanel, constraints);
        JComponentKt.inAllChildren(this, (Function1<? super JComponent, Unit>)((Function1)arg_0 -> InlineChatComponent._init_$lambda$4(this, arg_0)));
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Inlay<?> inlay = this.getInlay();
                if (inlay == null) {
                    return;
                }
                int offset = inlay.getOffset();
                if (offset > this.getEditor().getDocument().getTextLength()) {
                    this.createInlay(this.getEditor().getCaretModel().getPrimaryCaret().getOffset());
                }
            }
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    public /* synthetic */ InlineChatComponent(Disposable disposable, ChatSessionPersistenceService chatSessionPersistenceService, Editor editor, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(InlineChatComponent.class);
        }
        this(disposable, chatSessionPersistenceService, editor, logger);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Nullable
    public final Inlay<?> getInlay() {
        return this.inlay;
    }

    public final void setInlay(@Nullable Inlay<?> inlay) {
        this.inlay = inlay;
    }

    @Nullable
    public final Container getInlineContainer() {
        return this.inlineContainer;
    }

    public final void setInlineContainer(@Nullable Container container) {
        this.inlineContainer = container;
    }

    @NotNull
    public final InlineChatInputPanel getChatInputPanel() {
        return this.chatInputPanel;
    }

    public final void setContent(@NotNull JComponent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        content.setOpaque(true);
        content.setBackground((Color)Style.Colors.InlineChat.INSTANCE.getBackground());
        this.centerContent = content;
        this.showContent();
    }

    public final int getInlayOffset() {
        Inlay<?> inlay = this.inlay;
        return inlay != null ? inlay.getOffset() : -1;
    }

    private final void showContent() {
        block0: {
            JComponent jComponent = this.centerContent;
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            ApplicationManager.getApplication().invokeLater(() -> InlineChatComponent.showContent$lambda$2$lambda$1(this, it));
        }
    }

    public final void createInlay(int offset) {
        this.inlay = this.editor.getInlayModel().addBlockElement(offset, false, true, 1, (EditorCustomElementRenderer)this);
    }

    private final void redraw() {
        ApplicationManager.getApplication().invokeLater(() -> InlineChatComponent.redraw$lambda$5(this));
    }

    public void dispose() {
        block0: {
            Inlay<?> inlay = this.inlay;
            if (inlay == null) break block0;
            inlay.dispose();
        }
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.getSize().width;
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.getSize().height;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        block1: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            Rectangle rectangle = inlay.getBounds();
            if (rectangle == null) break block1;
            Rectangle it = rectangle;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.getBounds(), (Object)it)) {
                return;
            }
            this.setBounds(it);
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean executeKeyStroke(@NotNull KeyStroke keyStroke) {
        ActionListener focusedComponentAction;
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        this.log.debug("executeKeyStroke: " + keyStroke);
        ActionListener action2 = this.chatInputPanel.getInputComponent().getActionForKeyStroke(keyStroke);
        Component focusedComponent = FocusManager.getCurrentManager().getFocusOwner();
        JComponent jComponent = focusedComponent instanceof JComponent ? (JComponent)focusedComponent : null;
        ActionListener actionListener = focusedComponentAction = jComponent != null ? jComponent.getActionForKeyStroke(keyStroke) : null;
        if (focusedComponent instanceof EditorComponentImpl) {
            EditorImpl editorImpl = ((EditorComponentImpl)focusedComponent).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"getEditor(...)");
            if (EditorKt.getFile((Editor)editorImpl) instanceof LightVirtualFile) {
                try {
                    Object object;
                    block14: {
                        ActionManager actionManager = ActionManager.getInstance();
                        String string = ((EditorComponentImpl)focusedComponent).getEditor().getContextMenuGroupId();
                        Intrinsics.checkNotNull((Object)string);
                        AnAction anAction = actionManager.getAction(string);
                        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
                        AnAction[] anActionArray = ((DefaultActionGroup)anAction).getChildActionsOrStubs();
                        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildActionsOrStubs(...)");
                        Object[] objectArray = anActionArray;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : objectArray) {
                            boolean bl;
                            block13: {
                                void $this$filterIsInstanceTo$iv$iv;
                                AnAction childAction = (AnAction)element$iv;
                                boolean bl2 = false;
                                Shortcut[] shortcutArray = childAction.getShortcutSet().getShortcuts();
                                Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
                                Object[] objectArray2 = shortcutArray;
                                boolean $i$f$filterIsInstance = false;
                                Object[] objectArray3 = objectArray2;
                                Collection destination$iv$iv = new ArrayList();
                                boolean $i$f$filterIsInstanceTo = false;
                                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                    if (!(element$iv$iv instanceof KeyboardShortcut)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                Iterable iterable = (List)destination$iv$iv;
                                boolean $i$f$any = false;
                                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (Object element$iv2 : iterable) {
                                        KeyboardShortcut it = (KeyboardShortcut)element$iv2;
                                        boolean bl3 = false;
                                        if (!(Intrinsics.areEqual((Object)it.getFirstKeyStroke(), (Object)keyStroke) || Intrinsics.areEqual((Object)it.getSecondKeyStroke(), (Object)keyStroke))) continue;
                                        bl = true;
                                        break block13;
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) continue;
                            object = element$iv;
                            break block14;
                        }
                        object = null;
                    }
                    AnAction childAction = (AnAction)object;
                    if (childAction != null) {
                        childAction.actionPerformed(AnActionEvent.createFromDataContext((String)"EditorInlay", null, (DataContext)SimpleDataContext.getProjectContext((Project)ProjectKt.getProject())));
                        return true;
                    } else {
                        ActionListener actionListener2 = action2;
                        if (actionListener2 == null) return true;
                        actionListener2.actionPerformed(new ActionEvent((Object)this.chatInputPanel.getInputComponent(), 0, ""));
                    }
                    return true;
                }
                catch (Exception exception) {
                    this.log.error("Failed to execute action for key stroke: " + keyStroke, exception);
                    return false;
                }
            }
        }
        if (this.handleKeyboardFocusChange(keyStroke)) {
            return true;
        }
        if (focusedComponentAction != null) {
            focusedComponentAction.actionPerformed(new ActionEvent(focusedComponent, 0, ""));
            return true;
        }
        if (action2 == null) return false;
        action2.actionPerformed(new ActionEvent((Object)this.chatInputPanel.getInputComponent(), 0, ""));
        return true;
    }

    private final boolean handleKeyboardFocusChange(KeyStroke keyStroke) {
        if (keyStroke.getKeyCode() == 9 && keyStroke.getModifiers() == 0) {
            FocusManager.getCurrentManager().getFocusOwner().transferFocus();
            return true;
        }
        if (keyStroke.getKeyCode() == 9 && keyStroke.getModifiers() == 65) {
            FocusManager.getCurrentManager().getFocusOwner().transferFocusBackward();
            return true;
        }
        return false;
    }

    private static final void showContent$lambda$2$lambda$1(InlineChatComponent this$0, JComponent $it) {
        if (!this$0.centerPanel.isVisible()) {
            this$0.centerPanel.setVisible(true);
        }
        this$0.centerPanel.removeAll();
        this$0.centerPanel.add((Component)$it, "Center");
    }

    private static final Unit _init_$lambda$4(InlineChatComponent this$0, JComponent childComponent) {
        Intrinsics.checkNotNullParameter((Object)childComponent, (String)"childComponent");
        childComponent.addComponentListener(new ComponentAdapter(this$0){
            final /* synthetic */ InlineChatComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                InlineChatComponent.access$redraw(this.this$0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final void redraw$lambda$5(InlineChatComponent this$0) {
        if (this$0.getSize().height != this$0.getMinimumSize().height) {
            this$0.setSize(new Dimension(800, this$0.getMinimumSize().height));
            Inlay<?> inlay = this$0.inlay;
            if (inlay != null) {
                inlay.update();
            }
            this$0.revalidate();
            this$0.repaint();
        }
    }

    public static final /* synthetic */ void access$redraw(InlineChatComponent $this) {
        $this.redraw();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/copilot/chat/inline/InlineChatComponent$FocusInputOnClickMouseListener;", "Ljava/awt/event/MouseAdapter;", "component", "Lcom/github/copilot/chat/inline/InlineChatComponent;", "<init>", "(Lcom/github/copilot/chat/inline/InlineChatComponent;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "core"})
    private static final class FocusInputOnClickMouseListener
    extends MouseAdapter {
        @NotNull
        private final InlineChatComponent component;

        public FocusInputOnClickMouseListener(@NotNull InlineChatComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.component = component2;
        }

        @Override
        public void mouseClicked(@Nullable MouseEvent e) {
            if (e == null) {
                return;
            }
            Project project = this.component.getEditor().getProject();
            Intrinsics.checkNotNull((Object)project);
            IdeFocusManager.getInstance((Project)project).requestFocus((Component)((Object)this.component.getChatInputPanel().getInputComponent()), true);
        }
    }
}

