/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.inline;

import com.github.copilot.chat.inline.GutterIconInfo;
import com.github.copilot.chat.inline.InlineChatGutterIconRenderer;
import com.github.copilot.chat.inline.InlineChatService;
import com.github.copilot.chat.inline.status.CachingInlineChatStatusService;
import com.github.copilot.chat.inline.status.CachingInlineChatStatusServiceKt;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.platform.utils.EditorKt;
import com.github.copilot.platform.utils.VirtualFileKt;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import io.ktor.util.collections.ConcurrentMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0014\u0010\u0011\u001a\u00020\r*\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\r*\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/copilot/chat/inline/InlineChatGutterIcon;", "", "<init>", "()V", "isRegistered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "gutterIcons", "Lio/ktor/util/collections/ConcurrentMap;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/github/copilot/chat/inline/GutterIconInfo;", "inlineStatusService", "Lcom/github/copilot/chat/inline/status/CachingInlineChatStatusService;", "register", "", "addEditorFactoryListener", "onEditorCreated", "editor", "addGutterIcon", "line", "", "removeGutterIcon", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "core"})
@SourceDebugExtension(value={"SMAP\nInlineChatGutterIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineChatGutterIcon.kt\ncom/github/copilot/chat/inline/InlineChatGutterIcon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,122:1\n1#2:123\n215#3,2:124\n*S KotlinDebug\n*F\n+ 1 InlineChatGutterIcon.kt\ncom/github/copilot/chat/inline/InlineChatGutterIcon\n*L\n39#1:124,2\n*E\n"})
public final class InlineChatGutterIcon {
    @NotNull
    public static final InlineChatGutterIcon INSTANCE = new InlineChatGutterIcon();
    @NotNull
    private static final AtomicBoolean isRegistered = new AtomicBoolean(false);
    @NotNull
    private static final ConcurrentMap<Editor, GutterIconInfo> gutterIcons = new ConcurrentMap(0, 1, null);
    @NotNull
    private static final CachingInlineChatStatusService inlineStatusService = CachingInlineChatStatusServiceKt.CachingInlineChatStatusService();

    private InlineChatGutterIcon() {
    }

    public final void register() {
        if (isRegistered.compareAndSet(false, true)) {
            this.addEditorFactoryListener();
            inlineStatusService.onGloballyDisabled((Function0<Unit>)((Function0)InlineChatGutterIcon::register$lambda$1));
        }
    }

    private final void addEditorFactoryListener() {
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                InlineChatGutterIcon.access$onEditorCreated(InlineChatGutterIcon.INSTANCE, editor);
            }
        }, (Disposable)ApplicationKt.application());
    }

    private final void onEditorCreated(Editor editor) {
        EditorKt.addSelectionListener(editor, new SelectionListener(editor){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
            }

            public void selectionChanged(SelectionEvent e) {
                int selectionStart;
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (!EditorKt.getHasSelection(this.$editor)) {
                            GutterIconInfo gutterIconInfo = (GutterIconInfo)InlineChatGutterIcon.access$getGutterIcons$p().get((Object)this.$editor);
                            if (gutterIconInfo != null) {
                                GutterIconInfo gutterIconInfo2 = gutterIconInfo;
                                Editor editor = this.$editor;
                                GutterIconInfo it = gutterIconInfo2;
                                boolean bl = false;
                                InlineChatGutterIcon.access$removeGutterIcon(InlineChatGutterIcon.INSTANCE, editor, it.getHighlighter());
                            }
                            return;
                        }
                        if (!CopilotApplicationSettings.settings().inlineChatGutterIcon) {
                            return;
                        }
                        selectionStart = this.$editor.getDocument().getLineNumber(e.getNewRange().getStartOffset());
                        if (selectionStart < 0 || selectionStart >= this.$editor.getDocument().getLineCount()) break block7;
                        GutterIconInfo gutterIconInfo = (GutterIconInfo)InlineChatGutterIcon.access$getGutterIcons$p().get((Object)this.$editor);
                        boolean bl = gutterIconInfo != null ? gutterIconInfo.getLine() == selectionStart : false;
                        if (!bl) break block8;
                    }
                    return;
                }
                InlineChatGutterIcon.access$addGutterIcon(InlineChatGutterIcon.INSTANCE, this.$editor, selectionStart);
            }
        });
    }

    private final void addGutterIcon(Editor $this$addGutterIcon, int line) {
        block2: {
            Object object;
            GutterIconInfo gutterIconInfo = (GutterIconInfo)gutterIcons.get((Object)$this$addGutterIcon);
            if (gutterIconInfo != null) {
                GutterIconInfo it = gutterIconInfo;
                boolean bl = false;
                INSTANCE.removeGutterIcon($this$addGutterIcon, it.getHighlighter());
            }
            if ((object = EditorKt.getFile($this$addGutterIcon)) == null || (object = VirtualFileKt.getUri(object)) == null) break block2;
            Object uri = object;
            boolean bl = false;
            if (inlineStatusService.isEnabledForFile((String)uri)) {
                RangeHighlighter rangeHighlighter;
                RangeHighlighter $this$addGutterIcon_u24lambda_u245_u24lambda_u244 = rangeHighlighter = $this$addGutterIcon.getMarkupModel().addLineHighlighter(null, line, 0);
                boolean bl2 = false;
                $this$addGutterIcon_u24lambda_u245_u24lambda_u244.setGutterIconRenderer((GutterIconRenderer)new InlineChatGutterIconRenderer(line, (Function0<Unit>)((Function0)() -> InlineChatGutterIcon.addGutterIcon$lambda$5$lambda$4$lambda$3($this$addGutterIcon))));
                RangeHighlighter rangeHighlighter2 = rangeHighlighter;
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"apply(...)");
                RangeHighlighter highlighter = rangeHighlighter2;
                ((Map)gutterIcons).put($this$addGutterIcon, new GutterIconInfo(line, highlighter));
            }
        }
    }

    private final void removeGutterIcon(Editor $this$removeGutterIcon, RangeHighlighter highlighter) {
        $this$removeGutterIcon.getMarkupModel().removeHighlighter(highlighter);
        gutterIcons.remove((Object)$this$removeGutterIcon);
    }

    private static final Unit register$lambda$1() {
        Map $this$forEach$iv = MapsKt.toMap((Map)((Map)gutterIcons));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Editor editor = (Editor)entry.getKey();
            GutterIconInfo info = (GutterIconInfo)entry.getValue();
            INSTANCE.removeGutterIcon(editor, info.getHighlighter());
        }
        return Unit.INSTANCE;
    }

    private static final Unit addGutterIcon$lambda$5$lambda$4$lambda$3(Editor $this_addGutterIcon) {
        InlineChatService.Companion.openInlineChat($this_addGutterIcon);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$onEditorCreated(InlineChatGutterIcon $this, Editor editor) {
        $this.onEditorCreated(editor);
    }

    public static final /* synthetic */ ConcurrentMap access$getGutterIcons$p() {
        return gutterIcons;
    }

    public static final /* synthetic */ void access$addGutterIcon(InlineChatGutterIcon $this, Editor $receiver, int line) {
        $this.addGutterIcon($receiver, line);
    }

    public static final /* synthetic */ void access$removeGutterIcon(InlineChatGutterIcon $this, Editor $receiver, RangeHighlighter highlighter) {
        $this.removeGutterIcon($receiver, highlighter);
    }
}

