/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.inline;

import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.conversation.ConversationProgressHandler;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationPromptTemplate;
import com.github.copilot.chat.inline.InlineChatComponent;
import com.github.copilot.chat.inline.InlineChatInputComponent;
import com.github.copilot.chat.input.ChatInputController;
import com.github.copilot.chat.input.ModelPickPanel;
import com.github.copilot.chat.input.ModelScope;
import com.github.copilot.chat.input.PromptTemplatePopupController;
import com.github.copilot.chat.input.SendStopActionButtonPanel;
import com.github.copilot.chat.input.prompt.templates.PromptTemplateScope;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.ChatMessageType;
import com.github.copilot.chat.message.CopilotMessageComponent;
import com.github.copilot.chat.message.MessageComponent;
import com.github.copilot.chat.message.RetryMessage;
import com.github.copilot.chat.models.CopilotModelServiceKt;
import com.github.copilot.chat.session.CodeEditProgressHandler;
import com.github.copilot.chat.session.CopilotMessageComponentProgressHandler;
import com.github.copilot.chat.session.EphemeralChatSessionController;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.chat.user.Users;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.style.Style;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010&\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/github/copilot/chat/inline/InlineChatInputPanel;", "Ljavax/swing/JPanel;", "inlineChatComponent", "Lcom/github/copilot/chat/inline/InlineChatComponent;", "persistenceService", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "editor", "Lcom/intellij/openapi/editor/Editor;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/github/copilot/chat/inline/InlineChatComponent;Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;Lcom/intellij/openapi/editor/Editor;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getInlineChatComponent", "()Lcom/github/copilot/chat/inline/InlineChatComponent;", "getPersistenceService", "()Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "inputComponent", "Lcom/github/copilot/chat/inline/InlineChatInputComponent;", "getInputComponent", "()Lcom/github/copilot/chat/inline/InlineChatInputComponent;", "lastUserMessage", "", "promptTemplatePopupController", "Lcom/github/copilot/chat/input/PromptTemplatePopupController;", "buttonPanel", "Lcom/github/copilot/chat/input/SendStopActionButtonPanel;", "getButtonPanel", "()Lcom/github/copilot/chat/input/SendStopActionButtonPanel;", "modelPickPanel", "Lcom/github/copilot/chat/input/ModelPickPanel;", "getModelPickPanel", "()Lcom/github/copilot/chat/input/ModelPickPanel;", "chatSessionController", "Lcom/github/copilot/chat/session/EphemeralChatSessionController;", "getChatSessionController", "()Lcom/github/copilot/chat/session/EphemeralChatSessionController;", "retryMessage", "", "()Lkotlin/Unit;", "chatInputController", "Lcom/github/copilot/chat/input/ChatInputController;", "iconConstraints", "Ljava/awt/GridBagConstraints;", "inputConstraints", "modelPickConstraints", "sendButtonConstraints", "core"})
@SourceDebugExtension(value={"SMAP\nInlineChatInputPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineChatInputPanel.kt\ncom/github/copilot/chat/inline/InlineChatInputPanel\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,165:1\n39#2:166\n*S KotlinDebug\n*F\n+ 1 InlineChatInputPanel.kt\ncom/github/copilot/chat/inline/InlineChatInputPanel\n*L\n33#1:166\n*E\n"})
public final class InlineChatInputPanel
extends JPanel {
    @NotNull
    private final InlineChatComponent inlineChatComponent;
    @NotNull
    private final ChatSessionPersistenceService persistenceService;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Logger log;
    @NotNull
    private final InlineChatInputComponent inputComponent;
    @Nullable
    private String lastUserMessage;
    @NotNull
    private final PromptTemplatePopupController promptTemplatePopupController;
    @NotNull
    private final SendStopActionButtonPanel buttonPanel;
    @NotNull
    private final ModelPickPanel modelPickPanel;
    @NotNull
    private final EphemeralChatSessionController chatSessionController;
    @NotNull
    private final ChatInputController chatInputController;
    @NotNull
    private final GridBagConstraints iconConstraints;
    @NotNull
    private final GridBagConstraints inputConstraints;
    @NotNull
    private final GridBagConstraints modelPickConstraints;
    @NotNull
    private final GridBagConstraints sendButtonConstraints;

    /*
     * WARNING - void declaration
     */
    public InlineChatInputPanel(@NotNull InlineChatComponent inlineChatComponent, @NotNull ChatSessionPersistenceService persistenceService, @NotNull Editor editor, @NotNull Logger log) {
        void $this$_init__u24lambda_u2412;
        Serializable $this$buttonPanel_u24lambda_u243;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)inlineChatComponent, (String)"inlineChatComponent");
        Intrinsics.checkNotNullParameter((Object)persistenceService, (String)"persistenceService");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(new GridBagLayout());
        this.inlineChatComponent = inlineChatComponent;
        this.persistenceService = persistenceService;
        this.editor = editor;
        this.log = log;
        this.inputComponent = new InlineChatInputComponent(this);
        this.promptTemplatePopupController = new PromptTemplatePopupController((JComponent)((Object)this.inputComponent), CollectionsKt.listOf((Object)((Object)PromptTemplateScope.Inline)), (Function1<? super ConversationPromptTemplate, Unit>)((Function1)arg_0 -> InlineChatInputPanel.promptTemplatePopupController$lambda$0(this, arg_0)));
        SendStopActionButtonPanel sendStopActionButtonPanel = serializable = new SendStopActionButtonPanel((Function0<Unit>)((Function0)() -> InlineChatInputPanel.buttonPanel$lambda$1(this)), (Function0<Unit>)((Function0)() -> InlineChatInputPanel.buttonPanel$lambda$2(this)));
        InlineChatInputPanel inlineChatInputPanel = this;
        boolean bl = false;
        $this$buttonPanel_u24lambda_u243.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 8));
        inlineChatInputPanel.buttonPanel = serializable;
        this.modelPickPanel = new ModelPickPanel(CopilotModelServiceKt.CopilotModelService(), this.persistenceService, ModelScope.INLINE);
        this.chatSessionController = new EphemeralChatSessionController(this);
        this.chatInputController = new ChatInputController(this.inputComponent, this.chatSessionController, this.promptTemplatePopupController, null, InlineChatInputPanel::chatInputController$lambda$5, (arg_0, arg_1) -> InlineChatInputPanel.chatInputController$lambda$7(this, arg_0, arg_1), 8, null);
        $this$buttonPanel_u24lambda_u243 = serializable = new GridBagConstraints();
        inlineChatInputPanel = this;
        boolean bl2 = false;
        ((GridBagConstraints)$this$iconConstraints_u24lambda_u248).gridx = 0;
        ((GridBagConstraints)$this$iconConstraints_u24lambda_u248).gridy = 0;
        ((GridBagConstraints)$this$iconConstraints_u24lambda_u248).fill = 0;
        ((GridBagConstraints)$this$iconConstraints_u24lambda_u248).anchor = 12;
        inlineChatInputPanel.iconConstraints = serializable;
        Serializable $this$iconConstraints_u24lambda_u248 = serializable = new GridBagConstraints();
        inlineChatInputPanel = this;
        boolean bl3 = false;
        ((GridBagConstraints)$this$inputConstraints_u24lambda_u249).gridx = 1;
        ((GridBagConstraints)$this$inputConstraints_u24lambda_u249).gridy = 0;
        ((GridBagConstraints)$this$inputConstraints_u24lambda_u249).fill = 2;
        ((GridBagConstraints)$this$inputConstraints_u24lambda_u249).anchor = 10;
        ((GridBagConstraints)$this$inputConstraints_u24lambda_u249).weightx = 1.0;
        inlineChatInputPanel.inputConstraints = serializable;
        Serializable $this$inputConstraints_u24lambda_u249 = serializable = new GridBagConstraints();
        inlineChatInputPanel = this;
        boolean bl4 = false;
        ((GridBagConstraints)$this$modelPickConstraints_u24lambda_u2410).gridx = 2;
        ((GridBagConstraints)$this$modelPickConstraints_u24lambda_u2410).gridy = 0;
        ((GridBagConstraints)$this$modelPickConstraints_u24lambda_u2410).fill = 0;
        ((GridBagConstraints)$this$modelPickConstraints_u24lambda_u2410).anchor = 13;
        inlineChatInputPanel.modelPickConstraints = serializable;
        Serializable $this$modelPickConstraints_u24lambda_u2410 = serializable = new GridBagConstraints();
        inlineChatInputPanel = this;
        boolean bl5 = false;
        ((GridBagConstraints)$this$sendButtonConstraints_u24lambda_u2411).gridx = 3;
        ((GridBagConstraints)$this$sendButtonConstraints_u24lambda_u2411).gridy = 0;
        ((GridBagConstraints)$this$sendButtonConstraints_u24lambda_u2411).fill = 0;
        ((GridBagConstraints)$this$sendButtonConstraints_u24lambda_u2411).anchor = 13;
        ((GridBagConstraints)$this$sendButtonConstraints_u24lambda_u2411).anchor = 12;
        inlineChatInputPanel.sendButtonConstraints = serializable;
        this.setOpaque(false);
        Serializable $this$sendButtonConstraints_u24lambda_u2411 = serializable = new JLabel(CopilotIcons.COPILOT);
        inlineChatInputPanel = this;
        boolean bl6 = false;
        $this$_init__u24lambda_u2412.setBorder(BorderFactory.createEmptyBorder(11, 8, 11, 0));
        inlineChatInputPanel.add((Component)serializable, this.iconConstraints);
        this.add((Component)((Object)this.inputComponent), this.inputConstraints);
        this.add((Component)((Object)this.modelPickPanel), this.modelPickConstraints);
        this.add((Component)this.buttonPanel, this.sendButtonConstraints);
        Document document = this.inputComponent.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        ListenerUiUtil.whenTextChanged$default((Document)document, null, arg_0 -> InlineChatInputPanel._init_$lambda$14(this, arg_0), (int)1, null);
    }

    public /* synthetic */ InlineChatInputPanel(InlineChatComponent inlineChatComponent, ChatSessionPersistenceService chatSessionPersistenceService, Editor editor, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(InlineChatInputPanel.class);
        }
        this(inlineChatComponent, chatSessionPersistenceService, editor, logger);
    }

    @NotNull
    public final InlineChatComponent getInlineChatComponent() {
        return this.inlineChatComponent;
    }

    @NotNull
    public final ChatSessionPersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final InlineChatInputComponent getInputComponent() {
        return this.inputComponent;
    }

    @NotNull
    public final SendStopActionButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    @NotNull
    public final ModelPickPanel getModelPickPanel() {
        return this.modelPickPanel;
    }

    @NotNull
    public final EphemeralChatSessionController getChatSessionController() {
        return this.chatSessionController;
    }

    private final Unit retryMessage() {
        Unit unit;
        try {
            Unit unit2;
            String string = this.lastUserMessage;
            if (string != null) {
                String message = string;
                boolean bl = false;
                this.editor.getContentComponent().requestFocusInWindow();
                this.inputComponent.setText(message);
                this.chatInputController.submit();
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        catch (Exception e) {
            this.log.warn("Failed to retry message", e);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    private static final Unit promptTemplatePopupController$lambda$0(InlineChatInputPanel this$0, ConversationPromptTemplate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.inputComponent.setText("/" + it.getId());
        return Unit.INSTANCE;
    }

    private static final Unit buttonPanel$lambda$1(InlineChatInputPanel this$0) {
        this$0.chatInputController.submit();
        return Unit.INSTANCE;
    }

    private static final Unit buttonPanel$lambda$2(InlineChatInputPanel this$0) {
        this$0.chatInputController.stop();
        return Unit.INSTANCE;
    }

    private static final List chatInputController$lambda$5() {
        return CollectionsKt.emptyList();
    }

    private static final void chatInputController$lambda$7$lambda$6(InlineChatInputPanel this$0, MessageComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.retryMessage();
    }

    private static final Unit chatInputController$lambda$7(InlineChatInputPanel this$0, String content, List ignoredSkills) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)ignoredSkills, (String)"ignoredSkills");
        this$0.lastUserMessage = content;
        ChatMessageType chatMessageType = ChatMessageType.QUERY;
        Object[] objectArray = this$0.modelPickPanel.selectedModel();
        ChatMessage chatMessage = new ChatMessage(chatMessageType, null, content, null, null, null, null, null, null, null, null, null, null, null, null, null, ignoredSkills, null, null, (String)objectArray, null, 1507322, null);
        objectArray = Users.INSTANCE.getCopilotUser();
        ChatMessageType chatMessageType2 = ChatMessageType.RESPONSE;
        ChatMessage chatMessage2 = new ChatMessage(chatMessageType2, (GitHubUser)objectArray, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x1FFFFC, null);
        RetryMessage retryMessage = arg_0 -> InlineChatInputPanel.chatInputController$lambda$7$lambda$6(this$0, arg_0);
        ConversationService conversationService = this$0.chatSessionController.getConversationService();
        Project project = this$0.editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        CopilotMessageComponent responseMessageComponent = new CopilotMessageComponent(chatMessage2, retryMessage, conversationService, project, false, Style.Colors.INSTANCE.getGREY_3(), true, true);
        this$0.inlineChatComponent.setContent(responseMessageComponent);
        this$0.chatSessionController.lockSession();
        objectArray = new ConversationProgressHandler[]{new CopilotMessageComponentProgressHandler(responseMessageComponent, this$0.chatSessionController, null, 4, null), new CodeEditProgressHandler(responseMessageComponent, this$0.editor)};
        this$0.chatSessionController.executeRequest(chatMessage, CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$14$lambda$13(InlineChatInputPanel this$0) {
        String string = this$0.inputComponent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((CharSequence)string).length() > 0;
    }

    private static final Unit _init_$lambda$14(InlineChatInputPanel this$0, DocumentEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PromptTemplatePopupController promptTemplatePopupController = this$0.promptTemplatePopupController;
        String string = this$0.inputComponent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        promptTemplatePopupController.updateState(string);
        if (this$0.chatSessionController.isUnlocked(this$0.chatSessionController.getSession())) {
            this$0.buttonPanel.showSendButton((Function0<Boolean>)((Function0)() -> InlineChatInputPanel.lambda$14$lambda$13(this$0)));
        }
        return Unit.INSTANCE;
    }
}

