/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.inline;

import com.github.copilot.chat.inline.IdeEditorActionRouter;
import com.github.copilot.chat.inline.InlineChatComponent;
import com.github.copilot.chat.inline.KeyStrokeExecutor;
import com.github.copilot.chat.inline.status.InlineChatStatusService;
import com.github.copilot.chat.inline.status.InlineChatStatusServiceKt;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceServiceKt;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.VirtualFileKt;
import com.github.copilot.ui.component.JComponentKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/copilot/chat/inline/InlineChatService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "inlineChats", "", "", "Lcom/github/copilot/chat/inline/InlineChatComponent;", "inlineStatusService", "Lcom/github/copilot/chat/inline/status/InlineChatStatusService;", "persistenceService", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "dispose", "", "closeInlineChat", "editor", "Lcom/intellij/openapi/editor/Editor;", "inlineChatComponent", "closeAllInlineChats", "getInlineChat", "getInlineChatFromUserData", "openInlineChat", "toggleInlineChat", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nInlineChatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineChatService.kt\ncom/github/copilot/chat/inline/InlineChatService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1855#2,2:147\n1855#2,2:149\n1#3:151\n*S KotlinDebug\n*F\n+ 1 InlineChatService.kt\ncom/github/copilot/chat/inline/InlineChatService\n*L\n37#1:147,2\n57#1:149,2\n*E\n"})
public final class InlineChatService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, InlineChatComponent> inlineChats = new ConcurrentHashMap();
    @NotNull
    private final InlineChatStatusService inlineStatusService = InlineChatStatusServiceKt.InlineChatStatusService();
    @NotNull
    private final ChatSessionPersistenceService persistenceService = ChatSessionPersistenceServiceKt.chatSessionsPersistenceService(ProjectKt.getProject(), "GitHub Copilot");
    @NotNull
    private static final Key<Boolean> INLINE_CHAT_COMPONENT_SET_KEY;
    @NotNull
    private static final Key<InlineChatComponent> INLINE_CHAT_COMPONENT_KEY;

    public InlineChatService() {
        this.inlineStatusService.onGloballyDisabled((Function0<Unit>)((Function0)() -> InlineChatService._init_$lambda$0(this)));
        new IdeEditorActionRouter(this, arg_0 -> InlineChatService._init_$lambda$1(this, arg_0), null, 4, null).init();
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.inlineChats.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InlineChatComponent it = (InlineChatComponent)element$iv;
            boolean bl = false;
            this.closeInlineChat(it);
        }
        this.inlineChats.clear();
    }

    public final void closeInlineChat(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        InlineChatComponent inlineChatComponent = this.inlineChats.get(editor.getVirtualFile().getUrl());
        Intrinsics.checkNotNull((Object)inlineChatComponent);
        InlineChatComponent inlineChat = inlineChatComponent;
        Inlay<?> inlay = inlineChat.getInlay();
        if (inlay != null) {
            inlay.dispose();
        }
        inlineChat.setInlay(null);
        inlineChat.getChatInputPanel().getChatSessionController().destroyChatSession();
        editor.getContentComponent().remove(inlineChat);
        editor.getContentComponent().revalidate();
        editor.getContentComponent().repaint();
        this.inlineChats.remove(editor.getVirtualFile().getUrl());
    }

    public final void closeInlineChat(@NotNull InlineChatComponent inlineChatComponent) {
        Intrinsics.checkNotNullParameter((Object)inlineChatComponent, (String)"inlineChatComponent");
        this.closeInlineChat(inlineChatComponent.getEditor());
    }

    private final void closeAllInlineChats() {
        Iterable $this$forEach$iv = this.inlineChats.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InlineChatComponent it = (InlineChatComponent)element$iv;
            boolean bl = false;
            this.closeInlineChat(it);
        }
    }

    @Nullable
    public final InlineChatComponent getInlineChat(@NotNull Editor editor) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                object = editor.getVirtualFile();
                if (object == null || (object = object.getUrl()) == null) break block2;
                Object it = object;
                boolean bl = false;
                InlineChatComponent inlineChatComponent = this.inlineChats.get(editor.getVirtualFile().getUrl());
                object = inlineChatComponent;
                if (inlineChatComponent != null) break block3;
            }
            object = this.getInlineChatFromUserData(editor);
        }
        return object;
    }

    private final InlineChatComponent getInlineChatFromUserData(Editor editor) {
        if (!((Boolean)INLINE_CHAT_COMPONENT_SET_KEY.get((UserDataHolder)editor, (Object)false)).booleanValue()) {
            JComponent jComponent = editor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            editor.putUserData(INLINE_CHAT_COMPONENT_KEY, JComponentKt.findAncestor(jComponent, Reflection.getOrCreateKotlinClass(InlineChatComponent.class)));
            editor.putUserData(INLINE_CHAT_COMPONENT_SET_KEY, (Object)true);
        }
        return (InlineChatComponent)editor.getUserData(INLINE_CHAT_COMPONENT_KEY);
    }

    public final void openInlineChat(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = editor.getVirtualFile();
        if (object == null || (object = VirtualFileKt.getUri(object)) == null) {
            return;
        }
        Object fileUri = object;
        this.inlineStatusService.ifEnabledForFile((String)fileUri, (Function0<Unit>)((Function0)() -> InlineChatService.openInlineChat$lambda$6(this, editor)));
    }

    private final void toggleInlineChat(Editor editor) {
        boolean openInlineAtCurrentCaret = false;
        openInlineAtCurrentCaret = true;
        if (this.inlineChats.containsKey(editor.getVirtualFile().getUrl())) {
            InlineChatComponent inlineChatComponent = this.inlineChats.get(editor.getVirtualFile().getUrl());
            if (inlineChatComponent != null) {
                InlineChatComponent it = inlineChatComponent;
                boolean bl = false;
                Inlay<?> inlay = it.getInlay();
                openInlineAtCurrentCaret = !(inlay != null ? inlay.getOffset() == editor.getCaretModel().getPrimaryCaret().getOffset() : false);
            }
            this.closeInlineChat(editor);
        }
        if (openInlineAtCurrentCaret) {
            InlineChatComponent inlineChatComponent = new InlineChatComponent(this, this.persistenceService, editor, null, 8, null);
            editor.getContentComponent().add(inlineChatComponent);
            inlineChatComponent.setInlineContainer(editor.getContentComponent());
            int offset = editor.getSelectionModel().hasSelection() ? editor.getSelectionModel().getSelectionStart() : editor.getCaretModel().getPrimaryCaret().getOffset();
            inlineChatComponent.createInlay(offset);
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            IdeFocusManager.getInstance((Project)project).requestFocus((Component)((Object)inlineChatComponent.getChatInputPanel().getInputComponent()), true);
            this.inlineChats.put(editor.getVirtualFile().getUrl(), inlineChatComponent);
        }
    }

    private static final Unit _init_$lambda$0(InlineChatService this$0) {
        this$0.closeAllInlineChats();
        return Unit.INSTANCE;
    }

    private static final KeyStrokeExecutor _init_$lambda$1(InlineChatService this$0, Editor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getInlineChat(it);
    }

    private static final Unit openInlineChat$lambda$6$lambda$5(InlineChatService this$0, Editor $editor) {
        if (this$0.getInlineChatFromUserData($editor) == null) {
            this$0.toggleInlineChat($editor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit openInlineChat$lambda$6(InlineChatService this$0, Editor $editor) {
        ApplicationKt.runOnEdt((Function0<Unit>)((Function0)() -> InlineChatService.openInlineChat$lambda$6$lambda$5(this$0, $editor)));
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"copilot.chat.inline.chat.component.set");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INLINE_CHAT_COMPONENT_SET_KEY = key;
        Key key2 = Key.create((String)"copilot.chat.inline.chat.component");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        INLINE_CHAT_COMPONENT_KEY = key2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\nR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/github/copilot/chat/inline/InlineChatService$Companion;", "", "<init>", "()V", "INLINE_CHAT_COMPONENT_SET_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "INLINE_CHAT_COMPONENT_KEY", "Lcom/github/copilot/chat/inline/InlineChatComponent;", "inlineChatService", "Lcom/github/copilot/chat/inline/InlineChatService;", "getInlineChatService", "()Lcom/github/copilot/chat/inline/InlineChatService;", "getInlineChat", "editor", "Lcom/intellij/openapi/editor/Editor;", "openInlineChat", "", "closeInlineChat", "inlineChatComponent", "core"})
    @SourceDebugExtension(value={"SMAP\nInlineChatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineChatService.kt\ncom/github/copilot/chat/inline/InlineChatService$Companion\n+ 2 Service.kt\ncom/github/copilot/platform/utils/ServiceKt\n*L\n1#1,146:1\n5#2,4:147\n*S KotlinDebug\n*F\n+ 1 InlineChatService.kt\ncom/github/copilot/chat/inline/InlineChatService$Companion\n*L\n135#1:147,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final InlineChatService getInlineChatService() {
            boolean $i$f$platformService = false;
            Class<InlineChatService> service$iv = InlineChatService.class;
            boolean bl = false;
            Object object = ApplicationManager.getApplication().getService(service$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + service$iv.getName() + " (classloader: " + service$iv.getClassLoader());
            }
            return (InlineChatService)object;
        }

        @Nullable
        public final InlineChatComponent getInlineChat(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return this.getInlineChatService().getInlineChat(editor);
        }

        public final void openInlineChat(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.getInlineChatService().openInlineChat(editor);
        }

        public final void closeInlineChat(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.getInlineChatService().closeInlineChat(editor);
        }

        public final void closeInlineChat(@NotNull InlineChatComponent inlineChatComponent) {
            Intrinsics.checkNotNullParameter((Object)inlineChatComponent, (String)"inlineChatComponent");
            this.getInlineChatService().closeInlineChat(inlineChatComponent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

