/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.inline.status;

import com.github.copilot.chat.inline.status.CachingInlineChatStatusService;
import com.github.copilot.chat.inline.status.InlineChatStatusService;
import com.github.copilot.chat.inline.status.InlineChatStatusServiceKt;
import com.github.copilot.chat.inline.status.InlineChatStatusSubscription;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.ProjectService;
import com.github.copilot.platform.utils.ProjectServiceKt;
import com.github.copilot.platform.utils.VirtualFileKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import io.ktor.util.collections.ConcurrentSetKt;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u0011H\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\f\u0010\u001a\u001a\u00020\u0017*\u00020\fH\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/copilot/chat/inline/status/CachingStatusService;", "Lcom/github/copilot/chat/inline/status/CachingInlineChatStatusService;", "inlineStatusService", "Lcom/github/copilot/chat/inline/status/InlineChatStatusService;", "<init>", "(Lcom/github/copilot/chat/inline/status/InlineChatStatusService;)V", "uncheckedOpenFiles", "", "", "enabledFiles", "projectService", "Lcom/github/copilot/platform/utils/ProjectService;", "Lcom/intellij/openapi/project/Project;", "Lcom/github/copilot/platform/utils/PlatformProjectService;", "isGloballyEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isEnabledForFile", "", "fileUri", "onGloballyDisabled", "Lcom/github/copilot/chat/inline/status/InlineChatStatusSubscription;", "subscriber", "Lkotlin/Function0;", "", "initStatusListeners", "initOpenFilesAndFileListeners", "checkOpenFiles", "addFileListener", "Lcom/intellij/util/messages/MessageBusConnection;", "checkFile", "uri", "core"})
@SourceDebugExtension(value={"SMAP\nCachingStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingStatusService.kt\ncom/github/copilot/chat/inline/status/CachingStatusService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1855#2,2:88\n1855#2,2:90\n1855#2,2:92\n*S KotlinDebug\n*F\n+ 1 CachingStatusService.kt\ncom/github/copilot/chat/inline/status/CachingStatusService\n*L\n51#1:88,2\n38#1:90,2\n63#1:92,2\n*E\n"})
public final class CachingStatusService
implements CachingInlineChatStatusService {
    @NotNull
    private final InlineChatStatusService inlineStatusService;
    @NotNull
    private final Set<String> uncheckedOpenFiles;
    @NotNull
    private final Set<String> enabledFiles;
    @NotNull
    private final ProjectService<Project> projectService;
    @NotNull
    private final AtomicBoolean isGloballyEnabled;

    public CachingStatusService(@NotNull InlineChatStatusService inlineStatusService) {
        Intrinsics.checkNotNullParameter((Object)inlineStatusService, (String)"inlineStatusService");
        this.inlineStatusService = inlineStatusService;
        this.uncheckedOpenFiles = ConcurrentSetKt.ConcurrentSet();
        this.enabledFiles = ConcurrentSetKt.ConcurrentSet();
        this.projectService = ProjectServiceKt.PlatformProjectService();
        this.isGloballyEnabled = new AtomicBoolean(false);
        this.initStatusListeners();
        this.initOpenFilesAndFileListeners();
    }

    public /* synthetic */ CachingStatusService(InlineChatStatusService inlineChatStatusService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            inlineChatStatusService = InlineChatStatusServiceKt.InlineChatStatusService();
        }
        this(inlineChatStatusService);
    }

    @Override
    public boolean isEnabledForFile(@NotNull String fileUri) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        return this.enabledFiles.contains(fileUri);
    }

    @Override
    public boolean isGloballyEnabled() {
        return this.isGloballyEnabled.get();
    }

    @Override
    @NotNull
    public InlineChatStatusSubscription onGloballyDisabled(@NotNull Function0<Unit> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        return this.inlineStatusService.onGloballyDisabled(subscriber);
    }

    private final InlineChatStatusSubscription initStatusListeners() {
        InlineChatStatusService $this$initStatusListeners_u24lambda_u243 = this.inlineStatusService;
        boolean bl = false;
        $this$initStatusListeners_u24lambda_u243.onGloballyEnabled((Function0<Unit>)((Function0)() -> CachingStatusService.initStatusListeners$lambda$3$lambda$1(this)));
        return $this$initStatusListeners_u24lambda_u243.onGloballyDisabled((Function0<Unit>)((Function0)() -> CachingStatusService.initStatusListeners$lambda$3$lambda$2(this)));
    }

    private final void initOpenFilesAndFileListeners() {
        ProjectService<Project> $this$initOpenFilesAndFileListeners_u24lambda_u246 = this.projectService;
        boolean bl = false;
        Iterable $this$forEach$iv = $this$initOpenFilesAndFileListeners_u24lambda_u246.getAllProjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl2 = false;
            this.checkOpenFiles(project);
            this.addFileListener(project);
        }
        $this$initOpenFilesAndFileListeners_u24lambda_u246.onProjectOpened((Function1<Project, Unit>)((Function1)arg_0 -> CachingStatusService.initOpenFilesAndFileListeners$lambda$6$lambda$5(this, arg_0)));
    }

    private final void checkOpenFiles(Project $this$checkOpenFiles) {
        ProjectKt.runWhenInitialized($this$checkOpenFiles, (Function0<Unit>)((Function0)() -> CachingStatusService.checkOpenFiles$lambda$8($this$checkOpenFiles, this)));
    }

    private final MessageBusConnection addFileListener(Project $this$addFileListener) {
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        return ProjectKt.subscribe($this$addFileListener, topic, new FileEditorManagerListener(this){
            final /* synthetic */ CachingStatusService this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                CachingStatusService.access$checkFile(this.this$0, VirtualFileKt.getUri(file));
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String string = VirtualFileKt.getUri(file);
                CachingStatusService cachingStatusService = this.this$0;
                String uri = string;
                boolean bl = false;
                CachingStatusService.access$getUncheckedOpenFiles$p(cachingStatusService).remove(uri);
                CachingStatusService.access$getEnabledFiles$p(cachingStatusService).remove(uri);
            }
        });
    }

    private final void checkFile(String uri) {
        if (this.isGloballyEnabled.get()) {
            this.inlineStatusService.ifEnabledForFile(uri, (Function0<Unit>)((Function0)() -> CachingStatusService.checkFile$lambda$9(this, uri)));
        } else {
            this.uncheckedOpenFiles.add(uri);
        }
    }

    private static final Unit initStatusListeners$lambda$3$lambda$1(CachingStatusService this$0) {
        this$0.isGloballyEnabled.set(true);
        Iterable $this$forEach$iv = this$0.uncheckedOpenFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this$0.checkFile(it);
        }
        this$0.uncheckedOpenFiles.clear();
        return Unit.INSTANCE;
    }

    private static final Unit initStatusListeners$lambda$3$lambda$2(CachingStatusService this$0) {
        this$0.isGloballyEnabled.set(false);
        this$0.uncheckedOpenFiles.addAll((Collection<String>)this$0.enabledFiles);
        this$0.enabledFiles.clear();
        return Unit.INSTANCE;
    }

    private static final Unit initOpenFilesAndFileListeners$lambda$6$lambda$5(CachingStatusService this$0, Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this$0.checkOpenFiles(project);
        this$0.addFileListener(project);
        return Unit.INSTANCE;
    }

    private static final Unit checkOpenFiles$lambda$8(Project $this_checkOpenFiles, CachingStatusService this$0) {
        Iterable $this$forEach$iv = ProjectKt.getOpenFiles($this_checkOpenFiles);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.checkFile(VirtualFileKt.getUri(it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit checkFile$lambda$9(CachingStatusService this$0, String $uri) {
        this$0.enabledFiles.add($uri);
        return Unit.INSTANCE;
    }

    public CachingStatusService() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$checkFile(CachingStatusService $this, String uri) {
        $this.checkFile(uri);
    }

    public static final /* synthetic */ Set access$getUncheckedOpenFiles$p(CachingStatusService $this) {
        return $this.uncheckedOpenFiles;
    }

    public static final /* synthetic */ Set access$getEnabledFiles$p(CachingStatusService $this) {
        return $this.enabledFiles;
    }
}

