/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.inline.status;

import com.github.copilot.chat.inline.status.GlobalStatus;
import com.github.copilot.chat.inline.status.InlineChatStatusService;
import com.github.copilot.chat.inline.status.InlineChatStatusSubscription;
import com.github.copilot.chat.inline.status.InlineStatusService;
import com.github.copilot.chat.precondition.ChatPreconditions;
import com.github.copilot.chat.precondition.ChatPreconditionsService;
import com.github.copilot.chat.precondition.ChatPreconditionsServiceKt;
import com.github.copilot.chat.precondition.ChatPreconditionsSubscription;
import com.github.copilot.featureflags.CopilotFeatureFlags;
import com.github.copilot.github.feature.FeatureFlagService;
import com.github.copilot.github.feature.FeatureFlagSubscription;
import com.github.copilot.lang.agent.commands.CheckFileStatusResult;
import com.github.copilot.status.CopilotAuthStatus;
import com.github.copilot.status.CopilotAuthStatusKt;
import com.github.copilot.status.CopilotAuthStatusService;
import com.github.copilot.status.FileStatusService;
import com.github.copilot.status.FileStatusServiceKt;
import io.ktor.util.collections.ConcurrentMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000o\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002*\u0001#\b\u0080\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u001a\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0012H\u0002J\b\u0010!\u001a\u00020\u0010H\u0002J\u001b\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010%J\t\u0010&\u001a\u00020\u0003H\u00c2\u0003J\t\u0010'\u001a\u00020\u0005H\u00c2\u0003J\t\u0010(\u001a\u00020\u0007H\u00c2\u0003J\t\u0010)\u001a\u00020\tH\u00c2\u0003J1\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0010H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/github/copilot/chat/inline/status/InlineStatusService;", "Lcom/github/copilot/chat/inline/status/InlineChatStatusService;", "authStatusService", "Lcom/github/copilot/status/CopilotAuthStatusService;", "featureFlagService", "Lcom/github/copilot/github/feature/FeatureFlagService;", "preconditionsService", "Lcom/github/copilot/chat/precondition/ChatPreconditionsService;", "fileStatusService", "Lcom/github/copilot/status/FileStatusService;", "<init>", "(Lcom/github/copilot/status/CopilotAuthStatusService;Lcom/github/copilot/github/feature/FeatureFlagService;Lcom/github/copilot/chat/precondition/ChatPreconditionsService;Lcom/github/copilot/status/FileStatusService;)V", "globalStatus", "Lcom/github/copilot/chat/inline/status/GlobalStatus;", "globallyEnabledSubscribers", "Lio/ktor/util/collections/ConcurrentMap;", "", "Lkotlin/Function0;", "", "globallyDisabledSubscribers", "ifEnabledForFile", "fileUri", "block", "onGloballyEnabled", "Lcom/github/copilot/chat/inline/status/InlineChatStatusSubscription;", "subscriber", "onGloballyDisabled", "subscribeToAuthStatus", "subscribeToFeatureFlag", "Lcom/github/copilot/github/feature/FeatureFlagSubscription;", "subscribeToPreconditions", "Lcom/github/copilot/chat/precondition/ChatPreconditionsSubscription;", "checkGlobalStatus", "generateId", "subscription", "com/github/copilot/chat/inline/status/InlineStatusService$subscription$1", "unsubscribe", "(Lkotlin/jvm/functions/Function0;)Lcom/github/copilot/chat/inline/status/InlineStatusService$subscription$1;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nInlineStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineStatusService.kt\ncom/github/copilot/chat/inline/status/InlineStatusService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1855#2,2:145\n*S KotlinDebug\n*F\n+ 1 InlineStatusService.kt\ncom/github/copilot/chat/inline/status/InlineStatusService\n*L\n87#1:145,2\n*E\n"})
public final class InlineStatusService
implements InlineChatStatusService {
    @NotNull
    private final CopilotAuthStatusService authStatusService;
    @NotNull
    private final FeatureFlagService featureFlagService;
    @NotNull
    private final ChatPreconditionsService preconditionsService;
    @NotNull
    private final FileStatusService fileStatusService;
    @NotNull
    private final GlobalStatus globalStatus;
    @NotNull
    private final ConcurrentMap<String, Function0<Unit>> globallyEnabledSubscribers;
    @NotNull
    private final ConcurrentMap<String, Function0<Unit>> globallyDisabledSubscribers;

    public InlineStatusService(@NotNull CopilotAuthStatusService authStatusService, @NotNull FeatureFlagService featureFlagService, @NotNull ChatPreconditionsService preconditionsService, @NotNull FileStatusService fileStatusService) {
        Intrinsics.checkNotNullParameter((Object)authStatusService, (String)"authStatusService");
        Intrinsics.checkNotNullParameter((Object)featureFlagService, (String)"featureFlagService");
        Intrinsics.checkNotNullParameter((Object)preconditionsService, (String)"preconditionsService");
        Intrinsics.checkNotNullParameter((Object)fileStatusService, (String)"fileStatusService");
        this.authStatusService = authStatusService;
        this.featureFlagService = featureFlagService;
        this.preconditionsService = preconditionsService;
        this.fileStatusService = fileStatusService;
        this.globalStatus = new GlobalStatus();
        this.globallyEnabledSubscribers = new ConcurrentMap(0, 1, null);
        this.globallyDisabledSubscribers = new ConcurrentMap(0, 1, null);
        this.subscribeToAuthStatus();
        this.subscribeToFeatureFlag();
        this.subscribeToPreconditions();
    }

    public /* synthetic */ InlineStatusService(CopilotAuthStatusService copilotAuthStatusService, FeatureFlagService featureFlagService, ChatPreconditionsService chatPreconditionsService, FileStatusService fileStatusService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            copilotAuthStatusService = CopilotAuthStatusService.Companion;
        }
        if ((n & 2) != 0) {
            featureFlagService = FeatureFlagService.Companion;
        }
        if ((n & 4) != 0) {
            chatPreconditionsService = ChatPreconditionsServiceKt.ChatPreconditionsService();
        }
        if ((n & 8) != 0) {
            fileStatusService = FileStatusService.Companion.getDEFAULT();
        }
        this(copilotAuthStatusService, featureFlagService, chatPreconditionsService, fileStatusService);
    }

    @Override
    public void ifEnabledForFile(@NotNull String fileUri, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!this.globalStatus.isOk()) {
            return;
        }
        this.fileStatusService.checkFileStatus(fileUri, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> InlineStatusService.ifEnabledForFile$lambda$0(block, arg_0)), (Function1<? super CheckFileStatusResult, Unit>)((Function1)arg_0 -> InlineStatusService.ifEnabledForFile$lambda$1(block, arg_0)));
    }

    @Override
    @NotNull
    public InlineChatStatusSubscription onGloballyEnabled(@NotNull Function0<Unit> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        String id = this.generateId();
        ((Map)this.globallyEnabledSubscribers).put(id, subscriber);
        return this.subscription((Function0<Unit>)((Function0)() -> InlineStatusService.onGloballyEnabled$lambda$2(this, id)));
    }

    @Override
    @NotNull
    public InlineChatStatusSubscription onGloballyDisabled(@NotNull Function0<Unit> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        String id = this.generateId();
        ((Map)this.globallyDisabledSubscribers).put(id, subscriber);
        return this.subscription((Function0<Unit>)((Function0)() -> InlineStatusService.onGloballyDisabled$lambda$3(this, id)));
    }

    private final void subscribeToAuthStatus() {
        this.authStatusService.subscribe((Function1<? super CopilotAuthStatus, Unit>)((Function1)arg_0 -> InlineStatusService.subscribeToAuthStatus$lambda$4(this, arg_0)));
    }

    private final FeatureFlagSubscription subscribeToFeatureFlag() {
        return this.featureFlagService.onFeatureFlags((Function1<? super CopilotFeatureFlags, Unit>)((Function1)arg_0 -> InlineStatusService.subscribeToFeatureFlag$lambda$5(this, arg_0)));
    }

    private final ChatPreconditionsSubscription subscribeToPreconditions() {
        return this.preconditionsService.subscribeToPreconditions((Function1<? super ChatPreconditions, Unit>)((Function1)arg_0 -> InlineStatusService.subscribeToPreconditions$lambda$6(this, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkGlobalStatus() {
        InlineStatusService inlineStatusService = this;
        synchronized (inlineStatusService) {
            boolean bl = false;
            if (this.globalStatus.getHasChanged()) {
                Iterable $this$forEach$iv = (this.globalStatus.isOk() ? this.globallyEnabledSubscribers : this.globallyDisabledSubscribers).values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl2 = false;
                    it.invoke();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String generateId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final subscription.1 subscription(Function0<Unit> unsubscribe) {
        return new InlineChatStatusSubscription(unsubscribe){
            final /* synthetic */ Function0<Unit> $unsubscribe;
            {
                this.$unsubscribe = $unsubscribe;
            }

            public void unsubscribe() {
                this.$unsubscribe.invoke();
            }
        };
    }

    private final CopilotAuthStatusService component1() {
        return this.authStatusService;
    }

    private final FeatureFlagService component2() {
        return this.featureFlagService;
    }

    private final ChatPreconditionsService component3() {
        return this.preconditionsService;
    }

    private final FileStatusService component4() {
        return this.fileStatusService;
    }

    @NotNull
    public final InlineStatusService copy(@NotNull CopilotAuthStatusService authStatusService, @NotNull FeatureFlagService featureFlagService, @NotNull ChatPreconditionsService preconditionsService, @NotNull FileStatusService fileStatusService) {
        Intrinsics.checkNotNullParameter((Object)authStatusService, (String)"authStatusService");
        Intrinsics.checkNotNullParameter((Object)featureFlagService, (String)"featureFlagService");
        Intrinsics.checkNotNullParameter((Object)preconditionsService, (String)"preconditionsService");
        Intrinsics.checkNotNullParameter((Object)fileStatusService, (String)"fileStatusService");
        return new InlineStatusService(authStatusService, featureFlagService, preconditionsService, fileStatusService);
    }

    public static /* synthetic */ InlineStatusService copy$default(InlineStatusService inlineStatusService, CopilotAuthStatusService copilotAuthStatusService, FeatureFlagService featureFlagService, ChatPreconditionsService chatPreconditionsService, FileStatusService fileStatusService, int n, Object object) {
        if ((n & 1) != 0) {
            copilotAuthStatusService = inlineStatusService.authStatusService;
        }
        if ((n & 2) != 0) {
            featureFlagService = inlineStatusService.featureFlagService;
        }
        if ((n & 4) != 0) {
            chatPreconditionsService = inlineStatusService.preconditionsService;
        }
        if ((n & 8) != 0) {
            fileStatusService = inlineStatusService.fileStatusService;
        }
        return inlineStatusService.copy(copilotAuthStatusService, featureFlagService, chatPreconditionsService, fileStatusService);
    }

    @NotNull
    public String toString() {
        return "InlineStatusService(authStatusService=" + this.authStatusService + ", featureFlagService=" + this.featureFlagService + ", preconditionsService=" + this.preconditionsService + ", fileStatusService=" + this.fileStatusService + ")";
    }

    public int hashCode() {
        int result = this.authStatusService.hashCode();
        result = result * 31 + this.featureFlagService.hashCode();
        result = result * 31 + this.preconditionsService.hashCode();
        result = result * 31 + this.fileStatusService.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InlineStatusService)) {
            return false;
        }
        InlineStatusService inlineStatusService = (InlineStatusService)other;
        if (!Intrinsics.areEqual((Object)this.authStatusService, (Object)inlineStatusService.authStatusService)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.featureFlagService, (Object)inlineStatusService.featureFlagService)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.preconditionsService, (Object)inlineStatusService.preconditionsService)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fileStatusService, (Object)inlineStatusService.fileStatusService);
    }

    private static final Unit ifEnabledForFile$lambda$0(Function0 $block, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $block.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit ifEnabledForFile$lambda$1(Function0 $block, CheckFileStatusResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (FileStatusServiceKt.isNotBlocked(it)) {
            $block.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onGloballyEnabled$lambda$2(InlineStatusService this$0, String $id) {
        this$0.globallyEnabledSubscribers.remove((Object)$id);
        return Unit.INSTANCE;
    }

    private static final Unit onGloballyDisabled$lambda$3(InlineStatusService this$0, String $id) {
        this$0.globallyDisabledSubscribers.remove((Object)$id);
        return Unit.INSTANCE;
    }

    private static final Unit subscribeToAuthStatus$lambda$4(InlineStatusService this$0, CopilotAuthStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this$0.globalStatus.setAuthOk(CopilotAuthStatusKt.isReady(status));
        this$0.checkGlobalStatus();
        return Unit.INSTANCE;
    }

    private static final Unit subscribeToFeatureFlag$lambda$5(InlineStatusService this$0, CopilotFeatureFlags flags) {
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        this$0.globalStatus.setFeatureFlagged(flags.isInlineChatEnabled());
        this$0.checkGlobalStatus();
        return Unit.INSTANCE;
    }

    private static final Unit subscribeToPreconditions$lambda$6(InlineStatusService this$0, ChatPreconditions preconditions) {
        Intrinsics.checkNotNullParameter((Object)preconditions, (String)"preconditions");
        this$0.globalStatus.setArePreconditionsMet(preconditions.status().isOk());
        this$0.checkGlobalStatus();
        return Unit.INSTANCE;
    }

    public InlineStatusService() {
        this(null, null, null, null, 15, null);
    }
}

