/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.input;

import com.github.copilot.chat.input.ChatInputController;
import com.github.copilot.chat.input.PopupController;
import com.github.copilot.chat.input.PromptTemplateListItemComponent;
import com.github.copilot.chat.input.PromptTemplatePopupController;
import com.github.copilot.chat.input.agent.NoOpRemoteAgentPopupController;
import com.github.copilot.chat.input.agent.RemoteAgentListItem;
import com.github.copilot.chat.session.InputHistory;
import com.github.copilot.chat.session.InputHistoryResult;
import com.github.copilot.chat.session.SessionController;
import com.intellij.ui.components.JBTextArea;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0007*\u0006\u0019\u001c\u001f\"%(\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r\u0012\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010*\u001a\u00020\u0012J\u0006\u0010+\u001a\u00020\u0012J\u0010\u0010,\u001a\u00020\u00122\b\u0010-\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0010\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u0010\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)\u00a8\u0006."}, d2={"Lcom/github/copilot/chat/input/ChatInputController;", "", "textArea", "Lcom/intellij/ui/components/JBTextArea;", "chatSessionController", "Lcom/github/copilot/chat/session/SessionController;", "promptTemplatePopupController", "Lcom/github/copilot/chat/input/PromptTemplatePopupController;", "remoteAgentPopupController", "Lcom/github/copilot/chat/input/PopupController;", "Lcom/github/copilot/chat/input/agent/RemoteAgentListItem;", "Lcom/github/copilot/chat/input/agent/RemoteAgentPopupController;", "ignoredSkillsProvider", "Lkotlin/Function0;", "", "", "onSubmit", "Lkotlin/Function2;", "", "<init>", "(Lcom/intellij/ui/components/JBTextArea;Lcom/github/copilot/chat/session/SessionController;Lcom/github/copilot/chat/input/PromptTemplatePopupController;Lcom/github/copilot/chat/input/PopupController;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "getOnSubmit", "()Lkotlin/jvm/functions/Function2;", "lastInput", "upAction", "com/github/copilot/chat/input/ChatInputController$upAction$1", "Lcom/github/copilot/chat/input/ChatInputController$upAction$1;", "downAction", "com/github/copilot/chat/input/ChatInputController$downAction$1", "Lcom/github/copilot/chat/input/ChatInputController$downAction$1;", "enterAction", "com/github/copilot/chat/input/ChatInputController$enterAction$1", "Lcom/github/copilot/chat/input/ChatInputController$enterAction$1;", "tabAction", "com/github/copilot/chat/input/ChatInputController$tabAction$1", "Lcom/github/copilot/chat/input/ChatInputController$tabAction$1;", "shiftTabAction", "com/github/copilot/chat/input/ChatInputController$shiftTabAction$1", "Lcom/github/copilot/chat/input/ChatInputController$shiftTabAction$1;", "newlineAction", "com/github/copilot/chat/input/ChatInputController$newlineAction$1", "Lcom/github/copilot/chat/input/ChatInputController$newlineAction$1;", "submit", "stop", "updateInput", "input", "core"})
@SourceDebugExtension(value={"SMAP\nChatInputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputController.kt\ncom/github/copilot/chat/input/ChatInputController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class ChatInputController {
    @NotNull
    private final JBTextArea textArea;
    @NotNull
    private final SessionController chatSessionController;
    @NotNull
    private final PromptTemplatePopupController promptTemplatePopupController;
    @NotNull
    private final PopupController<RemoteAgentListItem> remoteAgentPopupController;
    @NotNull
    private final Function0<List<String>> ignoredSkillsProvider;
    @NotNull
    private final Function2<String, List<String>, Unit> onSubmit;
    @Nullable
    private String lastInput;
    @NotNull
    private final upAction.1 upAction;
    @NotNull
    private final downAction.1 downAction;
    @NotNull
    private final enterAction.1 enterAction;
    @NotNull
    private final tabAction.1 tabAction;
    @NotNull
    private final shiftTabAction.1 shiftTabAction;
    @NotNull
    private final newlineAction.1 newlineAction;

    public ChatInputController(@NotNull JBTextArea textArea, @NotNull SessionController chatSessionController, @NotNull PromptTemplatePopupController promptTemplatePopupController, @NotNull PopupController<RemoteAgentListItem> remoteAgentPopupController, @NotNull Function0<? extends List<String>> ignoredSkillsProvider, @NotNull Function2<? super String, ? super List<String>, Unit> onSubmit) {
        Intrinsics.checkNotNullParameter((Object)textArea, (String)"textArea");
        Intrinsics.checkNotNullParameter((Object)chatSessionController, (String)"chatSessionController");
        Intrinsics.checkNotNullParameter((Object)promptTemplatePopupController, (String)"promptTemplatePopupController");
        Intrinsics.checkNotNullParameter(remoteAgentPopupController, (String)"remoteAgentPopupController");
        Intrinsics.checkNotNullParameter(ignoredSkillsProvider, (String)"ignoredSkillsProvider");
        Intrinsics.checkNotNullParameter(onSubmit, (String)"onSubmit");
        this.textArea = textArea;
        this.chatSessionController = chatSessionController;
        this.promptTemplatePopupController = promptTemplatePopupController;
        this.remoteAgentPopupController = remoteAgentPopupController;
        this.ignoredSkillsProvider = ignoredSkillsProvider;
        this.onSubmit = onSubmit;
        this.lastInput = this.chatSessionController.getSessionInput();
        this.upAction = new AbstractAction(this){
            final /* synthetic */ ChatInputController this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                if (ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).isPopupEnabled()) {
                    ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).highlightPrevious();
                } else if (ChatInputController.access$getRemoteAgentPopupController$p(this.this$0).isPopupEnabled()) {
                    ChatInputController.access$getRemoteAgentPopupController$p(this.this$0).highlightPrevious();
                } else if (ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition() == 0) {
                    InputHistory inputHistory = ChatInputController.access$getChatSessionController$p(this.this$0).getSession().getHistory();
                    String string = ChatInputController.access$getTextArea$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    InputHistoryResult result = inputHistory.older(string);
                    if (result instanceof InputHistoryResult.Success) {
                        ChatInputController.access$getTextArea$p(this.this$0).setText(((InputHistoryResult.Success)result).getInput());
                        ChatInputController.access$getTextArea$p(this.this$0).setCaretPosition(0);
                    } else {
                        ChatInputController.access$getTextArea$p(this.this$0).getActionMap().get("caret-up").actionPerformed(e);
                    }
                } else {
                    int previousCaretPosition = ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition();
                    ChatInputController.access$getTextArea$p(this.this$0).getActionMap().get("caret-up").actionPerformed(e);
                    if (previousCaretPosition == ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition()) {
                        ChatInputController.access$getTextArea$p(this.this$0).setCaretPosition(0);
                    }
                }
            }
        };
        this.downAction = new AbstractAction(this){
            final /* synthetic */ ChatInputController this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void actionPerformed(ActionEvent e) {
                if (ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).isPopupEnabled()) {
                    ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).highlightNext();
                    return;
                } else if (ChatInputController.access$getRemoteAgentPopupController$p(this.this$0).isPopupEnabled()) {
                    ChatInputController.access$getRemoteAgentPopupController$p(this.this$0).highlightNext();
                    return;
                } else if (ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition() == ChatInputController.access$getTextArea$p(this.this$0).getText().length()) {
                    InputHistory inputHistory = ChatInputController.access$getChatSessionController$p(this.this$0).getSession().getHistory();
                    String string = ChatInputController.access$getTextArea$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    InputHistoryResult result = inputHistory.newer(string);
                    if (result instanceof InputHistoryResult.Success) {
                        ChatInputController.access$getTextArea$p(this.this$0).setText(((InputHistoryResult.Success)result).getInput());
                        ChatInputController.access$getTextArea$p(this.this$0).setCaretPosition(ChatInputController.access$getTextArea$p(this.this$0).getText().length());
                        return;
                    } else if (result instanceof InputHistoryResult.EndOfHistory) {
                        ChatInputController.access$getTextArea$p(this.this$0).setText("");
                        return;
                    } else {
                        if (!(result instanceof InputHistoryResult.NotAPreviousInput)) throw new NoWhenBranchMatchedException();
                        ChatInputController.access$getTextArea$p(this.this$0).getActionMap().get("caret-down").actionPerformed(e);
                    }
                    return;
                } else {
                    int previousCaretPosition = ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition();
                    ChatInputController.access$getTextArea$p(this.this$0).getActionMap().get("caret-down").actionPerformed(e);
                    if (previousCaretPosition != ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition()) return;
                    ChatInputController.access$getTextArea$p(this.this$0).setCaretPosition(ChatInputController.access$getTextArea$p(this.this$0).getText().length());
                }
            }
        };
        this.enterAction = new AbstractAction(this){
            final /* synthetic */ ChatInputController this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                if (ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).isPopupEnabled()) {
                    ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).select((Function1<? super PromptTemplateListItemComponent, Unit>)((Function1)arg_0 -> enterAction.1.actionPerformed$lambda$0(this.this$0, arg_0)));
                } else if (ChatInputController.access$getRemoteAgentPopupController$p(this.this$0).isPopupEnabled()) {
                    PopupController.DefaultImpls.select$default(ChatInputController.access$getRemoteAgentPopupController$p(this.this$0), null, 1, null);
                } else {
                    this.this$0.submit();
                }
            }

            private static final Unit actionPerformed$lambda$0(ChatInputController this$0, PromptTemplateListItemComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ChatInputController.access$getTextArea$p(this$0).setText("/" + it.getConversationPromptTemplate().getId());
                return Unit.INSTANCE;
            }
        };
        this.tabAction = new AbstractAction(this){
            final /* synthetic */ ChatInputController this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                if (ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).isPopupEnabled()) {
                    ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).select((Function1<? super PromptTemplateListItemComponent, Unit>)((Function1)arg_0 -> tabAction.1.actionPerformed$lambda$0(this.this$0, arg_0)));
                } else if (ChatInputController.access$getRemoteAgentPopupController$p(this.this$0).isPopupEnabled()) {
                    PopupController.DefaultImpls.select$default(ChatInputController.access$getRemoteAgentPopupController$p(this.this$0), null, 1, null);
                } else {
                    ChatInputController.access$getTextArea$p(this.this$0).transferFocus();
                }
            }

            private static final Unit actionPerformed$lambda$0(ChatInputController this$0, PromptTemplateListItemComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ChatInputController.access$getTextArea$p(this$0).setText("/" + it.getConversationPromptTemplate().getId());
                return Unit.INSTANCE;
            }
        };
        this.shiftTabAction = new AbstractAction(this){
            final /* synthetic */ ChatInputController this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                ChatInputController.access$getTextArea$p(this.this$0).transferFocusBackward();
            }
        };
        this.newlineAction = new AbstractAction(this){
            final /* synthetic */ ChatInputController this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                if (!ChatInputController.access$getPromptTemplatePopupController$p(this.this$0).isPopupEnabled() && !ChatInputController.access$getRemoteAgentPopupController$p(this.this$0).isPopupEnabled()) {
                    int previousPosition = ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition();
                    JBTextArea jBTextArea = ChatInputController.access$getTextArea$p(this.this$0);
                    String string = ChatInputController.access$getTextArea$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String string2 = string;
                    int n = 0;
                    int n2 = ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition();
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String string4 = ChatInputController.access$getTextArea$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                    string2 = string4;
                    n = ChatInputController.access$getTextArea$p(this.this$0).getCaretPosition();
                    String string5 = string2.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                    jBTextArea.setText(string3 + "\n" + string5);
                    ChatInputController.access$getTextArea$p(this.this$0).setCaretPosition(previousPosition + 1);
                }
            }
        };
        String string = this.lastInput;
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.textArea.setText(it);
        }
        this.textArea.getActionMap().put("upAction", this.upAction);
        this.textArea.getActionMap().put("downAction", this.downAction);
        this.textArea.getActionMap().put("enterAction", this.enterAction);
        this.textArea.getActionMap().put("tabAction", this.tabAction);
        this.textArea.getActionMap().put("shiftTabAction", this.shiftTabAction);
        this.textArea.getActionMap().put("newlineAction", this.newlineAction);
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "upAction");
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "downAction");
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enterAction");
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "tabAction");
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(9, 64), "shiftTabAction");
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(10, 64), "newlineAction");
    }

    public /* synthetic */ ChatInputController(JBTextArea jBTextArea, SessionController sessionController, PromptTemplatePopupController promptTemplatePopupController, PopupController popupController, Function0 function0, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            popupController = NoOpRemoteAgentPopupController.INSTANCE;
        }
        this(jBTextArea, sessionController, promptTemplatePopupController, popupController, (Function0<? extends List<String>>)function0, (Function2<? super String, ? super List<String>, Unit>)function2);
    }

    @NotNull
    public final Function2<String, List<String>, Unit> getOnSubmit() {
        return this.onSubmit;
    }

    public final void submit() {
        String string = this.textArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.isBlank((CharSequence)string) && this.chatSessionController.isUnlocked(this.chatSessionController.getSession())) {
            String string2 = this.textArea.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String input = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            this.textArea.setText("");
            this.updateInput(null);
            this.onSubmit.invoke((Object)input, this.ignoredSkillsProvider.invoke());
        }
    }

    public final void stop() {
        this.chatSessionController.stopActiveResponses(false);
    }

    public final void updateInput(@Nullable String input) {
        if (!Intrinsics.areEqual((Object)input, (Object)this.lastInput)) {
            this.lastInput = input;
            this.chatSessionController.updateInput(input);
        }
    }

    public static final /* synthetic */ PromptTemplatePopupController access$getPromptTemplatePopupController$p(ChatInputController $this) {
        return $this.promptTemplatePopupController;
    }

    public static final /* synthetic */ PopupController access$getRemoteAgentPopupController$p(ChatInputController $this) {
        return $this.remoteAgentPopupController;
    }

    public static final /* synthetic */ JBTextArea access$getTextArea$p(ChatInputController $this) {
        return $this.textArea;
    }

    public static final /* synthetic */ SessionController access$getChatSessionController$p(ChatInputController $this) {
        return $this.chatSessionController;
    }
}

