/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.input;

import com.github.copilot.chat.agent.RemoteAgentService;
import com.github.copilot.chat.input.AddReferenceAction;
import com.github.copilot.chat.input.CopilotChatInputPanelWrapper;
import com.github.copilot.chat.input.CopilotChatInputTextArea;
import com.github.copilot.chat.input.CopilotChatInputToolBarPanel;
import com.github.copilot.chat.input.CopilotInputBorderFocusListener;
import com.github.copilot.chat.input.ModelPickPanel;
import com.github.copilot.chat.input.ModelScope;
import com.github.copilot.chat.input.SendStopActionButtonPanel;
import com.github.copilot.chat.input.UserMessageListener;
import com.github.copilot.chat.models.CopilotModelService;
import com.github.copilot.chat.references.ReferenceComponent;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.style.Style;
import com.github.copilot.ui.component.ActionButtonKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.WrapLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\"J\u0006\u0010+\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0018\u0010\u0014\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/github/copilot/chat/input/CopilotChatInputPanel;", "Ljavax/swing/JPanel;", "chatSessionController", "Lcom/github/copilot/chat/session/ChatSessionController;", "persistenceService", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "remoteAgentService", "Lcom/github/copilot/chat/agent/RemoteAgentService;", "copilotModelService", "Lcom/github/copilot/chat/models/CopilotModelService;", "<init>", "(Lcom/github/copilot/chat/session/ChatSessionController;Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;Lcom/github/copilot/chat/agent/RemoteAgentService;Lcom/github/copilot/chat/models/CopilotModelService;)V", "textInputArea", "Lcom/github/copilot/chat/input/CopilotChatInputTextArea;", "getTextInputArea", "()Lcom/github/copilot/chat/input/CopilotChatInputTextArea;", "focusedBorder", "Ljavax/swing/border/CompoundBorder;", "kotlin.jvm.PlatformType", "Ljavax/swing/border/CompoundBorder;", "unfocusedBorder", "buttonPanel", "Lcom/github/copilot/chat/input/SendStopActionButtonPanel;", "leftPanel", "modelPickPanel", "Lcom/github/copilot/chat/input/ModelPickPanel;", "rightPanel", "leftBottomPanelConstraints", "Ljava/awt/GridBagConstraints;", "rightBottomPanelConstraints", "bottomPanel", "Lcom/github/copilot/chat/input/CopilotChatInputToolBarPanel;", "referencesPanel", "addExplicitReference", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "removeExplicitReference", "referenceComponent", "Lcom/github/copilot/chat/references/ReferenceComponent;", "removeAllReferences", "loadModel", "core"})
public final class CopilotChatInputPanel
extends JPanel {
    @NotNull
    private final ChatSessionController chatSessionController;
    @NotNull
    private final ChatSessionPersistenceService persistenceService;
    @NotNull
    private final CopilotChatInputTextArea textInputArea;
    private final CompoundBorder focusedBorder;
    private final CompoundBorder unfocusedBorder;
    @NotNull
    private final SendStopActionButtonPanel buttonPanel;
    @NotNull
    private final JPanel leftPanel;
    @NotNull
    private final ModelPickPanel modelPickPanel;
    @NotNull
    private final JPanel rightPanel;
    @NotNull
    private final GridBagConstraints leftBottomPanelConstraints;
    @NotNull
    private final GridBagConstraints rightBottomPanelConstraints;
    @NotNull
    private final CopilotChatInputToolBarPanel bottomPanel;
    @NotNull
    private final JPanel referencesPanel;

    /*
     * WARNING - void declaration
     */
    public CopilotChatInputPanel(@NotNull ChatSessionController chatSessionController, @NotNull ChatSessionPersistenceService persistenceService, @NotNull RemoteAgentService remoteAgentService, @NotNull CopilotModelService copilotModelService) {
        void $this$referencesPanel_u24lambda_u248;
        Serializable $this$bottomPanel_u24lambda_u247;
        Serializable $this$rightPanel_u24lambda_u244;
        JPanel $this$leftPanel_u24lambda_u243;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)chatSessionController, (String)"chatSessionController");
        Intrinsics.checkNotNullParameter((Object)persistenceService, (String)"persistenceService");
        Intrinsics.checkNotNullParameter((Object)remoteAgentService, (String)"remoteAgentService");
        Intrinsics.checkNotNullParameter((Object)copilotModelService, (String)"copilotModelService");
        super(new GridBagLayout());
        this.chatSessionController = chatSessionController;
        this.persistenceService = persistenceService;
        this.textInputArea = new CopilotChatInputTextArea(this.chatSessionController, remoteAgentService, null, null, null, (arg_0, arg_1) -> CopilotChatInputPanel.textInputArea$lambda$0(this, arg_0, arg_1), 28, null);
        this.focusedBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12), CopilotInputBorderFocusListener.Companion.getFocusBorder());
        this.unfocusedBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12), CopilotInputBorderFocusListener.Companion.getUnfocusedBorder());
        this.buttonPanel = new SendStopActionButtonPanel((Function0<Unit>)((Function0)() -> CopilotChatInputPanel.buttonPanel$lambda$1(this)), (Function0<Unit>)((Function0)() -> CopilotChatInputPanel.buttonPanel$lambda$2(this)));
        Serializable serializable2 = serializable = new JPanel();
        CopilotChatInputPanel copilotChatInputPanel = this;
        boolean bl = false;
        $this$leftPanel_u24lambda_u243.setOpaque(false);
        $this$leftPanel_u24lambda_u243.add((Component)ActionButtonKt.actionButton(new AddReferenceAction(this, this.chatSessionController)));
        copilotChatInputPanel.leftPanel = serializable;
        this.modelPickPanel = new ModelPickPanel(copilotModelService, this.persistenceService, ModelScope.CHAT_PANEL);
        $this$leftPanel_u24lambda_u243 = serializable = new JPanel(new FlowLayout());
        copilotChatInputPanel = this;
        boolean bl2 = false;
        $this$rightPanel_u24lambda_u244.setOpaque(false);
        $this$rightPanel_u24lambda_u244.add((Component)((Object)this.modelPickPanel), 0);
        $this$rightPanel_u24lambda_u244.add(this.buttonPanel, new FlowLayout(10, 5, 5));
        copilotChatInputPanel.rightPanel = serializable;
        $this$rightPanel_u24lambda_u244 = serializable = new GridBagConstraints();
        copilotChatInputPanel = this;
        boolean bl3 = false;
        ((GridBagConstraints)$this$leftBottomPanelConstraints_u24lambda_u245).fill = 0;
        ((GridBagConstraints)$this$leftBottomPanelConstraints_u24lambda_u245).anchor = 17;
        ((GridBagConstraints)$this$leftBottomPanelConstraints_u24lambda_u245).weightx = 1.0;
        ((GridBagConstraints)$this$leftBottomPanelConstraints_u24lambda_u245).gridwidth = 1;
        ((GridBagConstraints)$this$leftBottomPanelConstraints_u24lambda_u245).gridx = 0;
        ((GridBagConstraints)$this$leftBottomPanelConstraints_u24lambda_u245).gridy = 0;
        ((GridBagConstraints)$this$leftBottomPanelConstraints_u24lambda_u245).ipadx = 1;
        copilotChatInputPanel.leftBottomPanelConstraints = serializable;
        Serializable $this$leftBottomPanelConstraints_u24lambda_u245 = serializable = new GridBagConstraints();
        copilotChatInputPanel = this;
        boolean bl4 = false;
        ((GridBagConstraints)$this$rightBottomPanelConstraints_u24lambda_u246).fill = 0;
        ((GridBagConstraints)$this$rightBottomPanelConstraints_u24lambda_u246).anchor = 13;
        ((GridBagConstraints)$this$rightBottomPanelConstraints_u24lambda_u246).weightx = 1.0;
        ((GridBagConstraints)$this$rightBottomPanelConstraints_u24lambda_u246).gridwidth = 1;
        ((GridBagConstraints)$this$rightBottomPanelConstraints_u24lambda_u246).gridx = 1;
        ((GridBagConstraints)$this$rightBottomPanelConstraints_u24lambda_u246).gridy = 0;
        ((GridBagConstraints)$this$rightBottomPanelConstraints_u24lambda_u246).ipadx = 9;
        copilotChatInputPanel.rightBottomPanelConstraints = serializable;
        Serializable $this$rightBottomPanelConstraints_u24lambda_u246 = serializable = new CopilotChatInputToolBarPanel(0.0, 1, null);
        copilotChatInputPanel = this;
        boolean bl5 = false;
        $this$bottomPanel_u24lambda_u247.add(this.leftPanel, this.leftBottomPanelConstraints);
        $this$bottomPanel_u24lambda_u247.add(this.rightPanel, this.rightBottomPanelConstraints);
        $this$bottomPanel_u24lambda_u247.setOpaque(true);
        $this$bottomPanel_u24lambda_u247.setBorder(Style.Borders.INSTANCE.getChatInputControlPanelBorder());
        copilotChatInputPanel.bottomPanel = serializable;
        $this$bottomPanel_u24lambda_u247 = serializable = new JPanel((LayoutManager)new WrapLayout(0, 4, 4));
        copilotChatInputPanel = this;
        boolean $i$a$-apply-CopilotChatInputPanel$referencesPanel$22 = false;
        $this$referencesPanel_u24lambda_u248.setBorder(Style.Borders.INSTANCE.getReferencesPanelBorder());
        copilotChatInputPanel.referencesPanel = serializable;
        this.setOpaque(false);
        this.referencesPanel.setEnabled(false);
        this.referencesPanel.setVisible(false);
        this.chatSessionController.getChatSessionManager().addUnlockListener(arg_0 -> CopilotChatInputPanel._init_$lambda$10(this, arg_0));
        this.chatSessionController.getChatSessionManager().addLockListener(arg_0 -> CopilotChatInputPanel._init_$lambda$11(this, arg_0));
        Document document = this.textInputArea.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        ListenerUiUtil.whenTextChanged$default((Document)document, null, arg_0 -> CopilotChatInputPanel._init_$lambda$13(this, arg_0), (int)1, null);
        this.textInputArea.addFocusListener(new CopilotInputBorderFocusListener(this, (Function1<? super FocusEvent, Unit>)((Function1)arg_0 -> CopilotChatInputPanel._init_$lambda$14(this, arg_0)), (Function1<? super FocusEvent, Unit>)((Function1)arg_0 -> CopilotChatInputPanel._init_$lambda$15(this, arg_0))));
        CopilotChatInputPanelWrapper wrapper = new CopilotChatInputPanelWrapper(this.textInputArea);
        Serializable $i$a$-apply-CopilotChatInputPanel$referencesPanel$22 = serializable2 = new GridBagConstraints();
        Component component2 = wrapper;
        copilotChatInputPanel = this;
        boolean bl6 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u2416).fill = 2;
        ((GridBagConstraints)$this$_init__u24lambda_u2416).anchor = 10;
        ((GridBagConstraints)$this$_init__u24lambda_u2416).weightx = 1.0;
        ((GridBagConstraints)$this$_init__u24lambda_u2416).gridx = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2416).gridy = 0;
        Unit unit = Unit.INSTANCE;
        copilotChatInputPanel.add(component2, serializable2);
        Serializable $this$_init__u24lambda_u2416 = serializable2 = new GridBagConstraints();
        component2 = this.referencesPanel;
        copilotChatInputPanel = this;
        boolean bl7 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u2417).gridx = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2417).gridy = 1;
        ((GridBagConstraints)$this$_init__u24lambda_u2417).fill = 2;
        unit = Unit.INSTANCE;
        copilotChatInputPanel.add(component2, serializable2);
        Serializable $this$_init__u24lambda_u2417 = serializable2 = new GridBagConstraints();
        component2 = this.bottomPanel;
        copilotChatInputPanel = this;
        boolean bl8 = false;
        $this$_init__u24lambda_u2418.gridx = 0;
        $this$_init__u24lambda_u2418.gridy = 2;
        $this$_init__u24lambda_u2418.fill = 2;
        unit = Unit.INSTANCE;
        copilotChatInputPanel.add(component2, serializable2);
        this.setBorder(this.isFocusOwner() ? (Border)this.focusedBorder : (Border)this.unfocusedBorder);
    }

    @NotNull
    public final CopilotChatInputTextArea getTextInputArea() {
        return this.textInputArea;
    }

    public final void addExplicitReference(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ApplicationManager.getApplication().invokeLater(() -> CopilotChatInputPanel.addExplicitReference$lambda$19(this, virtualFile, project));
    }

    public final void removeExplicitReference(@NotNull ReferenceComponent referenceComponent) {
        Intrinsics.checkNotNullParameter((Object)referenceComponent, (String)"referenceComponent");
        ApplicationManager.getApplication().invokeLater(() -> CopilotChatInputPanel.removeExplicitReference$lambda$20(this, referenceComponent));
    }

    public final void removeAllReferences() {
        ApplicationManager.getApplication().invokeLater(() -> CopilotChatInputPanel.removeAllReferences$lambda$21(this));
    }

    public final void loadModel() {
        this.modelPickPanel.loadModel();
    }

    private static final Unit textInputArea$lambda$0(CopilotChatInputPanel this$0, String content, List ignoredSkills) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)ignoredSkills, (String)"ignoredSkills");
        UserMessageListener.Companion.onUserMessage(content, this$0.chatSessionController.getSession(), null, null, ignoredSkills, this$0.modelPickPanel.selectedModel());
        return Unit.INSTANCE;
    }

    private static final Unit buttonPanel$lambda$1(CopilotChatInputPanel this$0) {
        this$0.textInputArea.getChatInputController().submit();
        return Unit.INSTANCE;
    }

    private static final Unit buttonPanel$lambda$2(CopilotChatInputPanel this$0) {
        this$0.chatSessionController.unlockSession();
        SessionController.stopActiveResponses$default(this$0.chatSessionController, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final boolean lambda$10$lambda$9(CopilotChatInputPanel this$0) {
        String string = this$0.textInputArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((CharSequence)string).length() > 0;
    }

    private static final void _init_$lambda$10(CopilotChatInputPanel this$0, ChatSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)this$0.chatSessionController.getSession(), (Object)it)) {
            return;
        }
        this$0.buttonPanel.showSendButton((Function0<Boolean>)((Function0)() -> CopilotChatInputPanel.lambda$10$lambda$9(this$0)));
    }

    private static final void _init_$lambda$11(CopilotChatInputPanel this$0, ChatSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)this$0.chatSessionController.getSession(), (Object)it)) {
            return;
        }
        this$0.buttonPanel.showStopButton();
    }

    private static final boolean lambda$13$lambda$12(CopilotChatInputPanel this$0) {
        String string = this$0.textInputArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((CharSequence)string).length() > 0;
    }

    private static final Unit _init_$lambda$13(CopilotChatInputPanel this$0, DocumentEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.chatSessionController.getChatSessionManager().isUnlocked(this$0.chatSessionController.getSession())) {
            this$0.buttonPanel.showSendButton((Function0<Boolean>)((Function0)() -> CopilotChatInputPanel.lambda$13$lambda$12(this$0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$14(CopilotChatInputPanel this$0, FocusEvent it) {
        this$0.setBorder(this$0.focusedBorder);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$15(CopilotChatInputPanel this$0, FocusEvent it) {
        this$0.setBorder(this$0.unfocusedBorder);
        return Unit.INSTANCE;
    }

    private static final void addExplicitReference$lambda$19(CopilotChatInputPanel this$0, VirtualFile $virtualFile, Project $project) {
        this$0.referencesPanel.add(new ReferenceComponent($virtualFile, $project, null, null, null, 28, null));
        this$0.referencesPanel.setEnabled(true);
        this$0.referencesPanel.setVisible(this$0.referencesPanel.isEnabled());
        this$0.referencesPanel.revalidate();
        this$0.referencesPanel.repaint();
    }

    private static final void removeExplicitReference$lambda$20(CopilotChatInputPanel this$0, ReferenceComponent $referenceComponent) {
        this$0.referencesPanel.remove($referenceComponent);
        JPanel jPanel = this$0.referencesPanel;
        Component[] componentArray = this$0.referencesPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        jPanel.setEnabled(!(((Object[])componentArray).length == 0));
        this$0.referencesPanel.setVisible(this$0.referencesPanel.isEnabled());
        this$0.referencesPanel.revalidate();
        this$0.referencesPanel.repaint();
    }

    private static final void removeAllReferences$lambda$21(CopilotChatInputPanel this$0) {
        this$0.referencesPanel.removeAll();
        this$0.referencesPanel.setEnabled(false);
        this$0.referencesPanel.setVisible(false);
        this$0.referencesPanel.revalidate();
        this$0.referencesPanel.repaint();
    }
}

