/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.input;

import com.github.copilot.chat.conversation.agent.rpc.command.CopilotModel;
import com.github.copilot.chat.input.ModelScope;
import com.github.copilot.chat.models.CopilotModelService;
import com.github.copilot.chat.models.CopilotModelServiceKt;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0007\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/copilot/chat/input/ModelPickPanel;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/github/copilot/chat/conversation/agent/rpc/command/CopilotModel;", "copilotModelService", "Lcom/github/copilot/chat/models/CopilotModelService;", "persistenceService", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "scope", "Lcom/github/copilot/chat/input/ModelScope;", "<init>", "(Lcom/github/copilot/chat/models/CopilotModelService;Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;Lcom/github/copilot/chat/input/ModelScope;)V", "models", "", "selectedModel", "", "fetchModel", "updateVisible", "", "loadModel", "core"})
@SourceDebugExtension(value={"SMAP\nModelPickPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelPickPanel.kt\ncom/github/copilot/chat/input/ModelPickPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1855#2,2:103\n1054#2:106\n1963#2,14:107\n1855#2,2:121\n1#3:105\n*S KotlinDebug\n*F\n+ 1 ModelPickPanel.kt\ncom/github/copilot/chat/input/ModelPickPanel\n*L\n21#1:103,2\n53#1:106\n71#1:107,14\n83#1:121,2\n*E\n"})
public final class ModelPickPanel
extends ComboBox<CopilotModel> {
    @NotNull
    private final CopilotModelService copilotModelService;
    @NotNull
    private final ChatSessionPersistenceService persistenceService;
    @NotNull
    private final ModelScope scope;
    @NotNull
    private List<CopilotModel> models;

    public ModelPickPanel(@NotNull CopilotModelService copilotModelService, @NotNull ChatSessionPersistenceService persistenceService, @NotNull ModelScope scope) {
        CopilotModel it;
        Intrinsics.checkNotNullParameter((Object)copilotModelService, (String)"copilotModelService");
        Intrinsics.checkNotNullParameter((Object)persistenceService, (String)"persistenceService");
        Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
        this.copilotModelService = copilotModelService;
        this.persistenceService = persistenceService;
        this.scope = scope;
        this.models = this.fetchModel(this.scope.toString());
        this.setOpaque(false);
        this.models = this.fetchModel(this.scope.toString());
        Iterable $this$forEach$iv = this.models;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (CopilotModel)element$iv;
            boolean bl = false;
            this.addItem(it);
        }
        if (this.copilotModelService.getDefaultModel(this.scope) != null) {
            this.setSelectedItem(this.copilotModelService.getDefaultModel(this.scope));
        } else if (this.persistenceService.getSelectedModel(this.scope) != null) {
            Object v0;
            ModelPickPanel modelPickPanel;
            block5: {
                Iterable iterable = this.models;
                modelPickPanel = this;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    it = (CopilotModel)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getModelFamily(), (Object)this.persistenceService.getSelectedModel(this.scope))) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            modelPickPanel.setSelectedItem(v0);
        }
        this.addActionListener(arg_0 -> ModelPickPanel._init_$lambda$2(this, arg_0));
        this.updateVisible();
    }

    @Nullable
    public final String selectedModel() {
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        if (((Object[])componentArray).length == 0) {
            return null;
        }
        Object object = this.getSelectedItem();
        CopilotModel copilotModel = object instanceof CopilotModel ? (CopilotModel)object : null;
        return copilotModel != null ? copilotModel.getModelFamily() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<CopilotModel> fetchModel(@NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ModelPickPanel modelPickPanel = this;
        synchronized (modelPickPanel) {
            boolean bl = false;
            int maxRetries = 3;
            int attempt = 0;
            List models = CollectionsKt.emptyList();
            while (attempt < maxRetries) {
                try {
                    Iterable $this$sortedByDescending$iv = CopilotModelServiceKt.getCopilotModelsByScope(this.copilotModelService, scope);
                    boolean $i$f$sortedByDescending = false;
                    models = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            CopilotModel it = (CopilotModel)b;
                            boolean bl = false;
                            Comparable comparable = Boolean.valueOf(Intrinsics.areEqual((Object)it.getModelFamily(), (Object)"gpt-4o"));
                            it = (CopilotModel)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)it.getModelFamily(), (Object)"gpt-4o")));
                        }
                    });
                    break;
                }
                catch (Exception e) {
                    if (++attempt < maxRetries) continue;
                    models = CollectionsKt.emptyList();
                }
            }
            List list = models;
            return list;
        }
    }

    public final void updateVisible() {
        if (this.models.isEmpty()) {
            this.setVisible(false);
        } else {
            Object v0;
            this.setVisible(true);
            Iterable $this$maxByOrNull$iv = this.models;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    CopilotModel it = (CopilotModel)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getModelName().length();
                    do {
                        Object e$iv = iterator$iv.next();
                        CopilotModel it2 = (CopilotModel)e$iv;
                        $i$a$-maxByOrNull-ModelPickPanel$updateVisible$model$1 = false;
                        int v$iv = it2.getModelName().length();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            CopilotModel model = v0;
            if (model != null) {
                CopilotModel prototypeDisplayValueModel = CopilotModel.copy$default(model, null, StringsKt.dropLast((String)model.getModelName(), (int)3), null, 5, null);
                this.setPrototypeDisplayValue(prototypeDisplayValueModel);
            }
        }
    }

    public final void loadModel() {
        if (!this.isVisible()) {
            this.models = this.fetchModel(this.scope.toString());
            this.removeAllItems();
            Iterable $this$forEach$iv = this.models;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CopilotModel it = (CopilotModel)element$iv;
                boolean bl = false;
                this.addItem(it);
            }
            if (this.copilotModelService.getDefaultModel(this.scope) != null) {
                this.setSelectedItem(this.copilotModelService.getDefaultModel(this.scope));
            }
            this.updateVisible();
        }
    }

    private static final void _init_$lambda$2(ModelPickPanel this$0, ActionEvent it) {
        CopilotModelService copilotModelService = this$0.copilotModelService;
        ModelScope modelScope = this$0.scope;
        Object object = this$0.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.github.copilot.chat.conversation.agent.rpc.command.CopilotModel");
        copilotModelService.setDefaultModel(modelScope, (CopilotModel)object);
        ChatSessionPersistenceService chatSessionPersistenceService = this$0.persistenceService;
        ModelScope modelScope2 = this$0.scope;
        Object object2 = this$0.getSelectedItem();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.github.copilot.chat.conversation.agent.rpc.command.CopilotModel");
        chatSessionPersistenceService.updateSelectedModel(modelScope2, ((CopilotModel)object2).toString());
    }
}

