/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.input.agent;

import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.agent.RemoteAgentKt;
import com.github.copilot.chat.agent.RemoteAgentService;
import com.github.copilot.chat.input.PopupController;
import com.github.copilot.chat.input.agent.RemoteAgentInputProcessor;
import com.github.copilot.chat.input.agent.RemoteAgentList;
import com.github.copilot.chat.input.agent.RemoteAgentListItem;
import com.github.copilot.chat.input.agent.RemoteAgentProcessedInput;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.ui.popup.JBPopupKt;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0082\b\u0018\u0000 72\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u00017B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\b\u0010\u001e\u001a\u00020\fH\u0016J\u0012\u0010\u001f\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J*\u0010*\u001a\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u0017*\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00172\b\u0010+\u001a\u0004\u0018\u00010#H\u0002J\u0016\u0010,\u001a\u00020\u0015*\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u0017H\u0002J\t\u0010-\u001a\u00020\u0005H\u00c2\u0003J\t\u0010.\u001a\u00020\u0007H\u00c2\u0003J\t\u0010/\u001a\u00020\tH\u00c2\u0003J\u0015\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000bH\u00c2\u0003J=\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u00102\u001a\u00020\u001c2\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u00020%H\u00d6\u0001J\t\u00106\u001a\u00020#H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\u00020%*\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00068"}, d2={"Lcom/github/copilot/chat/input/agent/AgentPopupController;", "Lcom/github/copilot/chat/input/PopupController;", "Lcom/github/copilot/chat/input/agent/RemoteAgentListItem;", "Lcom/github/copilot/chat/input/agent/RemoteAgentPopupController;", "parentComponent", "Ljavax/swing/JTextArea;", "remoteAgentService", "Lcom/github/copilot/chat/agent/RemoteAgentService;", "remoteAgentInputProcessor", "Lcom/github/copilot/chat/input/agent/RemoteAgentInputProcessor;", "onSelected", "Lkotlin/Function1;", "", "<init>", "(Ljavax/swing/JTextArea;Lcom/github/copilot/chat/agent/RemoteAgentService;Lcom/github/copilot/chat/input/agent/RemoteAgentInputProcessor;Lkotlin/jvm/functions/Function1;)V", "remoteAgents", "", "Lcom/github/copilot/chat/agent/RemoteAgent;", "getRemoteAgents", "()Ljava/util/List;", "remoteAgentsList", "Lcom/github/copilot/chat/input/agent/RemoteAgentList;", "previousResults", "Lcom/github/copilot/chat/agent/RemoteAgents;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "close", "isPopupEnabled", "", "highlightPrevious", "highlightNext", "select", "item", "updateState", "text", "", "caretPosition", "", "caretPositionAfterChange", "Ljavax/swing/event/DocumentEvent;", "getCaretPositionAfterChange", "(Ljavax/swing/event/DocumentEvent;)I", "filter", "input", "toRemoteAgentList", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nRemoteAgentPopupController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteAgentPopupController.kt\ncom/github/copilot/chat/input/agent/AgentPopupController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n766#2:162\n857#2,2:163\n766#2:165\n857#2,2:166\n766#2:168\n857#2,2:169\n766#2:171\n857#2,2:172\n1#3:174\n*S KotlinDebug\n*F\n+ 1 RemoteAgentPopupController.kt\ncom/github/copilot/chat/input/agent/AgentPopupController\n*L\n142#1:162\n142#1:163,2\n143#1:165\n143#1:166,2\n144#1:168\n144#1:169,2\n145#1:171\n145#1:172,2\n*E\n"})
final class AgentPopupController
implements PopupController<RemoteAgentListItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTextArea parentComponent;
    @NotNull
    private final RemoteAgentService remoteAgentService;
    @NotNull
    private final RemoteAgentInputProcessor remoteAgentInputProcessor;
    @NotNull
    private final Function1<RemoteAgentListItem, Unit> onSelected;
    @NotNull
    private RemoteAgentList remoteAgentsList;
    @NotNull
    private List<RemoteAgent> previousResults;
    @Nullable
    private JBPopup popup;
    @NotNull
    private static final Regex agentInputRegex = new Regex("^@\\S*\\s?");

    public AgentPopupController(@NotNull JTextArea parentComponent, @NotNull RemoteAgentService remoteAgentService, @NotNull RemoteAgentInputProcessor remoteAgentInputProcessor, @NotNull Function1<? super RemoteAgentListItem, Unit> onSelected) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)remoteAgentService, (String)"remoteAgentService");
        Intrinsics.checkNotNullParameter((Object)remoteAgentInputProcessor, (String)"remoteAgentInputProcessor");
        Intrinsics.checkNotNullParameter(onSelected, (String)"onSelected");
        this.parentComponent = parentComponent;
        this.remoteAgentService = remoteAgentService;
        this.remoteAgentInputProcessor = remoteAgentInputProcessor;
        this.onSelected = onSelected;
        this.remoteAgentsList = this.toRemoteAgentList(this.getRemoteAgents());
        this.previousResults = RemoteAgentKt.RemoteAgents(new RemoteAgent[0]);
        ListenerUiUtil.whenTextChanged$default((JTextComponent)this.parentComponent, null, arg_0 -> AgentPopupController._init_$lambda$0(this, arg_0), (int)1, null);
    }

    private final List<RemoteAgent> getRemoteAgents() {
        return this.remoteAgentService.getRemoteAgents();
    }

    @Override
    public void close() {
        ApplicationKt.runOnEdt((Function0<Unit>)((Function0)() -> AgentPopupController.close$lambda$1(this)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPopupEnabled() {
        JBPopup jBPopup = this.popup;
        if (jBPopup == null) return false;
        if (!jBPopup.isVisible()) return false;
        boolean bl = true;
        if (!bl) return false;
        JBPopup jBPopup2 = this.popup;
        if (jBPopup2 == null) return false;
        if (jBPopup2.isDisposed()) return false;
        return true;
    }

    @Override
    public void highlightPrevious() {
        RemoteAgentList $this$highlightPrevious_u24lambda_u242 = this.remoteAgentsList;
        boolean bl = false;
        $this$highlightPrevious_u24lambda_u242.setSelectedIndex($this$highlightPrevious_u24lambda_u242.getSelectedIndex() > 0 ? $this$highlightPrevious_u24lambda_u242.getSelectedIndex() - 1 : $this$highlightPrevious_u24lambda_u242.getItemsCount() - 1);
    }

    @Override
    public void highlightNext() {
        RemoteAgentList $this$highlightNext_u24lambda_u243 = this.remoteAgentsList;
        boolean bl = false;
        $this$highlightNext_u24lambda_u243.setSelectedIndex($this$highlightNext_u24lambda_u243.getSelectedIndex() < $this$highlightNext_u24lambda_u243.getItemsCount() - 1 ? $this$highlightNext_u24lambda_u243.getSelectedIndex() + 1 : 0);
    }

    @Override
    public void select(@Nullable RemoteAgentListItem item) {
        RemoteAgentListItem remoteAgentListItem = item;
        if (remoteAgentListItem == null) {
            remoteAgentListItem = (RemoteAgentListItem)this.remoteAgentsList.getSelectedValue();
        }
        if (remoteAgentListItem != null) {
            JTextArea jTextArea;
            RemoteAgentListItem selectedValue = remoteAgentListItem;
            boolean bl = false;
            String agentInput = selectedValue.getInputText();
            JTextArea $this$select_u24lambda_u245_u24lambda_u244 = jTextArea = this.parentComponent;
            boolean bl2 = false;
            String string = $this$select_u24lambda_u245_u24lambda_u244.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            $this$select_u24lambda_u245_u24lambda_u244.setText(agentInputRegex.replaceFirst((CharSequence)string, agentInput));
            $this$select_u24lambda_u245_u24lambda_u244.setCaretPosition(agentInput.length());
        }
        this.close();
    }

    private final void updateState(String text, int caretPosition) {
        if (!this.parentComponent.isShowing()) {
            return;
        }
        RemoteAgentProcessedInput remoteAgentProcessedInput = this.remoteAgentInputProcessor.process(text, caretPosition);
        boolean isAgentInput = remoteAgentProcessedInput.component1();
        String agentInput = remoteAgentProcessedInput.component2();
        if (!isAgentInput) {
            this.close();
            this.previousResults = RemoteAgentKt.RemoteAgents(new RemoteAgent[0]);
            return;
        }
        List<RemoteAgent> filteredResults = this.filter(this.getRemoteAgents(), agentInput);
        boolean bl = false;
        if (filteredResults.size() == 1 && Intrinsics.areEqual((Object)((RemoteAgent)CollectionsKt.first(filteredResults)).getSlug(), (Object)agentInput)) {
            this.close();
            this.previousResults = RemoteAgentKt.RemoteAgents(new RemoteAgent[0]);
            return;
        }
        if (Intrinsics.areEqual(filteredResults, this.previousResults)) {
            return;
        }
        this.previousResults = filteredResults;
        this.close();
        if (filteredResults.isEmpty()) {
            return;
        }
        this.remoteAgentsList = this.toRemoteAgentList(filteredResults);
        ApplicationKt.runOnEdt((Function0<Unit>)((Function0)() -> AgentPopupController.updateState$lambda$8(this)));
    }

    private final int getCaretPositionAfterChange(DocumentEvent $this$caretPositionAfterChange) {
        DocumentEvent.EventType eventType = $this$caretPositionAfterChange.getType();
        return Intrinsics.areEqual((Object)eventType, (Object)DocumentEvent.EventType.INSERT) ? $this$caretPositionAfterChange.getOffset() + $this$caretPositionAfterChange.getLength() : (Intrinsics.areEqual((Object)eventType, (Object)DocumentEvent.EventType.REMOVE) ? Math.max($this$caretPositionAfterChange.getOffset() + 1 - $this$caretPositionAfterChange.getLength(), 0) : $this$caretPositionAfterChange.getOffset());
    }

    /*
     * WARNING - void declaration
     */
    private final List<RemoteAgent> filter(List<RemoteAgent> $this$filter, String input) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        void $this$filterTo$iv$iv4;
        if (input == null) {
            return $this$filter;
        }
        Iterable $this$filter$iv = $this$filter;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv4) {
            RemoteAgent it = (RemoteAgent)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith((String)it.getSlug(), (String)input, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set slugStartsWith = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv2 = $this$filter;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            RemoteAgent it = (RemoteAgent)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)it.getSlug(), (CharSequence)input, (boolean)true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set slugContains = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filter$iv3 = $this$filter;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            RemoteAgent it = (RemoteAgent)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith((String)it.getDescription(), (String)input, (boolean)true)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set descriptionStartsWith = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Iterable $this$filter$iv4 = $this$filter;
        boolean $i$f$filter4 = false;
        destination$iv$iv3 = $this$filter$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RemoteAgent it = (RemoteAgent)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)it.getDescription(), (CharSequence)input, (boolean)true)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        Set descriptionContains = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
        return CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)slugStartsWith, (Iterable)slugContains), (Iterable)descriptionStartsWith), (Iterable)descriptionContains));
    }

    private final RemoteAgentList toRemoteAgentList(List<RemoteAgent> $this$toRemoteAgentList) {
        RemoteAgentList remoteAgentList;
        RemoteAgentList $this$toRemoteAgentList_u24lambda_u2413 = remoteAgentList = new RemoteAgentList($this$toRemoteAgentList, (Function1<? super RemoteAgentListItem, Unit>)((Function1)new Function1<RemoteAgentListItem, Unit>((Object)this){

            public final void invoke(RemoteAgentListItem p0) {
                ((AgentPopupController)this.receiver).select(p0);
            }
        }), this.parentComponent);
        boolean bl = false;
        $this$toRemoteAgentList_u24lambda_u2413.setSelectedIndex(0);
        return remoteAgentList;
    }

    private final JTextArea component1() {
        return this.parentComponent;
    }

    private final RemoteAgentService component2() {
        return this.remoteAgentService;
    }

    private final RemoteAgentInputProcessor component3() {
        return this.remoteAgentInputProcessor;
    }

    private final Function1<RemoteAgentListItem, Unit> component4() {
        return this.onSelected;
    }

    @NotNull
    public final AgentPopupController copy(@NotNull JTextArea parentComponent, @NotNull RemoteAgentService remoteAgentService, @NotNull RemoteAgentInputProcessor remoteAgentInputProcessor, @NotNull Function1<? super RemoteAgentListItem, Unit> onSelected) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)remoteAgentService, (String)"remoteAgentService");
        Intrinsics.checkNotNullParameter((Object)remoteAgentInputProcessor, (String)"remoteAgentInputProcessor");
        Intrinsics.checkNotNullParameter(onSelected, (String)"onSelected");
        return new AgentPopupController(parentComponent, remoteAgentService, remoteAgentInputProcessor, onSelected);
    }

    public static /* synthetic */ AgentPopupController copy$default(AgentPopupController agentPopupController, JTextArea jTextArea, RemoteAgentService remoteAgentService, RemoteAgentInputProcessor remoteAgentInputProcessor, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            jTextArea = agentPopupController.parentComponent;
        }
        if ((n & 2) != 0) {
            remoteAgentService = agentPopupController.remoteAgentService;
        }
        if ((n & 4) != 0) {
            remoteAgentInputProcessor = agentPopupController.remoteAgentInputProcessor;
        }
        if ((n & 8) != 0) {
            function1 = agentPopupController.onSelected;
        }
        return agentPopupController.copy(jTextArea, remoteAgentService, remoteAgentInputProcessor, function1);
    }

    @NotNull
    public String toString() {
        return "AgentPopupController(parentComponent=" + this.parentComponent + ", remoteAgentService=" + this.remoteAgentService + ", remoteAgentInputProcessor=" + this.remoteAgentInputProcessor + ", onSelected=" + this.onSelected + ")";
    }

    public int hashCode() {
        int result = this.parentComponent.hashCode();
        result = result * 31 + this.remoteAgentService.hashCode();
        result = result * 31 + this.remoteAgentInputProcessor.hashCode();
        result = result * 31 + this.onSelected.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AgentPopupController)) {
            return false;
        }
        AgentPopupController agentPopupController = (AgentPopupController)other;
        if (!Intrinsics.areEqual((Object)this.parentComponent, (Object)agentPopupController.parentComponent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.remoteAgentService, (Object)agentPopupController.remoteAgentService)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.remoteAgentInputProcessor, (Object)agentPopupController.remoteAgentInputProcessor)) {
            return false;
        }
        return Intrinsics.areEqual(this.onSelected, agentPopupController.onSelected);
    }

    private static final Unit _init_$lambda$0(AgentPopupController this$0, DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = this$0.parentComponent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.updateState(string, this$0.getCaretPositionAfterChange(event));
        return Unit.INSTANCE;
    }

    private static final Unit close$lambda$1(AgentPopupController this$0) {
        block0: {
            JBPopup jBPopup = this$0.popup;
            if (jBPopup == null) break block0;
            jBPopup.cancel();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateState$lambda$8(AgentPopupController this$0) {
        void $this$updateState_u24lambda_u248_u24lambda_u247;
        JBPopup jBPopup;
        JBPopup jBPopup2 = jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this$0.remoteAgentsList), null).setMinSize(new Dimension(this$0.parentComponent.getWidth(), 0)).createPopup();
        AgentPopupController agentPopupController = this$0;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$updateState_u24lambda_u248_u24lambda_u247);
        JBPopupKt.showAbove((JBPopup)$this$updateState_u24lambda_u248_u24lambda_u247, this$0.parentComponent);
        agentPopupController.popup = jBPopup;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/copilot/chat/input/agent/AgentPopupController$Companion;", "", "<init>", "()V", "agentInputRegex", "Lkotlin/text/Regex;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

