/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.renderer.ChatMarkdownTransformer;
import com.github.copilot.chat.utils.CopyKt;
import com.github.copilot.platform.utils.ProjectKt;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.ProjectManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/copilot/chat/message/CopyFilteredHtmlContentsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "<init>", "(Lcom/github/copilot/chat/message/ChatMessage;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "core"})
public final class CopyFilteredHtmlContentsAction
extends AnAction {
    @NotNull
    private final ChatMessage chatMessage;

    public CopyFilteredHtmlContentsAction(@NotNull ChatMessage chatMessage) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        super("Copy Filtered HTML Contents", "Copy filtered HTML to clipboard", AllIcons.Actions.ChangeView);
        this.chatMessage = chatMessage;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CopyKt.copyToClipBoard(ChatMarkdownTransformer.INSTANCE.toHtml(this.chatMessage.getContent()));
        Notification notification = CopilotNotifications.createFullContentNotification(CopilotBundle.get("copilot.chat.debug.copy.title"), CopilotBundle.get("copilot.chat.debug.copy.text"), NotificationType.INFORMATION, true);
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"getInstance(...)");
        notification.notify(ProjectKt.getBestProject$default(projectManager, null, 1, null));
    }
}

