/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message;

import com.github.copilot.chat.message.HtmlContentComponent;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotChatLocale;
import com.github.copilot.style.Style;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import java.awt.ComponentOrientation;
import java.awt.Rectangle;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/copilot/chat/message/HtmlComponent;", "Ljavax/swing/JEditorPane;", "html", "", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "locale", "Ljava/util/Locale;", "<init>", "(Ljava/lang/String;Lcom/github/copilot/platform/utils/observability/Logger;Ljava/util/Locale;)V", "core"})
@SourceDebugExtension(value={"SMAP\nHtmlComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlComponent.kt\ncom/github/copilot/chat/message/HtmlComponent\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,41:1\n39#2:42\n*S KotlinDebug\n*F\n+ 1 HtmlComponent.kt\ncom/github/copilot/chat/message/HtmlComponent\n*L\n18#1:42\n*E\n"})
public final class HtmlComponent
extends JEditorPane {
    @NotNull
    private final Logger log;
    @NotNull
    private final Locale locale;

    public HtmlComponent(@NotNull String html, @NotNull Logger log, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.log = log;
        this.locale = locale;
        this.setOpaque(false);
        this.setEditable(false);
        this.setContentType("text/html");
        Function2[] function2Array = new Function2[]{ExtendableHTMLViewFactory.Extensions.WORD_WRAP};
        this.setEditorKit(new HTMLEditorKitBuilder().withViewFactoryExtensions(function2Array).build());
        this.setFont(UIManager.getFont("Label.font"));
        this.setText(html);
        this.setBorder(Style.Borders.INSTANCE.getDefaultHorizontalBorder());
        this.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle position) {
            }
        });
        this.setComponentOrientation(ComponentOrientation.getOrientation(this.locale));
    }

    public /* synthetic */ HtmlComponent(String string, Logger logger, Locale locale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(HtmlContentComponent.class);
        }
        if ((n & 4) != 0) {
            String string2 = CopilotApplicationSettings.settings().chatNaturalLanguage;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"chatNaturalLanguage");
            locale = CopilotChatLocale.INSTANCE.getLocaleByLanguageName(string2);
        }
        this(string, logger, locale);
    }

    public HtmlComponent() {
        this(null, null, null, 7, null);
    }
}

