/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message;

import com.github.copilot.CopilotBundle;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotChatLocale;
import com.github.copilot.style.Style;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.DefaultCaret;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/copilot/chat/message/HtmlContentComponent;", "Ljavax/swing/JEditorPane;", "htmlSupplier", "Lkotlin/Function0;", "", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "locale", "Ljava/util/Locale;", "<init>", "(Lkotlin/jvm/functions/Function0;Lcom/github/copilot/platform/utils/observability/Logger;Ljava/util/Locale;)V", "getHtmlSupplier", "()Lkotlin/jvm/functions/Function0;", "setHtmlSupplier", "(Lkotlin/jvm/functions/Function0;)V", "refresh", "", "core"})
@SourceDebugExtension(value={"SMAP\nHtmlContentComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlContentComponent.kt\ncom/github/copilot/chat/message/HtmlContentComponent\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,64:1\n39#2:65\n*S KotlinDebug\n*F\n+ 1 HtmlContentComponent.kt\ncom/github/copilot/chat/message/HtmlContentComponent\n*L\n23#1:65\n*E\n"})
public final class HtmlContentComponent
extends JEditorPane {
    @NotNull
    private Function0<String> htmlSupplier;
    @NotNull
    private final Logger log;
    @NotNull
    private final Locale locale;

    public HtmlContentComponent(@NotNull Function0<String> htmlSupplier, @NotNull Logger log, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(htmlSupplier, (String)"htmlSupplier");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.htmlSupplier = htmlSupplier;
        this.log = log;
        this.locale = locale;
        this.setOpaque(false);
        this.setEditable(false);
        this.setContentType("text/html");
        Function2[] function2Array = new Function2[]{ExtendableHTMLViewFactory.Extensions.WORD_WRAP};
        this.setEditorKit(new HTMLEditorKitBuilder().withViewFactoryExtensions(function2Array).build());
        this.setFont(UIManager.getFont("Label.font"));
        this.setText((String)this.htmlSupplier.invoke());
        this.setBorder(Style.Borders.INSTANCE.getDefaultHorizontalBorder());
        this.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle position) {
            }
        });
        this.setComponentOrientation(ComponentOrientation.getOrientation(this.locale));
        this.addHyperlinkListener(arg_0 -> HtmlContentComponent._init_$lambda$1(this, arg_0));
    }

    public /* synthetic */ HtmlContentComponent(Function0 function0, Logger logger, Locale locale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = HtmlContentComponent::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(HtmlContentComponent.class);
        }
        if ((n & 4) != 0) {
            String string = CopilotApplicationSettings.settings().chatNaturalLanguage;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chatNaturalLanguage");
            locale = CopilotChatLocale.INSTANCE.getLocaleByLanguageName(string);
        }
        this((Function0<String>)function0, logger, locale);
    }

    @NotNull
    public final Function0<String> getHtmlSupplier() {
        return this.htmlSupplier;
    }

    public final void setHtmlSupplier(@NotNull Function0<String> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.htmlSupplier = function0;
    }

    public final void refresh() {
        this.setText((String)this.htmlSupplier.invoke());
    }

    private static final String _init_$lambda$0() {
        return "";
    }

    private static final void _init_$lambda$1(HtmlContentComponent this$0, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                String string = CopilotBundle.get("copilot.chat.open.url.warning.title");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                Object[] objectArray = new Object[]{event.getURL()};
                String string2 = CopilotBundle.get("copilot.chat.open.url.warning.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                MessageDialogBuilder.YesNo dialog = (MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).yesText("Continue")).noText("Cancel")).asWarning();
                if (dialog.ask((Component)this$0)) {
                    BrowserUtil.browse((URL)event.getURL());
                }
            }
            catch (Exception e) {
                this$0.log.warn("Failed to open browser", e);
            }
        }
    }

    public HtmlContentComponent() {
        this(null, null, null, 7, null);
    }
}

