/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotBundleEx;
import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.agent.RemoteAgentKt;
import com.github.copilot.chat.agent.avatar.RemoteAgentAvatar;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.conversation.agent.rpc.ChatAnnotation;
import com.github.copilot.chat.conversation.agent.rpc.ChatNotification;
import com.github.copilot.chat.conversation.agent.rpc.ConfirmationRequest;
import com.github.copilot.chat.conversation.agent.rpc.ConfirmationResponse;
import com.github.copilot.chat.formatting.Markdown;
import com.github.copilot.chat.input.UserMessageListener;
import com.github.copilot.chat.message.AnnotationOffset;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.ChatMessageStatus;
import com.github.copilot.chat.message.ChatMessageTypeKt;
import com.github.copilot.chat.message.ConfirmationPanel;
import com.github.copilot.chat.message.DiffContentResult;
import com.github.copilot.chat.message.HtmlContentComponent;
import com.github.copilot.chat.message.MessageComponentKt;
import com.github.copilot.chat.message.MessageContentPanel;
import com.github.copilot.chat.message.MessageNotificationPanel;
import com.github.copilot.chat.message.ModelPolicyNotificationComponent;
import com.github.copilot.chat.message.NotificationComponent;
import com.github.copilot.chat.message.NotificationStyle;
import com.github.copilot.chat.message.NotificationType;
import com.github.copilot.chat.message.PartialOffsetsWithAnnotations;
import com.github.copilot.chat.message.RetryMessage;
import com.github.copilot.chat.message.StepPanelComponent;
import com.github.copilot.chat.message.UpdatableComponent;
import com.github.copilot.chat.message.UpgradeNotificationComponent;
import com.github.copilot.chat.message.auth.RemoteAgentAuthPanel;
import com.github.copilot.chat.message.codeblock.CodeBlockContainer;
import com.github.copilot.chat.message.references.ChatReference;
import com.github.copilot.chat.message.references.ChatReferencesListPanel;
import com.github.copilot.chat.panels.CollapsiblePanel;
import com.github.copilot.chat.renderer.ChatMarkdownTransformer;
import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.chat.user.GitHubUserIcon;
import com.github.copilot.configuration.Configuration;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotChatLocale;
import com.github.copilot.style.Style;
import com.github.copilot.ui.component.JComponentKt;
import com.github.copilot.ui.component.RoundEmptyBorder;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\b\b\u0002\u0010C\u001a\u00020\nJ\u000e\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020FJ\u0010\u0010G\u001a\u00020@2\u0006\u0010H\u001a\u00020$H\u0002J\u0018\u0010I\u001a\u00020@2\u0006\u0010J\u001a\u00020K2\u0006\u0010A\u001a\u00020BH\u0002J\u001a\u0010L\u001a\u00020@2\b\b\u0002\u0010M\u001a\u00020\u00012\b\b\u0002\u0010N\u001a\u00020\u0001J\u0006\u0010O\u001a\u00020@J\b\u0010P\u001a\u00020@H\u0016J\u0010\u0010Q\u001a\u00020@2\u0006\u0010R\u001a\u00020KH\u0016J4\u0010S\u001a\u00020@2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020V0U2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2\u0012\b\u0002\u0010X\u001a\f\u0012\u0004\u0012\u00020Y0Uj\u0002`ZJ$\u0010[\u001a\u00020@2\u0006\u0010\\\u001a\u00020V2\u0012\b\u0002\u0010X\u001a\f\u0012\u0004\u0012\u00020Y0Uj\u0002`ZH\u0002J\b\u0010]\u001a\u00020@H\u0002J\b\u0010^\u001a\u00020@H\u0016J\b\u0010_\u001a\u00020@H\u0014J\b\u0010`\u001a\u00020@H\u0002J\b\u0010a\u001a\u00020@H\u0002J\u0010\u0010b\u001a\u00020@2\u0006\u0010c\u001a\u00020\u0004H\u0002J\u001f\u0010d\u001a\u00020@2\u0006\u0010c\u001a\u00020K2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010f\u00a2\u0006\u0002\u0010gJ\u001a\u0010h\u001a\u00020@2\b\b\u0002\u0010i\u001a\u00020\n2\b\b\u0002\u0010j\u001a\u00020\nJ\u000e\u0010k\u001a\u00020@2\u0006\u0010c\u001a\u00020KJ\u0012\u0010l\u001a\u00020@2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010KJ$\u0010m\u001a\u00020$2\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020K2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020@0rJ\b\u0010s\u001a\u00020\nH\u0002J\b\u0010t\u001a\u00020@H\u0002J\u0018\u0010u\u001a\u00020@2\u0010\u0010v\u001a\f\u0012\u0004\u0012\u00020w0Uj\u0002`xJ\u001d\u0010y\u001a\n z*\u0004\u0018\u00010K0K2\u0006\u0010{\u001a\u00020fH\u0002\u00a2\u0006\u0002\u0010|J\b\u0010}\u001a\u00020~H\u0002J\u0006\u0010\u007f\u001a\u00020@R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u001aR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u00020\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00108\u00a8\u0006\u0080\u0001"}, d2={"Lcom/github/copilot/chat/message/MessageComponent;", "Ljavax/swing/JPanel;", "Lcom/github/copilot/chat/message/UpdatableComponent;", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "conversationService", "Lcom/github/copilot/chat/conversation/ConversationService;", "project", "Lcom/intellij/openapi/project/Project;", "first", "", "isPanelView", "separatorColor", "Lcom/intellij/ui/JBColor;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "locale", "Ljava/util/Locale;", "<init>", "(Lcom/github/copilot/chat/message/ChatMessage;Lcom/github/copilot/chat/conversation/ConversationService;Lcom/intellij/openapi/project/Project;ZZLcom/intellij/ui/JBColor;Lcom/github/copilot/platform/utils/observability/Logger;Ljava/util/Locale;)V", "getChatMessage", "()Lcom/github/copilot/chat/message/ChatMessage;", "getConversationService", "()Lcom/github/copilot/chat/conversation/ConversationService;", "getProject", "()Lcom/intellij/openapi/project/Project;", "()Z", "getLog", "()Lcom/github/copilot/platform/utils/observability/Logger;", "retryMessageAction", "Lcom/github/copilot/chat/message/RetryMessage;", "getRetryMessageAction", "()Lcom/github/copilot/chat/message/RetryMessage;", "setRetryMessageAction", "(Lcom/github/copilot/chat/message/RetryMessage;)V", "combinedActionPanel", "Ljavax/swing/JComponent;", "getCombinedActionPanel", "()Ljavax/swing/JComponent;", "setCombinedActionPanel", "(Ljavax/swing/JComponent;)V", "contentPanel", "userPanel", "userPanelConstraints", "Ljava/awt/GridBagConstraints;", "topLinePanel", "emptyPanelConstraints", "combinedActionPanelConstraints", "stepPanel", "Lcom/github/copilot/chat/message/StepPanelComponent;", "getStepPanel", "()Lcom/github/copilot/chat/message/StepPanelComponent;", "messageContentPanel", "Lcom/github/copilot/chat/message/MessageContentPanel;", "messageCenterContent", "getMessageCenterContent", "()Ljavax/swing/JPanel;", "setMessageCenterContent", "(Ljavax/swing/JPanel;)V", "messagePanel", "getMessagePanel", "getPreferredSize", "Ljava/awt/Dimension;", "addConfirmationDialog", "", "confirmationRequest", "Lcom/github/copilot/chat/conversation/agent/rpc/ConfirmationRequest;", "answered", "addMessageNotification", "chatNotification", "Lcom/github/copilot/chat/conversation/agent/rpc/ChatNotification;", "addMessageNotificationComponent", "component", "confirm", "state", "", "replaceActionPanels", "actionPanel", "developerActionPanel", "forceRefreshTopPanel", "updateActions", "updateContent", "content", "insertNewComponents", "newPartials", "", "Lcom/github/copilot/chat/formatting/Markdown$MarkdownPartial;", "lastPartial", "annotations", "Lcom/github/copilot/chat/conversation/agent/rpc/ChatAnnotation;", "Lcom/github/copilot/chat/conversation/agent/rpc/ChatAnnotations;", "updateLastComponent", "markdownPartial", "refreshHtmlWithTheme", "noMoreUpdates", "onNoMoreUpdates", "removeTopMarginFromFirstCodeBlock", "removeMarginFromCodeBlock", "setOk", "message", "setError", "code", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "setUnexpectedError", "hideSteps", "hideActionPanel", "setFilter", "setCancelled", "setAuthorizationRequired", "agent", "Lcom/github/copilot/chat/agent/RemoteAgent;", "authUri", "resendQuestion", "Lkotlin/Function0;", "isInitialMessage", "clearSouth", "setReferences", "references", "Lcom/github/copilot/chat/message/references/ChatReference;", "Lcom/github/copilot/chat/message/references/ChatReferences;", "referencesLabel", "kotlin.jvm.PlatformType", "numReferences", "(I)Ljava/lang/String;", "diffContent", "Lcom/github/copilot/chat/message/DiffContentResult;", "retry", "core"})
@SourceDebugExtension(value={"SMAP\nMessageComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageComponent.kt\ncom/github/copilot/chat/message/MessageComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,641:1\n1#2:642\n1855#3,2:643\n1855#3,2:646\n1855#3,2:650\n1855#3:652\n1855#3,2:653\n1856#3:655\n1855#3,2:656\n39#4:645\n13579#5,2:648\n*S KotlinDebug\n*F\n+ 1 MessageComponent.kt\ncom/github/copilot/chat/message/MessageComponent\n*L\n209#1:643,2\n324#1:646,2\n415#1:650,2\n430#1:652\n434#1:653,2\n430#1:655\n443#1:656,2\n59#1:645\n363#1:648,2\n*E\n"})
public class MessageComponent
extends JPanel
implements UpdatableComponent {
    @NotNull
    private final ChatMessage chatMessage;
    @NotNull
    private final ConversationService conversationService;
    @NotNull
    private final Project project;
    private final boolean isPanelView;
    @NotNull
    private final Logger log;
    @NotNull
    private final Locale locale;
    @NotNull
    private RetryMessage retryMessageAction;
    @NotNull
    private JComponent combinedActionPanel;
    @NotNull
    private final JComponent contentPanel;
    @NotNull
    private final JPanel userPanel;
    @NotNull
    private final GridBagConstraints userPanelConstraints;
    @NotNull
    private final JPanel topLinePanel;
    @NotNull
    private final GridBagConstraints emptyPanelConstraints;
    @NotNull
    private final GridBagConstraints combinedActionPanelConstraints;
    @NotNull
    private final StepPanelComponent stepPanel;
    @NotNull
    private MessageContentPanel messageContentPanel;
    @NotNull
    private JPanel messageCenterContent;
    @NotNull
    private final JPanel messagePanel;

    /*
     * WARNING - void declaration
     */
    public MessageComponent(@NotNull ChatMessage chatMessage, @NotNull ConversationService conversationService, @NotNull Project project, boolean first, boolean isPanelView, @NotNull JBColor separatorColor, @NotNull Logger log, @NotNull Locale locale) {
        void $this$_init__u24lambda_u2417;
        Serializable $this$messagePanel_u24lambda_u2416;
        Serializable $this$messageCenterContent_u24lambda_u2415;
        Serializable $this$stepPanel_u24lambda_u2414;
        Serializable $this$topLinePanel_u24lambda_u2411;
        Serializable $this$userPanel_u24lambda_u249;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)conversationService, (String)"conversationService");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)separatorColor, (String)"separatorColor");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.chatMessage = chatMessage;
        this.conversationService = conversationService;
        this.project = project;
        this.isPanelView = isPanelView;
        this.log = log;
        this.locale = locale;
        this.retryMessageAction = MessageComponent::retryMessageAction$lambda$0;
        this.combinedActionPanel = JComponentKt.opaque(new JPanel(), false);
        this.contentPanel = JComponentKt.opaque(new JPanel(new BorderLayout()), false);
        JPanel jPanel = serializable = new JPanel();
        JPanel jPanel2 = this;
        boolean bl = false;
        ((JComponent)$this$userPanel_u24lambda_u249).setOpaque(false);
        ((Container)$this$userPanel_u24lambda_u249).setLayout(new BoxLayout((Container)$this$userPanel_u24lambda_u249, 0));
        GitHubUser gitHubUser = this.chatMessage.getUser();
        if (gitHubUser != null) {
            JComponent $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u246;
            JComponent $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u245;
            JComponent $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u244;
            JComponent jComponent;
            Serializable serializable2;
            Serializable serializable3;
            JComponent jComponent2;
            GitHubUser user = gitHubUser;
            boolean bl2 = false;
            RemoteAgent remoteAgent = this.chatMessage.getAgent();
            RemoteAgentAvatar agentAvatar = remoteAgent != null ? RemoteAgentKt.getAvatar(remoteAgent) : null;
            void v2 = $this$userPanel_u24lambda_u249;
            if (ChatMessageTypeKt.isResponse(this.chatMessage.getType()) && agentAvatar != null) {
                JLabel jLabel;
                GitHubUserIcon gitHubUserIcon;
                JComponent jComponent3 = jComponent2 = new JPanel();
                serializable3 = v2;
                boolean bl3 = false;
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243.setLayout(new OverlayLayout($this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243));
                GitHubUserIcon $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243_u24lambda_u241 = gitHubUserIcon = user.getIcon();
                boolean bl4 = false;
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243_u24lambda_u241.setBorder(new RoundEmptyBorder((Color)Style.Colors.INSTANCE.getSeparators(), user.getIcon().getIcon().getIconWidth(), 1, 1, 1, 1, 0));
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243_u24lambda_u241.setAlignmentX(0.9f);
                GitHubUserIcon userIcon = gitHubUserIcon;
                JLabel $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243_u24lambda_u242 = jLabel = new JLabel(agentAvatar.getSmall());
                boolean bl5 = false;
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243_u24lambda_u242.setBorder(new RoundEmptyBorder((Color)Style.Colors.INSTANCE.getSeparators(), agentAvatar.getSmall().getIconWidth(), 1, 1, 0, 1, 1));
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243_u24lambda_u242.setAlignmentX(0.0f);
                JLabel agentAvatarIcon = jLabel;
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243.add(agentAvatarIcon);
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243.add(userIcon);
                serializable2 = serializable3;
                jComponent = jComponent2;
            } else {
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u243 = jComponent2 = user.getIcon();
                serializable3 = v2;
                boolean bl6 = false;
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u244.setBorder(new RoundEmptyBorder((Color)Style.Colors.INSTANCE.getSeparators(), user.getIcon().getIcon().getIconWidth(), 1, 1, 1, 1, 1));
                serializable2 = serializable3;
                jComponent = jComponent2;
            }
            ((Container)serializable2).add(jComponent);
            $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u244 = jComponent2 = new JLabel(user.getName());
            serializable3 = $this$userPanel_u24lambda_u249;
            boolean bl7 = false;
            $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u245.setBorder(Style.Borders.INSTANCE.getUserNameBorder());
            $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u245.setFont(new FontUIResource($this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u245.getFont().getName(), 1, $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u245.getFont().getSize()));
            $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u245.addComponentListener(new ComponentAdapter((JLabel)$this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u245){
                final /* synthetic */ JLabel $this_apply;
                {
                    this.$this_apply = $receiver;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$this_apply.setFont(new FontUIResource(this.$this_apply.getFont().getName(), 1, this.$this_apply.getFont().getSize()));
                }
            });
            ((Container)serializable3).add(jComponent2);
            if (ChatMessageTypeKt.isResponse(this.chatMessage.getType()) && this.chatMessage.getAgent() != null) {
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u245 = jComponent2 = new JLabel("used " + RemoteAgentKt.getAsInput(this.chatMessage.getAgent()));
                serializable3 = $this$userPanel_u24lambda_u249;
                boolean bl8 = false;
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u246.setBorder(Style.Borders.INSTANCE.getUserNameBorder());
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u246.setForeground((Color)Style.Colors.INSTANCE.getSECONDARY_TEXT());
                ((Container)serializable3).add(jComponent2);
            }
            if (Intrinsics.areEqual((Object)this.chatMessage.getContent(), (Object)"") && this.chatMessage.getConfirmationResponse() != null) {
                void $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u247;
                ConfirmationResponse confirmationResponse = this.chatMessage.getConfirmationResponse();
                Intrinsics.checkNotNull((Object)confirmationResponse);
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u246 = jComponent2 = new JLabel(confirmationResponse.getState() + " confirmation");
                serializable3 = $this$userPanel_u24lambda_u249;
                boolean bl9 = false;
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u247.setBorder(Style.Borders.INSTANCE.getUserNameBorder());
                $this$userPanel_u24lambda_u249_u24lambda_u248_u24lambda_u247.setForeground((Color)Style.Colors.INSTANCE.getSECONDARY_TEXT());
                ((Container)serializable3).add(jComponent2);
            }
        }
        ((MessageComponent)jPanel2).userPanel = serializable;
        serializable = new GridBagConstraints();
        $this$userPanel_u24lambda_u249 = serializable;
        jPanel2 = this;
        boolean bl10 = false;
        ((GridBagConstraints)$this$userPanelConstraints_u24lambda_u2410).fill = 0;
        ((GridBagConstraints)$this$userPanelConstraints_u24lambda_u2410).anchor = 17;
        ((GridBagConstraints)$this$userPanelConstraints_u24lambda_u2410).weightx = 1.0;
        ((GridBagConstraints)$this$userPanelConstraints_u24lambda_u2410).gridwidth = 1;
        ((GridBagConstraints)$this$userPanelConstraints_u24lambda_u2410).gridx = 0;
        ((GridBagConstraints)$this$userPanelConstraints_u24lambda_u2410).gridy = 0;
        ((GridBagConstraints)$this$userPanelConstraints_u24lambda_u2410).ipadx = 5;
        ((MessageComponent)jPanel2).userPanelConstraints = serializable;
        serializable = new JPanel(new GridBagLayout());
        Serializable $this$userPanelConstraints_u24lambda_u2410 = serializable;
        jPanel2 = this;
        boolean bl11 = false;
        $this$topLinePanel_u24lambda_u2411.add(this.userPanel, this.userPanelConstraints);
        $this$topLinePanel_u24lambda_u2411.setBorder(Style.Borders.INSTANCE.getMessageHeaderBorder());
        $this$topLinePanel_u24lambda_u2411.setOpaque(false);
        ((MessageComponent)jPanel2).topLinePanel = serializable;
        $this$topLinePanel_u24lambda_u2411 = serializable = new GridBagConstraints();
        jPanel2 = this;
        boolean bl12 = false;
        ((GridBagConstraints)$this$emptyPanelConstraints_u24lambda_u2412).fill = 0;
        ((GridBagConstraints)$this$emptyPanelConstraints_u24lambda_u2412).anchor = 13;
        ((GridBagConstraints)$this$emptyPanelConstraints_u24lambda_u2412).weightx = 1.0;
        ((GridBagConstraints)$this$emptyPanelConstraints_u24lambda_u2412).gridwidth = 1;
        ((GridBagConstraints)$this$emptyPanelConstraints_u24lambda_u2412).gridx = 1;
        ((GridBagConstraints)$this$emptyPanelConstraints_u24lambda_u2412).gridy = 0;
        ((MessageComponent)jPanel2).emptyPanelConstraints = serializable;
        Serializable $this$emptyPanelConstraints_u24lambda_u2412 = serializable = new GridBagConstraints();
        jPanel2 = this;
        boolean bl13 = false;
        ((GridBagConstraints)$this$combinedActionPanelConstraints_u24lambda_u2413).fill = 0;
        ((GridBagConstraints)$this$combinedActionPanelConstraints_u24lambda_u2413).anchor = 13;
        ((GridBagConstraints)$this$combinedActionPanelConstraints_u24lambda_u2413).weightx = 1.0;
        ((GridBagConstraints)$this$combinedActionPanelConstraints_u24lambda_u2413).gridwidth = 1;
        ((GridBagConstraints)$this$combinedActionPanelConstraints_u24lambda_u2413).gridx = 2;
        ((GridBagConstraints)$this$combinedActionPanelConstraints_u24lambda_u2413).gridy = 0;
        ((GridBagConstraints)$this$combinedActionPanelConstraints_u24lambda_u2413).ipadx = 5;
        ((MessageComponent)jPanel2).combinedActionPanelConstraints = serializable;
        Serializable $this$combinedActionPanelConstraints_u24lambda_u2413 = serializable = new StepPanelComponent(CollectionsKt.toMutableList(this.chatMessage.getSteps().values()));
        jPanel2 = this;
        boolean bl14 = false;
        $this$stepPanel_u24lambda_u2414.setVisible(false);
        ((MessageComponent)jPanel2).stepPanel = serializable;
        this.messageContentPanel = new MessageContentPanel();
        $this$stepPanel_u24lambda_u2414 = serializable = new JPanel(new BorderLayout());
        jPanel2 = this;
        boolean bl15 = false;
        $this$messageCenterContent_u24lambda_u2415.setOpaque(false);
        $this$messageCenterContent_u24lambda_u2415.add(this.messageContentPanel, "Center");
        ((MessageComponent)jPanel2).messageCenterContent = serializable;
        $this$messageCenterContent_u24lambda_u2415 = serializable = new JPanel(new BorderLayout());
        jPanel2 = this;
        boolean bl16 = false;
        $this$messagePanel_u24lambda_u2416.setOpaque(false);
        $this$messagePanel_u24lambda_u2416.add(this.stepPanel, "North");
        $this$messagePanel_u24lambda_u2416.add(this.messageCenterContent, "Center");
        ((MessageComponent)jPanel2).messagePanel = serializable;
        this.setLayout(new BorderLayout());
        switch (WhenMappings.$EnumSwitchMapping$0[this.chatMessage.getStatus().ordinal()]) {
            case 1: {
                this.setOk(this.chatMessage);
                break;
            }
            case 2: {
                this.setError(this.chatMessage.getContent(), this.chatMessage.getErrorCode());
                break;
            }
            case 3: {
                this.setFilter(this.chatMessage.getContent());
                break;
            }
            case 4: {
                this.setCancelled(this.chatMessage.getContent());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$messagePanel_u24lambda_u2416 = serializable = new JPanel();
        jPanel2 = this.topLinePanel;
        boolean bl17 = false;
        $this$_init__u24lambda_u2417.setOpaque(false);
        jPanel2.add((Component)serializable, this.emptyPanelConstraints);
        this.contentPanel.add((Component)this.topLinePanel, "North");
        this.contentPanel.add((Component)this.messagePanel, "Center");
        this.add(this.contentPanel);
        this.setBorder(this.chatMessage.getConfirmationResponse() != null ? Style.Borders.INSTANCE.messageBorder(separatorColor, 0) : (!this.isPanelView ? BorderFactory.createEmptyBorder() : (!first ? Style.Borders.messageBorder$default(Style.Borders.INSTANCE, separatorColor, 0, 2, null) : Style.Borders.INSTANCE.getTopMessageBorder())));
        ConfirmationRequest confirmationRequest = this.chatMessage.getConfirmationRequest();
        if (confirmationRequest != null) {
            ConfirmationRequest it = confirmationRequest;
            boolean bl18 = false;
            this.addConfirmationDialog(it, true);
        }
        Iterable $this$forEach$iv = this.chatMessage.getNotifications();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatNotification notification = (ChatNotification)element$iv;
            boolean bl19 = false;
            this.addMessageNotification(notification);
        }
        MessageBusConnection messageBusConnection = ApplicationKt.getApplication().getMessageBus().connect((Disposable)this.conversationService.getSessionController().getSession());
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> MessageComponent._init_$lambda$20(this, arg_0));
    }

    public /* synthetic */ MessageComponent(ChatMessage chatMessage, ConversationService conversationService, Project project, boolean bl, boolean bl2, JBColor jBColor, Logger logger, Locale locale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            jBColor = Style.Colors.INSTANCE.getSeparators();
        }
        if ((n & 0x40) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(MessageComponent.class);
        }
        if ((n & 0x80) != 0) {
            String string = CopilotApplicationSettings.settings().chatNaturalLanguage;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chatNaturalLanguage");
            locale = CopilotChatLocale.INSTANCE.getLocaleByLanguageName(string);
        }
        this(chatMessage, conversationService, project, bl, bl2, jBColor, logger, locale);
    }

    @NotNull
    public final ChatMessage getChatMessage() {
        return this.chatMessage;
    }

    @NotNull
    public final ConversationService getConversationService() {
        return this.conversationService;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isPanelView() {
        return this.isPanelView;
    }

    @NotNull
    protected final Logger getLog() {
        return this.log;
    }

    @NotNull
    protected final RetryMessage getRetryMessageAction() {
        return this.retryMessageAction;
    }

    protected final void setRetryMessageAction(@NotNull RetryMessage retryMessage) {
        Intrinsics.checkNotNullParameter((Object)retryMessage, (String)"<set-?>");
        this.retryMessageAction = retryMessage;
    }

    @NotNull
    protected final JComponent getCombinedActionPanel() {
        return this.combinedActionPanel;
    }

    protected final void setCombinedActionPanel(@NotNull JComponent jComponent) {
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"<set-?>");
        this.combinedActionPanel = jComponent;
    }

    @NotNull
    public final StepPanelComponent getStepPanel() {
        return this.stepPanel;
    }

    @NotNull
    protected final JPanel getMessageCenterContent() {
        return this.messageCenterContent;
    }

    protected final void setMessageCenterContent(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.messageCenterContent = jPanel;
    }

    @NotNull
    protected final JPanel getMessagePanel() {
        return this.messagePanel;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(UiSizeUtilKt.getPreferredWidth((JComponent)this.topLinePanel), super.getPreferredSize().height);
    }

    /*
     * WARNING - void declaration
     */
    public final void addConfirmationDialog(@NotNull ConfirmationRequest confirmationRequest, boolean answered) {
        void $this$addConfirmationDialog_u24lambda_u2423;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)confirmationRequest, (String)"confirmationRequest");
        JPanel jPanel2 = jPanel = new JPanel();
        MessageComponent messageComponent = this;
        boolean bl = false;
        $this$addConfirmationDialog_u24lambda_u2423.setLayout(new BorderLayout());
        $this$addConfirmationDialog_u24lambda_u2423.add((Component)new ConfirmationPanel(confirmationRequest, (Function0<Unit>)((Function0)() -> MessageComponent.addConfirmationDialog$lambda$23$lambda$21(this, confirmationRequest)), (Function0<Unit>)((Function0)() -> MessageComponent.addConfirmationDialog$lambda$23$lambda$22(this, confirmationRequest)), answered), "Center");
        messageComponent.addMessageNotificationComponent(jPanel);
    }

    public static /* synthetic */ void addConfirmationDialog$default(MessageComponent messageComponent, ConfirmationRequest confirmationRequest, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addConfirmationDialog");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        messageComponent.addConfirmationDialog(confirmationRequest, bl);
    }

    public final void addMessageNotification(@NotNull ChatNotification chatNotification) {
        Intrinsics.checkNotNullParameter((Object)chatNotification, (String)"chatNotification");
        NotificationStyle style = NotificationStyle.Companion.fromString(chatNotification.getSeverity());
        this.addMessageNotificationComponent(new MessageNotificationPanel(style, chatNotification.getMessage()));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMessageNotificationComponent(JComponent component2) {
        JPanel $this$addMessageNotificationComponent_u24lambda_u2424;
        JComponent jComponent;
        LayoutManager layoutManager = this.messageCenterContent.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
        JPanel northComponent = (JPanel)((BorderLayout)layoutManager).getLayoutComponent("North");
        if (northComponent == null) {
            $this$addMessageNotificationComponent_u24lambda_u2424 = jComponent = new JPanel((LayoutManager)new VerticalLayout());
            boolean bl = false;
            $this$addMessageNotificationComponent_u24lambda_u2424.setBorder(BorderFactory.createEmptyBorder(0, 8, 12, 8));
            northComponent = jComponent;
            this.messageCenterContent.add((Component)northComponent, "North");
        }
        Component[] componentArray = northComponent.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        if (ArraysKt.lastOrNull((Object[])componentArray) instanceof MessageNotificationPanel) {
            void $this$addMessageNotificationComponent_u24lambda_u2425;
            $this$addMessageNotificationComponent_u24lambda_u2424 = jComponent = new JLabel();
            JPanel jPanel = northComponent;
            boolean bl = false;
            $this$addMessageNotificationComponent_u24lambda_u2425.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            jPanel.add(jComponent);
        }
        northComponent.add(component2);
    }

    private final void confirm(String state, ConfirmationRequest confirmationRequest) {
        UserMessageListener.Companion.onUserMessage("", this.conversationService.getSessionController().getSession(), null, new ConfirmationResponse(confirmationRequest.getAgentSlug(), state, confirmationRequest.getConfirmation()), null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void replaceActionPanels(@NotNull JPanel actionPanel, @NotNull JPanel developerActionPanel) {
        void $this$replaceActionPanels_u24lambda_u2427;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)actionPanel, (String)"actionPanel");
        Intrinsics.checkNotNullParameter((Object)developerActionPanel, (String)"developerActionPanel");
        JComponentKt.opaque(actionPanel, false);
        JComponentKt.opaque(developerActionPanel, false);
        JPanel jPanel2 = jPanel = new JPanel(new FlowLayout(0, 5, 0));
        MessageComponent messageComponent = this;
        boolean bl = false;
        $this$replaceActionPanels_u24lambda_u2427.setOpaque(false);
        if (Configuration.isChatDebugToolsEnabled$default(Configuration.INSTANCE, false, 1, null)) {
            Component[] componentArray = developerActionPanel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            if (!(((Object[])componentArray).length == 0)) {
                void $this$replaceActionPanels_u24lambda_u2427_u24lambda_u2426;
                JPanel jPanel3;
                JPanel jPanel4 = jPanel3 = developerActionPanel;
                void var8_9 = $this$replaceActionPanels_u24lambda_u2427;
                boolean bl2 = false;
                $this$replaceActionPanels_u24lambda_u2427_u24lambda_u2426.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, JBColor.background().brighter()), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
                var8_9.add(jPanel3);
            }
        }
        $this$replaceActionPanels_u24lambda_u2427.add(actionPanel);
        messageComponent.combinedActionPanel = jPanel;
        this.topLinePanel.add((Component)this.combinedActionPanel, this.combinedActionPanelConstraints);
    }

    public static /* synthetic */ void replaceActionPanels$default(MessageComponent messageComponent, JPanel jPanel, JPanel jPanel2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: replaceActionPanels");
        }
        if ((n & 1) != 0) {
            jPanel = new JPanel();
        }
        if ((n & 2) != 0) {
            jPanel2 = new JPanel();
        }
        messageComponent.replaceActionPanels(jPanel, jPanel2);
    }

    public final void forceRefreshTopPanel() {
        ApplicationManager.getApplication().invokeLater(() -> MessageComponent.forceRefreshTopPanel$lambda$28(this));
    }

    public void updateActions() {
    }

    @Override
    public void updateContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (((CharSequence)this.chatMessage.getContent()).length() == 0) {
            this.stepPanel.makeCollapsible(true);
            this.stepPanel.hideContent();
        }
        int previousOffset = this.chatMessage.getContent().length();
        ChatMessage chatMessage = this.chatMessage;
        chatMessage.setContent(chatMessage.getContent() + content);
        int newOffset = this.chatMessage.getContent().length();
        List<ChatAnnotation> annotations = MessageComponentKt.overlappingAnnotations(this.chatMessage.getAnnotations(), previousOffset, newOffset);
        DiffContentResult diffContentResult = this.diffContent();
        if (diffContentResult instanceof DiffContentResult.Update) {
            this.updateLastComponent(((DiffContentResult.Update)diffContentResult).getMarkdownPartial(), annotations);
        } else if (diffContentResult instanceof DiffContentResult.Insert) {
            this.insertNewComponents(((DiffContentResult.Insert)diffContentResult).getNewPartials(), ((DiffContentResult.Insert)diffContentResult).getLastPartial(), annotations);
        } else if (diffContentResult instanceof DiffContentResult.NoUpdate) {
            this.log.trace("No update needed");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.revalidate();
        this.repaint();
    }

    public final void insertNewComponents(@NotNull List<Markdown.MarkdownPartial> newPartials, @Nullable Markdown.MarkdownPartial lastPartial, @NotNull List<ChatAnnotation> annotations) {
        Intrinsics.checkNotNullParameter(newPartials, (String)"newPartials");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        if (lastPartial != null) {
            MessageComponent.updateLastComponent$default(this, lastPartial, null, 2, null);
        }
        Iterable $this$forEach$iv = newPartials;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Markdown.MarkdownPartial newPartial = (Markdown.MarkdownPartial)element$iv;
            boolean bl = false;
            HtmlContentComponent newComponent = switch (WhenMappings.$EnumSwitchMapping$1[newPartial.getType().ordinal()]) {
                case 1 -> new HtmlContentComponent(() -> MessageComponent.insertNewComponents$lambda$31$lambda$29(newPartial), null, this.locale, 2, null);
                case 2 -> {
                    CodeBlockContainer var10_10;
                    CodeBlockContainer $this$insertNewComponents_u24lambda_u2431_u24lambda_u2430 = var10_10 = new CodeBlockContainer(newPartial, this.project, newPartial.getIndex(), this.chatMessage, this.conversationService);
                    boolean $i$a$-apply-MessageComponent$insertNewComponents$1$newComponent$2 = false;
                    if (!((Collection)annotations).isEmpty()) {
                        $this$insertNewComponents_u24lambda_u2431_u24lambda_u2430.setCodeBlockBanners(annotations);
                    }
                    yield var10_10;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            this.messageContentPanel.add(newComponent);
            if (this.chatMessage.getActionPanel() != null) {
                this.messageContentPanel.add(this.chatMessage.getActionPanel());
            }
            this.removeTopMarginFromFirstCodeBlock();
        }
    }

    public static /* synthetic */ void insertNewComponents$default(MessageComponent messageComponent, List list, Markdown.MarkdownPartial markdownPartial, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: insertNewComponents");
        }
        if ((n & 2) != 0) {
            markdownPartial = null;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        messageComponent.insertNewComponents(list, markdownPartial, list2);
    }

    private final void updateLastComponent(Markdown.MarkdownPartial markdownPartial, List<ChatAnnotation> annotations) {
        Component[] componentArray = this.messageContentPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        if (((Object[])componentArray).length == 0 || this.project.isDisposed()) {
            return;
        }
        Component lastComponent = this.messageContentPanel.getComponents()[this.messageContentPanel.getComponents().length - 1];
        if (lastComponent instanceof HtmlContentComponent) {
            ((HtmlContentComponent)lastComponent).setHtmlSupplier((Function0<String>)((Function0)() -> MessageComponent.updateLastComponent$lambda$32(markdownPartial)));
            ((HtmlContentComponent)lastComponent).refresh();
        } else if (lastComponent instanceof CodeBlockContainer) {
            ((CodeBlockContainer)lastComponent).getCodeBlockPanel().getCodeBlock().getEditorTextField().setText(markdownPartial.getContent());
            ((CodeBlockContainer)lastComponent).getCodeBlockPanel().getCodeBlock().getEditorTextField().revalidate();
            ((CodeBlockContainer)lastComponent).getCodeBlockPanel().getCodeBlock().getEditorTextField().repaint();
            if (!((Collection)annotations).isEmpty()) {
                ((CodeBlockContainer)lastComponent).setCodeBlockBanners(annotations);
            }
        }
    }

    static /* synthetic */ void updateLastComponent$default(MessageComponent messageComponent, Markdown.MarkdownPartial markdownPartial, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateLastComponent");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        messageComponent.updateLastComponent(markdownPartial, list);
    }

    private final void refreshHtmlWithTheme() {
        Component[] componentArray = this.messageContentPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            if (!(it instanceof HtmlContentComponent)) continue;
            ((HtmlContentComponent)it).refresh();
        }
    }

    @Override
    public void noMoreUpdates() {
        this.updateContent("");
        Iterator iterator = ArrayIteratorKt.iterator((Object[])this.messageContentPanel.getComponents());
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            if (!(component2 instanceof CodeBlockContainer) || ((CodeBlockContainer)component2).getCodeBlockPanel().getControlPanel().isEnabled()) continue;
            ((CodeBlockContainer)component2).getCodeBlockPanel().getControlPanel().setEnabled(true);
        }
        this.removeMarginFromCodeBlock();
        JComponentKt.update(this);
        this.onNoMoreUpdates();
    }

    protected void onNoMoreUpdates() {
    }

    private final void removeTopMarginFromFirstCodeBlock() {
        Component firstComponent;
        if (this.messageContentPanel.getComponents().length == 1 && (firstComponent = this.messageContentPanel.getComponents()[0]) instanceof CodeBlockContainer) {
            ((CodeBlockContainer)firstComponent).noTopBorder();
        }
    }

    private final void removeMarginFromCodeBlock() {
        Component[] componentArray = this.messageContentPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        if (!(((Object[])componentArray).length == 0)) {
            Component[] componentArray2 = this.messageContentPanel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray2, (String)"getComponents(...)");
            Component lastComponent = (Component)ArraysKt.last((Object[])componentArray2);
            if (lastComponent instanceof CodeBlockContainer) {
                if (Intrinsics.areEqual((Object)((CodeBlockContainer)lastComponent).getBorder(), (Object)Style.Borders.INSTANCE.getCodeBlockOuterBorderFirst())) {
                    ((CodeBlockContainer)lastComponent).noVerticalBorders();
                } else {
                    ((CodeBlockContainer)lastComponent).noBottomBorder();
                }
            }
        }
    }

    private final void setOk(ChatMessage message) {
        Map annotations = new LinkedHashMap();
        Iterable $this$forEach$iv = message.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list;
            ChatAnnotation annotation = (ChatAnnotation)element$iv;
            boolean bl = false;
            AnnotationOffset offset = new AnnotationOffset(annotation.getStartOffset(), annotation.getStopOffset());
            Map map = annotations;
            List list2 = (List)annotations.get(offset);
            if (list2 == null) {
                list2 = new ArrayList();
            }
            List $this$setOk_u24lambda_u2435_u24lambda_u2434 = list = list2;
            boolean bl2 = false;
            $this$setOk_u24lambda_u2435_u24lambda_u2434.add(annotation);
            map.put(offset, list);
        }
        List<Markdown.MarkdownPartial> partialOffsets = Markdown.INSTANCE.decomposeASTtoPartialOffsets(message.getContent());
        if (annotations.isEmpty()) {
            MessageComponent.insertNewComponents$default(this, partialOffsets, null, null, 6, null);
        } else {
            List newComponents = new ArrayList();
            PartialOffsetsWithAnnotations partialOffsetsWithAnnotations = null;
            partialOffsetsWithAnnotations = new PartialOffsetsWithAnnotations(null, null, 3, null);
            Iterable $this$forEach$iv2 = partialOffsets;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Markdown.MarkdownPartial partialOffset = (Markdown.MarkdownPartial)element$iv;
                boolean bl = false;
                partialOffsetsWithAnnotations.addPartial(partialOffset);
                Iterable $this$forEach$iv3 = annotations.keySet();
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    AnnotationOffset annotationOffset = (AnnotationOffset)element$iv2;
                    boolean bl3 = false;
                    if (annotationOffset.getEnd() >= partialOffset.getStart() && (annotationOffset.getEnd() <= partialOffset.getEnd() || Intrinsics.areEqual((Object)partialOffset, (Object)CollectionsKt.last(partialOffsets)))) {
                        partialOffsetsWithAnnotations.addAnnotations((List)annotations.get(annotationOffset));
                    }
                    newComponents.add(partialOffsetsWithAnnotations);
                    partialOffsetsWithAnnotations = new PartialOffsetsWithAnnotations(null, null, 3, null);
                }
            }
            $this$forEach$iv2 = newComponents;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                PartialOffsetsWithAnnotations it = (PartialOffsetsWithAnnotations)element$iv;
                boolean bl = false;
                MessageComponent.insertNewComponents$default(this, it.getPartials(), null, it.getAnnotations(), 2, null);
            }
        }
    }

    public final void setError(@NotNull String message, @Nullable Integer code) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Integer n = code;
        int n2 = 402;
        if (n != null && n == n2) {
            v1 = this.messageContentPanel.add(new UpgradeNotificationComponent(message));
        } else if (StringsKt.contains$default((CharSequence)message, (CharSequence)"the model is not supported", (boolean)false, (int)2, null)) {
            String model = "claude-3.5-sonnet";
            v1 = this.messageContentPanel.add(new ModelPolicyNotificationComponent(this, model));
        } else {
            v1 = this.messageContentPanel.add(new NotificationComponent(message, NotificationType.ERROR));
        }
    }

    public static /* synthetic */ void setError$default(MessageComponent messageComponent, String string, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setError");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        messageComponent.setError(string, n);
    }

    public final void setUnexpectedError(boolean hideSteps, boolean hideActionPanel) {
        if (hideSteps) {
            this.messagePanel.remove(this.stepPanel);
        }
        if (hideActionPanel) {
            this.topLinePanel.remove(this.combinedActionPanel);
        }
        MessageComponent.setError$default(this, CopilotBundleEx.Chat.INSTANCE.getError(), null, 2, null);
        JComponentKt.update(this);
    }

    public static /* synthetic */ void setUnexpectedError$default(MessageComponent messageComponent, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setUnexpectedError");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        messageComponent.setUnexpectedError(bl, bl2);
    }

    public final void setFilter(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.setFocusable(false);
        FocusManager.getCurrentManager().focusNextComponent();
        ApplicationManager.getApplication().invokeLater(() -> MessageComponent.setFilter$lambda$39(this, message));
    }

    /*
     * WARNING - void declaration
     */
    public final void setCancelled(@Nullable String message) {
        void $this$setCancelled_u24lambda_u2440;
        NotificationComponent notificationComponent;
        if (this.isInitialMessage()) {
            this.chatMessage.setContent("");
            this.messageContentPanel.removeAll();
            this.messageContentPanel.revalidate();
            this.messageContentPanel.repaint();
        }
        this.chatMessage.setStatus(ChatMessageStatus.CANCELLED);
        if (message != null) {
            MessageComponent.insertNewComponents$default(this, Markdown.INSTANCE.decomposeASTtoPartialOffsets(message), null, null, 6, null);
        }
        this.removeMarginFromCodeBlock();
        String string = CopilotBundle.get("copilot.chat.message.cancelled.text");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        NotificationComponent notificationComponent2 = notificationComponent = new NotificationComponent(string, NotificationType.INFO);
        MessageContentPanel messageContentPanel = this.messageContentPanel;
        boolean bl = false;
        Component[] componentArray = this.messageContentPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        $this$setCancelled_u24lambda_u2440.setBorder(((Object[])componentArray).length == 0 ? Style.Borders.INSTANCE.getNotificationBelowEmptyMessageBorder() : Style.Borders.INSTANCE.getNotificationBelowContentBorder());
        messageContentPanel.add((Component)notificationComponent, "South");
        this.messageContentPanel.revalidate();
        this.messageContentPanel.repaint();
    }

    public static /* synthetic */ void setCancelled$default(MessageComponent messageComponent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setCancelled");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        messageComponent.setCancelled(string);
    }

    @NotNull
    public final JComponent setAuthorizationRequired(@NotNull RemoteAgent agent, @NotNull String authUri, @NotNull Function0<Unit> resendQuestion) {
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)authUri, (String)"authUri");
        Intrinsics.checkNotNullParameter(resendQuestion, (String)"resendQuestion");
        MessageContentPanel $this$setAuthorizationRequired_u24lambda_u2441 = this.messageContentPanel;
        boolean bl = false;
        this.messagePanel.remove(this.stepPanel);
        this.topLinePanel.remove(this.combinedActionPanel);
        $this$setAuthorizationRequired_u24lambda_u2441.add(new RemoteAgentAuthPanel(agent, authUri, resendQuestion));
        return JComponentKt.update($this$setAuthorizationRequired_u24lambda_u2441);
    }

    private final boolean isInitialMessage() {
        Component[] componentArray = this.messageContentPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        return ((Object[])componentArray).length == 0;
    }

    private final void clearSouth() {
        LayoutManager layoutManager = this.contentPanel.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
        BorderLayout layout = (BorderLayout)layoutManager;
        Component southComponent = layout.getLayoutComponent("South");
        if (southComponent != null) {
            this.contentPanel.remove(southComponent);
        }
    }

    public final void setReferences(@NotNull List<? extends ChatReference> references) {
        CollapsiblePanel collapsiblePanel;
        Intrinsics.checkNotNullParameter(references, (String)"references");
        if (references.isEmpty()) {
            return;
        }
        String string = this.referencesLabel(references.size());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"referencesLabel(...)");
        CollapsiblePanel $this$setReferences_u24lambda_u2442 = collapsiblePanel = new CollapsiblePanel(string, false, 2, null);
        boolean bl = false;
        $this$setReferences_u24lambda_u2442.setBorder(Style.Borders.INSTANCE.getReferencesCollapsiblePanelBorder());
        $this$setReferences_u24lambda_u2442.addContent(new ChatReferencesListPanel(this.project, references));
        CollapsiblePanel panel = collapsiblePanel;
        this.messagePanel.add((Component)panel, "South");
    }

    private final String referencesLabel(int numReferences) {
        String string;
        if (numReferences == 1) {
            Object[] objectArray = new Object[]{numReferences};
            string = CopilotBundle.get("copilot.chat.message.references.singular.text", objectArray);
        } else {
            Object[] objectArray = new Object[]{numReferences};
            string = CopilotBundle.get("copilot.chat.message.references.plural.text", objectArray);
        }
        return string;
    }

    private final DiffContentResult diffContent() {
        DiffContentResult diffContentResult;
        List<Markdown.MarkdownPartial> partials = Markdown.INSTANCE.decomposeASTtoPartialOffsets(this.chatMessage.getContent());
        int contentComponentsCount = this.messageContentPanel.getComponents().length;
        if (partials.size() > contentComponentsCount) {
            int numberOfNewComponents = partials.size() - contentComponentsCount;
            List<Markdown.MarkdownPartial> newPartials = partials.subList(partials.size() - numberOfNewComponents, partials.size());
            diffContentResult = partials.size() > numberOfNewComponents ? new DiffContentResult.Insert(newPartials, (Markdown.MarkdownPartial)CollectionsKt.getOrNull(partials, (int)(partials.size() - (numberOfNewComponents + 1)))) : new DiffContentResult.Insert(newPartials, null, 2, null);
        } else {
            diffContentResult = partials.isEmpty() ? (DiffContentResult)DiffContentResult.NoUpdate.INSTANCE : (DiffContentResult)new DiffContentResult.Update((Markdown.MarkdownPartial)CollectionsKt.last(partials));
        }
        return diffContentResult;
    }

    public final void retry() {
        this.retryMessageAction.retry(this);
    }

    private static final void retryMessageAction$lambda$0(MessageComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void _init_$lambda$20(MessageComponent this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.refreshHtmlWithTheme();
    }

    private static final Unit addConfirmationDialog$lambda$23$lambda$21(MessageComponent this$0, ConfirmationRequest $confirmationRequest) {
        this$0.confirm("accepted", $confirmationRequest);
        return Unit.INSTANCE;
    }

    private static final Unit addConfirmationDialog$lambda$23$lambda$22(MessageComponent this$0, ConfirmationRequest $confirmationRequest) {
        this$0.confirm("dismissed", $confirmationRequest);
        return Unit.INSTANCE;
    }

    private static final void forceRefreshTopPanel$lambda$28(MessageComponent this$0) {
        this$0.contentPanel.add((Component)this$0.topLinePanel, "North");
        this$0.topLinePanel.revalidate();
        this$0.topLinePanel.repaint();
    }

    private static final String insertNewComponents$lambda$31$lambda$29(Markdown.MarkdownPartial $newPartial) {
        return ChatMarkdownTransformer.INSTANCE.toHtml($newPartial.getContent());
    }

    private static final String updateLastComponent$lambda$32(Markdown.MarkdownPartial $markdownPartial) {
        return ChatMarkdownTransformer.INSTANCE.toHtml($markdownPartial.getContent());
    }

    private static final void setFilter$lambda$39(MessageComponent this$0, String $message) {
        this$0.chatMessage.setContent("");
        this$0.messageContentPanel.removeAll();
        this$0.messageContentPanel.add(new NotificationComponent($message, null, 2, null));
        this$0.messageContentPanel.revalidate();
        this$0.messageContentPanel.repaint();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ChatMessageStatus.values().length];
            try {
                nArray[ChatMessageStatus.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageStatus.FILTERED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageStatus.CANCELLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Markdown.MarkdownType.values().length];
            try {
                nArray[Markdown.MarkdownType.MARKDOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Markdown.MarkdownType.CODE_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

