/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message;

import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClient;
import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClientKt;
import com.github.copilot.chat.conversation.agent.rpc.command.CopilotSetModelPolicyCommand;
import com.github.copilot.chat.message.MessageComponent;
import com.github.copilot.chat.message.ModelPolicyNotificationComponent;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.style.Style;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\r\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/copilot/chat/message/ModelPolicyNotificationComponent;", "Ljavax/swing/JPanel;", "messageComponent", "Lcom/github/copilot/chat/message/MessageComponent;", "model", "", "<init>", "(Lcom/github/copilot/chat/message/MessageComponent;Ljava/lang/String;)V", "conversationClient", "Lcom/github/copilot/chat/conversation/agent/CopilotAgentConversationClient;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "contentPanel", "com/github/copilot/chat/message/ModelPolicyNotificationComponent$contentPanel$1", "Lcom/github/copilot/chat/message/ModelPolicyNotificationComponent$contentPanel$1;", "upgradeButton", "Ljavax/swing/JButton;", "messagePanel", "getTitleByModel", "getMesssageByModel", "getLinkByModel", "core"})
@SourceDebugExtension(value={"SMAP\nModelPolicyNotificationComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelPolicyNotificationComponent.kt\ncom/github/copilot/chat/message/ModelPolicyNotificationComponent\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,152:1\n39#2:153\n*S KotlinDebug\n*F\n+ 1 ModelPolicyNotificationComponent.kt\ncom/github/copilot/chat/message/ModelPolicyNotificationComponent\n*L\n26#1:153\n*E\n"})
public final class ModelPolicyNotificationComponent
extends JPanel {
    @NotNull
    private final CopilotAgentConversationClient conversationClient;
    @NotNull
    private final Logger log;
    @NotNull
    private final contentPanel.1 contentPanel;
    @NotNull
    private final JButton upgradeButton;
    @NotNull
    private final JPanel messagePanel;

    /*
     * WARNING - void declaration
     */
    public ModelPolicyNotificationComponent(@NotNull MessageComponent messageComponent, @NotNull String model) {
        Serializable serializable;
        JLabel jLabel;
        void $this$messagePanel_u24lambda_u248;
        Serializable $this$upgradeButton_u24lambda_u247;
        Serializable $this$contentPanel_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)messageComponent, (String)"messageComponent");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(new GridBagLayout());
        this.conversationClient = CopilotAgentConversationClientKt.CopilotAgentConversationClient();
        boolean $i$f$Logger22 = false;
        this.log = new GitHubLogger(ModelPolicyNotificationComponent.class);
        Serializable $i$f$Logger22 = new GridBagLayout();
        Serializable serializable2 = $i$f$Logger22 = new JPanel((GridBagLayout)$i$f$Logger22){

            protected void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2 = (Graphics2D)graphics;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor((Color)Style.Colors.Message.INSTANCE.getUserMessageBackground());
                g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 16.0f, 16.0f));
                g2.dispose();
            }
        };
        JPanel jPanel = this;
        boolean bl = false;
        ((JComponent)$this$contentPanel_u24lambda_u240).setOpaque(false);
        ((JComponent)$this$contentPanel_u24lambda_u240).setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        ((ModelPolicyNotificationComponent)jPanel).contentPanel = $i$f$Logger22;
        $this$contentPanel_u24lambda_u240 = $i$f$Logger22 = new JButton("Enable");
        jPanel = this;
        boolean bl2 = false;
        ClientProperty.put((JComponent)((JComponent)$this$upgradeButton_u24lambda_u247), (Key)DarculaButtonUI.DEFAULT_STYLE_KEY, (Object)true);
        ((JComponent)$this$upgradeButton_u24lambda_u247).setOpaque(false);
        ((AbstractButton)$this$upgradeButton_u24lambda_u247).addActionListener(arg_0 -> ModelPolicyNotificationComponent.upgradeButton$lambda$7$lambda$6(this, model, messageComponent, (JButton)$this$upgradeButton_u24lambda_u247, arg_0));
        ((ModelPolicyNotificationComponent)jPanel).upgradeButton = $i$f$Logger22;
        $this$upgradeButton_u24lambda_u247 = $i$f$Logger22 = new JPanel(new GridBagLayout());
        jPanel = this;
        boolean bl3 = false;
        $this$messagePanel_u24lambda_u248.setOpaque(false);
        ((ModelPolicyNotificationComponent)jPanel).messagePanel = $i$f$Logger22;
        this.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
        this.setOpaque(true);
        String title = this.getTitleByModel(model);
        String message = this.getMesssageByModel(model);
        String link = this.getLinkByModel(model);
        JLabel $this$_init__u24lambda_u249 = jLabel = new JLabel("<html><body style='width: 100%'>" + title + "</body></html>");
        boolean bl4 = false;
        $this$_init__u24lambda_u249.setFont($this$_init__u24lambda_u249.getFont().deriveFont(16.0f));
        JLabel titleLabel = jLabel;
        JLabel $this$_init__u24lambda_u2410 = serializable = new JLabel(message);
        boolean bl5 = false;
        $this$_init__u24lambda_u2410.addMouseListener(new MouseAdapter(link){
            final /* synthetic */ String $link;
            {
                this.$link = $link;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BrowserUtil.browse((String)this.$link);
            }
        });
        JLabel messageLabel2 = serializable;
        $this$_init__u24lambda_u2410 = serializable = new GridBagConstraints();
        Component component2 = titleLabel;
        jPanel = this.messagePanel;
        boolean bl6 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u2411).gridx = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2411).gridy = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2411).anchor = 17;
        ((GridBagConstraints)$this$_init__u24lambda_u2411).fill = 2;
        ((GridBagConstraints)$this$_init__u24lambda_u2411).weightx = 1.0;
        this.setForeground((Color)Style.Colors.INSTANCE.getPRIMARY_TEXT());
        ((GridBagConstraints)$this$_init__u24lambda_u2411).insets = (Insets)JBUI.insetsBottom((int)8);
        Unit unit = Unit.INSTANCE;
        jPanel.add(component2, serializable);
        Serializable $this$_init__u24lambda_u2411 = serializable = new GridBagConstraints();
        component2 = messageLabel2;
        jPanel = this.messagePanel;
        boolean bl7 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u2412).gridx = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2412).gridy = 1;
        ((GridBagConstraints)$this$_init__u24lambda_u2412).anchor = 17;
        ((GridBagConstraints)$this$_init__u24lambda_u2412).fill = 2;
        ((GridBagConstraints)$this$_init__u24lambda_u2412).weightx = 1.0;
        this.setForeground((Color)Style.Colors.INSTANCE.getSECONDARY_TEXT());
        unit = Unit.INSTANCE;
        jPanel.add(component2, serializable);
        Serializable $this$_init__u24lambda_u2412 = serializable = new GridBagConstraints();
        component2 = this.upgradeButton;
        jPanel = this.messagePanel;
        boolean bl8 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u2413).gridx = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2413).gridy = 2;
        ((GridBagConstraints)$this$_init__u24lambda_u2413).anchor = 17;
        unit = Unit.INSTANCE;
        jPanel.add(component2, serializable);
        Serializable $this$_init__u24lambda_u2413 = serializable = new GridBagConstraints();
        component2 = this.messagePanel;
        jPanel = this.contentPanel;
        boolean bl9 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u2414).gridx = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2414).gridy = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2414).weightx = 1.0;
        ((GridBagConstraints)$this$_init__u24lambda_u2414).fill = 1;
        unit = Unit.INSTANCE;
        jPanel.add(component2, serializable);
        Serializable $this$_init__u24lambda_u2414 = serializable = new GridBagConstraints();
        component2 = this.contentPanel;
        jPanel = this;
        boolean bl10 = false;
        $this$_init__u24lambda_u2415.gridx = 0;
        $this$_init__u24lambda_u2415.gridy = 0;
        $this$_init__u24lambda_u2415.weightx = 1.0;
        $this$_init__u24lambda_u2415.weighty = 1.0;
        $this$_init__u24lambda_u2415.fill = 1;
        unit = Unit.INSTANCE;
        jPanel.add(component2, serializable);
    }

    private final String getTitleByModel(String model) {
        return Intrinsics.areEqual((Object)model, (Object)"claude-3.5-sonnet") ? "Enable Claude 3.5 Sonnet(Preview) for all clients" : "Model not supported";
    }

    private final String getMesssageByModel(String model) {
        return Intrinsics.areEqual((Object)model, (Object)"claude-3.5-sonnet") ? "<html><body style='width: 100%'>Enable access to the latest Claude 3.5 Sonnet model from Anthropic. <a href='https://docs.github.com/copilot/using-github-copilot/using-claude-sonnet-in-github-copilot'>[Learn more about how GitHub Copilot serves Claude 3.5 Sonnet.]</a></body></html>" : "Model not supported";
    }

    private final String getLinkByModel(String model) {
        return Intrinsics.areEqual((Object)model, (Object)"claude-3.5-sonnet") ? "https://docs.github.com/copilot/using-github-copilot/using-claude-sonnet-in-github-copilot" : "Model not supported";
    }

    private static final Unit upgradeButton$lambda$7$lambda$6$lambda$5$lambda$1(ModelPolicyNotificationComponent this$0, Throwable error) {
        Logger logger = this$0.log;
        Intrinsics.checkNotNull((Object)error);
        logger.warn(error);
        return Unit.INSTANCE;
    }

    private static final void upgradeButton$lambda$7$lambda$6$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit upgradeButton$lambda$7$lambda$6$lambda$5$lambda$3(JButton $this_apply, ModelPolicyNotificationComponent this$0, String $model, String response) {
        $this_apply.setVisible(false);
        this$0.log.info("Successfully enable " + $model + ": " + response);
        return Unit.INSTANCE;
    }

    private static final void upgradeButton$lambda$7$lambda$6$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void upgradeButton$lambda$7$lambda$6(ModelPolicyNotificationComponent this$0, String $model, MessageComponent $messageComponent, JButton $this_apply, ActionEvent it) {
        try {
            CancellablePromise<String> promise;
            CancellablePromise<String> cancellablePromise;
            CancellablePromise<String> $this$upgradeButton_u24lambda_u247_u24lambda_u246_u24lambda_u245 = cancellablePromise = (promise = this$0.conversationClient.setModelPolicy(new CopilotSetModelPolicyCommand($model, "enabled")));
            boolean bl = false;
            $this$upgradeButton_u24lambda_u247_u24lambda_u246_u24lambda_u245.onError(arg_0 -> ModelPolicyNotificationComponent.upgradeButton$lambda$7$lambda$6$lambda$5$lambda$2(arg_0 -> ModelPolicyNotificationComponent.upgradeButton$lambda$7$lambda$6$lambda$5$lambda$1(this$0, arg_0), arg_0));
            $this$upgradeButton_u24lambda_u247_u24lambda_u246_u24lambda_u245.onSuccess(arg_0 -> ModelPolicyNotificationComponent.upgradeButton$lambda$7$lambda$6$lambda$5$lambda$4(arg_0 -> ModelPolicyNotificationComponent.upgradeButton$lambda$7$lambda$6$lambda$5$lambda$3($this_apply, this$0, $model, arg_0), arg_0));
        }
        catch (Throwable e) {
            this$0.log.warn("Error occurred enable " + $model, e);
        }
        $messageComponent.retry();
    }
}

