/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message;

import com.github.copilot.chat.message.NotificationType;
import com.github.copilot.platform.utils.JBColorKt;
import com.github.copilot.style.Style;
import com.intellij.icons.AllIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/copilot/chat/message/NotificationComponent;", "Ljavax/swing/JPanel;", "message", "", "type", "Lcom/github/copilot/chat/message/NotificationType;", "<init>", "(Ljava/lang/String;Lcom/github/copilot/chat/message/NotificationType;)V", "generateFormattedContent", "icon", "Ljavax/swing/Icon;", "leftConstraint", "Ljava/awt/GridBagConstraints;", "rightConstraint", "core"})
public final class NotificationComponent
extends JPanel {
    @NotNull
    private final String message;
    @NotNull
    private final NotificationType type;

    public NotificationComponent(@NotNull String message, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(new GridBagLayout());
        this.message = message;
        this.type = type;
        this.add((Component)new JLabel(this.icon()), this.leftConstraint());
        JLabel linkLabel2 = new JLabel(this.generateFormattedContent());
        linkLabel2.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        this.add((Component)linkLabel2, this.rightConstraint());
        this.setBorder(Style.Borders.INSTANCE.getNotificationBelowEmptyMessageBorder());
    }

    public /* synthetic */ NotificationComponent(String string, NotificationType notificationType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            notificationType = NotificationType.INFO;
        }
        this(string, notificationType);
    }

    private final String generateFormattedContent() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> "<html><font color='#" + JBColorKt.toHexString((Color)Style.Colors.INSTANCE.getSECONDARY_TEXT()) + "'>" + this.message + "</font></html>";
            case 2 -> "<html><font color='#DB5C5C'>" + this.message + "</font></html>";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Icon icon() {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                Icon icon2 = AllIcons.General.Information;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Information");
                break;
            }
            case 2: {
                Icon icon3 = AllIcons.General.Error;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Error");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    private final GridBagConstraints leftConstraint() {
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        return c;
    }

    private final GridBagConstraints rightConstraint() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.gridx = 1;
        return c;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            try {
                nArray[NotificationType.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

