/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message;

import com.github.copilot.chat.message.NonChunkableToken;
import com.github.copilot.chat.message.NonChunkableTokenKt;
import com.github.copilot.chat.message.NonChunkableTokenMatch;
import com.github.copilot.chat.message.TypewriterEvent;
import com.github.copilot.chat.message.TypewriterEventType;
import com.github.copilot.chat.message.UpdatableComponent;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0002)*BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0012\b\u0002\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f*\u00020\u001dH\u0002J\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010\u000f\u001a\u00020\u001bJ\u0006\u0010!\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020\u001bH\u0002J\u000e\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0019J\u0006\u0010%\u001a\u00020\u0010J\u0012\u0010&\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/github/copilot/chat/message/TypeWriter;", "Ljava/awt/event/ActionListener;", "component", "Lcom/github/copilot/chat/message/UpdatableComponent;", "interval", "", "chunkSize", "nonChunkableTokens", "", "Lcom/github/copilot/chat/message/NonChunkableToken;", "Lcom/github/copilot/chat/message/NonChunkableTokens;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/github/copilot/chat/message/UpdatableComponent;IILjava/util/Set;Lcom/github/copilot/platform/utils/observability/Logger;)V", "flush", "", "complete", "timer", "Ljavax/swing/Timer;", "eventQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/github/copilot/chat/message/TypewriterEvent;", "onCompleteListeners", "", "Lcom/github/copilot/chat/message/TypeWriter$OnCompleteListener;", "addText", "", "newText", "", "chunk", "", "done", "stop", "startIfStopped", "addOnCompleteListener", "onCompleteListener", "isComplete", "actionPerformed", "e", "Ljava/awt/event/ActionEvent;", "OnCompleteListener", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTypeWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeWriter.kt\ncom/github/copilot/chat/message/TypeWriter\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n39#2:213\n1855#3,2:214\n1855#3,2:216\n1855#3,2:218\n766#3:220\n857#3,2:221\n*S KotlinDebug\n*F\n+ 1 TypeWriter.kt\ncom/github/copilot/chat/message/TypeWriter\n*L\n23#1:213\n40#1:214,2\n69#1:216,2\n162#1:218,2\n172#1:220\n172#1:221,2\n*E\n"})
public final class TypeWriter
implements ActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpdatableComponent component;
    private final int interval;
    private final int chunkSize;
    @NotNull
    private final Set<NonChunkableToken> nonChunkableTokens;
    @NotNull
    private final Logger log;
    private boolean flush;
    private boolean complete;
    @NotNull
    private final Timer timer;
    @NotNull
    private final ConcurrentLinkedQueue<TypewriterEvent> eventQueue;
    @NotNull
    private final List<OnCompleteListener> onCompleteListeners;
    @NotNull
    private static final Set<NonChunkableToken> DEFAULT_NON_CHUNKABLE_TOKENS;

    public TypeWriter(@NotNull UpdatableComponent component2, int interval, int chunkSize, @NotNull Set<NonChunkableToken> nonChunkableTokens, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter(nonChunkableTokens, (String)"nonChunkableTokens");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.component = component2;
        this.interval = interval;
        this.chunkSize = chunkSize;
        this.nonChunkableTokens = nonChunkableTokens;
        this.log = log;
        this.timer = new Timer(this.interval, this);
        this.eventQueue = new ConcurrentLinkedQueue();
        this.onCompleteListeners = new ArrayList();
    }

    public /* synthetic */ TypeWriter(UpdatableComponent updatableComponent, int n, int n2, Set set, Logger logger, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 50;
        }
        if ((n3 & 4) != 0) {
            n2 = 10;
        }
        if ((n3 & 8) != 0) {
            set = DEFAULT_NON_CHUNKABLE_TOKENS;
        }
        if ((n3 & 0x10) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(TypeWriter.class);
        }
        this(updatableComponent, n, n2, set, logger);
    }

    public final void addText(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.log.trace("Adding text to typewriter: " + newText);
        if (((CharSequence)newText).length() > 0) {
            Iterable $this$forEach$iv = this.chunk(newText);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.log.trace("Adding chunk to typewriter queue: " + it);
                this.eventQueue.offer(new TypewriterEvent(it, null, 2, null));
            }
        }
        this.log.trace("Done adding chunks to typewriter queue");
        if (!((Collection)this.eventQueue).isEmpty() && !this.timer.isRunning()) {
            this.log.trace("Starting typewriter timer");
            this.timer.start();
        }
    }

    private final List<String> chunk(String $this$chunk) {
        List chunks = new ArrayList();
        List<NonChunkableTokenMatch> nonChunkableTokenMatches = NonChunkableTokenKt.find(this.nonChunkableTokens, $this$chunk);
        if (nonChunkableTokenMatches.isEmpty()) {
            v0 = chunks.addAll(StringsKt.chunked((CharSequence)$this$chunk, (int)this.chunkSize));
        } else {
            String str = null;
            str = $this$chunk;
            int offset = 0;
            Iterable $this$forEach$iv = nonChunkableTokenMatches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String beforeMatch;
                NonChunkableTokenMatch match = (NonChunkableTokenMatch)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)str.substring(0, match.getStartIndex() - offset), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                chunks.addAll(StringsKt.chunked((CharSequence)beforeMatch, (int)this.chunkSize));
                chunks.add(match.getToken());
                Intrinsics.checkNotNullExpressionValue((Object)str.substring(match.getEndIndex() + 1 - offset), (String)"this as java.lang.String).substring(startIndex)");
                offset += beforeMatch.length() + match.getToken().length();
            }
            v0 = chunks.addAll(StringsKt.chunked((CharSequence)str, (int)this.chunkSize));
        }
        return chunks;
    }

    public final void done() {
        this.startIfStopped();
        this.eventQueue.add(new TypewriterEvent(null, TypewriterEventType.DONE, 1, null));
        this.log.trace("Typewriter done signal received.");
    }

    public final void flush() {
        this.log.trace("Typewriter flush signal received. Flushing the queue.");
        this.flush = true;
        this.done();
    }

    public final void stop() {
        this.log.trace("Typewriter stop signal received. Stopping the typewriter.");
        this.startIfStopped();
        this.eventQueue.clear();
        this.eventQueue.add(new TypewriterEvent(null, TypewriterEventType.DONE, 1, null));
    }

    private final void startIfStopped() {
        if (!this.timer.isRunning()) {
            this.log.trace("The timer is not running. Starting the timer to finish processing.");
            this.timer.start();
        }
    }

    public final void addOnCompleteListener(@NotNull OnCompleteListener onCompleteListener) {
        Intrinsics.checkNotNullParameter((Object)onCompleteListener, (String)"onCompleteListener");
        this.onCompleteListeners.add(onCompleteListener);
    }

    public final boolean isComplete() {
        return this.complete;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        block10: {
            try {
                void $this$filterTo$iv$iv;
                this.log.trace("Typewriter timer action performed");
                this.log.trace("Typewriter queue size: " + this.eventQueue.size());
                this.log.trace("Typewriter flush: " + this.flush);
                this.log.trace("Typewriter complete: " + this.complete);
                this.log.trace("Typewriter timer running: " + this.timer.isRunning());
                this.log.trace("Typewriter queue: " + CollectionsKt.joinToString$default((Iterable)this.eventQueue, null, null, null, (int)0, null, TypeWriter::actionPerformed$lambda$2, (int)31, null));
                if (!(!((Collection)this.eventQueue).isEmpty())) break block10;
                if (!this.flush) {
                    TypewriterEvent event = this.eventQueue.poll();
                    switch (WhenMappings.$EnumSwitchMapping$0[event.getType().ordinal()]) {
                        case 1: {
                            this.component.updateContent(event.getText());
                            break block10;
                        }
                        case 2: {
                            this.component.noMoreUpdates();
                            this.eventQueue.add(new TypewriterEvent(null, TypewriterEventType.EXECUTE_ON_COMPLETE_LISTENERS, 1, null));
                            break block10;
                        }
                        case 3: {
                            Iterable $this$forEach$iv = this.onCompleteListeners;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                OnCompleteListener it = (OnCompleteListener)element$iv;
                                boolean bl = false;
                                it.onComplete();
                            }
                            this.timer.stop();
                            this.complete = true;
                            break block10;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                this.flush = false;
                Iterable $this$filter$iv = this.eventQueue;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TypewriterEvent it = (TypewriterEvent)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getType() == TypewriterEventType.ADD_TEXT)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String it = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, TypeWriter::actionPerformed$lambda$5, (int)30, null);
                boolean bl = false;
                this.component.updateContent(it);
                this.eventQueue.clear();
                this.eventQueue.add(new TypewriterEvent(null, TypewriterEventType.DONE, 1, null));
            }
            catch (Throwable e2) {
                this.log.error("Error in typewriter", e2);
                this.eventQueue.clear();
                this.eventQueue.add(new TypewriterEvent(null, TypewriterEventType.EXECUTE_ON_COMPLETE_LISTENERS, 1, null));
            }
        }
    }

    private static final CharSequence actionPerformed$lambda$2(TypewriterEvent it) {
        return it.getText();
    }

    private static final CharSequence actionPerformed$lambda$5(TypewriterEvent it) {
        return it.getText();
    }

    static {
        NonChunkableToken[] nonChunkableTokenArray = new NonChunkableToken[]{NonChunkableToken.Companion.getJSDOC_ANNOTATION()};
        DEFAULT_NON_CHUNKABLE_TOKENS = NonChunkableTokenKt.NonChunkableTokens(nonChunkableTokenArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/copilot/chat/message/TypeWriter$Companion;", "", "<init>", "()V", "DEFAULT_NON_CHUNKABLE_TOKENS", "", "Lcom/github/copilot/chat/message/NonChunkableToken;", "Lcom/github/copilot/chat/message/NonChunkableTokens;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/github/copilot/chat/message/TypeWriter$OnCompleteListener;", "", "onComplete", "", "core"})
    public static interface OnCompleteListener {
        public void onComplete();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypewriterEventType.values().length];
            try {
                nArray[TypewriterEventType.ADD_TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypewriterEventType.DONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypewriterEventType.EXECUTE_ON_COMPLETE_LISTENERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

