/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message.codeblock;

import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.formatting.LanguageUtils;
import com.github.copilot.chat.formatting.Markdown;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.ScrollPaneDragScroller;
import com.github.copilot.chat.message.codeblock.CodeBlockPanel;
import com.github.copilot.chat.message.codeblock.CopilotCodeBlockCopyPastePostProcessor;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.style.Style;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0002)*BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0013\u0010&\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lcom/github/copilot/chat/message/codeblock/CodeBlock;", "Ljavax/swing/JPanel;", "codeBlockPanel", "Lcom/github/copilot/chat/message/codeblock/CodeBlockPanel;", "markdownPartial", "Lcom/github/copilot/chat/formatting/Markdown$MarkdownPartial;", "project", "Lcom/intellij/openapi/project/Project;", "codeBlockIndex", "", "controlPanelActionGroupId", "", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "conversationService", "Lcom/github/copilot/chat/conversation/ConversationService;", "<init>", "(Lcom/github/copilot/chat/message/codeblock/CodeBlockPanel;Lcom/github/copilot/chat/formatting/Markdown$MarkdownPartial;Lcom/intellij/openapi/project/Project;ILjava/lang/String;Lcom/github/copilot/chat/message/ChatMessage;Lcom/github/copilot/chat/conversation/ConversationService;)V", "file", "Lcom/intellij/testFramework/LightVirtualFile;", "getFile", "()Lcom/intellij/testFramework/LightVirtualFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "Lorg/jetbrains/annotations/NotNull;", "editorTextField", "Lcom/intellij/ui/EditorTextField;", "getEditorTextField", "()Lcom/intellij/ui/EditorTextField;", "setEditorTextField", "(Lcom/intellij/ui/EditorTextField;)V", "isOptimizedDrawingEnabled", "", "initEditorTextField", "", "updateEditorColors", "editorEx", "Lcom/intellij/openapi/editor/ex/EditorEx;", "language", "getLanguage", "()Ljava/lang/String;", "Companion", "CodeBlockFocusTraversalPolicy", "core"})
public final class CodeBlock
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeBlockPanel codeBlockPanel;
    @NotNull
    private final Markdown.MarkdownPartial markdownPartial;
    @NotNull
    private final Project project;
    private final int codeBlockIndex;
    @NotNull
    private final String controlPanelActionGroupId;
    @NotNull
    private final ChatMessage chatMessage;
    @Nullable
    private final ConversationService conversationService;
    @NotNull
    private final LightVirtualFile file;
    @NotNull
    private final FileType fileType;
    public EditorTextField editorTextField;
    @NotNull
    private static final Key<Integer> CODE_BLOCK_INDEX_KEY;
    @NotNull
    private static final Key<ChatMessage> CODE_BLOCK_CHAT_MESSAGE_KEY;
    @NotNull
    private static final Key<ConversationService> CODE_BLOCK_CONVERSATION_SERVICE_KEY;

    public CodeBlock(@NotNull CodeBlockPanel codeBlockPanel, @NotNull Markdown.MarkdownPartial markdownPartial, @NotNull Project project, int codeBlockIndex, @NotNull String controlPanelActionGroupId, @NotNull ChatMessage chatMessage, @Nullable ConversationService conversationService) {
        Intrinsics.checkNotNullParameter((Object)codeBlockPanel, (String)"codeBlockPanel");
        Intrinsics.checkNotNullParameter((Object)markdownPartial, (String)"markdownPartial");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)controlPanelActionGroupId, (String)"controlPanelActionGroupId");
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        super(new BorderLayout());
        this.codeBlockPanel = codeBlockPanel;
        this.markdownPartial = markdownPartial;
        this.project = project;
        this.codeBlockIndex = codeBlockIndex;
        this.controlPanelActionGroupId = controlPanelActionGroupId;
        this.chatMessage = chatMessage;
        this.conversationService = conversationService;
        this.file = new LightVirtualFile("", (CharSequence)this.markdownPartial.getContent());
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFile((VirtualFile)this.file);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFile(...)");
        this.fileType = fileType;
        this.initEditorTextField();
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new CodeBlockFocusTraversalPolicy());
    }

    public /* synthetic */ CodeBlock(CodeBlockPanel codeBlockPanel, Markdown.MarkdownPartial markdownPartial, Project project, int n, String string, ChatMessage chatMessage, ConversationService conversationService, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"getInstance(...)");
            project = ProjectKt.getBestProject$default(projectManager, null, 1, null);
        }
        if ((n2 & 0x10) != 0) {
            string = "";
        }
        this(codeBlockPanel, markdownPartial, project, n, string, chatMessage, conversationService);
    }

    @NotNull
    public final LightVirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final EditorTextField getEditorTextField() {
        EditorTextField editorTextField = this.editorTextField;
        if (editorTextField != null) {
            return editorTextField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"editorTextField");
        return null;
    }

    public final void setEditorTextField(@NotNull EditorTextField editorTextField) {
        Intrinsics.checkNotNullParameter((Object)editorTextField, (String)"<set-?>");
        this.editorTextField = editorTextField;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    private final void initEditorTextField() {
        if (this.project.isDisposed()) {
            return;
        }
        ApplicationKt.runReadAction(() -> CodeBlock.initEditorTextField$lambda$2(this));
    }

    private final void updateEditorColors(EditorEx editorEx) {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        Color c = scheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
        JComponent jComponent = editorEx.getContentComponent();
        Color color = c;
        if (color == null) {
            Color color2 = scheme.getDefaultBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
        }
        jComponent.setBorder(BorderFactory.createLineBorder(color, 6));
        JScrollPane jScrollPane = editorEx.getScrollPane();
        Color color3 = c;
        if (color3 == null) {
            Color color4 = scheme.getDefaultBackground();
            color3 = color4;
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getDefaultBackground(...)");
        }
        jScrollPane.setBackground(color3);
        Color color5 = c;
        if (color5 == null) {
            color5 = scheme.getDefaultBackground();
        }
        editorEx.setBackgroundColor(color5);
        editorEx.setColorsScheme(scheme);
        editorEx.getScrollPane().getVerticalScrollBar().setBackground(editorEx.getBackgroundColor());
        editorEx.getScrollPane().getHorizontalScrollBar().setBackground(editorEx.getBackgroundColor());
        editorEx.getScrollPane().getCorner("LOWER_RIGHT_CORNER").setBackground(editorEx.getBackgroundColor());
    }

    @Nullable
    public final String getLanguage() {
        return this.markdownPartial.getLanguage();
    }

    private static final void initEditorTextField$lambda$2$lambda$1$lambda$0(CodeBlock this$0, EditorEx $editorEx, EditorColorsScheme it) {
        this$0.updateEditorColors($editorEx);
    }

    private static final void initEditorTextField$lambda$2$lambda$1(CodeBlock this$0, EditorEx editorEx) {
        Intrinsics.checkNotNullParameter((Object)editorEx, (String)"editorEx");
        EditorSettings editorSettings2 = editorEx.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings2, (String)"getSettings(...)");
        EditorSettings editorSettings3 = editorSettings2;
        editorSettings3.setLineNumbersShown(false);
        editorSettings3.setLineMarkerAreaShown(false);
        editorSettings3.setAutoCodeFoldingEnabled(false);
        editorSettings3.setUseSoftWraps(false);
        editorSettings3.setAnimatedScrolling(true);
        editorSettings3.setBlinkCaret(false);
        editorSettings3.setRightMarginShown(false);
        editorSettings3.setShowIntentionBulb(false);
        editorEx.setViewer(true);
        editorEx.setCaretVisible(false);
        editorEx.setCaretEnabled(false);
        editorEx.getScrollPane().setHorizontalScrollBarPolicy(30);
        editorEx.getScrollPane().setVerticalScrollBarPolicy(21);
        editorEx.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)true);
        editorEx.putUserData(CopilotCodeBlockCopyPastePostProcessor.Companion.getCOPILOT_CODE_BLOCK_DATA_KEY(), (Object)true);
        editorEx.putUserData(CODE_BLOCK_INDEX_KEY, (Object)this$0.codeBlockIndex);
        editorEx.putUserData(CODE_BLOCK_CHAT_MESSAGE_KEY, (Object)this$0.chatMessage);
        editorEx.putUserData(CODE_BLOCK_CONVERSATION_SERVICE_KEY, (Object)this$0.conversationService);
        editorEx.setRendererMode(false);
        this$0.updateEditorColors(editorEx);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)((Disposable)this$0.project), (Disposable)disposable2);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(disposable2);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> CodeBlock.initEditorTextField$lambda$2$lambda$1$lambda$0(this$0, editorEx, arg_0));
        JComponent jComponent = editorEx.getContentComponent();
        ConversationService conversationService = this$0.conversationService;
        SessionController sessionController = conversationService != null ? conversationService.getSessionController() : null;
        ScrollPaneDragScroller compositeMouseListener2 = new ScrollPaneDragScroller(this$0, jComponent, sessionController){
            final /* synthetic */ CodeBlock this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $super_call_param$2);
            }

            public void mouseExited(MouseEvent e) {
                CodeBlock.access$getCodeBlockPanel$p(this.this$0).getControlPanel().setVisible(false);
                super.mouseEntered(e);
            }

            public void mouseEntered(MouseEvent e) {
                CodeBlock.access$getCodeBlockPanel$p(this.this$0).getControlPanel().setVisible(true);
                super.mouseEntered(e);
            }
        };
        JComponent jComponent2 = editorEx.getContentComponent();
        JComponent jComponent3 = editorEx.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"getContentComponent(...)");
        ConversationService conversationService2 = this$0.conversationService;
        jComponent2.addMouseMotionListener(new ScrollPaneDragScroller(jComponent3, conversationService2 != null ? conversationService2.getSessionController() : null));
        editorEx.getContentComponent().addMouseListener(compositeMouseListener2);
        if (!StringsKt.isBlank((CharSequence)this$0.controlPanelActionGroupId)) {
            editorEx.setContextMenuGroupId(this$0.controlPanelActionGroupId);
        }
    }

    private static final Unit initEditorTextField$lambda$2(CodeBlock this$0) {
        this$0.setOpaque(false);
        this$0.file.setFileType(this$0.fileType);
        this$0.file.setLanguage(LanguageUtils.INSTANCE.determineLanguage(this$0.project, this$0.file, this$0.markdownPartial));
        this$0.setEditorTextField(EditorTextFieldProvider.getInstance().getEditorField(this$0.file.getLanguage(), this$0.project, (Iterable)CollectionsKt.listOf(arg_0 -> CodeBlock.initEditorTextField$lambda$2$lambda$1(this$0, arg_0))));
        FileViewProvider snippetViewProvider = PsiManager.getInstance((Project)this$0.project).findViewProvider((VirtualFile)this$0.file);
        if (snippetViewProvider != null) {
            this$0.getEditorTextField().setDocument(snippetViewProvider.getDocument());
        }
        this$0.getEditorTextField().setViewer(true);
        this$0.getEditorTextField().setFocusable(false);
        this$0.add((Component)this$0.getEditorTextField(), "Center");
        this$0.setMinimumSize(this$0.codeBlockPanel.getPreferredSize());
        this$0.setBorder(Style.Borders.INSTANCE.getCodeBlockOuterBorder());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CodeBlockPanel access$getCodeBlockPanel$p(CodeBlock $this) {
        return $this.codeBlockPanel;
    }

    static {
        Key key = Key.create((String)"copilot.chat.message.code.block.index");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CODE_BLOCK_INDEX_KEY = key;
        Key key2 = Key.create((String)"copilot.chat.message.code.block.chat.message");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        CODE_BLOCK_CHAT_MESSAGE_KEY = key2;
        Key key3 = Key.create((String)"copilot.chat.message.code.block.conversation.service");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        CODE_BLOCK_CONVERSATION_SERVICE_KEY = key3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016J\u001e\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/github/copilot/chat/message/codeblock/CodeBlock$CodeBlockFocusTraversalPolicy;", "Ljavax/swing/LayoutFocusTraversalPolicy;", "<init>", "(Lcom/github/copilot/chat/message/codeblock/CodeBlock;)V", "getComponentAfter", "Ljava/awt/Component;", "aContainer", "Ljava/awt/Container;", "aComponent", "getComponentBefore", "getFirstComponent", "getLastComponent", "getDefaultComponent", "core"})
    private final class CodeBlockFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        @Override
        @Nullable
        public Component getComponentAfter(@Nullable Container aContainer, @Nullable Component aComponent) {
            FocusTraversalPolicy policy;
            if (SwingUtilities.isDescendingFrom(aComponent, CodeBlock.this) && (policy = CodeBlock.this.getFocusCycleRootAncestor().getFocusTraversalPolicy()) != null) {
                return policy.getComponentAfter(CodeBlock.this.getFocusCycleRootAncestor(), CodeBlock.this);
            }
            return super.getComponentAfter(aContainer, aComponent);
        }

        @Override
        @Nullable
        public Component getComponentBefore(@Nullable Container aContainer, @Nullable Component aComponent) {
            FocusTraversalPolicy policy;
            if (SwingUtilities.isDescendingFrom(aComponent, CodeBlock.this) && (policy = CodeBlock.this.getFocusCycleRootAncestor().getFocusTraversalPolicy()) != null) {
                return policy.getComponentBefore(CodeBlock.this.getFocusCycleRootAncestor(), CodeBlock.this);
            }
            return super.getComponentBefore(aContainer, aComponent);
        }

        @Override
        @Nullable
        public Component getFirstComponent(@Nullable Container aContainer) {
            return null;
        }

        @Override
        @Nullable
        public Component getLastComponent(@Nullable Container aContainer) {
            return null;
        }

        @Override
        @Nullable
        public Component getDefaultComponent(@Nullable Container aContainer) {
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/github/copilot/chat/message/codeblock/CodeBlock$Companion;", "", "<init>", "()V", "CODE_BLOCK_INDEX_KEY", "Lcom/intellij/openapi/util/Key;", "", "getCODE_BLOCK_INDEX_KEY", "()Lcom/intellij/openapi/util/Key;", "CODE_BLOCK_CHAT_MESSAGE_KEY", "Lcom/github/copilot/chat/message/ChatMessage;", "getCODE_BLOCK_CHAT_MESSAGE_KEY", "CODE_BLOCK_CONVERSATION_SERVICE_KEY", "Lcom/github/copilot/chat/conversation/ConversationService;", "getCODE_BLOCK_CONVERSATION_SERVICE_KEY", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getCODE_BLOCK_INDEX_KEY() {
            return CODE_BLOCK_INDEX_KEY;
        }

        @NotNull
        public final Key<ChatMessage> getCODE_BLOCK_CHAT_MESSAGE_KEY() {
            return CODE_BLOCK_CHAT_MESSAGE_KEY;
        }

        @NotNull
        public final Key<ConversationService> getCODE_BLOCK_CONVERSATION_SERVICE_KEY() {
            return CODE_BLOCK_CONVERSATION_SERVICE_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

