/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message.codeblock;

import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.conversation.agent.rpc.command.CopyCodeBlockCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.CopySource;
import com.github.copilot.chat.conversation.agent.rpc.command.InsertCodeBlockCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.InsertSource;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.codeblock.CodeBlock;
import com.github.copilot.chat.message.codeblock.CopyPasteService;
import com.github.copilot.chat.message.codeblock.TextBlockContext;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016JH\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001a0\u00192\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/copilot/chat/message/codeblock/CopilotCodeBlockCopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/github/copilot/platform/utils/observability/Logger;)V", "collectTransferableData", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "processTransferableData", "", "project", "Lcom/intellij/openapi/project/Project;", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "", "indented", "Lcom/intellij/openapi/util/Ref;", "", "values", "extractTransferableData", "", "transferable", "Ljava/awt/datatransfer/Transferable;", "getCopiedText", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCopilotCodeBlockCopyPastePostProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopilotCodeBlockCopyPastePostProcessor.kt\ncom/github/copilot/chat/message/codeblock/CopilotCodeBlockCopyPastePostProcessor\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,130:1\n39#2:131\n*S KotlinDebug\n*F\n+ 1 CopilotCodeBlockCopyPastePostProcessor.kt\ncom/github/copilot/chat/message/codeblock/CopilotCodeBlockCopyPastePostProcessor\n*L\n31#1:131\n*E\n"})
public final class CopilotCodeBlockCopyPastePostProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private static final Key<Boolean> COPILOT_CODE_BLOCK_DATA_KEY;

    public CopilotCodeBlockCopyPastePostProcessor(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
    }

    public /* synthetic */ CopilotCodeBlockCopyPastePostProcessor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(CopilotCodeBlockCopyPastePostProcessor.class);
        }
        this(logger);
    }

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file, @NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        if (Intrinsics.areEqual((Object)editor.getUserData(COPILOT_CODE_BLOCK_DATA_KEY), (Object)true)) {
            Integer codeBlockIndex = (Integer)editor.getUserData(CodeBlock.Companion.getCODE_BLOCK_INDEX_KEY());
            ChatMessage codeBlockChatMessage = (ChatMessage)editor.getUserData(CodeBlock.Companion.getCODE_BLOCK_CHAT_MESSAGE_KEY());
            ConversationService codeBlockConversationService = (ConversationService)editor.getUserData(CodeBlock.Companion.getCODE_BLOCK_CONVERSATION_SERVICE_KEY());
            if (codeBlockIndex != null && codeBlockChatMessage != null && codeBlockConversationService != null && codeBlockChatMessage.getTurnId() != null) {
                try {
                    String copiedText = this.getCopiedText(file, startOffsets, endOffsets);
                    CopyPasteService.INSTANCE.queueCopyContext(new TextBlockContext(copiedText, codeBlockConversationService, codeBlockChatMessage, codeBlockIndex, file.getTextLength()));
                    String string = codeBlockConversationService.getSessionController().getSession().getSource().getRpcValue();
                    String string2 = codeBlockChatMessage.getTurnId();
                    Intrinsics.checkNotNull((Object)string2);
                    codeBlockConversationService.copyCodeBlock(new CopyCodeBlockCommand(string, string2, codeBlockIndex, CopySource.KEYBOARD.getRpcValue(), copiedText.length(), file.getTextLength(), copiedText, null, 128, null));
                }
                catch (Exception e) {
                    this.log.warn("Failed to copy code block", e);
                }
            }
        }
        return new ArrayList();
    }

    public void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(indented, (String)"indented");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        super.processTransferableData(project, editor, bounds, caretOffset, indented, values);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable transferable) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        try {
            Object object = transferable.getTransferData(DataFlavor.stringFlavor);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            TextBlockContext textBlockContext = CopyPasteService.INSTANCE.getCopyContext((String)object);
            if (textBlockContext != null) {
                void $this$extractTransferableData_u24lambda_u241_u24lambda_u240;
                TextBlockContext copyContext = textBlockContext;
                boolean bl = false;
                TextBlockContext textBlockContext2 = copyContext;
                ConversationService conversationService = copyContext.getConversationService();
                boolean bl2 = false;
                String string = $this$extractTransferableData_u24lambda_u241_u24lambda_u240.getConversationService().getSessionController().getSession().getSource().getRpcValue();
                String string2 = $this$extractTransferableData_u24lambda_u241_u24lambda_u240.getChatMessage().getTurnId();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = string2;
                int n = $this$extractTransferableData_u24lambda_u241_u24lambda_u240.getCodeBlockIndex();
                int n2 = $this$extractTransferableData_u24lambda_u241_u24lambda_u240.getContent().length();
                int n3 = $this$extractTransferableData_u24lambda_u241_u24lambda_u240.getTotalCharacters();
                String string4 = InsertSource.KEYBOARD.getRpcValue();
                conversationService.insertCodeBlock(new InsertCodeBlockCommand(string, string3, n, n2, n3, false, string4, null, 128, null));
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to capture suggestion acceptance for paste event", e);
        }
        return CollectionsKt.emptyList();
    }

    private final String getCopiedText(PsiFile file, int[] startOffsets, int[] endOffsets) {
        Object copiedText = "";
        int n = startOffsets.length;
        for (int i = 0; i < n; ++i) {
            int startOffset = startOffsets[i];
            int endOffset = endOffsets[i];
            String string = file.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string.substring(startOffset, endOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            copiedText = (String)copiedText + string2;
        }
        return copiedText;
    }

    public CopilotCodeBlockCopyPastePostProcessor() {
        this(null, 1, null);
    }

    static {
        Key key = Key.create((String)"copilot.chat.message.code.block");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COPILOT_CODE_BLOCK_DATA_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/github/copilot/chat/message/codeblock/CopilotCodeBlockCopyPastePostProcessor$Companion;", "", "<init>", "()V", "COPILOT_CODE_BLOCK_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "", "getCOPILOT_CODE_BLOCK_DATA_KEY", "()Lcom/intellij/openapi/util/Key;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getCOPILOT_CODE_BLOCK_DATA_KEY() {
            return COPILOT_CODE_BLOCK_DATA_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

