/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message.codeblock;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.conversation.agent.rpc.command.CopyCodeBlockCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.CopySource;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.codeblock.CodeBlock;
import com.github.copilot.chat.message.codeblock.CopyPasteService;
import com.github.copilot.chat.message.codeblock.TextBlockContext;
import com.github.copilot.chat.utils.CopyKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/copilot/chat/message/codeblock/CopyCodeBlockAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "codeBlockIndex", "", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "codeBlock", "Lcom/github/copilot/chat/message/codeblock/CodeBlock;", "conversationService", "Lcom/github/copilot/chat/conversation/ConversationService;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(ILcom/github/copilot/chat/message/ChatMessage;Lcom/github/copilot/chat/message/codeblock/CodeBlock;Lcom/github/copilot/chat/conversation/ConversationService;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getCodeBlock", "()Lcom/github/copilot/chat/message/codeblock/CodeBlock;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nCopyCodeBlockAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyCodeBlockAction.kt\ncom/github/copilot/chat/message/codeblock/CopyCodeBlockAction\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,102:1\n39#2:103\n*S KotlinDebug\n*F\n+ 1 CopyCodeBlockAction.kt\ncom/github/copilot/chat/message/codeblock/CopyCodeBlockAction\n*L\n24#1:103\n*E\n"})
public final class CopyCodeBlockAction
extends AnAction {
    private final int codeBlockIndex;
    @NotNull
    private final ChatMessage chatMessage;
    @NotNull
    private final CodeBlock codeBlock;
    @Nullable
    private final ConversationService conversationService;
    @NotNull
    private final Logger log;

    public CopyCodeBlockAction(int codeBlockIndex, @NotNull ChatMessage chatMessage, @NotNull CodeBlock codeBlock, @Nullable ConversationService conversationService, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)codeBlock, (String)"codeBlock");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(CopilotBundle.get("copilot.chat.message.code.block.copy.action.title"), CopilotBundle.get("copilot.chat.message.code.block.copy.action.description"), CopilotIcons.Copy);
        this.codeBlockIndex = codeBlockIndex;
        this.chatMessage = chatMessage;
        this.codeBlock = codeBlock;
        this.conversationService = conversationService;
        this.log = log;
        String string = KeymapManager.getInstance().getActiveKeymap().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.setShortcutSet(StringsKt.contains$default((CharSequence)string, (CharSequence)"Mac", (boolean)false, (int)2, null) ? (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(67, 256)) : (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(67, 128)));
    }

    public /* synthetic */ CopyCodeBlockAction(int n, ChatMessage chatMessage, CodeBlock codeBlock, ConversationService conversationService, Logger logger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(CopyCodeBlockAction.class);
        }
        this(n, chatMessage, codeBlock, conversationService, logger);
    }

    @NotNull
    public final CodeBlock getCodeBlock() {
        return this.codeBlock;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.conversationService == null) {
            this.log.debug("Conversation service is null");
            return;
        }
        Editor editor = this.codeBlock.getEditorTextField().getEditor();
        boolean bl = editor != null && (editor = editor.getSelectionModel()) != null ? editor.hasSelection() : false;
        if (bl) {
            object = this.codeBlock.getEditorTextField().getEditor();
            if (object == null || (object = object.getSelectionModel()) == null || (object = object.getSelectedText()) == null) {
                String string = this.codeBlock.getEditorTextField().getText();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            }
        } else {
            String string = this.codeBlock.getEditorTextField().getText();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        }
        Editor codeBlockContents = object;
        CopyPasteService.INSTANCE.queueCopyContext(new TextBlockContext((String)codeBlockContents, this.conversationService, this.chatMessage, this.codeBlockIndex, this.codeBlock.getEditorTextField().getText().length()));
        if (!StringsKt.isBlank((CharSequence)((CharSequence)codeBlockContents))) {
            CopyKt.copyToClipBoard((String)codeBlockContents);
            if (!Intrinsics.areEqual((Object)e.getPlace(), (Object)"EditorInlay")) {
                Timer timer;
                Notification notification = CopilotNotifications.createFullContentNotification(CopilotBundle.get("copilot.chat.message.code.block.copy.title"), CopilotBundle.get("copilot.chat.message.code.block.copy.message"), NotificationType.INFORMATION, true);
                notification.notify(e.getProject());
                Timer $this$actionPerformed_u24lambda_u241 = timer = new Timer(3000, arg_0 -> CopyCodeBlockAction.actionPerformed$lambda$0(notification, arg_0));
                boolean bl2 = false;
                $this$actionPerformed_u24lambda_u241.setRepeats(false);
                $this$actionPerformed_u24lambda_u241.start();
            }
            try {
                if (this.chatMessage.getTurnId() != null) {
                    String string = this.conversationService.getSessionController().getSession().getSource().getRpcValue();
                    String string2 = this.chatMessage.getTurnId();
                    Intrinsics.checkNotNull((Object)string2);
                    this.conversationService.copyCodeBlock(new CopyCodeBlockCommand(string, string2, this.codeBlockIndex, CopySource.TOOLBAR.getRpcValue(), codeBlockContents.length(), codeBlockContents.length(), (String)codeBlockContents, null, 128, null));
                }
            }
            catch (Exception e2) {
                this.log.warn("Failed to copy code block", e2);
            }
        }
    }

    private static final void actionPerformed$lambda$0(Notification $notification, ActionEvent it) {
        $notification.expire();
    }
}

