/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message.codeblock;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.conversation.agent.rpc.command.InsertCodeBlockCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.InsertSource;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.codeblock.CodeBlock;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/copilot/chat/message/codeblock/InsertCodeBlockAtCaretAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "codeBlockIndex", "", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "codeBlock", "Lcom/github/copilot/chat/message/codeblock/CodeBlock;", "conversationService", "Lcom/github/copilot/chat/conversation/ConversationService;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(ILcom/github/copilot/chat/message/ChatMessage;Lcom/github/copilot/chat/message/codeblock/CodeBlock;Lcom/github/copilot/chat/conversation/ConversationService;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getCodeBlock", "()Lcom/github/copilot/chat/message/codeblock/CodeBlock;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "formatCodeBlock", "", "content", "editor", "Lcom/intellij/openapi/editor/Editor;", "core"})
@SourceDebugExtension(value={"SMAP\nInsertCodeBlockAtCaretAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertCodeBlockAtCaretAction.kt\ncom/github/copilot/chat/message/codeblock/InsertCodeBlockAtCaretAction\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n39#2:103\n643#3,5:104\n1559#4:109\n1590#4,4:110\n*S KotlinDebug\n*F\n+ 1 InsertCodeBlockAtCaretAction.kt\ncom/github/copilot/chat/message/codeblock/InsertCodeBlockAtCaretAction\n*L\n23#1:103\n91#1:104,5\n94#1:109\n94#1:110,4\n*E\n"})
public final class InsertCodeBlockAtCaretAction
extends AnAction {
    private final int codeBlockIndex;
    @NotNull
    private final ChatMessage chatMessage;
    @NotNull
    private final CodeBlock codeBlock;
    @Nullable
    private final ConversationService conversationService;
    @NotNull
    private final Logger log;

    public InsertCodeBlockAtCaretAction(int codeBlockIndex, @NotNull ChatMessage chatMessage, @NotNull CodeBlock codeBlock, @Nullable ConversationService conversationService, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)codeBlock, (String)"codeBlock");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(CopilotBundle.get("copilot.chat.message.code.block.insert.action.title"), CopilotBundle.get("copilot.chat.message.code.block.insert.action.description"), CopilotIcons.Insert);
        this.codeBlockIndex = codeBlockIndex;
        this.chatMessage = chatMessage;
        this.codeBlock = codeBlock;
        this.conversationService = conversationService;
        this.log = log;
    }

    public /* synthetic */ InsertCodeBlockAtCaretAction(int n, ChatMessage chatMessage, CodeBlock codeBlock, ConversationService conversationService, Logger logger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(InsertCodeBlockAtCaretAction.class);
        }
        this(n, chatMessage, codeBlock, conversationService, logger);
    }

    @NotNull
    public final CodeBlock getCodeBlock() {
        return this.codeBlock;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.conversationService == null) {
            this.log.debug("Conversation service is null");
            return;
        }
        Project project = e.getProject();
        Editor editor = project != null ? ProjectKt.getCurrentEditor(project) : null;
        String string = this.codeBlock.getEditorTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String newContent = string;
        if (editor != null) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            Ref.IntRef offset = new Ref.IntRef();
            offset.element = caretModel2.getOffset();
            String formattedContent = this.formatCodeBlock(newContent, editor);
            WriteCommandAction.runWriteCommandAction((Project)e.getProject(), () -> InsertCodeBlockAtCaretAction.actionPerformed$lambda$0(editor, document2, offset, formattedContent));
            caretModel2.moveToOffset(offset.element + formattedContent.length());
        } else {
            this.log.debug("No editor found for project " + e.getProject());
        }
        if (this.chatMessage.getTurnId() != null) {
            String string2 = this.conversationService.getSessionController().getSession().getSource().getRpcValue();
            String string3 = this.chatMessage.getTurnId();
            Intrinsics.checkNotNull((Object)string3);
            String string4 = string3;
            int n = this.codeBlockIndex;
            int n2 = newContent.length();
            int n3 = newContent.length();
            String string5 = InsertSource.TOOLBAR.getRpcValue();
            this.conversationService.insertCodeBlock(new InsertCodeBlockCommand(string2, string4, n, n2, n3, false, string5, null, 128, null));
        } else {
            this.log.debug("Cannot insert code block without a turnId");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String formatCodeBlock(String content, Editor editor) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        String string;
        Object $this$takeWhile$iv;
        block3: {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int caretLine = document2.getLineNumber(editor.getCaretModel().getOffset());
            int lineStartOffset = document2.getLineStartOffset(caretLine);
            String string2 = document2.getText(new TextRange(lineStartOffset, editor.getCaretModel().getOffset()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String lineText = string2;
            $this$takeWhile$iv = lineText;
            boolean $i$f$takeWhile = false;
            int n = ((String)$this$takeWhile$iv).length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it22 = ((String)$this$takeWhile$iv).charAt(index$iv);
                int n2 = 0;
                if (CharsKt.isWhitespace((char)it22)) continue;
                Object it22 = $this$takeWhile$iv;
                n2 = 0;
                String string3 = ((String)it22).substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block3;
            }
            string = $this$takeWhile$iv;
        }
        String currentIndent = string;
        $this$takeWhile$iv = StringsKt.lines((CharSequence)content);
        boolean $i$f$mapIndexed = false;
        void index$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void line;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string4 = (String)item$iv$iv;
            int n3 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(index == false ? line : currentIndent + (String)line);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final void actionPerformed$lambda$0(Editor $editor, Document $document, Ref.IntRef $offset, String $formattedContent) {
        String selectedContent = $editor.getSelectionModel().getSelectedText();
        if (selectedContent != null) {
            $document.deleteString($editor.getSelectionModel().getSelectionStart(), $editor.getSelectionModel().getSelectionEnd());
            $offset.element = $editor.getSelectionModel().getSelectionStart();
        }
        $document.insertString($offset.element, (CharSequence)$formattedContent);
    }
}

