/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message.codeblock;

import com.github.copilot.CopilotBundle;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.codeblock.CodeBlock;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jediterm.terminal.TtyConnector;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/copilot/chat/message/codeblock/InsertIntoTerminalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "codeBlockIndex", "", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "codeBlock", "Lcom/github/copilot/chat/message/codeblock/CodeBlock;", "conversationService", "Lcom/github/copilot/chat/conversation/ConversationService;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(ILcom/github/copilot/chat/message/ChatMessage;Lcom/github/copilot/chat/message/codeblock/CodeBlock;Lcom/github/copilot/chat/conversation/ConversationService;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getCodeBlock", "()Lcom/github/copilot/chat/message/codeblock/CodeBlock;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "insertIntoTerminal", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "createNewTerminal", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "terminalManager", "Lorg/jetbrains/plugins/terminal/TerminalToolWindowManager;", "workingDirectory", "insertTextIntoTerminal", "widget", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nInsertIntoTerminalAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertIntoTerminalAction.kt\ncom/github/copilot/chat/message/codeblock/InsertIntoTerminalAction\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n39#2:128\n1549#3:129\n1620#3,3:130\n*S KotlinDebug\n*F\n+ 1 InsertIntoTerminalAction.kt\ncom/github/copilot/chat/message/codeblock/InsertIntoTerminalAction\n*L\n23#1:128\n108#1:129\n108#1:130,3\n*E\n"})
public final class InsertIntoTerminalAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int codeBlockIndex;
    @NotNull
    private final ChatMessage chatMessage;
    @NotNull
    private final CodeBlock codeBlock;
    @Nullable
    private final ConversationService conversationService;
    @NotNull
    private final Logger log;
    @NotNull
    private static final Set<String> SUPPORTED_SHELL_LANGUAGES;

    public InsertIntoTerminalAction(int codeBlockIndex, @NotNull ChatMessage chatMessage, @NotNull CodeBlock codeBlock, @Nullable ConversationService conversationService, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)codeBlock, (String)"codeBlock");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(CopilotBundle.get("copilot.chat.message.code.block.terminal.action.title"), CopilotBundle.get("copilot.chat.message.code.block.terminal.action.description"), AllIcons.Nodes.Console);
        this.codeBlockIndex = codeBlockIndex;
        this.chatMessage = chatMessage;
        this.codeBlock = codeBlock;
        this.conversationService = conversationService;
        this.log = log;
    }

    public /* synthetic */ InsertIntoTerminalAction(int n, ChatMessage chatMessage, CodeBlock codeBlock, ConversationService conversationService, Logger logger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(InsertIntoTerminalAction.class);
        }
        this(n, chatMessage, codeBlock, conversationService, logger);
    }

    @NotNull
    public final CodeBlock getCodeBlock() {
        return this.codeBlock;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.conversationService == null) {
            this.log.debug("Conversation service is null");
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = this.codeBlock.getEditorTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.insertIntoTerminal(project2, string);
    }

    private final void insertIntoTerminal(Project project, String text) {
        TerminalToolWindowManager terminalManager = TerminalToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Terminal");
        if (toolWindow == null) {
            InsertIntoTerminalAction $this$insertIntoTerminal_u24lambda_u240 = this;
            boolean bl = false;
            $this$insertIntoTerminal_u24lambda_u240.log.warn("Terminal window not found");
            return;
        }
        ToolWindow window = toolWindow;
        String string = project.getBasePath();
        if (string == null) {
            string = "";
        }
        String workingDirectory = string;
        window.activate(() -> InsertIntoTerminalAction.insertIntoTerminal$lambda$4(window, this, terminalManager, workingDirectory, text));
    }

    private final ShellTerminalWidget createNewTerminal(TerminalToolWindowManager terminalManager, String workingDirectory) {
        ShellTerminalWidget shellTerminalWidget = terminalManager.createLocalShellWidget(workingDirectory, "Copilot Terminal", true, true);
        Intrinsics.checkNotNullExpressionValue((Object)shellTerminalWidget, (String)"createLocalShellWidget(...)");
        return shellTerminalWidget;
    }

    /*
     * WARNING - void declaration
     */
    private final void insertTextIntoTerminal(ShellTerminalWidget widget, String text) {
        try {
            void $this$mapTo$iv$iv;
            Object object;
            block9: {
                block8: {
                    object = widget.getShellCommand();
                    if (object == null || (object = (String)CollectionsKt.firstOrNull((List)object)) == null) break block8;
                    String string = ((String)object).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    object = string;
                    if (string != null) break block9;
                }
                object = "";
            }
            Object shellType = object;
            Iterable $this$map$iv = StringsKt.lines((CharSequence)text);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                char[] cArray = new char[]{'\\', '`', '|'};
                collection.add(StringsKt.trimEnd((String)it, (char[])cArray));
            }
            List lines = (List)destination$iv$iv;
            Object textToInsert = StringsKt.contains$default((CharSequence)((CharSequence)shellType), (CharSequence)"powershell", (boolean)false, (int)2, null) ? CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\r\n", null, null, (int)0, null, null, (int)62, null) : "\u001b[200~" + CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\u001b[201~";
            TtyConnector ttyConnector = widget.getTtyConnector();
            if (ttyConnector != null) {
                ttyConnector.write((String)textToInsert);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to insert text into terminal", e);
        }
    }

    private static final void insertIntoTerminal$lambda$4$lambda$2(InsertIntoTerminalAction this$0, ShellTerminalWidget $widget, String $text, ActionEvent actionEvent) {
        this$0.insertTextIntoTerminal($widget, $text);
    }

    private static final void insertIntoTerminal$lambda$4(ToolWindow $window, InsertIntoTerminalAction this$0, TerminalToolWindowManager $terminalManager, String $workingDirectory, String $text) {
        Timer timer;
        ShellTerminalWidget shellTerminalWidget;
        ShellTerminalWidget shellTerminalWidget2;
        ContentManager contentManager = $window.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.getSelectedContent();
        if (content != null) {
            Content content2 = content;
            boolean bl = false;
            JBTerminalWidget jBTerminalWidget = TerminalToolWindowManager.getWidgetByContent((Content)content2);
            shellTerminalWidget2 = jBTerminalWidget instanceof ShellTerminalWidget ? (ShellTerminalWidget)jBTerminalWidget : null;
        } else {
            shellTerminalWidget2 = null;
        }
        ShellTerminalWidget currentWidget = shellTerminalWidget2;
        if (currentWidget == null) {
            Intrinsics.checkNotNull((Object)$terminalManager);
            shellTerminalWidget = this$0.createNewTerminal($terminalManager, $workingDirectory);
        } else if (currentWidget.hasRunningCommands()) {
            Intrinsics.checkNotNull((Object)$terminalManager);
            shellTerminalWidget = this$0.createNewTerminal($terminalManager, $workingDirectory);
        } else {
            shellTerminalWidget = currentWidget;
        }
        ShellTerminalWidget widget = shellTerminalWidget;
        Timer $this$insertIntoTerminal_u24lambda_u244_u24lambda_u243 = timer = new Timer(500, arg_0 -> InsertIntoTerminalAction.insertIntoTerminal$lambda$4$lambda$2(this$0, widget, $text, arg_0));
        boolean bl = false;
        $this$insertIntoTerminal_u24lambda_u244_u24lambda_u243.setRepeats(false);
        $this$insertIntoTerminal_u24lambda_u244_u24lambda_u243.start();
    }

    static {
        Object[] objectArray = new String[]{"sh", "shell", "bash", "zsh", "fish", "cmd", "command", "terminal", "console", "powershell", "pwsh", "ps1"};
        SUPPORTED_SHELL_LANGUAGES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/copilot/chat/message/codeblock/InsertIntoTerminalAction$Companion;", "", "<init>", "()V", "SUPPORTED_SHELL_LANGUAGES", "", "", "isShellCommand", "", "language", "core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isShellCommand(@Nullable String language) {
            CharSequence charSequence = language;
            if (charSequence == null) return false;
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                return false;
            }
            boolean bl = false;
            if (bl) return false;
            Set set = SUPPORTED_SHELL_LANGUAGES;
            String string = language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (!set.contains(((Object)StringsKt.trim((CharSequence)string)).toString())) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

