/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message.references;

import com.github.copilot.chat.conversation.agent.rpc.FileReference;
import com.github.copilot.chat.conversation.agent.rpc.Position;
import com.github.copilot.chat.conversation.agent.rpc.Range;
import com.github.copilot.chat.conversation.agent.rpc.Reference;
import com.github.copilot.chat.conversation.agent.rpc.UnknownReference;
import com.github.copilot.chat.conversation.agent.rpc.WebSearchReference;
import com.github.copilot.chat.conversation.agent.rpc.WebSearchResult;
import com.github.copilot.chat.message.references.ChatReference;
import com.github.copilot.chat.message.references.FileChatReference;
import com.github.copilot.chat.message.references.FileChatReferencePosition;
import com.github.copilot.chat.message.references.FileChatReferenceRange;
import com.github.copilot.chat.message.references.WebSearchChatReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003*\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\u0014\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u000f0\u0001j\u0002`\u0010*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u000f*\u00020\u0013\u00a8\u0006\u0014"}, d2={"toChatReferences", "", "Lcom/github/copilot/chat/message/references/ChatReference;", "Lcom/github/copilot/chat/message/references/ChatReferences;", "Lcom/github/copilot/chat/conversation/agent/rpc/Reference;", "toFileChatReference", "Lcom/github/copilot/chat/message/references/FileChatReference;", "Lcom/github/copilot/chat/conversation/agent/rpc/FileReference;", "toFileChatReferenceRange", "Lcom/github/copilot/chat/message/references/FileChatReferenceRange;", "Lcom/github/copilot/chat/conversation/agent/rpc/Range;", "toFileChatReferencePosition", "Lcom/github/copilot/chat/message/references/FileChatReferencePosition;", "Lcom/github/copilot/chat/conversation/agent/rpc/Position;", "toWebSearchChatReferences", "Lcom/github/copilot/chat/message/references/WebSearchChatReference;", "Lcom/github/copilot/chat/message/references/WebSearchChatReferences;", "Lcom/github/copilot/chat/conversation/agent/rpc/WebSearchReference;", "toWebSearchChatReference", "Lcom/github/copilot/chat/conversation/agent/rpc/WebSearchResult;", "core"})
@SourceDebugExtension(value={"SMAP\nChatReferenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatReferenceUtils.kt\ncom/github/copilot/chat/message/references/ChatReferenceUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1855#2,2:52\n1549#2:54\n1620#2,3:55\n*S KotlinDebug\n*F\n+ 1 ChatReferenceUtils.kt\ncom/github/copilot/chat/message/references/ChatReferenceUtilsKt\n*L\n17#1:52,2\n48#1:54\n48#1:55,3\n*E\n"})
public final class ChatReferenceUtilsKt {
    @NotNull
    public static final List<ChatReference> toChatReferences(@NotNull List<? extends Reference> $this$toChatReferences) {
        Intrinsics.checkNotNullParameter($this$toChatReferences, (String)"<this>");
        List references = new ArrayList();
        Iterable $this$forEach$iv = $this$toChatReferences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Reference rpcReference = (Reference)element$iv;
            boolean bl = false;
            Reference reference = rpcReference;
            if (reference instanceof FileReference) {
                references.add(ChatReferenceUtilsKt.toFileChatReference((FileReference)rpcReference));
                continue;
            }
            if (reference instanceof WebSearchReference) {
                references.addAll((Collection)ChatReferenceUtilsKt.toWebSearchChatReferences((WebSearchReference)rpcReference));
                continue;
            }
            if (reference instanceof UnknownReference) continue;
            throw new NoWhenBranchMatchedException();
        }
        return references;
    }

    @NotNull
    public static final FileChatReference toFileChatReference(@NotNull FileReference $this$toFileChatReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toFileChatReference, (String)"<this>");
        Range range = $this$toFileChatReference.getRange();
        return new FileChatReference($this$toFileChatReference.getUri(), range != null ? ChatReferenceUtilsKt.toFileChatReferenceRange(range) : null);
    }

    @NotNull
    public static final FileChatReferenceRange toFileChatReferenceRange(@NotNull Range $this$toFileChatReferenceRange) {
        Intrinsics.checkNotNullParameter((Object)$this$toFileChatReferenceRange, (String)"<this>");
        return new FileChatReferenceRange(ChatReferenceUtilsKt.toFileChatReferencePosition($this$toFileChatReferenceRange.getStart()), ChatReferenceUtilsKt.toFileChatReferencePosition($this$toFileChatReferenceRange.getEnd()));
    }

    @NotNull
    public static final FileChatReferencePosition toFileChatReferencePosition(@NotNull Position $this$toFileChatReferencePosition) {
        Intrinsics.checkNotNullParameter((Object)$this$toFileChatReferencePosition, (String)"<this>");
        return new FileChatReferencePosition($this$toFileChatReferencePosition.getLine(), $this$toFileChatReferencePosition.getCharacter());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<WebSearchChatReference> toWebSearchChatReferences(@NotNull WebSearchReference $this$toWebSearchChatReferences) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toWebSearchChatReferences, (String)"<this>");
        List<WebSearchResult> list2 = $this$toWebSearchChatReferences.getData().getResults();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WebSearchResult webSearchResult = (WebSearchResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ChatReferenceUtilsKt.toWebSearchChatReference((WebSearchResult)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final WebSearchChatReference toWebSearchChatReference(@NotNull WebSearchResult $this$toWebSearchChatReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toWebSearchChatReference, (String)"<this>");
        return new WebSearchChatReference($this$toWebSearchChatReference.getUrl());
    }
}

