/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.message.references;

import com.github.copilot.chat.message.references.ChatReference;
import com.github.copilot.chat.message.references.ChatReferenceComponent;
import com.github.copilot.chat.message.references.FileChatReference;
import com.github.copilot.chat.message.references.FileChatReferenceComponentKt;
import com.github.copilot.chat.message.references.WebSearchChatReference;
import com.github.copilot.chat.message.references.WebSearchChatReferenceComponentKt;
import com.github.copilot.platform.utils.ApplicationKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/copilot/chat/message/references/ChatReferencesListPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "references", "", "Lcom/github/copilot/chat/message/references/ChatReference;", "Lcom/github/copilot/chat/message/references/ChatReferences;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "gridBagConstraints", "Ljava/awt/GridBagConstraints;", "addFileReference", "", "reference", "Lcom/github/copilot/chat/message/references/FileChatReference;", "(Lcom/github/copilot/chat/message/references/FileChatReference;)Lkotlin/Unit;", "addWebSearchReference", "Lcom/github/copilot/chat/message/references/WebSearchChatReference;", "core"})
@SourceDebugExtension(value={"SMAP\nChatReferencesListPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatReferencesListPanel.kt\ncom/github/copilot/chat/message/references/ChatReferencesListPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1855#2,2:45\n1#3:47\n*S KotlinDebug\n*F\n+ 1 ChatReferencesListPanel.kt\ncom/github/copilot/chat/message/references/ChatReferencesListPanel\n*L\n27#1:45,2\n*E\n"})
public final class ChatReferencesListPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final GridBagConstraints gridBagConstraints;

    public ChatReferencesListPanel(@NotNull Project project, @NotNull List<? extends ChatReference> references) {
        GridBagConstraints gridBagConstraints;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        super(new GridBagLayout());
        this.project = project;
        GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
        ChatReferencesListPanel chatReferencesListPanel = this;
        boolean bl = false;
        $this$gridBagConstraints_u24lambda_u240.gridx = 0;
        $this$gridBagConstraints_u24lambda_u240.gridy = -1;
        $this$gridBagConstraints_u24lambda_u240.fill = 2;
        $this$gridBagConstraints_u24lambda_u240.weightx = 1.0;
        $this$gridBagConstraints_u24lambda_u240.insets = (Insets)JBUI.insetsTop((int)4);
        chatReferencesListPanel.gridBagConstraints = gridBagConstraints;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        Iterable $this$forEach$iv = references;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatReference reference = (ChatReference)element$iv;
            boolean bl2 = false;
            ChatReference chatReference = reference;
            if (chatReference instanceof FileChatReference) {
                this.addFileReference((FileChatReference)reference);
                continue;
            }
            if (chatReference instanceof WebSearchChatReference) {
                this.addWebSearchReference((WebSearchChatReference)reference);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final Unit addFileReference(FileChatReference reference) {
        Unit unit;
        ChatReferenceComponent chatReferenceComponent = FileChatReferenceComponentKt.FileChatReferenceComponent(this.project, reference);
        if (chatReferenceComponent != null) {
            ChatReferenceComponent it = chatReferenceComponent;
            boolean bl = false;
            ApplicationKt.runOnEdt((Function0<Unit>)((Function0)() -> ChatReferencesListPanel.addFileReference$lambda$3$lambda$2(this, it)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void addWebSearchReference(WebSearchChatReference reference) {
        ChatReferenceComponent it = WebSearchChatReferenceComponentKt.WebSearchChatReferenceComponent(reference);
        boolean bl = false;
        ApplicationKt.runOnEdt((Function0<Unit>)((Function0)() -> ChatReferencesListPanel.addWebSearchReference$lambda$5$lambda$4(this, it)));
    }

    private static final Unit addFileReference$lambda$3$lambda$2(ChatReferencesListPanel this$0, ChatReferenceComponent $it) {
        this$0.add((Component)$it, this$0.gridBagConstraints);
        return Unit.INSTANCE;
    }

    private static final Unit addWebSearchReference$lambda$5$lambda$4(ChatReferencesListPanel this$0, ChatReferenceComponent $it) {
        this$0.add((Component)$it, this$0.gridBagConstraints);
        return Unit.INSTANCE;
    }
}

