/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.precondition;

import com.github.copilot.chat.precondition.ChatEnabledPrecondition;
import com.github.copilot.chat.precondition.ChatPreconditionStatus;
import com.github.copilot.chat.precondition.ChatPreconditionsKt;
import com.github.copilot.chat.precondition.ChatTokenPrecondition;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/github/copilot/chat/precondition/ChatPreconditions;", "", "status", "Lcom/github/copilot/chat/precondition/ChatPreconditionStatus;", "token", "Lcom/github/copilot/chat/precondition/ChatTokenPrecondition;", "chatEnabled", "Lcom/github/copilot/chat/precondition/ChatEnabledPrecondition;", "<init>", "(Lcom/github/copilot/chat/precondition/ChatPreconditionStatus;Lcom/github/copilot/chat/precondition/ChatTokenPrecondition;Lcom/github/copilot/chat/precondition/ChatEnabledPrecondition;)V", "getStatus", "()Lcom/github/copilot/chat/precondition/ChatPreconditionStatus;", "getToken", "()Lcom/github/copilot/chat/precondition/ChatTokenPrecondition;", "getChatEnabled", "()Lcom/github/copilot/chat/precondition/ChatEnabledPrecondition;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "core"})
public final class ChatPreconditions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatPreconditionStatus status;
    @NotNull
    private final ChatTokenPrecondition token;
    @NotNull
    private final ChatEnabledPrecondition chatEnabled;
    @NotNull
    private static final ChatPreconditions UNKNOWN = new ChatPreconditions(ChatPreconditionStatus.UNKNOWN, ChatTokenPrecondition.Companion.getUNKNOWN(), ChatEnabledPrecondition.Companion.getUNKNOWN());

    public ChatPreconditions(@NotNull ChatPreconditionStatus status, @NotNull ChatTokenPrecondition token, @NotNull ChatEnabledPrecondition chatEnabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)chatEnabled, (String)"chatEnabled");
        this.status = status;
        this.token = token;
        this.chatEnabled = chatEnabled;
    }

    @NotNull
    public final ChatPreconditionStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final ChatTokenPrecondition getToken() {
        return this.token;
    }

    @NotNull
    public final ChatEnabledPrecondition getChatEnabled() {
        return this.chatEnabled;
    }

    @NotNull
    public final ChatPreconditionStatus status() {
        return ChatPreconditionsKt.isChatEnabled(this) && !this.token.getStatus().isFailed() ? ChatPreconditionStatus.OK : (this.chatEnabled.getStatus().isUnknown() ? ChatPreconditionStatus.UNKNOWN : ChatPreconditionStatus.FAILED);
    }

    @NotNull
    public final ChatPreconditionStatus component1() {
        return this.status;
    }

    @NotNull
    public final ChatTokenPrecondition component2() {
        return this.token;
    }

    @NotNull
    public final ChatEnabledPrecondition component3() {
        return this.chatEnabled;
    }

    @NotNull
    public final ChatPreconditions copy(@NotNull ChatPreconditionStatus status, @NotNull ChatTokenPrecondition token, @NotNull ChatEnabledPrecondition chatEnabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)chatEnabled, (String)"chatEnabled");
        return new ChatPreconditions(status, token, chatEnabled);
    }

    public static /* synthetic */ ChatPreconditions copy$default(ChatPreconditions chatPreconditions, ChatPreconditionStatus chatPreconditionStatus, ChatTokenPrecondition chatTokenPrecondition, ChatEnabledPrecondition chatEnabledPrecondition, int n, Object object) {
        if ((n & 1) != 0) {
            chatPreconditionStatus = chatPreconditions.status;
        }
        if ((n & 2) != 0) {
            chatTokenPrecondition = chatPreconditions.token;
        }
        if ((n & 4) != 0) {
            chatEnabledPrecondition = chatPreconditions.chatEnabled;
        }
        return chatPreconditions.copy(chatPreconditionStatus, chatTokenPrecondition, chatEnabledPrecondition);
    }

    @NotNull
    public String toString() {
        return "ChatPreconditions(status=" + this.status + ", token=" + this.token + ", chatEnabled=" + this.chatEnabled + ")";
    }

    public int hashCode() {
        int result = this.status.hashCode();
        result = result * 31 + this.token.hashCode();
        result = result * 31 + this.chatEnabled.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatPreconditions)) {
            return false;
        }
        ChatPreconditions chatPreconditions = (ChatPreconditions)other;
        if (this.status != chatPreconditions.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.token, (Object)chatPreconditions.token)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.chatEnabled, (Object)chatPreconditions.chatEnabled);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/copilot/chat/precondition/ChatPreconditions$Companion;", "", "<init>", "()V", "UNKNOWN", "Lcom/github/copilot/chat/precondition/ChatPreconditions;", "getUNKNOWN", "()Lcom/github/copilot/chat/precondition/ChatPreconditions;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChatPreconditions getUNKNOWN() {
            return UNKNOWN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

