/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.precondition;

import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClient;
import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClientKt;
import com.github.copilot.chat.conversation.agent.rpc.Preconditions;
import com.github.copilot.chat.precondition.ChatPreconditions;
import com.github.copilot.chat.precondition.ChatPreconditionsListener;
import com.github.copilot.chat.precondition.ChatPreconditionsService;
import com.github.copilot.chat.precondition.ChatPreconditionsSubscription;
import com.github.copilot.chat.precondition.ChatPreconditionsUtilKt;
import com.github.copilot.lang.agent.NotSignedInException;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.platform.utils.PromiseKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.util.CoroutineScopeUtilsKt;
import io.ktor.util.collections.ConcurrentMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0014\u001a\u00020\u000f2\"\u0010\u0015\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0016J/\u0010\u001d\u001a\u000b\u0012\u0002\b\u00030\u001e\u00a2\u0006\u0002\b\u001f2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/github/copilot/chat/precondition/PreconditionsService;", "Lcom/github/copilot/chat/precondition/ChatPreconditionsService;", "<init>", "()V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "log", "Lcom/github/copilot/platform/utils/observability/GitHubLogger;", "conversationClient", "Lcom/github/copilot/chat/conversation/agent/CopilotAgentConversationClient;", "subscribers", "Lio/ktor/util/collections/ConcurrentMap;", "", "Lkotlin/Function1;", "Lcom/github/copilot/chat/precondition/ChatPreconditions;", "", "value", "preconditions", "setPreconditions", "(Lcom/github/copilot/chat/precondition/ChatPreconditions;)V", "refreshPreconditions", "onComplete", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function2;)V", "subscribeToPreconditions", "Lcom/github/copilot/chat/precondition/ChatPreconditionsSubscription;", "subscriber", "getPreconditions", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/annotations/NotNull;", "forceCheck", "", "timeoutMs", "", "retryAttempts", "initPreconditionsListener", "core"})
@SourceDebugExtension(value={"SMAP\nChatPreconditionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPreconditionsService.kt\ncom/github/copilot/chat/precondition/PreconditionsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,127:1\n1855#2,2:128\n39#3:130\n*S KotlinDebug\n*F\n+ 1 ChatPreconditionsService.kt\ncom/github/copilot/chat/precondition/PreconditionsService\n*L\n43#1:128,2\n33#1:130\n*E\n"})
final class PreconditionsService
implements ChatPreconditionsService {
    @NotNull
    public static final PreconditionsService INSTANCE = new PreconditionsService();
    @NotNull
    private static final CoroutineScope scope = CoroutineScopeUtilsKt.CoroutineScope$default("PreconditionsService", null, null, 6, null);
    @NotNull
    private static final GitHubLogger log;
    @NotNull
    private static final CopilotAgentConversationClient conversationClient;
    @NotNull
    private static final ConcurrentMap<String, Function1<ChatPreconditions, Unit>> subscribers;
    @NotNull
    private static ChatPreconditions preconditions;

    private PreconditionsService() {
    }

    private final void setPreconditions(ChatPreconditions value) {
        if (!Intrinsics.areEqual((Object)value, (Object)preconditions)) {
            preconditions = value;
            Iterable $this$forEach$iv = subscribers.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)preconditions);
            }
        }
    }

    @Override
    public void refreshPreconditions(@NotNull Function2<? super ChatPreconditions, ? super Continuation<? super Unit>, ? extends Object> onComplete) {
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onComplete, null){
            int label;
            final /* synthetic */ Function2<ChatPreconditions, Continuation<? super Unit>, Object> $onComplete;
            {
                this.$onComplete = $onComplete;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        requestTimeout = 10000;
                        requestRetryAttempts = 3;
                        future = PreconditionsService.access$getPreconditions(PreconditionsService.INSTANCE, true, requestTimeout, requestRetryAttempts);
                        this.label = 1;
                        v0 = TimeoutKt.withTimeoutOrNull((long)(requestTimeout * requestRetryAttempts), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(future, null){
                            int label;
                            final /* synthetic */ Future<?> $future;
                            {
                                this.$future = $future;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 3 sources

                                        while (!this.$future.isDone()) {
                                            this.label = 1;
                                            v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                            if (v0 != var2_2) continue;
                                            return var2_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl5
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.label = 2;
                        v1 = this.$onComplete.invoke((Object)PreconditionsService.access$getPreconditions$p(), (Object)this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    @NotNull
    public ChatPreconditionsSubscription subscribeToPreconditions(@NotNull Function1<? super ChatPreconditions, Unit> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        subscriber.invoke((Object)preconditions);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        ((Map)subscribers).put(id, subscriber);
        return new ChatPreconditionsSubscription(id){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
            }

            public void unsubscribe() {
                PreconditionsService.access$getSubscribers$p().remove((Object)this.$id);
            }
        };
    }

    private final Future<?> getPreconditions(boolean forceCheck, int timeoutMs, int retryAttempts) {
        return ApplicationKt.runOnPooledThread(() -> PreconditionsService.getPreconditions$lambda$1(retryAttempts, forceCheck, timeoutMs));
    }

    static /* synthetic */ Future getPreconditions$default(PreconditionsService preconditionsService, boolean bl, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            bl = false;
        }
        if ((n3 & 2) != 0) {
            n = 10000;
        }
        if ((n3 & 4) != 0) {
            n2 = 3;
        }
        return preconditionsService.getPreconditions(bl, n, n2);
    }

    private final void initPreconditionsListener() {
        ChatPreconditionsListener.Companion.onPreconditions((Function1<? super ChatPreconditions, Unit>)((Function1)PreconditionsService::initPreconditionsListener$lambda$2));
    }

    private static final void getPreconditions$lambda$1(int $retryAttempts, boolean $forceCheck, int $timeoutMs) {
        int retryAttempt = 0;
        while (retryAttempt < $retryAttempts) {
            try {
                CancellablePromise<Preconditions> promise = conversationClient.checkPreconditions($forceCheck);
                Preconditions response = (Preconditions)promise.blockingGet($timeoutMs);
                if (PromiseKt.isSuccess((Promise)promise) && response != null) {
                    INSTANCE.setPreconditions(ChatPreconditionsUtilKt.toChatPreconditions(response));
                    break;
                }
            }
            catch (NotSignedInException e) {
                break;
            }
            catch (Throwable e) {
                log.warn("Error occurred trying to get preconditions", e);
            }
            if (++retryAttempt != $retryAttempts) continue;
            INSTANCE.setPreconditions(ChatPreconditions.Companion.getUNKNOWN());
        }
    }

    private static final Unit initPreconditionsListener$lambda$2(ChatPreconditions it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.setPreconditions(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Future access$getPreconditions(PreconditionsService $this, boolean forceCheck, int timeoutMs, int retryAttempts) {
        return $this.getPreconditions(forceCheck, timeoutMs, retryAttempts);
    }

    public static final /* synthetic */ ChatPreconditions access$getPreconditions$p() {
        return preconditions;
    }

    public static final /* synthetic */ ConcurrentMap access$getSubscribers$p() {
        return subscribers;
    }

    static {
        boolean $i$f$Logger = false;
        log = new GitHubLogger(PreconditionsService.class);
        conversationClient = CopilotAgentConversationClientKt.CopilotAgentConversationClient();
        subscribers = new ConcurrentMap(0, 1, null);
        preconditions = ChatPreconditions.Companion.getUNKNOWN();
        PreconditionsService.getPreconditions$default(INSTANCE, false, 0, 0, 7, null);
        INSTANCE.initPreconditionsListener();
    }
}

