/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.rating;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.ChatMessageRating;
import com.github.copilot.chat.rating.MessageRatingListener;
import com.github.copilot.platform.action.MutuallyExclusiveToggleAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/github/copilot/chat/rating/HelpfulAction;", "Lcom/github/copilot/platform/action/MutuallyExclusiveToggleAction;", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "conversationService", "Lcom/github/copilot/chat/conversation/ConversationService;", "<init>", "(Lcom/github/copilot/chat/message/ChatMessage;Lcom/github/copilot/chat/conversation/ConversationService;)V", "getConversationService", "()Lcom/github/copilot/chat/conversation/ConversationService;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "onSelected", "", "core"})
public final class HelpfulAction
extends MutuallyExclusiveToggleAction {
    @NotNull
    private final ChatMessage chatMessage;
    @NotNull
    private final ConversationService conversationService;

    public HelpfulAction(@NotNull ChatMessage chatMessage, @NotNull ConversationService conversationService) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)conversationService, (String)"conversationService");
        super(CopilotBundle.get("copilot.chat.message.helpful"), CopilotBundle.get("copilot.chat.message.helpful.description"), CopilotIcons.Like, null, 8, null);
        this.chatMessage = chatMessage;
        this.conversationService = conversationService;
    }

    @NotNull
    public final ConversationService getConversationService() {
        return this.conversationService;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Override
    public void onSelected() {
        this.getLog().debug("Rating chat message " + this.chatMessage.getTurnId() + " as helpful}");
        this.chatMessage.setRating(ChatMessageRating.HELPFUL);
        this.conversationService.rateChatMessage(this.chatMessage);
        MessageRatingListener.Companion.onRating(this.chatMessage);
    }
}

