/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.references;

import com.github.copilot.chat.references.FileSearchResult;
import com.github.copilot.chat.references.FileSearchService;
import com.github.copilot.chat.references.FileSearchServiceKt;
import com.github.copilot.chat.references.FileSource;
import com.github.copilot.chat.references.SearchResultsFilter;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.VirtualFileKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ConcurrencyUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b*.\u0010\u0000\"\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001\u00a8\u0006\t"}, d2={"FileSearchResultsConsumer", "Lkotlin/Function1;", "", "Lcom/github/copilot/chat/references/FileSearchResult;", "", "FileSearchService", "Lcom/github/copilot/chat/references/FileSearchService;", "project", "Lcom/intellij/openapi/project/Project;", "core"})
public final class FileSearchServiceKt {
    @NotNull
    public static final FileSearchService FileSearchService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new FileSearchService(project){
            private final FileSearchEverywhereContributor projectSearchService;
            private final FileSearchEverywhereContributor librariesSearchService;
            private final SearchResultsFilter searchResultsFilter;
            private ProgressIndicator previousProjectSearchProgressIndicator;
            private ProgressIndicator previousLibrariesSearchProgressIndicator;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                this.projectSearchService = this.searchService(ProjectKt.getProjectScope($project));
                this.librariesSearchService = this.searchService(ProjectKt.getLibrariesScope($project));
                this.searchResultsFilter = new SearchResultsFilter($project);
            }

            public List<FileSearchResult> getOpenFiles(int limit, Set<String> excludedUris) {
                Intrinsics.checkNotNullParameter(excludedUris, (String)"excludedUris");
                List openFiles = new ArrayList<E>();
                for (VirtualFile openFile : FileEditorManager.getInstance((Project)this.$project).getOpenFiles()) {
                    Intrinsics.checkNotNull((Object)openFile);
                    if (!excludedUris.contains(VirtualFileKt.getUri(openFile))) {
                        openFiles.add(this.toFileSearchResult(openFile));
                    }
                    if (openFiles.size() >= limit) break;
                }
                return openFiles;
            }

            public ProgressIndicator search(String query2, int resultsLimit, Set<String> excludedUris, Function1<? super List<FileSearchResult>, Unit> resultConsumer) {
                ProgressIndicator progressIndicator;
                Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
                Intrinsics.checkNotNullParameter(excludedUris, (String)"excludedUris");
                Intrinsics.checkNotNullParameter(resultConsumer, (String)"resultConsumer");
                this.cancelPreviousSearch();
                List searchResults = new ArrayList<E>();
                ProgressIndicator $this$search_u24lambda_u243 = progressIndicator = this.search(this.projectSearchService, FileSource.PROJECT, query2, resultsLimit, excludedUris, (Function1<? super List<FileSearchResult>, Unit>)((Function1)arg_0 -> FileSearchService.1.search$lambda$2(searchResults, resultsLimit, this, query2, excludedUris, resultConsumer, arg_0)));
                boolean bl = false;
                this.previousProjectSearchProgressIndicator = $this$search_u24lambda_u243;
                return progressIndicator;
            }

            private final void cancelPreviousSearch() {
                block1: {
                    ProgressIndicator progressIndicator = this.previousLibrariesSearchProgressIndicator;
                    if (progressIndicator != null) {
                        progressIndicator.cancel();
                    }
                    ProgressIndicator progressIndicator2 = this.previousProjectSearchProgressIndicator;
                    if (progressIndicator2 == null) break block1;
                    progressIndicator2.cancel();
                }
            }

            private final ProgressIndicator search(FileSearchEverywhereContributor $this$search, FileSource source, String query2, int resultsLimit, Set<String> excludedUris, Function1<? super List<FileSearchResult>, Unit> resultConsumer) {
                EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
                if ($this$search == null) {
                    EmptyProgressIndicator emptyProgressIndicator;
                    EmptyProgressIndicator $this$search_u24lambda_u244 = emptyProgressIndicator = progressIndicator;
                    boolean bl = false;
                    $this$search_u24lambda_u244.cancel();
                    return (ProgressIndicator)emptyProgressIndicator;
                }
                Runnable runnable = ConcurrencyUtil.underThreadNameRunnable((String)"Copilot Chat File Search", () -> FileSearchService.1.search$lambda$8($this$search, query2, progressIndicator, resultsLimit, excludedUris, resultConsumer, this, source));
                Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"underThreadNameRunnable(...)");
                Runnable searchTask = runnable;
                ApplicationKt.runOnPooledThread(searchTask);
                return (ProgressIndicator)progressIndicator;
            }

            private final FileSearchEverywhereContributor searchService(GlobalSearchScope $this$searchService) {
                return (FileSearchEverywhereContributor)ApplicationKt.runOnEdtAndWait(() -> FileSearchService.1.searchService$lambda$10(this.$project, $this$searchService));
            }

            private final FileSearchResult toFileSearchResult(PsiFileSystemItem $this$toFileSearchResult, FileSource source) {
                Icon icon = $this$toFileSearchResult.getIcon(0);
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
                Icon icon2 = icon;
                VirtualFile virtualFile = $this$toFileSearchResult.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                VirtualFile virtualFile2 = virtualFile;
                String string = $this$toFileSearchResult.getVirtualFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string;
                VirtualFile virtualFile3 = $this$toFileSearchResult.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
                String string3 = this.getPresentablePath(virtualFile3);
                return new FileSearchResult(source, virtualFile2, icon2, string2, string3);
            }

            private final FileSearchResult toFileSearchResult(VirtualFile $this$toFileSearchResult) {
                FileSource fileSource = ProjectFileIndex.getInstance((Project)this.$project).isInSourceContent($this$toFileSearchResult) ? FileSource.PROJECT : FileSource.LIBRARY;
                Object object = PsiManager.getInstance((Project)this.$project).findFile($this$toFileSearchResult);
                if (object == null || (object = object.getIcon(0)) == null) {
                    Icon icon = AllIcons.FileTypes.Text;
                    object = icon;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Text");
                }
                String string = $this$toFileSearchResult.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return new FileSearchResult(fileSource, $this$toFileSearchResult, (Icon)object, string, this.getPresentablePath($this$toFileSearchResult));
            }

            private final String getPresentablePath(VirtualFile $this$presentablePath) {
                String string;
                block6: {
                    block5: {
                        String string2;
                        string = this.$project.getBasePath();
                        if (string == null) break block5;
                        String basePath = string;
                        boolean bl = false;
                        if ($this$presentablePath.getParent() != null && Intrinsics.areEqual((Object)basePath, (Object)$this$presentablePath.getParent().getPath())) {
                            string2 = $this$presentablePath.getName();
                        } else {
                            String string3 = $this$presentablePath.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                            string2 = StringsKt.removePrefix((String)string3, (CharSequence)basePath);
                        }
                        string = string2;
                        if (string2 != null) break block6;
                    }
                    String string4 = $this$presentablePath.getPath();
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                }
                return string;
            }

            private static final Unit search$lambda$2$lambda$0(List $searchResults, Function1 $resultConsumer, List it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $searchResults.addAll(it);
                $resultConsumer.invoke((Object)$searchResults);
                return Unit.INSTANCE;
            }

            private static final Unit search$lambda$2(List $searchResults, int $resultsLimit, FileSearchService.1 this$0, String $query, Set $excludedUris, Function1 $resultConsumer, List projectResults) {
                Intrinsics.checkNotNullParameter((Object)projectResults, (String)"projectResults");
                $searchResults.addAll(projectResults);
                if ($searchResults.size() < $resultsLimit) {
                    ProgressIndicator progressIndicator;
                    ProgressIndicator $this$search_u24lambda_u242_u24lambda_u241 = progressIndicator = this$0.search(this$0.librariesSearchService, FileSource.LIBRARY, $query, $resultsLimit - $searchResults.size(), $excludedUris, (Function1<? super List<FileSearchResult>, Unit>)((Function1)arg_0 -> FileSearchService.1.search$lambda$2$lambda$0($searchResults, $resultConsumer, arg_0)));
                    boolean bl = false;
                    this$0.previousLibrariesSearchProgressIndicator = $this$search_u24lambda_u242_u24lambda_u241;
                } else {
                    $resultConsumer.invoke((Object)$searchResults);
                }
                return Unit.INSTANCE;
            }

            private static final Unit search$lambda$8$lambda$7$lambda$6(Object $it, Set $excludedUris, FileSearchService.1 this$0, List $results, FileSource $source) {
                block1: {
                    PsiFileSystemItem psiFileSystemItem = $it instanceof PsiFileSystemItem ? (PsiFileSystemItem)$it : null;
                    if (psiFileSystemItem == null) break block1;
                    PsiFileSystemItem result = psiFileSystemItem;
                    boolean bl = false;
                    VirtualFile virtualFile = result.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    if (!$excludedUris.contains(VirtualFileKt.getUri(virtualFile)) && this$0.searchResultsFilter.isNotExcluded(result)) {
                        $results.add(this$0.toFileSearchResult(result, $source));
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void search$lambda$8(FileSearchEverywhereContributor $this_search, String $query, EmptyProgressIndicator $progressIndicator, int $resultsLimit, Set $excludedUris, Function1 $resultConsumer, FileSearchService.1 this$0, FileSource $source) {
                List results = new ArrayList<E>();
                List list = $this_search.search($query, (ProgressIndicator)$progressIndicator, $resultsLimit + $excludedUris.size()).getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    ApplicationKt.runReadAction(() -> FileSearchService.1.search$lambda$8$lambda$7$lambda$6(it, $excludedUris, this$0, results, $source));
                }
                $resultConsumer.invoke((Object)results);
            }

            private static final FileSearchEverywhereContributor searchService$lambda$10(Project $project, GlobalSearchScope $this_searchService) {
                FileSearchEverywhereContributor fileSearchEverywhereContributor;
                FileSearchEverywhereContributor $this$searchService_u24lambda_u2410_u24lambda_u249 = fileSearchEverywhereContributor = new FileSearchEverywhereContributor(ProjectKt.newActionEvent$default($project, null, null, null, 7, null));
                boolean bl = false;
                $this$searchService_u24lambda_u2410_u24lambda_u249.setScope(new ScopeDescriptor((SearchScope)$this_searchService));
                return fileSearchEverywhereContributor;
            }
        };
    }
}

