/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.references;

import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.contentExclusion.ContentExclusionStatusService;
import com.github.copilot.chat.contentExclusion.ContentExclusionStatusServiceKt;
import com.github.copilot.chat.references.ChatReferenceRemovalListener;
import com.github.copilot.platform.utils.VirtualFileKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.style.Style;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001cJ\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/copilot/chat/references/ReferenceComponent;", "Ljavax/swing/JPanel;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "psiManagerProvider", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiManager;", "contentExclusionsStatusService", "Lcom/github/copilot/chat/contentExclusion/ContentExclusionStatusService;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/github/copilot/platform/utils/observability/Logger;Lkotlin/jvm/functions/Function0;Lcom/github/copilot/chat/contentExclusion/ContentExclusionStatusService;)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLog", "()Lcom/github/copilot/platform/utils/observability/Logger;", "getPsiManagerProvider", "()Lkotlin/jvm/functions/Function0;", "close", "Ljavax/swing/JLabel;", "iconForFile", "Ljavax/swing/Icon;", "isBlocked", "", "checkIsFileBlocked", "addOpenFileListener", "", "paintComponent", "g", "Ljava/awt/Graphics;", "paintBorder", "core"})
@SourceDebugExtension(value={"SMAP\nReferenceComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceComponent.kt\ncom/github/copilot/chat/references/ReferenceComponent\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,120:1\n39#2:121\n*S KotlinDebug\n*F\n+ 1 ReferenceComponent.kt\ncom/github/copilot/chat/references/ReferenceComponent\n*L\n26#1:121\n*E\n"})
public final class ReferenceComponent
extends JPanel {
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Project project;
    @NotNull
    private final Logger log;
    @NotNull
    private final Function0<PsiManager> psiManagerProvider;
    @NotNull
    private final ContentExclusionStatusService contentExclusionsStatusService;
    @NotNull
    private final JLabel close;

    /*
     * WARNING - void declaration
     */
    public ReferenceComponent(@NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull Logger log, @NotNull Function0<? extends PsiManager> psiManagerProvider, @NotNull ContentExclusionStatusService contentExclusionsStatusService) {
        void $this$_init__u24lambda_u243;
        JLabel $this$_init__u24lambda_u242;
        JLabel jLabel;
        void $this$close_u24lambda_u241;
        JLabel jLabel2;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(psiManagerProvider, (String)"psiManagerProvider");
        Intrinsics.checkNotNullParameter((Object)contentExclusionsStatusService, (String)"contentExclusionsStatusService");
        super(new FlowLayout(0, 0, 0));
        this.virtualFile = virtualFile;
        this.project = project;
        this.log = log;
        this.psiManagerProvider = psiManagerProvider;
        this.contentExclusionsStatusService = contentExclusionsStatusService;
        JLabel jLabel3 = jLabel2 = new JLabel(CopilotIcons.CloseSmall);
        ReferenceComponent referenceComponent = this;
        boolean bl = false;
        $this$close_u24lambda_u241.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ReferenceComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                ChatReferenceRemovalListener.Companion.onReferenceRemoval(this.this$0);
            }
        });
        referenceComponent.close = jLabel2;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setToolTipText(this.virtualFile.getPath());
        boolean isFileBlocked = this.checkIsFileBlocked();
        Icon icon = this.iconForFile(isFileBlocked);
        JLabel jLabel4 = jLabel = new JLabel(icon);
        referenceComponent = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u242.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        $this$_init__u24lambda_u242.setCursor(Cursor.getPredefinedCursor(12));
        this.addOpenFileListener($this$_init__u24lambda_u242);
        referenceComponent.add(jLabel);
        $this$_init__u24lambda_u242 = jLabel = new JLabel(this.virtualFile.getName());
        referenceComponent = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u243.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        $this$_init__u24lambda_u243.setCursor(Cursor.getPredefinedCursor(12));
        if (isFileBlocked) {
            $this$_init__u24lambda_u243.setForeground((Color)Style.Colors.INSTANCE.getSECONDARY_TEXT());
        }
        this.addOpenFileListener((JLabel)$this$_init__u24lambda_u243);
        referenceComponent.add(jLabel);
        this.add(this.close);
    }

    public /* synthetic */ ReferenceComponent(VirtualFile virtualFile, Project project, Logger logger, Function0 function0, ContentExclusionStatusService contentExclusionStatusService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(ReferenceComponent.class);
        }
        if ((n & 8) != 0) {
            function0 = () -> ReferenceComponent._init_$lambda$0(project);
        }
        if ((n & 0x10) != 0) {
            contentExclusionStatusService = ContentExclusionStatusServiceKt.ContentExclusionStatusService();
        }
        this(virtualFile, project, logger, (Function0<? extends PsiManager>)function0, contentExclusionStatusService);
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final Function0<PsiManager> getPsiManagerProvider() {
        return this.psiManagerProvider;
    }

    private final Icon iconForFile(boolean isBlocked) {
        if (isBlocked) {
            Icon icon = CopilotIcons.CopilotBlocked;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CopilotBlocked");
            return icon;
        }
        Object object = ((PsiManager)this.psiManagerProvider.invoke()).findFile(this.virtualFile);
        if (object == null || (object = object.getIcon(0)) == null) {
            Icon icon = AllIcons.FileTypes.Text;
            object = icon;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Text");
        }
        return object;
    }

    public final boolean checkIsFileBlocked() {
        return this.contentExclusionsStatusService.isExcluded(VirtualFileKt.getUri(this.virtualFile));
    }

    private final void addOpenFileListener(JLabel $this$addOpenFileListener) {
        $this$addOpenFileListener.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ReferenceComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                try {
                    FileEditorManager.getInstance((Project)this.this$0.getProject()).openFile(this.this$0.getVirtualFile(), true);
                }
                catch (Exception e2) {
                    this.this$0.getLog().warn("Unable to open file: " + this.this$0.getVirtualFile().getPath());
                    ChatReferenceRemovalListener.Companion.onReferenceRemoval(this.this$0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            g2d.setColor((Color)Style.Colors.InputArea.References.INSTANCE.getBackground());
            Path2D.Float border = new Path2D.Float(0);
            border.append(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 12.0f, 12.0f), false);
            g2d.fill(border);
        }
        finally {
            g2d.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintBorder(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            g2d.setColor((Color)Style.Colors.InputArea.References.INSTANCE.getBorder());
            Path2D.Float border = new Path2D.Float(0);
            border.append(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 12.0f, 12.0f), false);
            border.append(new RoundRectangle2D.Float(1.0f, 1.0f, (float)this.getWidth() - (float)2, (float)this.getHeight() - (float)2, 11.0f, 11.0f), false);
            g2d.fill(border);
        }
        finally {
            g2d.dispose();
        }
    }

    private static final PsiManager _init_$lambda$0(Project $project) {
        return PsiManager.getInstance((Project)$project);
    }
}

