/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.references;

import com.github.copilot.chat.references.ChatReferenceAdditionListener;
import com.github.copilot.chat.references.FileSearchResult;
import com.github.copilot.chat.references.FileSearchService;
import com.github.copilot.chat.references.FileSearchServiceKt;
import com.github.copilot.chat.references.ReferencesPopupComponent;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.platform.utils.VirtualFileKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0002&'B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0018J\u0016\u0010!\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0006\u0010%\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lcom/github/copilot/chat/references/ReferencesPopupController;", "", "project", "Lcom/intellij/openapi/project/Project;", "chatSessionController", "Lcom/github/copilot/chat/session/ChatSessionController;", "configuration", "Lcom/github/copilot/chat/references/ReferencesPopupController$Configuration;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/github/copilot/chat/session/ChatSessionController;Lcom/github/copilot/chat/references/ReferencesPopupController$Configuration;)V", "searchService", "Lcom/github/copilot/chat/references/FileSearchService;", "component", "Lcom/github/copilot/chat/references/ReferencesPopupComponent;", "getComponent", "()Lcom/github/copilot/chat/references/ReferencesPopupComponent;", "minPopupSize", "Ljava/awt/Dimension;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "getPopup", "()Lcom/intellij/openapi/ui/popup/JBPopup;", "currentReferenceUris", "", "", "getCurrentReferenceUris", "()Ljava/util/Set;", "show", "", "relativeTo", "Ljavax/swing/JComponent;", "setSearchQuery", "query", "addFile", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "addAllOpenFiles", "Configuration", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nReferencesPopupController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferencesPopupController.kt\ncom/github/copilot/chat/references/ReferencesPopupController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n1855#2,2:76\n1549#2:78\n1620#2,3:79\n*S KotlinDebug\n*F\n+ 1 ReferencesPopupController.kt\ncom/github/copilot/chat/references/ReferencesPopupController\n*L\n35#1:72\n35#1:73,3\n52#1:76,2\n60#1:78\n60#1:79,3\n*E\n"})
public final class ReferencesPopupController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ChatSessionController chatSessionController;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final FileSearchService searchService;
    @NotNull
    private final ReferencesPopupComponent component;
    @NotNull
    private final Dimension minPopupSize;
    @NotNull
    private final JBPopup popup;
    private static final int FILE_LIMIT = 15;

    public ReferencesPopupController(@NotNull Project project, @NotNull ChatSessionController chatSessionController, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSessionController, (String)"chatSessionController");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.project = project;
        this.chatSessionController = chatSessionController;
        this.configuration = configuration;
        this.searchService = FileSearchServiceKt.FileSearchService(this.project);
        this.component = new ReferencesPopupComponent(this, this.configuration.getShowSearchInput(), (Function1<? super List<? extends VirtualFile>, Unit>)((Function1)new Function1<List<? extends VirtualFile>, Unit>((Object)this){

            public final void invoke(List<? extends VirtualFile> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ReferencesPopupController.access$addFile((ReferencesPopupController)this.receiver, p0);
            }
        }));
        this.minPopupSize = new Dimension(435, 300);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.component, (JComponent)this.component.getSearchInput()).setFocusable(true).setRequestFocus(true).setResizable(true).setMovable(true).setMinSize(this.minPopupSize).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        this.popup = jBPopup;
    }

    public /* synthetic */ ReferencesPopupController(Project project, ChatSessionController chatSessionController, Configuration configuration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            configuration = new Configuration(false, 1, null);
        }
        this(project, chatSessionController, configuration);
    }

    @NotNull
    public final ReferencesPopupComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JBPopup getPopup() {
        return this.popup;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getCurrentReferenceUris() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.chatSessionController.getCurrentReferences();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(VirtualFileKt.getUri((VirtualFile)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void show(@NotNull JComponent relativeTo) {
        Intrinsics.checkNotNullParameter((Object)relativeTo, (String)"relativeTo");
        int topOffset = relativeTo.getBorder() != null ? relativeTo.getBorder().getBorderInsets((Component)((Component)relativeTo)).top : 0;
        int leftOffset = relativeTo.getBorder() != null ? relativeTo.getBorder().getBorderInsets((Component)((Component)relativeTo)).left : 0;
        this.component.setSearchResults(this.searchService.getOpenFiles(15, this.getCurrentReferenceUris()));
        this.popup.show(new RelativePoint((Component)relativeTo, new Point(leftOffset, -this.minPopupSize.height + topOffset)));
    }

    public final void setSearchQuery(@NotNull String query2) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        this.searchService.search(query2, 15, this.getCurrentReferenceUris(), (Function1<? super List<FileSearchResult>, Unit>)((Function1)arg_0 -> ReferencesPopupController.setSearchQuery$lambda$1(this, arg_0)));
    }

    private final void addFile(List<? extends VirtualFile> files) {
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            ChatReferenceAdditionListener.Companion.onReferenceAddition(this.project, it);
            this.popup.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addAllOpenFiles() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<FileSearchResult> openFiles = this.searchService.getOpenFiles(15, this.getCurrentReferenceUris());
        Iterable iterable = openFiles;
        ReferencesPopupController referencesPopupController = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileSearchResult fileSearchResult = (FileSearchResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        referencesPopupController.addFile((List)destination$iv$iv);
    }

    private static final Unit setSearchQuery$lambda$1(ReferencesPopupController this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.component.setSearchResults(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$addFile(ReferencesPopupController $this, List files) {
        $this.addFile(files);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/copilot/chat/references/ReferencesPopupController$Companion;", "", "<init>", "()V", "FILE_LIMIT", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/github/copilot/chat/references/ReferencesPopupController$Configuration;", "", "showSearchInput", "", "<init>", "(Z)V", "getShowSearchInput", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    public static final class Configuration {
        private final boolean showSearchInput;

        public Configuration(boolean showSearchInput) {
            this.showSearchInput = showSearchInput;
        }

        public /* synthetic */ Configuration(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        public final boolean getShowSearchInput() {
            return this.showSearchInput;
        }

        public final boolean component1() {
            return this.showSearchInput;
        }

        @NotNull
        public final Configuration copy(boolean showSearchInput) {
            return new Configuration(showSearchInput);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = configuration.showSearchInput;
            }
            return configuration.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Configuration(showSearchInput=" + this.showSearchInput + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.showSearchInput);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration = (Configuration)other;
            return this.showSearchInput == configuration.showSearchInput;
        }

        public Configuration() {
            this(false, 1, null);
        }
    }
}

