/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.references;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\bH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/copilot/chat/references/SearchResultsFilter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "excludedFileExtensions", "", "", "isExcluded", "", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "isNotExcluded", "component1", "copy", "equals", "other", "hashCode", "", "toString", "core"})
final class SearchResultsFilter {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> excludedFileExtensions;

    public SearchResultsFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Object[] objectArray = new String[]{"jpg", "jpeg", "png", "gif", "bmp", "tif", "tiff", "ico", "webp", "raw", "indd", "ai", "eps", "pdf", "bin", "exe", "dat", "dll", "so", "class", "jar", "app", "dmg", "iso", "img", "docx", "pptx", "xlsx", "mp3", "wav", "flac", "mp4", "avi", "mov"};
        this.excludedFileExtensions = SetsKt.setOf((Object[])objectArray);
    }

    public final boolean isExcluded(@NotNull PsiFileSystemItem item) {
        FileType fileType;
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item.isDirectory()) {
            return true;
        }
        String string = item.getVirtualFile().getExtension();
        if (string != null) {
            String ext = string;
            boolean bl = false;
            String string2 = ext.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (this.excludedFileExtensions.contains(string2)) {
                return true;
            }
        }
        if ((psiFile = PsiManager.getInstance((Project)this.project).findFile(item.getVirtualFile())) != null && (fileType = psiFile.getFileType()) != null) {
            FileType fileType2 = fileType;
            boolean bl = false;
            return fileType2.isBinary();
        }
        return false;
    }

    public final boolean isNotExcluded(@NotNull PsiFileSystemItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return !this.isExcluded(item);
    }

    private final Project component1() {
        return this.project;
    }

    @NotNull
    public final SearchResultsFilter copy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new SearchResultsFilter(project);
    }

    public static /* synthetic */ SearchResultsFilter copy$default(SearchResultsFilter searchResultsFilter, Project project, int n, Object object) {
        if ((n & 1) != 0) {
            project = searchResultsFilter.project;
        }
        return searchResultsFilter.copy(project);
    }

    @NotNull
    public String toString() {
        return "SearchResultsFilter(project=" + this.project + ")";
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SearchResultsFilter)) {
            return false;
        }
        SearchResultsFilter searchResultsFilter = (SearchResultsFilter)other;
        return Intrinsics.areEqual((Object)this.project, (Object)searchResultsFilter.project);
    }
}

