/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.renderer;

import com.github.copilot.chat.renderer.MarkdownASTEnvelope;
import com.github.copilot.chat.renderer.MarkdownTransformer;
import com.github.copilot.chat.renderer.steps.TransformationStep;
import com.github.copilot.chat.renderer.steps.html.EscapeDisallowedTagsTransformerStep;
import com.github.copilot.chat.renderer.steps.html.HtmlCodeFormatterTransformerStep;
import com.github.copilot.chat.renderer.steps.html.RemoveParagraphTagsTransformerStep;
import com.github.copilot.chat.renderer.steps.html.StripHtmlAttributesTransformerStep;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/copilot/chat/renderer/ChatMarkdownTransformer;", "Lcom/github/copilot/chat/renderer/MarkdownTransformer;", "<init>", "()V", "markdownTransformerSteps", "", "Lcom/github/copilot/chat/renderer/steps/TransformationStep;", "Lorg/intellij/markdown/ast/ASTNode;", "htmlDocumentTransformerSteps", "Lorg/jsoup/nodes/Document;", "htmlStringTransformerSteps", "", "toHtml", "markdown", "astEnvelope", "Lcom/github/copilot/chat/renderer/MarkdownASTEnvelope;", "transformMarkdownAst", "markdownASTEnvelope", "transformHtmlDocument", "document", "transformHtmlString", "htmlString", "fromMarkdownAstToHtmlDocument", "core"})
public final class ChatMarkdownTransformer
implements MarkdownTransformer {
    @NotNull
    public static final ChatMarkdownTransformer INSTANCE = new ChatMarkdownTransformer();
    @NotNull
    private static final List<TransformationStep<ASTNode>> markdownTransformerSteps = new ArrayList();
    @NotNull
    private static final List<TransformationStep<Document>> htmlDocumentTransformerSteps;
    @NotNull
    private static final List<TransformationStep<String>> htmlStringTransformerSteps;

    private ChatMarkdownTransformer() {
    }

    @Override
    @NotNull
    public String toHtml(@NotNull String markdown) {
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        String trimmedMarkdown = ((Object)StringsKt.trim((CharSequence)markdown)).toString();
        GFMFlavourDescriptor flavour = new GFMFlavourDescriptor(false, false, false, 7, null);
        return this.toHtml(new MarkdownASTEnvelope(trimmedMarkdown, new MarkdownParser((MarkdownFlavourDescriptor)flavour).buildMarkdownTreeFromString(trimmedMarkdown)));
    }

    @Override
    @NotNull
    public String toHtml(@NotNull MarkdownASTEnvelope astEnvelope) {
        Intrinsics.checkNotNullParameter((Object)astEnvelope, (String)"astEnvelope");
        MarkdownASTEnvelope transformedMarkdownAst = this.transformMarkdownAst(astEnvelope);
        Document htmlDocument = this.fromMarkdownAstToHtmlDocument(transformedMarkdownAst);
        Document transformedHtmlDocument = this.transformHtmlDocument(htmlDocument);
        String string = transformedHtmlDocument.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String htmlDocumentString = string;
        String finalDocument = this.transformHtmlString(htmlDocumentString);
        return finalDocument;
    }

    private final MarkdownASTEnvelope transformMarkdownAst(MarkdownASTEnvelope markdownASTEnvelope) {
        for (TransformationStep<ASTNode> step : markdownTransformerSteps) {
            markdownASTEnvelope.setAstRoot(step.transform(markdownASTEnvelope.getAstRoot()));
        }
        return markdownASTEnvelope;
    }

    private final Document transformHtmlDocument(Document document) {
        Document transformedDocument = document;
        for (TransformationStep<Document> step : htmlDocumentTransformerSteps) {
            transformedDocument = step.transform(transformedDocument);
        }
        return transformedDocument;
    }

    private final String transformHtmlString(String htmlString) {
        String transformedHtmlString = htmlString;
        for (TransformationStep<String> step : htmlStringTransformerSteps) {
            transformedHtmlString = step.transform(transformedHtmlString);
        }
        return transformedHtmlString;
    }

    private final Document fromMarkdownAstToHtmlDocument(MarkdownASTEnvelope astEnvelope) {
        GFMFlavourDescriptor flavour = new GFMFlavourDescriptor(false, false, false, 7, null);
        Document document = Jsoup.parse((String)HtmlGenerator.generateHtml$default((HtmlGenerator)new HtmlGenerator(astEnvelope.getMarkdown(), astEnvelope.getAstRoot(), (MarkdownFlavourDescriptor)flavour, false, 8, null), null, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        return document;
    }

    static {
        Object[] objectArray = new TransformationStep[]{new StripHtmlAttributesTransformerStep(), new EscapeDisallowedTagsTransformerStep(), new HtmlCodeFormatterTransformerStep()};
        htmlDocumentTransformerSteps = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new TransformationStep[]{new RemoveParagraphTagsTransformerStep(null, 1, null)};
        htmlStringTransformerSteps = CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

