/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.renderer.steps.html;

import com.github.copilot.chat.renderer.steps.html.HtmlDocumentTransformerStep;
import com.github.copilot.chat.renderer.steps.html.ImgValidator;
import com.github.copilot.chat.renderer.steps.html.NodeValidator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/copilot/chat/renderer/steps/html/EscapeDisallowedTagsTransformerStep;", "Lcom/github/copilot/chat/renderer/steps/html/HtmlDocumentTransformerStep;", "<init>", "()V", "allowedTags", "", "", "conditionalNodeValidators", "", "Lcom/github/copilot/chat/renderer/steps/html/NodeValidator;", "transform", "Lorg/jsoup/nodes/Document;", "original", "escapeNode", "", "node", "Lorg/jsoup/nodes/Node;", "removeIntermediateNode", "intermediateNode", "attributeString", "core"})
@SourceDebugExtension(value={"SMAP\nEscapeDisallowedTagsTransformerStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EscapeDisallowedTagsTransformerStep.kt\ncom/github/copilot/chat/renderer/steps/html/EscapeDisallowedTagsTransformerStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1855#2,2:81\n*S KotlinDebug\n*F\n+ 1 EscapeDisallowedTagsTransformerStep.kt\ncom/github/copilot/chat/renderer/steps/html/EscapeDisallowedTagsTransformerStep\n*L\n49#1:81,2\n*E\n"})
public final class EscapeDisallowedTagsTransformerStep
extends HtmlDocumentTransformerStep {
    @NotNull
    private final List<String> allowedTags;
    @NotNull
    private final Map<String, NodeValidator> conditionalNodeValidators;

    public EscapeDisallowedTagsTransformerStep() {
        Object[] objectArray = new String[]{"html", "body", "h1", "h2", "h3", "h4", "h5", "h6", "p", "pre", "b", "i", "a", "code", "ul", "ol", "li", "br", "em", "strong", "blockquote", "table", "th", "tr", "thead", "tbody", "td", "#text"};
        this.allowedTags = CollectionsKt.listOf((Object[])objectArray);
        this.conditionalNodeValidators = MapsKt.mapOf((Pair)TuplesKt.to((Object)"img", (Object)ImgValidator.INSTANCE));
    }

    @Override
    @NotNull
    public Document transform(@NotNull Document original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Element element = original.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        this.escapeNode((Node)element);
        return original;
    }

    private final void escapeNode(Node node) {
        List list = node.childNodes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childNodes(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.escapeNode(it);
        }
        if (this.conditionalNodeValidators.keySet().contains(node.nodeName())) {
            NodeValidator nodeValidator = this.conditionalNodeValidators.get(node.nodeName());
            Intrinsics.checkNotNull((Object)nodeValidator);
            if (!nodeValidator.isValid(node)) {
                this.removeIntermediateNode(node);
            }
        } else if (!this.allowedTags.contains(node.nodeName())) {
            this.removeIntermediateNode(node);
        }
    }

    private final void removeIntermediateNode(Node intermediateNode) {
        Node parentNode;
        Node node = parentNode = intermediateNode.parent();
        Intrinsics.checkNotNull((Object)node);
        int index = node.childNodes().indexOf(intermediateNode);
        parentNode.childNode(index).before((Node)new TextNode("<" + intermediateNode.nodeName() + this.attributeString(intermediateNode) + ">"));
        for (Node child : intermediateNode.childNodes()) {
            parentNode.childNode(index).after(child);
            ++index;
        }
        parentNode.childNode(index).after((Node)new TextNode("</" + intermediateNode.nodeName() + ">"));
        intermediateNode.remove();
    }

    private final String attributeString(Node $this$attributeString) {
        List attributes = $this$attributeString.attributes().asList();
        Intrinsics.checkNotNull((Object)attributes);
        return CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)"", null, null, (int)0, null, EscapeDisallowedTagsTransformerStep::attributeString$lambda$1, (int)30, null);
    }

    private static final CharSequence attributeString$lambda$1(Attribute it) {
        return " " + it.getKey() + "=\"" + it.getValue() + "\"";
    }
}

