/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.renderer.steps.html;

import com.github.copilot.chat.renderer.steps.html.NodeValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\nJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/copilot/chat/renderer/steps/html/ImgValidator;", "Lcom/github/copilot/chat/renderer/steps/html/NodeValidator;", "<init>", "()V", "allowedDomains", "", "Lkotlin/text/Regex;", "validateSrc", "", "src", "", "validateSrcset", "srcset", "validate", "extractSrcset", "isValid", "node", "Lorg/jsoup/nodes/Node;", "core"})
@SourceDebugExtension(value={"SMAP\nImgValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImgValidator.kt\ncom/github/copilot/chat/renderer/steps/html/ImgValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1747#2,3:61\n1726#2,2:64\n1747#2,3:66\n1728#2:69\n1549#2:70\n1620#2,3:71\n*S KotlinDebug\n*F\n+ 1 ImgValidator.kt\ncom/github/copilot/chat/renderer/steps/html/ImgValidator\n*L\n25#1:61,3\n36#1:64,2\n37#1:66,3\n36#1:69\n53#1:70\n53#1:71,3\n*E\n"})
public final class ImgValidator
implements NodeValidator {
    @NotNull
    public static final ImgValidator INSTANCE = new ImgValidator();
    @NotNull
    private static final List<Regex> allowedDomains;

    private ImgValidator() {
    }

    private final boolean validateSrc(String src) {
        boolean bl;
        try {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = allowedDomains;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl3 = false;
                        if (!it.matches((CharSequence)src)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final boolean validateSrcset(String srcset) {
        boolean bl;
        try {
            boolean bl2;
            block10: {
                if (((CharSequence)srcset).length() == 0) {
                    return true;
                }
                List<String> srcsetUrls = this.extractSrcset(srcset);
                Iterable $this$all$iv = srcsetUrls;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl3;
                        block9: {
                            String src = (String)element$iv;
                            boolean bl4 = false;
                            Iterable $this$any$iv = allowedDomains;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    Regex it = (Regex)element$iv2;
                                    boolean bl5 = false;
                                    if (!INSTANCE.validateSrc(src)) continue;
                                    bl3 = true;
                                    break block9;
                                }
                                bl3 = false;
                            }
                        }
                        if (bl3) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            bl = bl2;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final boolean validate(@NotNull String src, @NotNull String srcset) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)srcset, (String)"srcset");
        return this.validateSrc(src) && this.validateSrcset(srcset);
    }

    public static /* synthetic */ boolean validate$default(ImgValidator imgValidator, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return imgValidator.validate(string, string2);
    }

    private final List<String> extractSrcset(String srcset) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)srcset, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{" "};
            collection.add((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null)));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isValid(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.attr("src");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String string2 = node.attr("srcset");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attr(...)");
        return this.validate(string, string2);
    }

    static {
        Object[] objectArray = new Regex[]{new Regex(".*://raw\\.githubusercontent\\.com.*"), new Regex(".*://private-user-images\\.githubusercontent\\.com.*"), new Regex(".*://avatars\\.githubusercontent\\.com.*"), new Regex(".*://gist\\.github\\.com/assets/.*")};
        allowedDomains = CollectionsKt.listOf((Object[])objectArray);
    }
}

