/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.renderer.steps.html;

import com.github.copilot.chat.renderer.steps.html.HtmlStringTransformerStep;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/copilot/chat/renderer/steps/html/RemoveParagraphTagsTransformerStep;", "Lcom/github/copilot/chat/renderer/steps/html/HtmlStringTransformerStep;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/github/copilot/platform/utils/observability/Logger;)V", "transform", "", "original", "core"})
@SourceDebugExtension(value={"SMAP\nRemoveParagraphTagsTransformerStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveParagraphTagsTransformerStep.kt\ncom/github/copilot/chat/renderer/steps/html/RemoveParagraphTagsTransformerStep\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,26:1\n39#2:27\n*S KotlinDebug\n*F\n+ 1 RemoveParagraphTagsTransformerStep.kt\ncom/github/copilot/chat/renderer/steps/html/RemoveParagraphTagsTransformerStep\n*L\n13#1:27\n*E\n"})
public final class RemoveParagraphTagsTransformerStep
extends HtmlStringTransformerStep {
    @NotNull
    private final Logger log;

    public RemoveParagraphTagsTransformerStep(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
    }

    public /* synthetic */ RemoveParagraphTagsTransformerStep(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(RemoveParagraphTagsTransformerStep.class);
        }
        this(logger);
    }

    @Override
    @NotNull
    public String transform(@NotNull String original) {
        String string;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        try {
            String noParagraphRawText = StringsKt.replace$default((String)StringsKt.replace$default((String)original, (String)"<p>", (String)"", (boolean)false, (int)4, null), (String)"</p>", (String)"<br><br>", (boolean)false, (int)4, null);
            int lastDoubleBreak = StringsKt.lastIndexOf$default((CharSequence)noParagraphRawText, (String)"<br><br>", (int)0, (boolean)false, (int)6, null);
            if (lastDoubleBreak >= 0) {
                String string2 = noParagraphRawText;
                int n = lastDoubleBreak + 8;
                noParagraphRawText = ((Object)StringsKt.removeRange((CharSequence)string2, (int)lastDoubleBreak, (int)n)).toString();
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to strip paragraph tags from HTML", e);
            string = original;
        }
        return string;
    }

    public RemoveParagraphTagsTransformerStep() {
        this(null, 1, null);
    }
}

