/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session;

import com.github.copilot.chat.message.ChatFollowUp;
import com.github.copilot.chat.message.ChatFollowUpKt;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.session.ChatSessionName;
import com.github.copilot.chat.session.ChatSessionNameSource;
import com.github.copilot.chat.session.ChatSessionSource;
import com.github.copilot.chat.session.InputHistory;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.chat.utils.TimeUtilKt;
import com.intellij.openapi.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 W2\u00020\u0001:\u0001WB\u008b\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u0012\b\u0002\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0006\u0010@\u001a\u00020\u0017J\u0006\u0010A\u001a\u00020\u0017J\b\u0010\u0016\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020BH\u0016J\t\u0010D\u001a\u00020\u0003H\u00c6\u0003J\t\u0010E\u001a\u00020\u0003H\u00c6\u0003J\t\u0010F\u001a\u00020\u0006H\u00c6\u0003J\t\u0010G\u001a\u00020\bH\u00c6\u0003J\t\u0010H\u001a\u00020\bH\u00c6\u0003J\t\u0010I\u001a\u00020\bH\u00c6\u0003J\t\u0010J\u001a\u00020\fH\u00c6\u0003J\t\u0010K\u001a\u00020\u000eH\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010M\u001a\u00020\u0011H\u00c6\u0003J\u0013\u0010N\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015H\u00c6\u0003J\t\u0010O\u001a\u00020\u0017H\u00c6\u0003J\u008d\u0001\u0010P\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0012\b\u0002\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u00c6\u0001J\u0013\u0010Q\u001a\u00020\u00172\b\u0010R\u001a\u0004\u0018\u00010SH\u00d6\u0003J\t\u0010T\u001a\u00020UH\u00d6\u0001J\t\u0010V\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001b\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\"\"\u0004\b$\u0010%R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010%R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001b\"\u0004\b-\u0010\u001eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R$\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020807\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00101R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006X"}, d2={"Lcom/github/copilot/chat/session/ChatSession;", "Lcom/intellij/openapi/Disposable;", "id", "", "conversationId", "user", "Lcom/github/copilot/chat/user/GitHubUser;", "createdAt", "Lkotlinx/datetime/Instant;", "activeAt", "modifiedAt", "name", "Lcom/github/copilot/chat/session/ChatSessionName;", "source", "Lcom/github/copilot/chat/session/ChatSessionSource;", "input", "history", "Lcom/github/copilot/chat/session/InputHistory;", "followUps", "", "Lcom/github/copilot/chat/message/ChatFollowUp;", "Lcom/github/copilot/chat/message/ChatFollowUps;", "addWelcomeMessage", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/github/copilot/chat/user/GitHubUser;Lkotlinx/datetime/Instant;Lkotlinx/datetime/Instant;Lkotlinx/datetime/Instant;Lcom/github/copilot/chat/session/ChatSessionName;Lcom/github/copilot/chat/session/ChatSessionSource;Ljava/lang/String;Lcom/github/copilot/chat/session/InputHistory;Ljava/util/List;Z)V", "getId", "()Ljava/lang/String;", "getConversationId", "setConversationId", "(Ljava/lang/String;)V", "getUser", "()Lcom/github/copilot/chat/user/GitHubUser;", "getCreatedAt", "()Lkotlinx/datetime/Instant;", "getActiveAt", "setActiveAt", "(Lkotlinx/datetime/Instant;)V", "getModifiedAt", "setModifiedAt", "getName", "()Lcom/github/copilot/chat/session/ChatSessionName;", "getSource", "()Lcom/github/copilot/chat/session/ChatSessionSource;", "getInput", "setInput", "getHistory", "()Lcom/github/copilot/chat/session/InputHistory;", "getFollowUps", "()Ljava/util/List;", "setFollowUps", "(Ljava/util/List;)V", "getAddWelcomeMessage", "()Z", "messages", "", "Lcom/github/copilot/chat/message/ChatMessage;", "getMessages", "controller", "Lcom/github/copilot/chat/session/SessionController;", "getController", "()Lcom/github/copilot/chat/session/SessionController;", "setController", "(Lcom/github/copilot/chat/session/SessionController;)V", "isInitialized", "isNotInitialized", "", "dispose", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "core"})
public final class ChatSession
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private String conversationId;
    @NotNull
    private final GitHubUser user;
    @NotNull
    private final Instant createdAt;
    @NotNull
    private Instant activeAt;
    @NotNull
    private Instant modifiedAt;
    @NotNull
    private final ChatSessionName name;
    @NotNull
    private final ChatSessionSource source;
    @Nullable
    private String input;
    @NotNull
    private final InputHistory history;
    @NotNull
    private List<ChatFollowUp> followUps;
    private final boolean addWelcomeMessage;
    @NotNull
    private final List<ChatMessage> messages;
    @Nullable
    private SessionController controller;

    public ChatSession(@NotNull String id, @NotNull String conversationId, @NotNull GitHubUser user, @NotNull Instant createdAt, @NotNull Instant activeAt, @NotNull Instant modifiedAt, @NotNull ChatSessionName name, @NotNull ChatSessionSource source, @Nullable String input, @NotNull InputHistory history, @NotNull List<ChatFollowUp> followUps, boolean addWelcomeMessage) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter((Object)activeAt, (String)"activeAt");
        Intrinsics.checkNotNullParameter((Object)modifiedAt, (String)"modifiedAt");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        Intrinsics.checkNotNullParameter(followUps, (String)"followUps");
        this.id = id;
        this.conversationId = conversationId;
        this.user = user;
        this.createdAt = createdAt;
        this.activeAt = activeAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.source = source;
        this.input = input;
        this.history = history;
        this.followUps = followUps;
        this.addWelcomeMessage = addWelcomeMessage;
        this.messages = new ArrayList();
        if (this.addWelcomeMessage) {
            this.addWelcomeMessage();
        }
    }

    public /* synthetic */ ChatSession(String string, String string2, GitHubUser gitHubUser, Instant instant, Instant instant2, Instant instant3, ChatSessionName chatSessionName, ChatSessionSource chatSessionSource, String string3, InputHistory inputHistory, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ChatSession.Companion.generateId();
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            gitHubUser = new GitHubUser(null, null, 3, null);
        }
        if ((n & 8) != 0) {
            instant = TimeUtilKt.getNow(Instant.Companion);
        }
        if ((n & 0x10) != 0) {
            instant2 = instant;
        }
        if ((n & 0x20) != 0) {
            instant3 = instant;
        }
        if ((n & 0x40) != 0) {
            chatSessionName = ChatSession.Companion.defaultName();
        }
        if ((n & 0x80) != 0) {
            chatSessionSource = ChatSessionSource.PANEL;
        }
        if ((n & 0x100) != 0) {
            string3 = null;
        }
        if ((n & 0x200) != 0) {
            inputHistory = new InputHistory(null, 1, null);
        }
        if ((n & 0x400) != 0) {
            list = ChatFollowUpKt.ChatFollowUps(new ChatFollowUp[0]);
        }
        if ((n & 0x800) != 0) {
            bl = true;
        }
        this(string, string2, gitHubUser, instant, instant2, instant3, chatSessionName, chatSessionSource, string3, inputHistory, list, bl);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getConversationId() {
        return this.conversationId;
    }

    public final void setConversationId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.conversationId = string;
    }

    @NotNull
    public final GitHubUser getUser() {
        return this.user;
    }

    @NotNull
    public final Instant getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public final Instant getActiveAt() {
        return this.activeAt;
    }

    public final void setActiveAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.activeAt = instant;
    }

    @NotNull
    public final Instant getModifiedAt() {
        return this.modifiedAt;
    }

    public final void setModifiedAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.modifiedAt = instant;
    }

    @NotNull
    public final ChatSessionName getName() {
        return this.name;
    }

    @NotNull
    public final ChatSessionSource getSource() {
        return this.source;
    }

    @Nullable
    public final String getInput() {
        return this.input;
    }

    public final void setInput(@Nullable String string) {
        this.input = string;
    }

    @NotNull
    public final InputHistory getHistory() {
        return this.history;
    }

    @NotNull
    public final List<ChatFollowUp> getFollowUps() {
        return this.followUps;
    }

    public final void setFollowUps(@NotNull List<ChatFollowUp> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.followUps = list;
    }

    public final boolean getAddWelcomeMessage() {
        return this.addWelcomeMessage;
    }

    @NotNull
    public final List<ChatMessage> getMessages() {
        return this.messages;
    }

    @Nullable
    public final SessionController getController() {
        return this.controller;
    }

    public final void setController(@Nullable SessionController sessionController) {
        this.controller = sessionController;
    }

    public final boolean isInitialized() {
        return !StringsKt.isBlank((CharSequence)this.conversationId);
    }

    public final boolean isNotInitialized() {
        return !this.isInitialized();
    }

    private final void addWelcomeMessage() {
        this.messages.add(ChatMessage.Companion.welcomeMessage(this.user.getName()));
    }

    public void dispose() {
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.conversationId;
    }

    @NotNull
    public final GitHubUser component3() {
        return this.user;
    }

    @NotNull
    public final Instant component4() {
        return this.createdAt;
    }

    @NotNull
    public final Instant component5() {
        return this.activeAt;
    }

    @NotNull
    public final Instant component6() {
        return this.modifiedAt;
    }

    @NotNull
    public final ChatSessionName component7() {
        return this.name;
    }

    @NotNull
    public final ChatSessionSource component8() {
        return this.source;
    }

    @Nullable
    public final String component9() {
        return this.input;
    }

    @NotNull
    public final InputHistory component10() {
        return this.history;
    }

    @NotNull
    public final List<ChatFollowUp> component11() {
        return this.followUps;
    }

    public final boolean component12() {
        return this.addWelcomeMessage;
    }

    @NotNull
    public final ChatSession copy(@NotNull String id, @NotNull String conversationId, @NotNull GitHubUser user, @NotNull Instant createdAt, @NotNull Instant activeAt, @NotNull Instant modifiedAt, @NotNull ChatSessionName name, @NotNull ChatSessionSource source, @Nullable String input, @NotNull InputHistory history, @NotNull List<ChatFollowUp> followUps, boolean addWelcomeMessage) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter((Object)activeAt, (String)"activeAt");
        Intrinsics.checkNotNullParameter((Object)modifiedAt, (String)"modifiedAt");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        Intrinsics.checkNotNullParameter(followUps, (String)"followUps");
        return new ChatSession(id, conversationId, user, createdAt, activeAt, modifiedAt, name, source, input, history, followUps, addWelcomeMessage);
    }

    public static /* synthetic */ ChatSession copy$default(ChatSession chatSession, String string, String string2, GitHubUser gitHubUser, Instant instant, Instant instant2, Instant instant3, ChatSessionName chatSessionName, ChatSessionSource chatSessionSource, String string3, InputHistory inputHistory, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = chatSession.id;
        }
        if ((n & 2) != 0) {
            string2 = chatSession.conversationId;
        }
        if ((n & 4) != 0) {
            gitHubUser = chatSession.user;
        }
        if ((n & 8) != 0) {
            instant = chatSession.createdAt;
        }
        if ((n & 0x10) != 0) {
            instant2 = chatSession.activeAt;
        }
        if ((n & 0x20) != 0) {
            instant3 = chatSession.modifiedAt;
        }
        if ((n & 0x40) != 0) {
            chatSessionName = chatSession.name;
        }
        if ((n & 0x80) != 0) {
            chatSessionSource = chatSession.source;
        }
        if ((n & 0x100) != 0) {
            string3 = chatSession.input;
        }
        if ((n & 0x200) != 0) {
            inputHistory = chatSession.history;
        }
        if ((n & 0x400) != 0) {
            list = chatSession.followUps;
        }
        if ((n & 0x800) != 0) {
            bl = chatSession.addWelcomeMessage;
        }
        return chatSession.copy(string, string2, gitHubUser, instant, instant2, instant3, chatSessionName, chatSessionSource, string3, inputHistory, list, bl);
    }

    @NotNull
    public String toString() {
        return "ChatSession(id=" + this.id + ", conversationId=" + this.conversationId + ", user=" + this.user + ", createdAt=" + this.createdAt + ", activeAt=" + this.activeAt + ", modifiedAt=" + this.modifiedAt + ", name=" + this.name + ", source=" + this.source + ", input=" + this.input + ", history=" + this.history + ", followUps=" + this.followUps + ", addWelcomeMessage=" + this.addWelcomeMessage + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.conversationId.hashCode();
        result = result * 31 + this.user.hashCode();
        result = result * 31 + this.createdAt.hashCode();
        result = result * 31 + this.activeAt.hashCode();
        result = result * 31 + this.modifiedAt.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.source.hashCode();
        result = result * 31 + (this.input == null ? 0 : this.input.hashCode());
        result = result * 31 + this.history.hashCode();
        result = result * 31 + ((Object)this.followUps).hashCode();
        result = result * 31 + Boolean.hashCode(this.addWelcomeMessage);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatSession)) {
            return false;
        }
        ChatSession chatSession = (ChatSession)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)chatSession.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.conversationId, (Object)chatSession.conversationId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)chatSession.user)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdAt, (Object)chatSession.createdAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.activeAt, (Object)chatSession.activeAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.modifiedAt, (Object)chatSession.modifiedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)chatSession.name)) {
            return false;
        }
        if (this.source != chatSession.source) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.input, (Object)chatSession.input)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.history, (Object)chatSession.history)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.followUps, chatSession.followUps)) {
            return false;
        }
        return this.addWelcomeMessage == chatSession.addWelcomeMessage;
    }

    public ChatSession() {
        this(null, null, null, null, null, null, null, null, null, null, null, false, 4095, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/github/copilot/chat/session/ChatSession$Companion;", "", "<init>", "()V", "defaultName", "Lcom/github/copilot/chat/session/ChatSessionName;", "generateId", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final ChatSessionName defaultName() {
            return new ChatSessionName("New Conversation", ChatSessionNameSource.COPILOT);
        }

        private final String generateId() {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

