/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session;

import com.github.copilot.chat.agent.RemoteAgentService;
import com.github.copilot.chat.models.CopilotModelService;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.chat.session.SessionManager;
import com.github.copilot.chat.session.component.ChatSessionComponent;
import com.github.copilot.chat.session.component.ChatSessionTransitionalComponent;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007H\u0016J\u0006\u0010%\u001a\u00020 J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0012\u0010(\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010'H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006*"}, d2={"Lcom/github/copilot/chat/session/ChatSessionController;", "Lcom/github/copilot/chat/session/SessionController;", "chatSessionManager", "Lcom/github/copilot/chat/session/SessionManager;", "persistenceService", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "session", "Lcom/github/copilot/chat/session/ChatSession;", "remoteAgentService", "Lcom/github/copilot/chat/agent/RemoteAgentService;", "copilotModelService", "Lcom/github/copilot/chat/models/CopilotModelService;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Lcom/github/copilot/chat/session/SessionManager;Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;Lcom/github/copilot/chat/session/ChatSession;Lcom/github/copilot/chat/agent/RemoteAgentService;Lcom/github/copilot/chat/models/CopilotModelService;Lcom/github/copilot/platform/utils/observability/Logger;)V", "getChatSessionManager", "()Lcom/github/copilot/chat/session/SessionManager;", "getPersistenceService", "()Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "getSession", "()Lcom/github/copilot/chat/session/ChatSession;", "currentReferences", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCurrentReferences", "()Ljava/util/Set;", "component", "Lcom/github/copilot/chat/session/component/ChatSessionTransitionalComponent;", "getComponent", "()Lcom/github/copilot/chat/session/component/ChatSessionTransitionalComponent;", "unlockSession", "", "lockSession", "isUnlocked", "", "chatSession", "reset", "getSessionInput", "", "updateInput", "input", "core"})
@SourceDebugExtension(value={"SMAP\nChatSessionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatSessionController.kt\ncom/github/copilot/chat/session/ChatSessionController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,66:1\n1#2:67\n39#3:68\n*S KotlinDebug\n*F\n+ 1 ChatSessionController.kt\ncom/github/copilot/chat/session/ChatSessionController\n*L\n18#1:68\n*E\n"})
public final class ChatSessionController
extends SessionController {
    @NotNull
    private final SessionManager chatSessionManager;
    @NotNull
    private final ChatSessionPersistenceService persistenceService;
    @NotNull
    private final RemoteAgentService remoteAgentService;
    @NotNull
    private final CopilotModelService copilotModelService;
    @NotNull
    private final Logger log;
    @NotNull
    private final ChatSession session;
    @NotNull
    private final Set<VirtualFile> currentReferences;
    @NotNull
    private final ChatSessionTransitionalComponent component;

    /*
     * WARNING - void declaration
     */
    public ChatSessionController(@NotNull SessionManager chatSessionManager, @NotNull ChatSessionPersistenceService persistenceService, @NotNull ChatSession session, @NotNull RemoteAgentService remoteAgentService, @NotNull CopilotModelService copilotModelService, @NotNull Logger log) {
        void $this$session_u24lambda_u240;
        ChatSession chatSession;
        Intrinsics.checkNotNullParameter((Object)chatSessionManager, (String)"chatSessionManager");
        Intrinsics.checkNotNullParameter((Object)persistenceService, (String)"persistenceService");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)remoteAgentService, (String)"remoteAgentService");
        Intrinsics.checkNotNullParameter((Object)copilotModelService, (String)"copilotModelService");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(null, 1, null);
        this.chatSessionManager = chatSessionManager;
        this.persistenceService = persistenceService;
        this.remoteAgentService = remoteAgentService;
        this.copilotModelService = copilotModelService;
        this.log = log;
        ChatSession chatSession2 = chatSession = session;
        ChatSessionController chatSessionController = this;
        boolean bl = false;
        $this$session_u24lambda_u240.setController(this);
        chatSessionController.session = chatSession;
        this.currentReferences = new LinkedHashSet();
        this.component = new ChatSessionTransitionalComponent(new ChatSessionComponent(this, this.remoteAgentService, this.copilotModelService, null, 8, null));
    }

    public /* synthetic */ ChatSessionController(SessionManager sessionManager, ChatSessionPersistenceService chatSessionPersistenceService, ChatSession chatSession, RemoteAgentService remoteAgentService, CopilotModelService copilotModelService, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(ChatSessionController.class);
        }
        this(sessionManager, chatSessionPersistenceService, chatSession, remoteAgentService, copilotModelService, logger);
    }

    @Override
    @NotNull
    public SessionManager getChatSessionManager() {
        return this.chatSessionManager;
    }

    @NotNull
    public final ChatSessionPersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    @Override
    @NotNull
    public ChatSession getSession() {
        return this.session;
    }

    @NotNull
    public final Set<VirtualFile> getCurrentReferences() {
        return this.currentReferences;
    }

    @NotNull
    public final ChatSessionTransitionalComponent getComponent() {
        return this.component;
    }

    @Override
    public void unlockSession() {
        this.getChatSessionManager().unlockSession(this.getSession());
    }

    @Override
    public void lockSession() {
        this.getChatSessionManager().lockSession(this.getSession());
    }

    @Override
    public boolean isUnlocked(@NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        return this.getChatSessionManager().isUnlocked(chatSession);
    }

    public final void reset() {
        this.getSession().setInput("");
        this.component.getChatSessionComponent().getChatInputPanel().getTextInputArea().setText("");
        CollectionsKt.removeAll((Iterable)this.currentReferences, ChatSessionController::reset$lambda$1);
        this.component.getChatSessionComponent().getChatInputPanel().removeAllReferences();
    }

    @Override
    @Nullable
    public String getSessionInput() {
        return this.getSession().getInput();
    }

    @Override
    public void updateInput(@Nullable String input) {
        if (!Intrinsics.areEqual((Object)this.getSession().getInput(), (Object)input)) {
            this.persistenceService.updateInput(this.getSession().getId(), input);
            this.getSession().setInput(input);
        }
    }

    private static final boolean reset$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

