/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session;

import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.agent.RemoteAgentService;
import com.github.copilot.chat.agent.RemoteAgentServiceKt;
import com.github.copilot.chat.conversation.ConversationProgressHandler;
import com.github.copilot.chat.conversation.agent.rpc.ConfirmationResponse;
import com.github.copilot.chat.input.EntryPointListener;
import com.github.copilot.chat.input.UserMessageListener;
import com.github.copilot.chat.message.ChatFollowUp;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.ChatMessageType;
import com.github.copilot.chat.message.CopilotMessageComponent;
import com.github.copilot.chat.message.references.ChatReferenceKt;
import com.github.copilot.chat.models.CopilotModelService;
import com.github.copilot.chat.models.CopilotModelServiceKt;
import com.github.copilot.chat.rating.MessageRatingListener;
import com.github.copilot.chat.references.ChatReferenceAdditionListener;
import com.github.copilot.chat.references.ChatReferenceRemovalListener;
import com.github.copilot.chat.references.ReferenceComponent;
import com.github.copilot.chat.session.ChatLockListener;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.chat.session.ChatSessionName;
import com.github.copilot.chat.session.ChatSessionNameSource;
import com.github.copilot.chat.session.ChatUnlockListener;
import com.github.copilot.chat.session.CopilotMessageComponentProgressHandler;
import com.github.copilot.chat.session.FollowUpProgressHandler;
import com.github.copilot.chat.session.PersistenceProgressHandler;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.chat.session.SessionManager;
import com.github.copilot.chat.session.component.ChatSessionComponent;
import com.github.copilot.chat.session.component.ChatSessionTransitionalComponent;
import com.github.copilot.chat.session.listener.AllChatSessionsDeleteRequestListener;
import com.github.copilot.chat.session.listener.ChatSessionCreateRequestListener;
import com.github.copilot.chat.session.listener.ChatSessionDeleteRequestListener;
import com.github.copilot.chat.session.listener.ChatSessionRenameRequestListener;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceServiceKt;
import com.github.copilot.chat.session.persistence.Client;
import com.github.copilot.chat.session.persistence.ClientKt;
import com.github.copilot.chat.session.persistence.PersistedChatSession;
import com.github.copilot.chat.session.persistence.PersistenceUtilsKt;
import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.featureflags.CopilotFeatureFlags;
import com.github.copilot.github.feature.FeatureFlagManager;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u00072\u00020\b2\u00020\tB?\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020:J\u001a\u0010;\u001a\u0002072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u00109\u001a\u00020:H\u0016J\u0012\u0010;\u001a\u0002072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010<\u001a\u0002072\u0006\u0010=\u001a\u00020>H\u0016J(\u0010?\u001a\u0002072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00109\u001a\u00020:2\u0006\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020BH\u0016J\u0018\u0010C\u001a\u0002072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u0002072\u0006\u0010G\u001a\u00020HH\u0016J\u001a\u0010I\u001a\u0002072\u0006\u0010J\u001a\u00020!2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010K\u001a\u000207H\u0002JF\u0010L\u001a\u0002072\u0006\u0010J\u001a\u00020!2\u0006\u00109\u001a\u00020:2\b\u0010M\u001a\u0004\u0018\u00010N2\b\u0010O\u001a\u0004\u0018\u00010P2\u000e\u0010Q\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010R2\b\u0010S\u001a\u0004\u0018\u00010!H\u0016Jj\u0010T\u001a\u0002072\u0006\u0010J\u001a\u00020!2\u0006\u00109\u001a\u00020:2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010N2\u0010\b\u0002\u0010U\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010R2\n\b\u0002\u0010O\u001a\u0004\u0018\u00010P2\u0010\b\u0002\u0010Q\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010R2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010!2\b\b\u0002\u0010V\u001a\u00020WH\u0002J\b\u0010X\u001a\u00020\u001eH\u0002J\u0006\u0010Y\u001a\u00020\u001eJ\u001a\u0010Z\u001a\u00020\u001e2\u0006\u0010[\u001a\u00020:2\b\b\u0002\u0010\\\u001a\u00020WH\u0002J\u0010\u0010]\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0016J\b\u0010^\u001a\u000207H\u0016J\u001d\u0010_\u001a\b\u0012\u0004\u0012\u00020:0R2\b\u0010`\u001a\u0004\u0018\u00010aH\u0016\u00a2\u0006\u0002\u0010bJ\u0010\u0010c\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010d\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010e\u001a\u00020W2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010f\u001a\u00020W2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010g\u001a\u0002072\u0006\u0010h\u001a\u00020%H\u0016J\u0010\u0010i\u001a\u0002072\u0006\u0010j\u001a\u00020#H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/github/copilot/chat/session/ChatSessionManager;", "Lcom/github/copilot/chat/session/SessionManager;", "Lcom/github/copilot/chat/input/UserMessageListener;", "Lcom/github/copilot/chat/input/EntryPointListener;", "Lcom/github/copilot/chat/session/listener/ChatSessionDeleteRequestListener;", "Lcom/github/copilot/chat/session/listener/ChatSessionRenameRequestListener;", "Lcom/github/copilot/chat/session/listener/AllChatSessionsDeleteRequestListener;", "Lcom/github/copilot/chat/rating/MessageRatingListener;", "Lcom/github/copilot/chat/references/ChatReferenceAdditionListener;", "Lcom/github/copilot/chat/references/ChatReferenceRemovalListener;", "project", "Lcom/intellij/openapi/project/Project;", "user", "Lcom/github/copilot/chat/user/GitHubUser;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "client", "Lcom/github/copilot/chat/session/persistence/Client;", "remoteAgentService", "Lcom/github/copilot/chat/agent/RemoteAgentService;", "copilotModelService", "Lcom/github/copilot/chat/models/CopilotModelService;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/github/copilot/chat/user/GitHubUser;Lcom/github/copilot/platform/utils/observability/Logger;Lcom/github/copilot/chat/session/persistence/Client;Lcom/github/copilot/chat/agent/RemoteAgentService;Lcom/github/copilot/chat/models/CopilotModelService;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getClient", "()Lcom/github/copilot/chat/session/persistence/Client;", "chatSessionsControllers", "", "Lcom/github/copilot/chat/session/ChatSessionController;", "chatSessionLocks", "", "", "lockListeners", "Lcom/github/copilot/chat/session/ChatLockListener;", "unlockListeners", "Lcom/github/copilot/chat/session/ChatUnlockListener;", "persistenceService", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "currentChatSessionController", "getCurrentChatSessionController", "()Lcom/github/copilot/chat/session/ChatSessionController;", "setCurrentChatSessionController", "(Lcom/github/copilot/chat/session/ChatSessionController;)V", "messageListener", "Lcom/intellij/util/messages/MessageBusConnection;", "entryPointListener", "sessionDeleteListener", "sessionRenameListener", "sessionsDeleteListener", "messageRatingsListener", "referenceAdditionListener", "referenceRemovalListener", "dispose", "", "getControllerForChatSession", "chatSession", "Lcom/github/copilot/chat/session/ChatSession;", "onSessionDeleteRequest", "onRating", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "onSessionRenameRequest", "newName", "source", "Lcom/github/copilot/chat/session/ChatSessionNameSource;", "onReferenceAddition", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "onReferenceRemoval", "referenceComponent", "Lcom/github/copilot/chat/references/ReferenceComponent;", "onEntryPoint", "content", "ensureChatWindowIsOpen", "onUserMessage", "followUp", "Lcom/github/copilot/chat/message/ChatFollowUp;", "confirmation", "Lcom/github/copilot/chat/conversation/agent/rpc/ConfirmationResponse;", "ignoredSkills", "", "model", "sendMessage", "references", "cancelActiveResponses", "", "getOrCreateChatSession", "newChatSession", "newChatSessionController", "session", "setActive", "deleteChatSession", "deleteAllChatSessions", "getChatSessions", "limit", "", "(Ljava/lang/Integer;)Ljava/util/List;", "lockSession", "unlockSession", "isLocked", "isUnlocked", "addUnlockListener", "chatUnlockListener", "addLockListener", "chatLockListener", "core"})
@SourceDebugExtension(value={"SMAP\nChatSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatSessionManager.kt\ncom/github/copilot/chat/session/ChatSessionManager\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n39#2:353\n288#3,2:354\n1855#3,2:357\n1549#3:359\n1620#3,3:360\n1855#3,2:363\n1855#3,2:365\n1#4:356\n*S KotlinDebug\n*F\n+ 1 ChatSessionManager.kt\ncom/github/copilot/chat/session/ChatSessionManager\n*L\n37#1:353\n100#1:354,2\n302#1:357,2\n311#1:359\n311#1:360,3\n317#1:363,2\n324#1:365,2\n*E\n"})
public final class ChatSessionManager
implements SessionManager,
UserMessageListener,
EntryPointListener,
ChatSessionDeleteRequestListener,
ChatSessionRenameRequestListener,
AllChatSessionsDeleteRequestListener,
MessageRatingListener,
ChatReferenceAdditionListener,
ChatReferenceRemovalListener {
    @NotNull
    private final Project project;
    @NotNull
    private final GitHubUser user;
    @NotNull
    private final Logger log;
    @NotNull
    private final Client client;
    @NotNull
    private final RemoteAgentService remoteAgentService;
    @NotNull
    private final CopilotModelService copilotModelService;
    @NotNull
    private final List<ChatSessionController> chatSessionsControllers;
    @NotNull
    private final Set<String> chatSessionLocks;
    @NotNull
    private final List<ChatLockListener> lockListeners;
    @NotNull
    private final List<ChatUnlockListener> unlockListeners;
    @NotNull
    private final ChatSessionPersistenceService persistenceService;
    @NotNull
    private ChatSessionController currentChatSessionController;
    @Nullable
    private MessageBusConnection messageListener;
    @Nullable
    private MessageBusConnection entryPointListener;
    @Nullable
    private MessageBusConnection sessionDeleteListener;
    @Nullable
    private MessageBusConnection sessionRenameListener;
    @Nullable
    private MessageBusConnection sessionsDeleteListener;
    @Nullable
    private MessageBusConnection messageRatingsListener;
    @Nullable
    private MessageBusConnection referenceAdditionListener;
    @Nullable
    private MessageBusConnection referenceRemovalListener;

    public ChatSessionManager(@NotNull Project project, @NotNull GitHubUser user, @NotNull Logger log, @NotNull Client client, @NotNull RemoteAgentService remoteAgentService, @NotNull CopilotModelService copilotModelService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)remoteAgentService, (String)"remoteAgentService");
        Intrinsics.checkNotNullParameter((Object)copilotModelService, (String)"copilotModelService");
        this.project = project;
        this.user = user;
        this.log = log;
        this.client = client;
        this.remoteAgentService = remoteAgentService;
        this.copilotModelService = copilotModelService;
        this.chatSessionsControllers = new ArrayList();
        this.chatSessionLocks = new LinkedHashSet();
        this.lockListeners = new ArrayList();
        this.unlockListeners = new ArrayList();
        this.persistenceService = ChatSessionPersistenceServiceKt.chatSessionsPersistenceService(this.getProject(), this.user.getName());
        this.currentChatSessionController = this.getOrCreateChatSession();
        this.messageListener = UserMessageListener.Companion.register(this);
        this.entryPointListener = EntryPointListener.Companion.register(this);
        this.sessionDeleteListener = ChatSessionDeleteRequestListener.Companion.register(this);
        this.sessionRenameListener = ChatSessionRenameRequestListener.Companion.register(this);
        this.sessionsDeleteListener = AllChatSessionsDeleteRequestListener.Companion.register(this);
        this.messageRatingsListener = MessageRatingListener.Companion.register(this);
        this.referenceAdditionListener = ChatReferenceAdditionListener.Companion.register(this);
        this.referenceRemovalListener = ChatReferenceRemovalListener.Companion.register(this);
        ProjectKt.onDisposed(this.getProject(), (Function0<Unit>)((Function0)() -> ChatSessionManager._init_$lambda$0(this)));
    }

    public /* synthetic */ ChatSessionManager(Project project, GitHubUser gitHubUser, Logger logger, Client client, RemoteAgentService remoteAgentService, CopilotModelService copilotModelService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(ChatSessionManager.class);
        }
        if ((n & 8) != 0) {
            client = ClientKt.Client();
        }
        if ((n & 0x10) != 0) {
            remoteAgentService = RemoteAgentServiceKt.RemoteAgentService();
        }
        if ((n & 0x20) != 0) {
            copilotModelService = CopilotModelServiceKt.CopilotModelService();
        }
        this(project, gitHubUser, logger, client, remoteAgentService, copilotModelService);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ChatSessionController getCurrentChatSessionController() {
        return this.currentChatSessionController;
    }

    public final void setCurrentChatSessionController(@NotNull ChatSessionController chatSessionController) {
        Intrinsics.checkNotNullParameter((Object)chatSessionController, (String)"<set-?>");
        this.currentChatSessionController = chatSessionController;
    }

    public final void dispose() {
        MessageBusConnection messageBusConnection = this.messageListener;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        MessageBusConnection messageBusConnection2 = this.entryPointListener;
        if (messageBusConnection2 != null) {
            messageBusConnection2.disconnect();
        }
        MessageBusConnection messageBusConnection3 = this.sessionDeleteListener;
        if (messageBusConnection3 != null) {
            messageBusConnection3.disconnect();
        }
        MessageBusConnection messageBusConnection4 = this.sessionRenameListener;
        if (messageBusConnection4 != null) {
            messageBusConnection4.disconnect();
        }
        MessageBusConnection messageBusConnection5 = this.sessionsDeleteListener;
        if (messageBusConnection5 != null) {
            messageBusConnection5.disconnect();
        }
        MessageBusConnection messageBusConnection6 = this.messageRatingsListener;
        if (messageBusConnection6 != null) {
            messageBusConnection6.disconnect();
        }
        MessageBusConnection messageBusConnection7 = this.referenceAdditionListener;
        if (messageBusConnection7 != null) {
            messageBusConnection7.disconnect();
        }
        MessageBusConnection messageBusConnection8 = this.referenceRemovalListener;
        if (messageBusConnection8 != null) {
            messageBusConnection8.disconnect();
        }
        this.persistenceService.dispose();
    }

    @NotNull
    public final ChatSessionController getControllerForChatSession(@NotNull ChatSession chatSession) {
        ChatSessionController chatSessionController;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
            Iterable $this$firstOrNull$iv = this.chatSessionsControllers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ChatSessionController it = (ChatSessionController)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSession().getId(), (Object)chatSession.getId())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((chatSessionController = (ChatSessionController)v0) == null) {
            chatSessionController = this.newChatSessionController(chatSession, false);
        }
        return chatSessionController;
    }

    @Override
    public void onSessionDeleteRequest(@Nullable Project project, @NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)project)) {
            return;
        }
        if (chatSession.getController() == null) {
            chatSession.setController(this.getControllerForChatSession(chatSession));
        }
        this.deleteChatSession(chatSession);
    }

    @Override
    public void onSessionDeleteRequest(@Nullable Project project) {
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)project)) {
            return;
        }
        this.deleteAllChatSessions();
    }

    @Override
    public void onRating(@NotNull ChatMessage chatMessage) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
            String string = chatMessage.getTurnId();
            if (string == null) break block0;
            String turnId = string;
            boolean bl = false;
            this.persistenceService.updateRating(turnId, chatMessage.getRating().getValue());
        }
    }

    @Override
    public void onSessionRenameRequest(@NotNull Project project, @NotNull ChatSession chatSession, @NotNull String newName, @NotNull ChatSessionNameSource source) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)project)) {
            return;
        }
        try {
            if (chatSession.getName().getSource().isUser() && source.isCopilot()) {
                return;
            }
            this.log.trace("Attempting to rename chat session " + chatSession.getName().getValue() + " to " + newName);
            ChatSessionController controller = this.getControllerForChatSession(chatSession);
            ChatSession chatSession2 = controller.getSession();
            String string = project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ChatSessionPersistenceServiceKt.renameSession(this.persistenceService, PersistenceUtilsKt.toPersistedChatSession(chatSession2, string, this.client), newName, PersistenceUtilsKt.toPersistedChatSessionNameSource(source));
            switch (WhenMappings.$EnumSwitchMapping$0[source.ordinal()]) {
                case 1: {
                    ChatSessionName chatSessionName = controller.getSession().getName().renameByUser(newName);
                    break;
                }
                case 2: {
                    ChatSessionName chatSessionName = controller.getSession().getName().renameByCopilot(newName);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            controller.getComponent().getChatSessionComponent().replaceToolbarForController(controller);
            this.log.trace("Renamed session " + controller.getSession().getName().getValue() + " to " + newName);
        }
        catch (Exception e) {
            this.log.error("Failed to rename session", e);
        }
    }

    @Override
    public void onReferenceAddition(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)project)) {
            return;
        }
        if (this.currentChatSessionController.getCurrentReferences().contains(virtualFile)) {
            return;
        }
        if (virtualFile.getFileType().isBinary()) {
            return;
        }
        this.currentChatSessionController.getCurrentReferences().add(virtualFile);
        this.currentChatSessionController.getComponent().getChatSessionComponent().getChatInputPanel().addExplicitReference(project, virtualFile);
    }

    @Override
    public void onReferenceRemoval(@NotNull ReferenceComponent referenceComponent) {
        Intrinsics.checkNotNullParameter((Object)referenceComponent, (String)"referenceComponent");
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)referenceComponent.getProject())) {
            return;
        }
        if (this.currentChatSessionController.getCurrentReferences().contains(referenceComponent.getVirtualFile())) {
            this.currentChatSessionController.getCurrentReferences().remove(referenceComponent.getVirtualFile());
        }
        this.currentChatSessionController.getComponent().getChatSessionComponent().getChatInputPanel().removeExplicitReference(referenceComponent);
    }

    @Override
    public void onEntryPoint(@NotNull String content, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)project)) {
            return;
        }
        this.ensureChatWindowIsOpen();
        CopilotFeatureFlags copilotFeatureFlags = FeatureFlagManager.INSTANCE.getFeatureFlags();
        boolean bl = copilotFeatureFlags != null ? !copilotFeatureFlags.isChatEnabled() : false;
        if (bl) {
            return;
        }
        ChatSessionManager.sendMessage$default(this, content, this.currentChatSessionController.getSession(), null, null, null, null, null, false, 252, null);
    }

    private final void ensureChatWindowIsOpen() {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.getProject());
        ToolWindow toolWindow = toolWindowManager.getToolWindow("GitHub Copilot Chat");
        if (toolWindow != null && !toolWindow.isVisible()) {
            toolWindow.show(null);
        }
    }

    @Override
    public void onUserMessage(@NotNull String content, @NotNull ChatSession chatSession, @Nullable ChatFollowUp followUp, @Nullable ConfirmationResponse confirmation, @Nullable List<String> ignoredSkills, @Nullable String model) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        if (!Intrinsics.areEqual((Object)chatSession.getId(), (Object)this.currentChatSessionController.getSession().getId())) {
            return;
        }
        ChatSessionManager.sendMessage$default(this, content, chatSession, followUp, CollectionsKt.toList((Iterable)this.currentChatSessionController.getCurrentReferences()), confirmation, ignoredSkills, model, false, 128, null);
    }

    private final void sendMessage(String content, ChatSession chatSession, ChatFollowUp followUp, List<? extends VirtualFile> references, ConfirmationResponse confirmation, List<String> ignoredSkills, String model, boolean cancelActiveResponses) {
        List list;
        RemoteAgent remoteAgent;
        Object object;
        List<Object> list2;
        if (this.isLocked(chatSession) && !cancelActiveResponses) {
            return;
        }
        if (cancelActiveResponses) {
            SessionController sessionController = chatSession.getController();
            if (sessionController != null) {
                SessionController.stopActiveResponses$default(sessionController, false, 1, null);
            }
        }
        SessionController sessionController = chatSession.getController();
        Intrinsics.checkNotNull((Object)sessionController, (String)"null cannot be cast to non-null type com.github.copilot.chat.session.ChatSessionController");
        ChatSessionController controller = (ChatSessionController)sessionController;
        controller.getComponent().getChatSessionComponent().updateFollowUps(CollectionsKt.emptyList());
        ChatMessageType chatMessageType = ChatMessageType.QUERY;
        Object[] objectArray = chatSession.getUser();
        List<Object> list3 = references;
        if (list3 == null || (list3 = ChatReferenceKt.virtualFilesToFileChatReferences(list3)) == null) {
            list3 = list2 = CollectionsKt.emptyList();
        }
        if ((object = RemoteAgent.Companion.slugFromUserMessage(content, confirmation)) != null) {
            String it = object;
            boolean bl = false;
            v3 = RemoteAgentServiceKt.getRemoteAgentBySlug(this.remoteAgentService, it);
        } else {
            v3 = remoteAgent = null;
        }
        if ((list = ignoredSkills) == null) {
            list = CollectionsKt.emptyList();
        }
        object = list;
        ChatMessage chatMessage = new ChatMessage(chatMessageType, (GitHubUser)objectArray, content, null, null, null, null, followUp, list2, null, null, null, null, null, remoteAgent, null, (List)object, null, confirmation, model, null, 1228408, null);
        CopilotMessageComponent copilotMessageComponent = controller.getComponent().getChatSessionComponent().addUserMessageWithResponsePlaceholder$core(chatMessage);
        objectArray = new ConversationProgressHandler[]{new PersistenceProgressHandler(chatMessage, controller, this.persistenceService), new CopilotMessageComponentProgressHandler(copilotMessageComponent, controller, this.remoteAgentService), new FollowUpProgressHandler(controller)};
        controller.executeRequest(chatMessage, CollectionsKt.listOf((Object[])objectArray));
    }

    static /* synthetic */ void sendMessage$default(ChatSessionManager chatSessionManager, String string, ChatSession chatSession, ChatFollowUp chatFollowUp, List list, ConfirmationResponse confirmationResponse, List list2, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            chatFollowUp = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            confirmationResponse = null;
        }
        if ((n & 0x20) != 0) {
            list2 = null;
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        chatSessionManager.sendMessage(string, chatSession, chatFollowUp, list, confirmationResponse, list2, string2, bl);
    }

    private final ChatSessionController getOrCreateChatSession() {
        PersistedChatSession persistedChatSession = ChatSessionPersistenceServiceKt.getLastActiveSession(this.persistenceService);
        ChatSession lastActiveSession = persistedChatSession != null ? PersistenceUtilsKt.toChatSession(persistedChatSession, this.user) : null;
        return lastActiveSession != null ? ChatSessionManager.newChatSessionController$default(this, lastActiveSession, false, 2, null) : this.newChatSession();
    }

    @NotNull
    public final ChatSessionController newChatSession() {
        this.log.info("New chat session requested");
        ChatSession session = new ChatSession(null, null, this.user, null, null, null, null, null, null, null, null, false, 4091, null);
        String string = this.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.persistenceService.persistSession(PersistenceUtilsKt.toPersistedChatSession(session, string, this.client));
        return ChatSessionManager.newChatSessionController$default(this, session, false, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ChatSessionController newChatSessionController(ChatSession session, boolean setActive) {
        ChatSessionController controller = new ChatSessionController(this, this.persistenceService, session, this.remoteAgentService, this.copilotModelService, null, 32, null);
        List<ChatSessionController> list = this.chatSessionsControllers;
        synchronized (list) {
            boolean bl = false;
            this.chatSessionsControllers.add(controller);
            if (setActive) {
                Object object = this.currentChatSessionController;
                if (object != null && (object = ((ChatSessionController)object).getComponent()) != null && (object = ((ChatSessionTransitionalComponent)object).getChatSessionComponent()) != null && (object = ((ChatSessionComponent)object).getMessagePanelScrollWorker()) != null) {
                    ((Timer)object).stop();
                }
                this.currentChatSessionController = controller;
                controller.getComponent().getChatSessionComponent().focusInputPanel();
            }
            Unit unit = Unit.INSTANCE;
        }
        return controller;
    }

    static /* synthetic */ ChatSessionController newChatSessionController$default(ChatSessionManager chatSessionManager, ChatSession chatSession, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return chatSessionManager.newChatSessionController(chatSession, bl);
    }

    @Override
    public void deleteChatSession(@NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        SessionController sessionController = chatSession.getController();
        if (sessionController != null) {
            SessionController.stopActiveResponses$default(sessionController, false, 1, null);
        }
        SessionController sessionController2 = chatSession.getController();
        if (sessionController2 != null) {
            sessionController2.destroyChatSession();
        }
        this.persistenceService.deleteSession(chatSession.getId());
        Object object = chatSession.getController();
        if (Intrinsics.areEqual((Object)(object != null && (object = ((SessionController)object).getSession()) != null ? ((ChatSession)object).getId() : null), (Object)this.currentChatSessionController.getSession().getId())) {
            this.log.debug("Deleting current chat session, creating a new one to replace it");
            ((ChatSessionCreateRequestListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ChatSessionCreateRequestListener.Companion.getTopic())).onSessionCreateRequest(this.getProject());
        }
    }

    @Override
    public void deleteAllChatSessions() {
        Iterable $this$forEach$iv = this.chatSessionsControllers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatSessionController it = (ChatSessionController)element$iv;
            boolean bl = false;
            SessionController.stopActiveResponses$default(it, false, 1, null);
            it.destroyChatSession();
        }
        this.persistenceService.deleteAllSessions();
        ((ChatSessionCreateRequestListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ChatSessionCreateRequestListener.Companion.getTopic())).onSessionCreateRequest(this.getProject());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ChatSession> getChatSessions(@Nullable Integer limit) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ChatSessionPersistenceService.DefaultImpls.getSessions$default(this.persistenceService, null, limit, 1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersistedChatSession persistedChatSession = (PersistedChatSession)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PersistenceUtilsKt.toChatSession((PersistedChatSession)it, this.user));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockSession(@NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Set<String> set = this.chatSessionLocks;
        synchronized (set) {
            boolean bl = false;
            this.chatSessionLocks.add(chatSession.getId());
            Iterable $this$forEach$iv = this.lockListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChatLockListener it = (ChatLockListener)element$iv;
                boolean bl2 = false;
                it.onLock(chatSession);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockSession(@NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Set<String> set = this.chatSessionLocks;
        synchronized (set) {
            boolean bl = false;
            if (this.isLocked(chatSession)) {
                this.chatSessionLocks.remove(chatSession.getId());
            }
            Iterable $this$forEach$iv = this.unlockListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChatUnlockListener it = (ChatUnlockListener)element$iv;
                boolean bl2 = false;
                it.onUnlock(chatSession);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean isLocked(ChatSession chatSession) {
        return this.chatSessionLocks.contains(chatSession.getId());
    }

    @Override
    public boolean isUnlocked(@NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        return !this.isLocked(chatSession);
    }

    @Override
    public void addUnlockListener(@NotNull ChatUnlockListener chatUnlockListener) {
        Intrinsics.checkNotNullParameter((Object)chatUnlockListener, (String)"chatUnlockListener");
        this.unlockListeners.add(chatUnlockListener);
    }

    @Override
    public void addLockListener(@NotNull ChatLockListener chatLockListener) {
        Intrinsics.checkNotNullParameter((Object)chatLockListener, (String)"chatLockListener");
        this.lockListeners.add(chatLockListener);
    }

    private static final Unit _init_$lambda$0(ChatSessionManager this$0) {
        this$0.dispose();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatSessionNameSource.values().length];
            try {
                nArray[ChatSessionNameSource.USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatSessionNameSource.COPILOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

