/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session;

import com.github.copilot.chat.agent.NoOpRemoteAgentService;
import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.agent.RemoteAgentService;
import com.github.copilot.chat.agent.RemoteAgentServiceKt;
import com.github.copilot.chat.conversation.ConversationProgressHandler;
import com.github.copilot.chat.conversation.agent.rpc.ChatAnnotation;
import com.github.copilot.chat.conversation.agent.rpc.ChatNotification;
import com.github.copilot.chat.conversation.agent.rpc.Unauthorized;
import com.github.copilot.chat.conversation.agent.rpc.message.ConversationError;
import com.github.copilot.chat.conversation.agent.rpc.message.ConversationProgressValue;
import com.github.copilot.chat.conversation.agent.rpc.message.Step;
import com.github.copilot.chat.input.UserMessageListener;
import com.github.copilot.chat.message.ChatMessageStatus;
import com.github.copilot.chat.message.CopilotMessageComponent;
import com.github.copilot.chat.message.MessageComponent;
import com.github.copilot.chat.message.references.ChatReference;
import com.github.copilot.chat.message.references.ChatReferenceUtilsKt;
import com.github.copilot.chat.message.references.ChatReferencesBuilder;
import com.github.copilot.chat.session.ActiveResponse;
import com.github.copilot.chat.session.ChatSessionNameSource;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.chat.session.SessionControllerKt;
import com.github.copilot.chat.session.listener.ChatSessionRenameRequestListener;
import com.google.gson.internal.LazilyParsedNumber;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/copilot/chat/session/CopilotMessageComponentProgressHandler;", "Lcom/github/copilot/chat/conversation/ConversationProgressHandler;", "copilotMessageComponent", "Lcom/github/copilot/chat/message/CopilotMessageComponent;", "sessionController", "Lcom/github/copilot/chat/session/SessionController;", "remoteAgentService", "Lcom/github/copilot/chat/agent/RemoteAgentService;", "<init>", "(Lcom/github/copilot/chat/message/CopilotMessageComponent;Lcom/github/copilot/chat/session/SessionController;Lcom/github/copilot/chat/agent/RemoteAgentService;)V", "initialMessage", "", "referencesBuilder", "Lcom/github/copilot/chat/message/references/ChatReferencesBuilder;", "onUnauthorized", "", "unauthorized", "Lcom/github/copilot/chat/conversation/agent/rpc/Unauthorized;", "onBegin", "disposable", "Lcom/intellij/openapi/Disposable;", "onComplete", "progress", "Lcom/github/copilot/chat/conversation/agent/rpc/message/ConversationProgressValue;", "onProgress", "onError", "error", "Lcom/github/copilot/chat/conversation/agent/rpc/message/ConversationError;", "core"})
@SourceDebugExtension(value={"SMAP\nCopilotMessageComponentProgressHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopilotMessageComponentProgressHandler.kt\ncom/github/copilot/chat/session/CopilotMessageComponentProgressHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,165:1\n1#2:166\n1855#3:167\n1856#3:170\n1855#3,2:171\n215#4,2:168\n*S KotlinDebug\n*F\n+ 1 CopilotMessageComponentProgressHandler.kt\ncom/github/copilot/chat/session/CopilotMessageComponentProgressHandler\n*L\n101#1:167\n101#1:170\n124#1:171,2\n103#1:168,2\n*E\n"})
public final class CopilotMessageComponentProgressHandler
extends ConversationProgressHandler {
    @NotNull
    private final CopilotMessageComponent copilotMessageComponent;
    @NotNull
    private final SessionController sessionController;
    @NotNull
    private final RemoteAgentService remoteAgentService;
    private boolean initialMessage;
    @Nullable
    private ChatReferencesBuilder referencesBuilder;

    public CopilotMessageComponentProgressHandler(@NotNull CopilotMessageComponent copilotMessageComponent, @NotNull SessionController sessionController, @NotNull RemoteAgentService remoteAgentService) {
        Intrinsics.checkNotNullParameter((Object)copilotMessageComponent, (String)"copilotMessageComponent");
        Intrinsics.checkNotNullParameter((Object)sessionController, (String)"sessionController");
        Intrinsics.checkNotNullParameter((Object)remoteAgentService, (String)"remoteAgentService");
        this.copilotMessageComponent = copilotMessageComponent;
        this.sessionController = sessionController;
        this.remoteAgentService = remoteAgentService;
        this.initialMessage = true;
    }

    public /* synthetic */ CopilotMessageComponentProgressHandler(CopilotMessageComponent copilotMessageComponent, SessionController sessionController, RemoteAgentService remoteAgentService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            remoteAgentService = NoOpRemoteAgentService.INSTANCE;
        }
        this(copilotMessageComponent, sessionController, remoteAgentService);
    }

    @Override
    public void onUnauthorized(@NotNull Unauthorized unauthorized) {
        block3: {
            Object object;
            block2: {
                Intrinsics.checkNotNullParameter((Object)unauthorized, (String)"unauthorized");
                this.referencesBuilder = null;
                object = RemoteAgentServiceKt.getRemoteAgentBySlug(this.remoteAgentService, unauthorized.getAgentSlug());
                if (object == null) break block2;
                RemoteAgent agent = object;
                boolean bl = false;
                String questionToResend = SessionControllerKt.getLastMessage(this.sessionController);
                JComponent jComponent = this.copilotMessageComponent.setAuthorizationRequired(agent, unauthorized.getAuthorizationUri(), (Function0<Unit>)((Function0)() -> CopilotMessageComponentProgressHandler.onUnauthorized$lambda$1$lambda$0(questionToResend, this)));
                object = jComponent;
                if (jComponent != null) break block3;
            }
            MessageComponent.setUnexpectedError$default(this.copilotMessageComponent, false, false, 3, null);
            object = Unit.INSTANCE;
        }
        this.sessionController.unlockSession();
    }

    @Override
    public void onBegin(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.referencesBuilder = new ChatReferencesBuilder();
        this.sessionController.getActiveCopilotResponses().put(this.copilotMessageComponent, new ActiveResponse(disposable, (Function0<Unit>)((Function0)CopilotMessageComponentProgressHandler::onBegin$lambda$2)));
    }

    @Override
    public void onComplete(@NotNull ConversationProgressValue progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.copilotMessageComponent.getTypeWriter().addOnCompleteListener(() -> CopilotMessageComponentProgressHandler.onComplete$lambda$5(this, progress));
        this.copilotMessageComponent.getTypeWriter().flush();
    }

    @Override
    public void onProgress(@NotNull ConversationProgressValue progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        ApplicationManager.getApplication().invokeLater(() -> CopilotMessageComponentProgressHandler.onProgress$lambda$10(this, progress));
    }

    @Override
    public void onError(@NotNull ConversationError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.referencesBuilder = null;
        this.copilotMessageComponent.getTypeWriter().addOnCompleteListener(() -> CopilotMessageComponentProgressHandler.onError$lambda$11(this, error));
        if (Intrinsics.areEqual((Object)error.getResponseIsFiltered(), (Object)true)) {
            this.sessionController.stopActiveResponses(true);
        } else {
            this.copilotMessageComponent.getTypeWriter().flush();
        }
        this.sessionController.removeActiveResponse(this.copilotMessageComponent);
    }

    private static final Unit onUnauthorized$lambda$1$lambda$0(String $questionToResend, CopilotMessageComponentProgressHandler this$0) {
        UserMessageListener.Companion.onUserMessage($questionToResend, this$0.sessionController.getSession(), null, null, null, null);
        return Unit.INSTANCE;
    }

    private static final Unit onBegin$lambda$2() {
        return Unit.INSTANCE;
    }

    private static final void onComplete$lambda$5(CopilotMessageComponentProgressHandler this$0, ConversationProgressValue $progress) {
        this$0.sessionController.unlockSession();
        Object object = this$0.referencesBuilder;
        if (object != null && (object = ((ChatReferencesBuilder)object).build()) != null) {
            Object it = object;
            boolean bl = false;
            this$0.copilotMessageComponent.setReferences((List<? extends ChatReference>)it);
        }
        String string = $progress.getSuggestedTitle();
        if (string != null) {
            String suggestedTitle = string;
            boolean bl = false;
            ChatSessionRenameRequestListener.Companion.onSessionRenameRequest(this$0.copilotMessageComponent.getProject(), this$0.sessionController.getSession(), suggestedTitle, ChatSessionNameSource.COPILOT);
        }
        this$0.sessionController.removeActiveResponse(this$0.copilotMessageComponent);
        this$0.copilotMessageComponent.updateActions();
        this$0.copilotMessageComponent.getStepPanel().updateSteps(CollectionsKt.toList((Iterable)this$0.copilotMessageComponent.getChatMessage().getSteps().values()));
        this$0.copilotMessageComponent.getStepPanel().makeCollapsible(true);
        this$0.copilotMessageComponent.getStepPanel().hideContent();
    }

    private static final void onProgress$lambda$10(CopilotMessageComponentProgressHandler this$0, ConversationProgressValue $progress) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<Object> list;
        if (this$0.initialMessage) {
            this$0.initialMessage = false;
            this$0.copilotMessageComponent.getChatMessage().setContent("");
            this$0.copilotMessageComponent.getChatMessage().setTurnId($progress.getTurnId());
        }
        if ((list = $progress.getReferences()) != null && (list = ChatReferenceUtilsKt.toChatReferences(list)) != null) {
            List<Object> it = list;
            boolean bl = false;
            ChatReferencesBuilder chatReferencesBuilder = this$0.referencesBuilder;
            if (chatReferencesBuilder != null) {
                chatReferencesBuilder.addReferences(it);
            }
        }
        Object object = $progress.getSteps();
        if (!(object == null || object.isEmpty())) {
            $this$forEach$iv = $progress.getSteps();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Step step = (Step)element$iv;
                boolean bl = false;
                if (this$0.copilotMessageComponent.getChatMessage().getStatus() == ChatMessageStatus.CANCELLED) {
                    Map<String, Step> $this$forEach$iv2 = this$0.copilotMessageComponent.getChatMessage().getSteps();
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<String, Step>> iterator = $this$forEach$iv2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Step> element$iv2;
                        Map.Entry<String, Step> entry = element$iv2 = iterator.next();
                        boolean bl2 = false;
                        Step value = entry.getValue();
                        if (!value.isRunning()) continue;
                        value.setCancelled();
                    }
                    continue;
                }
                this$0.copilotMessageComponent.getChatMessage().getSteps().put(step.getId(), step);
            }
            this$0.copilotMessageComponent.getStepPanel().setVisible(true);
            this$0.copilotMessageComponent.getStepPanel().updateSteps(CollectionsKt.toList((Iterable)this$0.copilotMessageComponent.getChatMessage().getSteps().values()));
        }
        if ($progress.getConfirmationRequest() != null) {
            this$0.copilotMessageComponent.getChatMessage().setConfirmationRequest($progress.getConfirmationRequest());
            MessageComponent.addConfirmationDialog$default(this$0.copilotMessageComponent, $progress.getConfirmationRequest(), false, 2, null);
        }
        List<ChatNotification> list2 = $progress.getNotifications();
        boolean bl = list2 != null ? !((Collection)list2).isEmpty() : false;
        if (bl) {
            $this$forEach$iv = $progress.getNotifications();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChatNotification notification = (ChatNotification)element$iv;
                boolean bl3 = false;
                this$0.copilotMessageComponent.getChatMessage().getNotifications().add(notification);
                this$0.copilotMessageComponent.addMessageNotification(notification);
            }
        }
        if ($progress.getReply() != null) {
            object = $progress.getAnnotations();
            if (!(object == null || object.isEmpty())) {
                for (ChatAnnotation annotation : $progress.getAnnotations()) {
                    annotation.setStartOffset(this$0.copilotMessageComponent.getOffset());
                    annotation.setStopOffset(annotation.getStartOffset() + $progress.getReply().length());
                    this$0.copilotMessageComponent.getChatMessage().getAnnotations().add(annotation);
                }
            }
            object = this$0.copilotMessageComponent;
            ((CopilotMessageComponent)object).setOffset(((CopilotMessageComponent)object).getOffset() + $progress.getReply().length());
            if (!$progress.getHideText()) {
                this$0.copilotMessageComponent.getTypeWriter().addText($progress.getReply());
            }
        }
    }

    private static final void onError$lambda$11(CopilotMessageComponentProgressHandler this$0, ConversationError $error) {
        this$0.sessionController.unlockSession();
        if (Intrinsics.areEqual((Object)$error.getResponseIsFiltered(), (Object)true)) {
            this$0.copilotMessageComponent.setFilter($error.getMessage());
        } else {
            LazilyParsedNumber lazilyParsedNumber = $error.getCode();
            this$0.copilotMessageComponent.setError($error.getMessage(), lazilyParsedNumber != null ? lazilyParsedNumber.intValue() : 0);
        }
        this$0.copilotMessageComponent.forceRefreshTopPanel();
        this$0.copilotMessageComponent.getStepPanel().makeCollapsible(true);
    }
}

