/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session;

import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.conversation.ConversationProgressHandler;
import com.github.copilot.chat.conversation.agent.rpc.ChatNotification;
import com.github.copilot.chat.conversation.agent.rpc.Unauthorized;
import com.github.copilot.chat.conversation.agent.rpc.message.ConversationError;
import com.github.copilot.chat.conversation.agent.rpc.message.ConversationProgressValue;
import com.github.copilot.chat.conversation.agent.rpc.message.StepUpdater;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.references.ChatReference;
import com.github.copilot.chat.message.references.ChatReferenceUtilsKt;
import com.github.copilot.chat.message.references.ChatReferencesBuilder;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.chat.session.persistence.ChatSessionPersistenceService;
import com.github.copilot.chat.session.persistence.PersistedMessageBuilder;
import com.github.copilot.chat.session.persistence.PersistedMessageStatus;
import com.github.copilot.chat.session.persistence.PersistedMessageType;
import com.github.copilot.chat.session.persistence.PersistedTurn;
import com.github.copilot.chat.session.persistence.PersistedTurnBuilder;
import com.github.copilot.chat.session.persistence.PersistenceUtilsKt;
import com.github.copilot.chat.user.Users;
import com.github.copilot.chat.utils.TimeUtilKt;
import com.google.gson.internal.LazilyParsedNumber;
import com.intellij.openapi.Disposable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0002J\b\u0010(\u001a\u00020%H\u0002J\u0012\u0010)\u001a\u00020\u00152\b\b\u0002\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\u00020$*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006,"}, d2={"Lcom/github/copilot/chat/session/PersistenceProgressHandler;", "Lcom/github/copilot/chat/conversation/ConversationProgressHandler;", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "sessionController", "Lcom/github/copilot/chat/session/SessionController;", "persistenceService", "Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;", "<init>", "(Lcom/github/copilot/chat/message/ChatMessage;Lcom/github/copilot/chat/session/SessionController;Lcom/github/copilot/chat/session/persistence/ChatSessionPersistenceService;)V", "messageOffset", "", "referencesBuilder", "Lcom/github/copilot/chat/message/references/ChatReferencesBuilder;", "hasPersistTurnBeenCalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "turnBuilder", "Lcom/github/copilot/chat/session/persistence/PersistedTurnBuilder;", "turnResponseBuilder", "Lcom/github/copilot/chat/session/persistence/PersistedMessageBuilder;", "onError", "", "error", "Lcom/github/copilot/chat/conversation/agent/rpc/message/ConversationError;", "onProgress", "progress", "Lcom/github/copilot/chat/conversation/agent/rpc/message/ConversationProgressValue;", "onComplete", "onBegin", "disposable", "Lcom/intellij/openapi/Disposable;", "onUnauthorized", "unauthorized", "Lcom/github/copilot/chat/conversation/agent/rpc/Unauthorized;", "persistTurn", "canBePersisted", "", "Lcom/github/copilot/chat/session/persistence/PersistedTurn;", "getCanBePersisted", "(Lcom/github/copilot/chat/session/persistence/PersistedTurn;)Z", "buildTurn", "updateModifiedAt", "modifiedAt", "Lkotlinx/datetime/Instant;", "core"})
@SourceDebugExtension(value={"SMAP\nPersistenceProgressHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistenceProgressHandler.kt\ncom/github/copilot/chat/session/PersistenceProgressHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class PersistenceProgressHandler
extends ConversationProgressHandler {
    @NotNull
    private final SessionController sessionController;
    @NotNull
    private final ChatSessionPersistenceService persistenceService;
    private int messageOffset;
    @Nullable
    private ChatReferencesBuilder referencesBuilder;
    @NotNull
    private final AtomicBoolean hasPersistTurnBeenCalled;
    @NotNull
    private final PersistedTurnBuilder turnBuilder;
    @NotNull
    private final PersistedMessageBuilder turnResponseBuilder;

    public PersistenceProgressHandler(@NotNull ChatMessage chatMessage, @NotNull SessionController sessionController, @NotNull ChatSessionPersistenceService persistenceService) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)sessionController, (String)"sessionController");
        Intrinsics.checkNotNullParameter((Object)persistenceService, (String)"persistenceService");
        this.sessionController = sessionController;
        this.persistenceService = persistenceService;
        this.hasPersistTurnBeenCalled = new AtomicBoolean(false);
        this.turnBuilder = new PersistedTurnBuilder(this.sessionController.getSession().getId(), PersistenceUtilsKt.toPersistedMessage(chatMessage));
        RemoteAgent remoteAgent = chatMessage.getAgent();
        this.turnResponseBuilder = new PersistedMessageBuilder(Users.INSTANCE.getCopilotUser().getName(), PersistedMessageType.RESPONSE, remoteAgent != null ? PersistenceUtilsKt.toPersistedAgent(remoteAgent) : null);
    }

    @Override
    public void onError(@NotNull ConversationError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (this.turnResponseBuilder.hasNotBeenCancelled()) {
            if (Intrinsics.areEqual((Object)error.getResponseIsFiltered(), (Object)true)) {
                this.turnResponseBuilder.status(PersistedMessageStatus.FILTERED);
            } else {
                this.turnResponseBuilder.status(PersistedMessageStatus.ERROR);
            }
            this.turnResponseBuilder.setContent(error.getMessage());
            LazilyParsedNumber lazilyParsedNumber = error.getCode();
            this.turnResponseBuilder.errorCode(lazilyParsedNumber != null ? lazilyParsedNumber.intValue() : 0);
        }
        this.persistTurn();
    }

    @Override
    public void onProgress(@NotNull ConversationProgressValue progress) {
        List<Object> list;
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        String string = progress.getReply();
        if (string != null) {
            String reply = string;
            boolean bl = false;
            this.turnBuilder.id(progress.getTurnId());
            this.turnResponseBuilder.appendContent(reply);
            this.messageOffset += reply.length();
            Collection collection = progress.getAnnotations();
            if (!(collection == null || collection.isEmpty())) {
                this.turnResponseBuilder.annotations(PersistenceUtilsKt.toPersistedMessageAnnotations(progress.getAnnotations(), this.messageOffset, this.messageOffset + progress.getReply().length()));
            }
            if (progress.getConfirmationRequest() != null) {
                this.turnResponseBuilder.confirmationRequest(PersistenceUtilsKt.toPersistedConfirmationRequest(progress.getConfirmationRequest()));
            }
        }
        if ((list = progress.getReferences()) != null && (list = ChatReferenceUtilsKt.toChatReferences(list)) != null) {
            List<Object> it = list;
            boolean bl = false;
            ChatReferencesBuilder chatReferencesBuilder = this.referencesBuilder;
            if (chatReferencesBuilder != null) {
                chatReferencesBuilder.addReferences(it);
            }
        }
        List<ChatNotification> list2 = progress.getNotifications();
        if (list2 != null) {
            List<ChatNotification> it = list2;
            boolean bl = false;
            this.turnResponseBuilder.notifications(PersistenceUtilsKt.toPersistedNotifications(it));
        }
        Collection collection = progress.getSteps();
        if (!(collection == null || collection.isEmpty())) {
            new StepUpdater(this.turnBuilder, progress.getSteps()).update();
        }
        String string2 = progress.getReply();
        this.messageOffset += string2 != null ? string2.length() : 0;
    }

    @Override
    public void onComplete(@NotNull ConversationProgressValue progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.persistTurn();
    }

    @Override
    public void onBegin(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.referencesBuilder = new ChatReferencesBuilder();
    }

    @Override
    public void onUnauthorized(@NotNull Unauthorized unauthorized) {
        Intrinsics.checkNotNullParameter((Object)unauthorized, (String)"unauthorized");
    }

    private final synchronized void persistTurn() {
        PersistedTurn turn = this.buildTurn();
        if (this.getCanBePersisted(turn) && this.hasPersistTurnBeenCalled.compareAndSet(false, true)) {
            this.persistenceService.persistTurn(turn);
            PersistenceProgressHandler.updateModifiedAt$default(this, null, 1, null);
        }
    }

    private final boolean getCanBePersisted(PersistedTurn $this$canBePersisted) {
        return $this$canBePersisted.getResponse() != null && ($this$canBePersisted.getRequest().getConfirmationResponse() != null || !StringsKt.isBlank((CharSequence)$this$canBePersisted.getResponse().getContent())) || !((Collection)$this$canBePersisted.getSteps()).isEmpty();
    }

    private final PersistedTurn buildTurn() {
        block0: {
            Object object = this.referencesBuilder;
            if (object == null || (object = ((ChatReferencesBuilder)object).build()) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.turnResponseBuilder.references(PersistenceUtilsKt.toPersistedReferences((List<? extends ChatReference>)it));
        }
        return PersistedTurnBuilder.build$default(this.turnBuilder.response(this.turnResponseBuilder.build()), null, 1, null);
    }

    private final void updateModifiedAt(Instant modifiedAt) {
        this.sessionController.getSession().setModifiedAt(modifiedAt);
        this.persistenceService.updateModifiedAt(this.sessionController.getSession().getId(), modifiedAt);
    }

    static /* synthetic */ void updateModifiedAt$default(PersistenceProgressHandler persistenceProgressHandler, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            instant = TimeUtilKt.getNow(Instant.Companion);
        }
        persistenceProgressHandler.updateModifiedAt(instant);
    }
}

