/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session;

import com.github.copilot.chat.conversation.ConversationProgressHandler;
import com.github.copilot.chat.conversation.ConversationProgressHandlerKt;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.conversation.ConversationServiceFactory;
import com.github.copilot.chat.conversation.CopilotConversationServiceFactory;
import com.github.copilot.chat.conversation.agent.rpc.Unauthorized;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationDestroyCommand;
import com.github.copilot.chat.conversation.agent.rpc.message.ConversationError;
import com.github.copilot.chat.conversation.agent.rpc.message.ConversationProgressValue;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.CopilotMessageComponent;
import com.github.copilot.chat.message.MessageComponent;
import com.github.copilot.chat.session.ActiveResponse;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.SessionManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import io.ktor.util.collections.ConcurrentMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u0019H&J\u0010\u0010\u001b\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\bJ\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0012\u0010\"\u001a\u00020\u00192\b\u0010#\u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0011H&J\u001c\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u0006\u0010,\u001a\u00020\u0019J$\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0082@\u00a2\u0006\u0002\u0010/R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lcom/github/copilot/chat/session/SessionController;", "", "conversationServiceFactory", "Lcom/github/copilot/chat/conversation/ConversationServiceFactory;", "<init>", "(Lcom/github/copilot/chat/conversation/ConversationServiceFactory;)V", "activeCopilotResponses", "", "Lcom/github/copilot/chat/message/CopilotMessageComponent;", "Lcom/github/copilot/chat/session/ActiveResponse;", "getActiveCopilotResponses", "()Ljava/util/Map;", "conversationService", "Lcom/github/copilot/chat/conversation/ConversationService;", "getConversationService", "()Lcom/github/copilot/chat/conversation/ConversationService;", "session", "Lcom/github/copilot/chat/session/ChatSession;", "getSession", "()Lcom/github/copilot/chat/session/ChatSession;", "chatSessionManager", "Lcom/github/copilot/chat/session/SessionManager;", "getChatSessionManager", "()Lcom/github/copilot/chat/session/SessionManager;", "unlockSession", "", "lockSession", "stopActiveResponses", "isResponseFiltered", "", "removeActiveResponse", "copilotMessageComponent", "getSessionInput", "", "updateInput", "input", "isUnlocked", "chatSession", "executeRequest", "chatMessage", "Lcom/github/copilot/chat/message/ChatMessage;", "middleware", "", "Lcom/github/copilot/chat/conversation/ConversationProgressHandler;", "destroyChatSession", "sendMessage", "message", "(Lcom/github/copilot/chat/message/ChatMessage;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core"})
@SourceDebugExtension(value={"SMAP\nSessionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionController.kt\ncom/github/copilot/chat/session/SessionController\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n215#2,2:107\n1855#3,2:109\n1855#3,2:111\n1855#3,2:113\n1855#3,2:115\n1855#3,2:117\n*S KotlinDebug\n*F\n+ 1 SessionController.kt\ncom/github/copilot/chat/session/SessionController\n*L\n32#1:107,2\n95#1:109,2\n89#1:111,2\n92#1:113,2\n86#1:115,2\n98#1:117,2\n*E\n"})
public abstract class SessionController {
    @NotNull
    private final Map<CopilotMessageComponent, ActiveResponse> activeCopilotResponses;
    @NotNull
    private final ConversationService conversationService;

    public SessionController(@NotNull ConversationServiceFactory conversationServiceFactory) {
        Intrinsics.checkNotNullParameter((Object)conversationServiceFactory, (String)"conversationServiceFactory");
        this.activeCopilotResponses = (Map)new ConcurrentMap(0, 1, null);
        this.conversationService = conversationServiceFactory.create(this);
    }

    public /* synthetic */ SessionController(ConversationServiceFactory conversationServiceFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            conversationServiceFactory = CopilotConversationServiceFactory.INSTANCE;
        }
        this(conversationServiceFactory);
    }

    @NotNull
    public final Map<CopilotMessageComponent, ActiveResponse> getActiveCopilotResponses() {
        return this.activeCopilotResponses;
    }

    @NotNull
    public final ConversationService getConversationService() {
        return this.conversationService;
    }

    @NotNull
    public abstract ChatSession getSession();

    @Nullable
    public abstract SessionManager getChatSessionManager();

    public abstract void unlockSession();

    public abstract void lockSession();

    public final void stopActiveResponses(boolean isResponseFiltered) {
        this.conversationService.cancelReplies();
        Map<CopilotMessageComponent, ActiveResponse> $this$forEach$iv = this.activeCopilotResponses;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CopilotMessageComponent, ActiveResponse>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CopilotMessageComponent, ActiveResponse> element$iv;
            Map.Entry<CopilotMessageComponent, ActiveResponse> entry = element$iv = iterator.next();
            boolean bl = false;
            CopilotMessageComponent messageComponent = entry.getKey();
            ActiveResponse activeResponse = entry.getValue();
            messageComponent.getTypeWriter().stop();
            MessageComponent.setCancelled$default(messageComponent, null, 1, null);
            activeResponse.cancel(isResponseFiltered);
            this.removeActiveResponse(messageComponent);
            messageComponent.getStepPanel().stop();
        }
    }

    public static /* synthetic */ void stopActiveResponses$default(SessionController sessionController, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopActiveResponses");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        sessionController.stopActiveResponses(bl);
    }

    public final void removeActiveResponse(@NotNull CopilotMessageComponent copilotMessageComponent) {
        Intrinsics.checkNotNullParameter((Object)copilotMessageComponent, (String)"copilotMessageComponent");
        if (this.activeCopilotResponses.containsKey(copilotMessageComponent)) {
            this.activeCopilotResponses.remove(copilotMessageComponent);
        }
    }

    @Nullable
    public String getSessionInput() {
        return null;
    }

    public void updateInput(@Nullable String input) {
    }

    public abstract boolean isUnlocked(@NotNull ChatSession var1);

    public final void executeRequest(@NotNull ChatMessage chatMessage, @NotNull List<? extends ConversationProgressHandler> middleware) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter(middleware, (String)"middleware");
        ApplicationManager.getApplication().executeOnPooledThread(() -> SessionController.executeRequest$lambda$1(this, chatMessage, middleware));
    }

    public final void destroyChatSession() {
        if (!StringsKt.isBlank((CharSequence)this.getSession().getConversationId())) {
            this.conversationService.destroyConversation(new ConversationDestroyCommand(this.getSession().getConversationId()));
        }
        Disposer.dispose((Disposable)this.getSession());
    }

    private final Object sendMessage(ChatMessage message, List<? extends ConversationProgressHandler> middleware, Continuation<? super Unit> $completion) {
        Object object = this.conversationService.onReply(message, ConversationProgressHandlerKt.conversationProgressHandler((Function1<? super ConversationError, Unit>)((Function1)arg_0 -> SessionController.sendMessage$lambda$3(middleware, arg_0)), (Function1<? super ConversationProgressValue, Unit>)((Function1)arg_0 -> SessionController.sendMessage$lambda$5(middleware, arg_0)), (Function1<? super ConversationProgressValue, Unit>)((Function1)arg_0 -> SessionController.sendMessage$lambda$7(middleware, arg_0)), (Function1<? super Disposable, Unit>)((Function1)arg_0 -> SessionController.sendMessage$lambda$9(middleware, arg_0)), (Function1<? super Unauthorized, Unit>)((Function1)arg_0 -> SessionController.sendMessage$lambda$11(middleware, arg_0))), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final void executeRequest$lambda$1(SessionController this$0, ChatMessage $chatMessage, List $middleware) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $chatMessage, (List<? extends ConversationProgressHandler>)$middleware, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SessionController this$0;
            final /* synthetic */ ChatMessage $chatMessage;
            final /* synthetic */ List<ConversationProgressHandler> $middleware;
            {
                this.this$0 = $receiver;
                this.$chatMessage = $chatMessage;
                this.$middleware = $middleware;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        this.this$0.getSession().getHistory().add(this.$chatMessage.getContent());
                        BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$chatMessage, this.$middleware, null){
                            int label;
                            final /* synthetic */ SessionController this$0;
                            final /* synthetic */ ChatMessage $chatMessage;
                            final /* synthetic */ List<ConversationProgressHandler> $middleware;
                            {
                                this.this$0 = $receiver;
                                this.$chatMessage = $chatMessage;
                                this.$middleware = $middleware;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = SessionController.access$sendMessage(this.this$0, this.$chatMessage, this.$middleware, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final Unit sendMessage$lambda$3(List $middleware, ConversationError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Iterable $this$forEach$iv = $middleware;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConversationProgressHandler it = (ConversationProgressHandler)element$iv;
            boolean bl = false;
            it.onError(error);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendMessage$lambda$5(List $middleware, ConversationProgressValue progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Iterable $this$forEach$iv = $middleware;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConversationProgressHandler it = (ConversationProgressHandler)element$iv;
            boolean bl = false;
            it.onProgress(progress);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendMessage$lambda$7(List $middleware, ConversationProgressValue complete) {
        Intrinsics.checkNotNullParameter((Object)complete, (String)"complete");
        Iterable $this$forEach$iv = $middleware;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConversationProgressHandler it = (ConversationProgressHandler)element$iv;
            boolean bl = false;
            it.onComplete(complete);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendMessage$lambda$9(List $middleware, Disposable begin) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Iterable $this$forEach$iv = $middleware;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConversationProgressHandler it = (ConversationProgressHandler)element$iv;
            boolean bl = false;
            it.onBegin(begin);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendMessage$lambda$11(List $middleware, Unauthorized unauthorized) {
        Intrinsics.checkNotNullParameter((Object)unauthorized, (String)"unauthorized");
        Iterable $this$forEach$iv = $middleware;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConversationProgressHandler it = (ConversationProgressHandler)element$iv;
            boolean bl = false;
            it.onUnauthorized(unauthorized);
        }
        return Unit.INSTANCE;
    }

    public SessionController() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Object access$sendMessage(SessionController $this, ChatMessage message, List middleware, Continuation $completion) {
        return $this.sendMessage(message, middleware, (Continuation<? super Unit>)$completion);
    }
}

