/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.session.actions;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.github.copilot.chat.session.ChatSession;
import com.github.copilot.chat.session.ChatSessionController;
import com.github.copilot.chat.session.ChatSessionNameSource;
import com.github.copilot.chat.session.component.dialog.RenameDialog;
import com.github.copilot.chat.session.listener.ChatSessionRenameRequestListener;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/copilot/chat/session/actions/RenameAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "chatSessionController", "Lcom/github/copilot/chat/session/ChatSessionController;", "<init>", "(Lcom/github/copilot/chat/session/ChatSessionController;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "core"})
public final class RenameAction
extends AnAction {
    @NotNull
    private final ChatSessionController chatSessionController;

    public RenameAction(@NotNull ChatSessionController chatSessionController) {
        Intrinsics.checkNotNullParameter((Object)chatSessionController, (String)"chatSessionController");
        super(CopilotBundle.get("copilot.chat.session.action.rename.current.conversation"), CopilotBundle.get("copilot.chat.session.action.rename.current.conversation.description"), CopilotIcons.Edit);
        this.chatSessionController = chatSessionController;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RenameDialog renameDialog = new RenameDialog(this.chatSessionController.getSession().getName().getValue());
        if (renameDialog.showAndGet()) {
            Project project = this.chatSessionController.getChatSessionManager().getProject();
            ChatSession chatSession = this.chatSessionController.getSession();
            String string = renameDialog.getTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            ChatSessionRenameRequestListener.Companion.onSessionRenameRequest(project, chatSession, string, ChatSessionNameSource.USER);
        }
    }
}

